//+------------------------------------------------------------------+
//|                                                      WASD_FR.mq5 |
//|                                           Copyright  2015, WASD |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property description "   3   (   ..      )"
//---  
#property copyright "Copyright  2015, WASD"
//---    
#property link      "https://www.mql5.com"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|          |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---       
#property indicator_color1  clrMagenta
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "Up Fractal"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---       
#property indicator_color2  clrBlue
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2 "Down Fractal"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int  UpLable=217; //   
input int  DnLable=218; //   
input double Range=0.1; //       ATR
//+----------------------------------------------+
//---   ,   
//---      
double UpBuffer[];
double DnBuffer[];
//---
int min_rates_total;
int ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,4));
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,UpLable);
//---       
   ArraySetAsSeries(UpBuffer,true);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,DnLable);
//---       
   ArraySetAsSeries(DnBuffer,true);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="WASD_FR";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit;
   double ATR[];
//---      
//---   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated+2; //      
     }
   to_copy=limit+1;
//---       UpFractal  DnFractal
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);
//---    
   for(int bar=2; bar<=limit && !IsStopped(); bar++)
     {
      UpBuffer[bar+1]=EMPTY_VALUE;
      DnBuffer[bar+1]=EMPTY_VALUE;
      if(low[bar+1]<low[bar] && low[bar+1]<low[bar+2]) DnBuffer[bar+1]=low[bar+1]-ATR[bar]*Range;
      if(high[bar+1]>high[bar] && high[bar+1]>high[bar+2]) UpBuffer[bar+1]=high[bar+1]+ATR[bar]*Range;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
