//+------------------------------------------------------------------+ 
//|                                                   ang_AZad_C.mq5 | 
//|                           Copyright  2006, ANG3110@latchess.com | 
//|                                             ANG3110@latchess.com | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, ANG3110@latchess.com"
#property link "ANG3110@latchess.com"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---    1
#property indicator_buffers 1 
//---    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//---   -  
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "ang_AZad_C"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrRed
#property indicator_levelstyle STYLE_SOLID
//+-----------------------------------+
//|         |
//+-----------------------------------+
input double ki=4;
input int Shift=0;
//+-----------------------------------+
//---      
int  min_rates_total;
//---   ,   
//---      
double IndBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//---     
   min_rates_total=4;
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"ang_AZad_C");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---      
   double z,z2,Za2,Za;
   static double z_,z2_,Za2_,Za_;
//---   
   int limit;
//---         
   ArraySetAsSeries(Close,true);
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      Za2_=Za=z2_=z_=Close[limit+1];
     }
   else limit=rates_total-prev_calculated;  //       
   z=z_;
   z2=z2_;
   Za2=Za2_;
   Za=Za_;
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      if(Close[bar]>z && Close[bar]>Close[bar+1]) z=Za_+(Close[bar]-Za_)/ki;
      if(Close[bar]<z && Close[bar]<Close[bar+1]) z=Za_+(Close[bar]-Za_)/ki;
      if(Close[bar]>z2 && Close[bar]<Close[bar+1]) z2=Za2_+(Close[bar]-Za2_)/ki;
      if(Close[bar]<z2 && Close[bar]>Close[bar+1]) z2=Za2_+(Close[bar]-Za2_)/ki;

      Za=z;
      Za2=z2;
      
      IndBuffer[bar]=(Za-Za2)/_Point;

      if(bar)
        {
         z_=z;
         z2_=z2;
         Za2_=Za2;
         Za_=Za;
        }
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
