//+------------------------------------------------------------------+
//|                                                 ADX Smoothed.mq5 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, MetaQuotes Software Corp."
//---    
#property link      "http://www.metaquotes.net"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 3
//---    
#property indicator_plots   3
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  Lime
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "Di Plus"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  Red
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2  "Di Minus"
//+----------------------------------------------+
//|   ADX            |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_LINE
//---    ADX     
#property indicator_color3  Blue
//---   3 -  
#property indicator_style3  STYLE_SOLID
//---    3  1
#property indicator_width3  1
//---    
#property indicator_label3  "ADX"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 88.0
#property indicator_level2 50.0
#property indicator_level3 12.0
#property indicator_levelcolor Gray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int    period = 14;
input double alpha1 = 0.25;
input double alpha2 = 0.33;
//+----------------------------------------------+
//---   ,   
//---      
double DiPlusBuffer[];
double DiMinusBuffer[];
double ADXBuffer[];
//---      
int ADX_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---    ADX
   ADX_Handle=iADX(NULL,0,period);
   if(ADX_Handle==INVALID_HANDLE)
     {
      Print("      ADX");
      return(INIT_FAILED);
     }
//---     
   min_rates_total=period+1;
//---    DiPlusBuffer   
   SetIndexBuffer(0,DiPlusBuffer,INDICATOR_DATA);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---          
   ArraySetAsSeries(DiPlusBuffer,true);
//---    DiMinusBuffer   
   SetIndexBuffer(1,DiMinusBuffer,INDICATOR_DATA);
//---       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---          
   ArraySetAsSeries(DiMinusBuffer,true);
//---    DiMinusBuffer   
   SetIndexBuffer(2,ADXBuffer,INDICATOR_DATA);
//---       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---          
   ArraySetAsSeries(ADXBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"ADX(",period,")smothed");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ADX_Handle)<rates_total || rates_total<min_rates_total) return(0);
//---    
   int limit,to_copy,bar;
   double ADX[],DIP[],DIM[],DiPlus,DiMinus,Adx;
   static double DiPlus_,DiMinus_,Adx_;
//---         
   ArraySetAsSeries(ADX,true);
   ArraySetAsSeries(DIP,true);
   ArraySetAsSeries(DIM,true);
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-2; //      
      DiPlus_=0.0;
      DiMinus_=0.0;
      Adx_=0.0;
      DiPlusBuffer[rates_total-1]=0.0;
      DiMinusBuffer[rates_total-1]=0.0;
      ADXBuffer[rates_total-1]=0.0;
     }
   else limit=rates_total-prev_calculated; //      
//---
   to_copy=limit+2;
//---      
   if(CopyBuffer(ADX_Handle,0,0,to_copy,ADX)<=0) return(0);
   if(CopyBuffer(ADX_Handle,1,0,to_copy,DIP)<=0) return(0);
   if(CopyBuffer(ADX_Handle,2,0,to_copy,DIM)<=0) return(0);
//---   
   DiPlus=DiPlus_;
   DiMinus=DiMinus_;
   Adx=Adx_;
//---    
   for(bar=limit; bar>=0; bar--)
     {
      //---        
      if(rates_total!=prev_calculated && bar==0)
        {
         DiPlus_=DiPlus;
         DiMinus_=DiMinus;
         Adx_=Adx;
        }
      //---
      DiPlus=2*DIP[bar]+(alpha1-2)*DIP[bar+1]+(1-alpha1)*DiPlus;
      DiMinus=2*DIM[bar]+(alpha1-2)*DIM[bar+1]+(1-alpha1)*DiMinus;
      Adx=2*ADX[bar]+(alpha1-2)*ADX[bar+1]+(1-alpha1)*Adx;
      //---
      DiPlusBuffer[bar]=alpha2*DiPlus+(1-alpha2)*DiPlusBuffer[bar+1];
      DiMinusBuffer[bar]=alpha2*DiMinus+(1-alpha2)*DiMinusBuffer[bar+1];
      ADXBuffer[bar]=alpha2*Adx+(1-alpha2)*ADXBuffer[bar+1];
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
