//+------------------------------------------------------------------+
//|                                             Volatility.Pivot.mq4 |
//|                                               mod by NiX 2007    |
//+------------------------------------------------------------------+
#property copyright "thanks to S.B.T. (Japan)"
#property link      "http://sufx.core.t3-ism.net/" //<<< convert this from VT, thanks mate !!!

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Orange
//---- input parameters
extern double     atr_range=100;
extern double     ima_range = 10;
extern double     atr_factor=3;
extern int        Mode = 0;
extern double     DeltaPrice = 30;


//---- buffers
double TrStop[];
double ATR[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(0, TrStop);

   SetIndexStyle(1, DRAW_NONE);
   SetIndexBuffer(1, ATR);

   string short_name = "VPO";
   IndicatorShortName(short_name);
   SetIndexLabel(1,"ATR");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int counted_bars = IndicatorCounted();
   int limit;
   int i;

   double DeltaStop;
   
   limit = Bars;

   for(i = 0; i < limit; i ++) {
      ATR[i] = iATR(NULL,0,atr_range,i);
   }

   for(i = limit - 1; i >= 0; i --) {
      if (Mode == 0) {
         DeltaStop = iMAOnArray(ATR,0,ima_range,0,MODE_EMA,i) * atr_factor;
         //DeltaStop = iATR(NULL,0,atr_range,i) * atr_factor;
      } else {
         DeltaStop = DeltaPrice*Point;
      }

      if (Open[i] == TrStop[i + 1]) {
         TrStop[i] = TrStop[i + 1];
      } else {
         if (Open[i+1]<TrStop[i+1] && Open[i]<TrStop[i+1]) {
            TrStop[i] = MathMin(TrStop[i + 1], Open[i] + DeltaStop);
         } else {
            if (Open[i+1]>TrStop[i+1] && Open[i]>TrStop[i+1]) {
               TrStop[i] = MathMax(TrStop[i+1], Open[i] - DeltaStop);         
            } else {
               if (Open[i] > TrStop[i+1]) TrStop[i] = Open[i] - DeltaStop; else TrStop[i] = Open[i] + DeltaStop;
            }
         }
      }
   }

//----
   return(0);
  }
//+------------------------------------------------------------------+