//+------------------------------------------------------------------+
//|                                                 PriceTrigger.mq4 |
//| version 0.0 pre-beta                                             |
//|                                                                  |
//|                                                 MT4 code by NiX  |
//|                                                                  |
//|                          Donate by PayPal to: artur@lunar.com.pl |
//+------------------------------------------------------------------+

#property copyright "Copyright  2007, NiX"

#property indicator_separate_window
#property indicator_minimum -1.2
#property indicator_maximum 1.2
#property indicator_buffers 1
#property indicator_color1 Yellow

extern double percent = 0.04;

extern int     NLD_Price = 0;
extern int     NLD_Length = 20;
extern int     NLD_Displace = 0;
extern int     NLD_Filter = 0;
extern int     NLD_Color = 1;
extern int     NLD_ColorBarBack = 0;
extern double  NLD_Deviation = 0;         

//---- buffers
double Buffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{

   if(percent < 0.01)
      percent = 0.01;
   else if(percent > 100)
      percent = 100;

   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,Buffer);
   IndicatorShortName("Price Trigger Signal ("+DoubleToStr(percent,2)+"%) = ");

   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   return(0);
}

bool isZero(double v)
{
   if((v == 0) || (v == EMPTY_VALUE))
      return(true);
   else  
      return(false);
}

datetime PrevTime = 0;

bool newBar()
{
   if( Time[0] != PrevTime)
   {
      PrevTime = Time[0];
      return(true);
   }
   else  
      return(false);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int start()
{
   double NLDup = 0, NLDdn = 0, PZZup = 0, PZZdn = 0;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) 
      return(-1);

   int limit=Bars-counted_bars-1;

   for(int shift=0; shift<limit; shift++) 
   { 
      NLDup = iCustom(Symbol(),Period(),"nonlagdot",NLD_Price, NLD_Length,NLD_Displace,
                      NLD_Filter,NLD_Color, NLD_ColorBarBack,NLD_Deviation,
                      1,shift+1);
      NLDdn = iCustom(Symbol(),Period(),"nonlagdot",NLD_Price, NLD_Length,NLD_Displace,
                      NLD_Filter,NLD_Color, NLD_ColorBarBack,NLD_Deviation,
                      2,shift+1);
      PZZup = iCustom(Symbol(),Period(),"precentualzz_victor",percent,0,shift+1);      
      PZZdn = iCustom(Symbol(),Period(),"precentualzz_victor",percent,1,shift+1);   
      
    //  Print(NLDup," ",PZZup," | ",NLDdn," ",PZZdn);
      if((!isZero(NLDup) && !isZero(PZZup)))
         Buffer[shift] = 1;
      else if(!isZero(NLDdn) && !isZero(PZZdn))
         Buffer[shift] = -1;
      else
         Buffer[shift] = 0;
      

   }
   
   return(0);
}


