//+------------------------------------------------------------------+
//|                                               MA Profit Diff.mq4 |
//|                                 Copyright  2010, Thomas Quester |
//|                                                  tquester@gmx.de |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Thomas Quester"
#property link      "tquester@gmx.de"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Red

double ExtMapBuffer1[];


extern int       PeriodShort=6;
extern int       PeriodLong=40;
extern int       Method=0;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   
   GetVars();
   
//----
   return(0);
  }
  
void GetVars()
{
   //Print("GetVars");
   string sym = Symbol()+Period();
   PeriodShort = GlobalVariableGet(sym+"PeriodShort");
   if(GetLastError()!=0) Print("Error getting "+sym+"PeriodShort");

   PeriodLong = GlobalVariableGet(sym+"PeriodLong");
   if(GetLastError()!=0) Print("Error getting "+sym+"PeriodLong");
   Method = GlobalVariableGet(sym+"Method");
   if(GetLastError()!=0) Print("Error getting "+sym+"Method");
   Print("GetVars ",sym," - ",PeriodShort,"/",PeriodLong);
   
}  
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
   int i;
   double maS,maL,maLLow,maLHigh;
   GetVars();
   //Print("MA2 Periode=",PeriodShort,"/",PeriodLong);
   for (i=Bars;i>=0;i--)
   {
      
      maS      = iMA(NULL,0,PeriodShort,0,Method,PRICE_MEDIAN,i);
      maL      = iMA(NULL,0,PeriodLong,0,Method,PRICE_MEDIAN,i);
      
      ExtMapBuffer1[i] = (maS-maL)/Point;
//----
   }
   return(0);
  }
//+------------------------------------------------------------------+