//+------------------------------------------------------------------+
//|                                              NonLagZigZag_v4.mq4 |
//|                                Copyright  2007, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"


#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Gold
#property indicator_width1 2

//---- input parameters
extern int     Price          =    0;  //Apply to Price(0-Close;1-Open;2-High;3-Low;4-Median price;5-Typical price;6-Weighted Close) 
extern int     Length         =   14;  //Period of NonLagMA
extern double  PctFilter      =    2;  //Dynamic filter in decimals
extern int     PriceMode      =    0;  //Price Mode: 0-High/Low, 1-Close
extern int     AlertMode      =    0;  //Alert Mode: 0-off,1-on
extern int     WarningMode    =    0;  //Warning Mode: 0-off,1-on
extern int     FiboMode       =    1;  //Fibo Mode:0-off,1-on
extern color   FiboLineColor  = CLR_NONE;  
extern color   FiboLevelColor = Aqua;
extern int     FiboLineStyle  =    0;
extern int     FiboLevelStyle =    0;

double ZZBuffer[];
double MABuffer[];
double trend[];
double Del[];
double AvgDel[];

int      ilow, ihigh, nlow, nhigh, prevnhigh,prevnlow, BarsBack;  
double   alfa[];
datetime lotime,hitime;
int      i, Phase, Len, Cycle=4, Back=0;
double   Coeff, beta, t, Sum, Weight, g;
double   pi = 3.1415926535;
int      pt1=0,pt0=0;
double   pzz1=0,pzz0=0, minzz=0, maxzz=0; 
bool     UpTrendAlert=false, DownTrendAlert=false;
bool     fTime=true;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
  int init()
  {
   IndicatorBuffers(5);
   SetIndexStyle(0,DRAW_SECTION);
   SetIndexBuffer(0,ZZBuffer);
   SetIndexBuffer(1,MABuffer);
   SetIndexBuffer(2,trend);
   SetIndexBuffer(3,Del);
   SetIndexBuffer(4,AvgDel); 
   string short_name;
//---- indicator line
   
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
//---- name for DataWindow and indicator subwindow label
   short_name="NonLagZigZag("+Length+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"NonLagZigZag");
//----
   SetIndexEmptyValue(0,0.0);   
   SetIndexDrawBegin(0,Length*Cycle+Length);
//----
   
   Coeff =  3*pi;
   Phase = Length-1;
   Len = Length*Cycle + Phase;  
   ArrayResize(alfa,Len);
   Weight=0;    
      
      for (i=0;i<Len-1;i++)
      {
      if (i<=Phase-1) t = 1.0*i/(Phase-1);
      else t = 1.0 + (i-Phase+1)*(2.0*Cycle-1.0)/(Cycle*Length-1.0); 
      beta = MathCos(pi*t);
      g = 1.0/(Coeff*t+1);   
      if (t <= 0.5 ) g = 1;
      alfa[i] = g * beta;
      Weight += alfa[i];
      }
 
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+  
int deinit() 
{
   int obtotal = ObjectsTotal();
   
   for (i = 0;i < obtotal;i ++)
   {
      if(StringFind(ObjectName(i),"NLZZ",0) == 4 && ObjectType("FiboNLZZ"+Period())==OBJ_FIBO) 
      {
      string obname = ObjectName(i);
         if (!ObjectDelete(obname)) 
         {
         int _GetLastError = GetLastError();
         //Print( "ObjectDelete( \"", StringConcatenate( "sup",i),"\" ) - Error #", _GetLastError );
         }
      }         
   }
}
//+------------------------------------------------------------------+
//| NonLagZigZag_v4                                                  |
//+------------------------------------------------------------------+
int start()
{
   int    i,shift, counted_bars=IndicatorCounted(),limit;
   double price,smin,smax;
   string aMessage="", wMessage="";
         
   if ( counted_bars > 0 )  limit=Bars-counted_bars;
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-1; 
   if ( counted_bars < 1 ) 
   {
   for(i=0;i<Bars-1;i++) 
   ZZBuffer[i]=0;
   for(i=1;i<Len;i++) 
   MABuffer[Bars-i]=iMA(NULL,0,1,0,MODE_SMA,Price,Bars-i);    
   }
   
   for(shift=limit;shift>=0;shift--) 
   {	
      Sum = 0;
      for (i=0;i<=Len-1;i++)
	   { 
      price = iMA(NULL,0,1,0,3,Price,i+shift);      
      Sum += alfa[i]*price;
      }
   
	if (Weight > 0) MABuffer[shift] = Sum/Weight;
   
   Del[shift] = MathAbs(MABuffer[shift] - MABuffer[shift+1]);
   
   double sumdel=0;
   for (i=0;i<=Length-1;i++) sumdel += Del[shift+i];
   
   AvgDel[shift] = sumdel/Length;
   
   double sumpow = 0;
   for (i=0;i<=Length-1;i++) sumpow += MathPow(Del[shift+i]-AvgDel[shift+i],2);
   double StdDev = MathSqrt(sumpow/Length); 
   
   double Filter = PctFilter * StdDev;       
   if (Filter < Point) Filter = Point;
   
   if( MathAbs(MABuffer[shift]-MABuffer[shift+1]) < Filter ) MABuffer[shift]=MABuffer[shift+1];
   
   trend[shift]=trend[shift+1];
   if (MABuffer[shift]-MABuffer[shift+1] > Filter) trend[shift]= 1;   
   if (MABuffer[shift+1]-MABuffer[shift] > Filter) trend[shift]=-1;
   
      if(trend[shift]>0)
      {
         if( trend[shift]!=trend[shift+1]) 
         {
         ilow = LowestBar(iBarShift(NULL,0,hitime,FALSE)-shift,shift);
         lotime = Time[ilow];
          
            if(PriceMode==0) ZZBuffer[ilow] = Low[ilow];
            else 
            ZZBuffer[ilow] = MathMin(Close[ilow],Open[ilow]); 
         }
         else
         if (shift==0) 
         {
         int hilen = iBarShift(NULL,0,lotime,FALSE);
         nhigh = HighestBar(hilen,0);
         
            if(PriceMode==0) ZZBuffer[nhigh] = High[nhigh];
            else   
            ZZBuffer[nhigh]=MathMax(Close[nhigh],Open[nhigh]);
         
         if (nhigh== 0) for (i=hilen-1;i>=1;i--) ZZBuffer[i]=0; 
         if (nhigh > 0) for (i=nhigh-1;i>=0;i--) ZZBuffer[i]=0; 
         }
      }
      
      if (trend[shift]<0)
      { 
         if( trend[shift]!=trend[shift+1]) 
         {
         ihigh = HighestBar(iBarShift(NULL,0,lotime,FALSE)-shift,shift);
         hitime=Time[ihigh];
            if(PriceMode==0) ZZBuffer[ihigh] = High[ihigh];
            else   
            ZZBuffer[ihigh] = MathMax(Close[ihigh],Open[ihigh]);
         }
         else
         if (shift==0) 
         {
         int lolen = iBarShift(NULL,0,hitime,FALSE);
         nlow = LowestBar(lolen,0);
            if(PriceMode==0) ZZBuffer[nlow] = Low[nlow];
            else 
            ZZBuffer[nlow] = MathMin(Close[nlow],Open[nlow]);
         if (nlow==0) for (i=lolen-1;i>=1;i--) ZZBuffer[i]=0; 
         if (nlow >0) for (i=nlow-1;i>=0;i--) ZZBuffer[i]=0; 
         }
      }   
      
      if(shift == 0 && (FiboMode == 1 || AlertMode == 1 || WarningMode == 1))
      {
         if(trend[shift] > 0) 
         {
         int t1 = Time[nhigh]; 
         double zz1 = ZZBuffer[hilen]; 
         int t0 = Time[nhigh]; 
         double zz0 = ZZBuffer[nhigh];
         }
         else
         if(trend[shift] < 0)
         {
         t1 = Time[nlow]; 
         zz1 = ZZBuffer[lolen]; 
         t0 = Time[nlow]; 
         zz0 = ZZBuffer[nlow]; 
         }
                
         zz0 = NormalizeDouble(zz0,Digits);
                 
         if (FiboMode == 1 && (t1 != pt1 || t0 != pt0 || zz1 != pzz1 || zz0 != pzz0))
         {
         ObjectDelete("FiboNLZZ" + Period());
      
         ObjectCreate("FiboNLZZ" + Period(), OBJ_FIBO, 0, t1, zz1, t0, zz0);
            
         ObjectSet("FiboNLZZ" + Period(),OBJPROP_FIBOLEVELS, 8);
               
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+0, 0);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 0, "0 %$ ");
 
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+1, 0.236);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 1, "23.6 %$ ");
 
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+2, 0.382);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 2, "38.2 %$ ");
 
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+3, 0.500);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 3, "50.0 %$ ");
  
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+4, 0.618);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 4, "61.8 %$ ");
 
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+5, 1.00);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 5, "100 %$ ");
    
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+6, 1.618);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 6, "161.8 %$ ");
 
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+7, 2.618);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 7, "261.8 %$ ");
 
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_FIRSTLEVEL+8, 4.236);
         ObjectSetFiboDescription("FiboNLZZ" + Period(), 8, "423.6 %$ ");
      
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_COLOR, FiboLineColor);
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_LEVELCOLOR, FiboLevelColor);
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_STYLE, FiboLineStyle);
         ObjectSet("FiboNLZZ" + Period(), OBJPROP_LEVELSTYLE, FiboLevelStyle);
         }
                  
         if (AlertMode > 0)
         {
            if (trend[shift+2]<0 && trend[shift+1]>0 && Volume[0]>1 && !UpTrendAlert)
            {
	         aMessage = " "+Symbol()+" M"+Period()+": NonLagZigZag is UP";
	         if(aMessage != "") Alert (aMessage); 
	         UpTrendAlert=true; DownTrendAlert=false;
	         } 
	 	      else
	         if (trend[shift+2]>0 && trend[shift+1]<0 && Volume[0]>1 && !DownTrendAlert)
            {
	         aMessage = " "+Symbol()+" M"+Period()+": NonLagZigZag is DOWN";
	         if(aMessage != "") Alert (aMessage); 
	         DownTrendAlert=true; UpTrendAlert=false;
	         }
         }	          	         
         
         if (WarningMode == 1)
         {
            if(fTime)
            {
            maxzz=zz0;
            minzz=zz0;
            fTime = false;
            }
                       
            if(trend[shift] > 0 && zz0 > maxzz)
            {
            wMessage = " "+Symbol()+" M"+Period()+": NonLagZigZag forms new HIGH="+DoubleToStr(zz0,Digits);
            if(wMessage != "") Alert (wMessage);
            maxzz = zz0;
            }
            else
            if(trend[shift] < 0 && zz0 < minzz)
            {
            wMessage = " "+Symbol()+" M"+Period()+": NonLagZigZag forms new LOW="+DoubleToStr(zz0,Digits);
            if(wMessage != "") Alert (wMessage);
            minzz = zz0;
            } 
         }
         
      pt1 = t1;
      pt0 = t0;
      pzz1 = zz1;
      pzz0 = zz0;
      }  
   }
   return(0);	
}

int LowestBar(int len,int k)
{
   double min = 10000000;   
   int lobar;
   
   for (int i=k+len-1;i>=k;i--)
   {
      if(PriceMode==0)
      {
         if(i==0)
         { 
            if(Low[i] < min) 
            {
            min = Low[i]; 
            lobar = i;
            }
         }
         else
         {
            if(Low[i] < min && Low[i] < Low[i-1]) 
            {
            min = Low[i]; 
            lobar = i;
            }
         }   
      }      
      else
      {
         if(i==0)
         { 
            if(MathMin(Close[i],Open[i]) < min) 
            {
            min = MathMin(Close[i],Open[i]); 
            lobar = i;
            }
         }
         else
         {
            if(MathMin(Close[i],Open[i]) < min && MathMin(Close[i],Open[i]) < MathMin(Close[i-1],Open[i-1])) 
            {
            min = MathMin(Close[i],Open[i]); 
            lobar = i;
            }
         }   
      }         
   }
   
   if(len<=0) lobar=k;
   
   return(lobar);
} 

int HighestBar(int len,int k)
{
   double max = -10000000;   
   int hibar;
   
   for (int i=k+len-1;i>=k;i--)
   {
      if(PriceMode==0)
      {
         if(i==0)
         {    
            if(High[i] > max) 
            {
            max = High[i]; 
            hibar = i;
            }
         }
         else
         {
            if(High[i] > max && High[i] > High[i-1]) 
            {
            max = High[i]; 
            hibar = i;
            }
         }
      }   
      else
      {
         if(i==0)
         {       
            if(MathMax(Close[i],Open[i]) > max && MathMax(Close[i],Open[i]) > MathMax(Close[i-1],Open[i-1])) 
            {
            max = MathMax(Close[i],Open[i]); 
            hibar = i;
            }
         }
         else
         {
            if(MathMax(Close[i],Open[i]) > max) 
            {
            max = MathMax(Close[i],Open[i]); 
            hibar = i;
            }
         }
      }
   }
   
   if(len<=0) hibar=k;
  
   return(hibar);
}                                     