/*
  
*/
#property copyright "Copyright  2008 Abner Gelin,www.reliablesignals.com"
#property link      "www.reliablesignals.com"

#property indicator_chart_window

bool gi_76 = TRUE;
int gi_80 = 0;
string gs_84 = "2018.12.01";
extern int GMTshift = 0;
extern int LabelShift = 20;
extern int LineShift = 40;
extern bool Pivot = TRUE;
extern color PivotColor = Yellow;
extern color PivotFontColor = White;
extern int PivotFontSize = 8;
extern bool CamarillaPivots = FALSE;
extern bool UseH1H2L1L2 = FALSE;
extern color CamFontColor = White;
extern int CamFontSize = 10;
extern bool FibPivots = FALSE;
extern color FibColor = Sienna;
extern color FibFontColor = White;
extern int FibFontSize = 8;
extern bool StandardPivots = TRUE;
extern color StandardFontColor = White;
extern int StandardFontSize = 8;
extern color SupportColor = White;
extern color ResistanceColor = Red;
extern bool MidPivots = FALSE;
extern color MidPivotColor = White;
extern int MidFontSize = 8;
int g_time_184;
int g_time_188;
double g_price_192;
double gd_200;
double g_price_208;
double g_price_216;
double g_price_224;
double g_price_232;
double g_price_240;
double g_price_248;
double g_price_256;
double g_price_264;
double g_price_272;
double g_high_304;
double g_low_312;
double gd_unused_320;
double gd_unused_328;
double g_day_336;
double g_day_344;
double gd_352 = 0.091667;
double gd_360 = 0.183333;
double gd_368 = 0.275;
double gd_376 = 0.55;
double g_high_384 = 0.0;
double g_low_392 = 0.0;
double g_close_400 = 0.0;
double gd_408 = 0.0;
double gd_416 = 0.0;
double gd_424 = 0.0;
double gd_unused_432 = 0.0;
double gd_440 = 0.0;
double gd_448 = 0.0;
double gd_456 = 0.0;

int init() {
   return (0);
}

int deinit() {
   if (CamarillaPivots) {
      ObjectDelete("H5 Label");
      ObjectDelete("H5 Line");
      ObjectDelete("H4 Label");
      ObjectDelete("H4 Line");
      ObjectDelete("H3 Label");
      ObjectDelete("H3 Line");
      if (UseH1H2L1L2) {
         ObjectDelete("H2 Label");
         ObjectDelete("H2 Line");
         ObjectDelete("H1 Label");
         ObjectDelete("H1 Line");
         ObjectDelete("L1 Label");
         ObjectDelete("L1 Line");
         ObjectDelete("L2 Label");
         ObjectDelete("L2 Line");
      }
      ObjectDelete("L3 Label");
      ObjectDelete("L3 Line");
      ObjectDelete("L4 Label");
      ObjectDelete("L4 Line");
      ObjectDelete("L5 Label");
      ObjectDelete("L5 Line");
   }
   if (FibPivots) {
      ObjectDelete("FibR1 Label");
      ObjectDelete("FibR1 Line");
      ObjectDelete("FibR2 Label");
      ObjectDelete("FibR2 Line");
      ObjectDelete("FibR3 Label");
      ObjectDelete("FibR3 Line");
      ObjectDelete("FibS1 Label");
      ObjectDelete("FibS1 Line");
      ObjectDelete("FibS2 Label");
      ObjectDelete("FibS2 Line");
      ObjectDelete("FibS3 Label");
      ObjectDelete("FibS3 Line");
   }
   if (Pivot) {
      ObjectDelete("P Label");
      ObjectDelete("P Line");
   }
   if (StandardPivots) {
      ObjectDelete("R1 Label");
      ObjectDelete("R1 Line");
      ObjectDelete("R2 Label");
      ObjectDelete("R2 Line");
      ObjectDelete("R3 Label");
      ObjectDelete("R3 Line");
      ObjectDelete("S1 Label");
      ObjectDelete("S1 Line");
      ObjectDelete("S2 Label");
      ObjectDelete("S2 Line");
      ObjectDelete("S3 Label");
      ObjectDelete("S3 Line");
   }
   if (MidPivots) {
      ObjectDelete("M5 Label");
      ObjectDelete("M5 Line");
      ObjectDelete("M4 Label");
      ObjectDelete("M4 Line");
      ObjectDelete("M3 Label");
      ObjectDelete("M3 Line");
      ObjectDelete("M2 Label");
      ObjectDelete("M2 Line");
      ObjectDelete("M1 Label");
      ObjectDelete("M1 Line");
      ObjectDelete("M0 Label");
      ObjectDelete("M0 Line");
   }
   return (0);
}

int start() {
   if (ChecarValidadeConta(0, gi_76, gi_80, gs_84)) return (0);
   int li_unused_0 = IndicatorCounted();
   double ld_4 = 0;
   double ld_unused_12 = 0;
   double ld_20 = 0;
   double l_price_28 = 0;
   double l_price_36 = 0;
   double l_price_44 = 0;
   double l_price_52 = 0;
   double l_price_60 = 0;
   double l_price_68 = 0;
   double l_price_76 = 0;
   double l_price_84 = 0;
   double l_price_92 = 0;
   double l_price_100 = 0;
   double l_price_108 = 0;
   double l_price_116 = 0;
   double ld_124 = 0;
   double ld_132 = 0;
   double ld_140 = 0;
   int li_148 = 720;
   if (Period() > PERIOD_D1) {
      Print("Error - Chart period is greater than 1 day.");
      return (-1);
   }
   g_high_304 = 0;
   g_low_312 = 0;
   gd_unused_320 = 0;
   gd_unused_328 = 0;
   g_day_336 = 0;
   g_day_344 = 0;
   while (li_148 != 0) {
      if (TimeDayOfWeek(Time[li_148]) == 0) g_day_336 = g_day_344;
      else g_day_336 = TimeDay(Time[li_148] - 3600 * GMTshift);
      if (g_day_344 != g_day_336) {
         g_close_400 = Close[li_148 + 1];
         gd_unused_328 = Open[li_148];
         g_high_384 = g_high_304;
         g_low_392 = g_low_312;
         g_high_304 = High[li_148];
         g_low_312 = Low[li_148];
         g_day_344 = g_day_336;
      }
      if (High[li_148] > g_high_304) g_high_304 = High[li_148];
      if (Low[li_148] < g_low_312) g_low_312 = Low[li_148];
      li_148--;
   }
   ld_140 = g_high_304 - g_low_312;
   ld_4 = g_high_384 - g_low_392;
   g_price_192 = (g_high_384 + g_low_392 + g_close_400) / 3.0;
   if (CamarillaPivots) {
      g_price_232 = g_high_384 / g_low_392 * g_close_400;
      g_price_224 = (g_high_384 - g_low_392) * gd_376 + g_close_400;
      g_price_216 = (g_high_384 - g_low_392) * gd_368 + g_close_400;
      g_price_208 = (g_high_384 - g_low_392) * gd_360 + g_close_400;
      gd_200 = (g_high_384 - g_low_392) * gd_352 + g_close_400;
      g_price_240 = g_close_400 - (g_high_384 - g_low_392) * gd_352;
      g_price_248 = g_close_400 - (g_high_384 - g_low_392) * gd_360;
      g_price_256 = g_close_400 - (g_high_384 - g_low_392) * gd_368;
      g_price_264 = g_close_400 - (g_high_384 - g_low_392) * gd_376;
      g_price_272 = g_close_400 - (g_price_232 - g_close_400);
   }
   if (FibPivots) {
      ld_20 = g_high_384 - g_low_392;
      gd_424 = g_price_192 + ld_20 / 2.0;
      gd_416 = g_price_192 + 0.62 * ld_20;
      gd_408 = g_price_192 + 0.99 * ld_20;
      gd_440 = g_price_192 - ld_20 / 2.0;
      gd_448 = g_price_192 - 0.62 * ld_20;
      gd_456 = g_price_192 - 0.99 * ld_20;
   }
   if (StandardPivots) {
      l_price_52 = 2.0 * g_price_192 - g_low_392;
      l_price_44 = 2.0 * g_price_192 - g_high_384;
      l_price_84 = g_price_192 - l_price_44 + l_price_52;
      l_price_76 = g_price_192 - l_price_52 + l_price_44;
      l_price_116 = 2.0 * g_price_192 + (g_high_384 - 2.0 * g_low_392);
      l_price_108 = 2.0 * g_price_192 - (2.0 * g_high_384 - g_low_392);
   }
   if (MidPivots && StandardPivots) {
      l_price_92 = (l_price_76 + l_price_108) / 2.0;
      l_price_60 = (l_price_44 + l_price_76) / 2.0;
      l_price_28 = (g_price_192 + l_price_44) / 2.0;
      l_price_36 = (g_price_192 + l_price_52) / 2.0;
      l_price_68 = (l_price_52 + l_price_84) / 2.0;
      l_price_100 = (l_price_84 + l_price_116) / 2.0;
   }
   if (ld_4 > 5.0) ld_124 = ld_4;
   else ld_124 = 10000.0 * ld_4;
   if (ld_140 > 5.0) ld_132 = ld_140;
   else ld_132 = 10000.0 * ld_140;
   if (StringSubstr(Symbol(), 3, 3) == "JPY") {
      ld_124 /= 100.0;
      ld_132 /= 100.0;
   }
   Comment("High= ", g_high_384, "    Previous Days Range= ", ld_124, 
      "\nLow= ", g_low_392, "    Current Days Range= ", ld_132, 
   "\nClose= ", g_close_400);
   g_time_184 = Time[LabelShift];
   g_time_188 = Time[LineShift];
   if (Pivot) {
      if (ObjectFind("P label") != 0) {
         ObjectCreate("P label", OBJ_TEXT, 0, g_time_184, g_price_192);
         ObjectSetText("P label", "Trading Base", PivotFontSize, "Arial", PivotFontColor);
      } else ObjectMove("P label", 0, g_time_184, g_price_192);
      if (ObjectFind("P line") != 0) {
         ObjectCreate("P line", OBJ_HLINE, 0, g_time_188, g_price_192);
         ObjectSet("P line", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("P line", OBJPROP_COLOR, PivotColor);
      } else ObjectMove("P line", 0, g_time_188, g_price_192);
   }
   if (StandardPivots) {
      if (ObjectFind("R1 label") != 0) {
         ObjectCreate("R1 label", OBJ_TEXT, 0, g_time_184, l_price_52);
         ObjectSetText("R1 label", " TB1", StandardFontSize, "Arial", StandardFontColor);
      } else ObjectMove("R1 label", 0, g_time_184, l_price_52);
      if (ObjectFind("R2 label") != 0) {
         ObjectCreate("R2 label", OBJ_TEXT, 0, g_time_184, l_price_84);
         ObjectSetText("R2 label", " TBR2", StandardFontSize, "Arial", StandardFontColor);
      } else ObjectMove("R2 label", 0, g_time_184, l_price_84);
      if (ObjectFind("R3 label") != 0) {
         ObjectCreate("R3 label", OBJ_TEXT, 0, g_time_184, l_price_116);
         ObjectSetText("R3 label", " TBR3", StandardFontSize, "Arial", StandardFontColor);
      } else ObjectMove("R3 label", 0, g_time_184, l_price_116);
      if (ObjectFind("S1 label") != 0) {
         ObjectCreate("S1 label", OBJ_TEXT, 0, g_time_184, l_price_44);
         ObjectSetText("S1 label", "TB2", StandardFontSize, "Arial", StandardFontColor);
      } else ObjectMove("S1 label", 0, g_time_184, l_price_44);
      if (ObjectFind("S2 label") != 0) {
         ObjectCreate("S2 label", OBJ_TEXT, 0, g_time_184, l_price_76);
         ObjectSetText("S2 label", "TBS2", StandardFontSize, "Arial", StandardFontColor);
      } else ObjectMove("S2 label", 0, g_time_184, l_price_76);
      if (ObjectFind("S3 label") != 0) {
         ObjectCreate("S3 label", OBJ_TEXT, 0, g_time_184, l_price_108);
         ObjectSetText("S3 label", "TBS3", StandardFontSize, "Arial", StandardFontColor);
      } else ObjectMove("S3 label", 0, g_time_184, l_price_108);
      if (ObjectFind("S1 line") != 0) {
         ObjectCreate("S1 line", OBJ_HLINE, 0, g_time_188, l_price_44);
         ObjectSet("S1 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("S1 line", OBJPROP_COLOR, SupportColor);
      } else ObjectMove("S1 line", 0, g_time_188, l_price_44);
      if (ObjectFind("S2 line") != 0) {
         ObjectCreate("S2 line", OBJ_HLINE, 0, g_time_188, l_price_76);
         ObjectSet("S2 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("S2 line", OBJPROP_COLOR, SupportColor);
      } else ObjectMove("S2 line", 0, g_time_188, l_price_76);
      if (ObjectFind("S3 line") != 0) {
         ObjectCreate("S3 line", OBJ_HLINE, 0, g_time_188, l_price_108);
         ObjectSet("S3 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("S3 line", OBJPROP_COLOR, SupportColor);
      } else ObjectMove("S3 line", 0, g_time_188, l_price_108);
      if (ObjectFind("R1 line") != 0) {
         ObjectCreate("R1 line", OBJ_HLINE, 0, g_time_188, l_price_52);
         ObjectSet("R1 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("R1 line", OBJPROP_COLOR, ResistanceColor);
      } else ObjectMove("R1 line", 0, g_time_188, l_price_52);
      if (ObjectFind("R2 line") != 0) {
         ObjectCreate("R2 line", OBJ_HLINE, 0, g_time_188, l_price_84);
         ObjectSet("R2 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("R2 line", OBJPROP_COLOR, ResistanceColor);
      } else ObjectMove("R2 line", 0, g_time_188, l_price_84);
      if (ObjectFind("R3 line") != 0) {
         ObjectCreate("R3 line", OBJ_HLINE, 0, g_time_188, l_price_116);
         ObjectSet("R3 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("R3 line", OBJPROP_COLOR, ResistanceColor);
      } else ObjectMove("R3 line", 0, g_time_188, l_price_116);
   }
   if (MidPivots && StandardPivots) {
      if (ObjectFind("M5 label") != 0) {
         ObjectCreate("M5 label", OBJ_TEXT, 0, g_time_184, l_price_100);
         ObjectSetText("M5 label", " M5", MidFontSize, "Arial", MidPivotColor);
      } else ObjectMove("M5 label", 0, g_time_184, l_price_100);
      if (ObjectFind("M4 label") != 0) {
         ObjectCreate("M4 label", OBJ_TEXT, 0, g_time_184, l_price_68);
         ObjectSetText("M4 label", " M4", MidFontSize, "Arial", MidPivotColor);
      } else ObjectMove("M4 label", 0, g_time_184, l_price_68);
      if (ObjectFind("M3 label") != 0) {
         ObjectCreate("M3 label", OBJ_TEXT, 0, g_time_184, l_price_36);
         ObjectSetText("M3 label", " M3", MidFontSize, "Arial", MidPivotColor);
      } else ObjectMove("M3 label", 0, g_time_184, l_price_36);
      if (ObjectFind("M2 label") != 0) {
         ObjectCreate("M2 label", OBJ_TEXT, 0, g_time_184, l_price_28);
         ObjectSetText("M2 label", " M2", MidFontSize, "Arial", MidPivotColor);
      } else ObjectMove("M2 label", 0, g_time_184, l_price_28);
      if (ObjectFind("M1 label") != 0) {
         ObjectCreate("M1 label", OBJ_TEXT, 0, g_time_184, l_price_60);
         ObjectSetText("M1 label", " M1", MidFontSize, "Arial", MidPivotColor);
      } else ObjectMove("M1 label", 0, g_time_184, l_price_60);
      if (ObjectFind("M0 label") != 0) {
         ObjectCreate("M0 label", OBJ_TEXT, 0, g_time_184, l_price_92);
         ObjectSetText("M0 label", " M0", MidFontSize, "Arial", MidPivotColor);
      } else ObjectMove("M0 label", 0, g_time_184, l_price_92);
      if (ObjectFind("M5 line") != 0) {
         ObjectCreate("M5 line", OBJ_HLINE, 0, g_time_188, l_price_100);
         ObjectSet("M5 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("M5 line", OBJPROP_COLOR, MidPivotColor);
      } else ObjectMove("M5 line", 0, g_time_188, l_price_100);
      if (ObjectFind("M4 line") != 0) {
         ObjectCreate("M4 line", OBJ_HLINE, 0, g_time_188, l_price_68);
         ObjectSet("M4 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("M4 line", OBJPROP_COLOR, MidPivotColor);
      } else ObjectMove("M4 line", 0, g_time_188, l_price_68);
      if (ObjectFind("M3 line") != 0) {
         ObjectCreate("M3 line", OBJ_HLINE, 0, g_time_188, l_price_36);
         ObjectSet("M3 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("M3 line", OBJPROP_COLOR, MidPivotColor);
      } else ObjectMove("M3 line", 0, g_time_188, l_price_36);
      if (ObjectFind("M2 line") != 0) {
         ObjectCreate("M2 line", OBJ_HLINE, 0, g_time_188, l_price_28);
         ObjectSet("M2 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("M2 line", OBJPROP_COLOR, MidPivotColor);
      } else ObjectMove("M2 line", 0, g_time_188, l_price_28);
      if (ObjectFind("M1 line") != 0) {
         ObjectCreate("M1 line", OBJ_HLINE, 0, g_time_188, l_price_60);
         ObjectSet("M1 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("M1 line", OBJPROP_COLOR, MidPivotColor);
      } else ObjectMove("M1 line", 0, g_time_188, l_price_60);
      if (ObjectFind("M0 line") != 0) {
         ObjectCreate("M0 line", OBJ_HLINE, 0, g_time_188, l_price_92);
         ObjectSet("M0 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("M0 line", OBJPROP_COLOR, MidPivotColor);
      } else ObjectMove("M0 line", 0, g_time_188, l_price_92);
   }
   if (FibPivots) {
      if (ObjectFind("FibR1 label") != 0) {
         ObjectCreate("FibR1 label", OBJ_TEXT, 0, g_time_184, 0);
         ObjectSetText("FibR1 label", "Fib R1", FibFontSize, "Arial", FibFontColor);
      } else ObjectMove("FibR1 label", 0, g_time_184, gd_424);
      if (ObjectFind("FibR2 label") != 0) {
         ObjectCreate("FibR2 label", OBJ_TEXT, 0, g_time_184, 0);
         ObjectSetText("FibR2 label", "Fib R2", FibFontSize, "Arial", FibFontColor);
      } else ObjectMove("FibR2 label", 0, g_time_184, gd_416);
      if (ObjectFind("FibR3 label") != 0) {
         ObjectCreate("FibR3 label", OBJ_TEXT, 0, g_time_184, 0);
         ObjectSetText("FibR3 label", "Fib R3", FibFontSize, "Arial", FibFontColor);
      } else ObjectMove("FibR3 label", 0, g_time_184, gd_408);
      if (ObjectFind("FibS1 label") != 0) {
         ObjectCreate("FibS1 label", OBJ_TEXT, 0, g_time_184, 0);
         ObjectSetText("FibS1 label", "Fib S1", FibFontSize, "Arial", FibFontColor);
      } else ObjectMove("FibS1 label", 0, g_time_184, gd_440);
      if (ObjectFind("FibS2 label") != 0) {
         ObjectCreate("FibS2 label", OBJ_TEXT, 0, g_time_184, 0);
         ObjectSetText("FibS2 label", "Fib S2", FibFontSize, "Arial", FibFontColor);
      } else ObjectMove("FibS2 label", 0, g_time_184, gd_448);
      if (ObjectFind("FibS3 label") != 0) {
         ObjectCreate("FibS3 label", OBJ_TEXT, 0, g_time_184, 0);
         ObjectSetText("FibS3 label", "Fib S3", FibFontSize, "Arial", FibFontColor);
      } else ObjectMove("FibS3 label", 0, g_time_184, gd_456);
      if (ObjectFind("FibS1 line") != 0) {
         ObjectCreate("FibS1 line", OBJ_HLINE, 0, g_time_188, 0);
         ObjectSet("FibS1 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("FibS1 line", OBJPROP_COLOR, FibColor);
      } else ObjectMove("FibS1 line", 0, g_time_188, gd_440);
      if (ObjectFind("FibS2 line") != 0) {
         ObjectCreate("FibS2 line", OBJ_HLINE, 0, g_time_188, 0);
         ObjectSet("FibS2 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("FibS2 line", OBJPROP_COLOR, FibColor);
      } else ObjectMove("FibS2 line", 0, g_time_188, gd_448);
      if (ObjectFind("FibS3 line") != 0) {
         ObjectCreate("FibS3 line", OBJ_HLINE, 0, g_time_188, 0);
         ObjectSet("FibS3 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("FibS3 line", OBJPROP_COLOR, FibColor);
      } else ObjectMove("FibS3 line", 0, g_time_188, gd_456);
      if (ObjectFind("FibR1 line") != 0) {
         ObjectCreate("FibR1 line", OBJ_HLINE, 0, g_time_188, 0);
         ObjectSet("FibR1 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("FibR1 line", OBJPROP_COLOR, FibColor);
      } else ObjectMove("FibR1 line", 0, g_time_188, gd_424);
      if (ObjectFind("FibR2 line") != 0) {
         ObjectCreate("FibR2 line", OBJ_HLINE, 0, g_time_188, 0);
         ObjectSet("FibR2 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("FibR2 line", OBJPROP_COLOR, FibColor);
      } else ObjectMove("FibR2 line", 0, g_time_188, gd_416);
      if (ObjectFind("FibR3 line") != 0) {
         ObjectCreate("FibR3 line", OBJ_HLINE, 0, g_time_188, 0);
         ObjectSet("FibR3 line", OBJPROP_STYLE, STYLE_DASHDOTDOT);
         ObjectSet("FibR3 line", OBJPROP_COLOR, FibColor);
      } else ObjectMove("FibR3 line", 0, g_time_188, gd_408);
   }
   if (CamarillaPivots) {
      if (ObjectFind("H5 label") != 0) {
         ObjectCreate("H5 label", OBJ_TEXT, 0, g_time_184, g_price_232);
         ObjectSetText("H5 label", "Cam H5", CamFontSize, "Arial", CamFontColor);
      } else ObjectMove("H5 label", 0, g_time_184, g_price_232);
      if (ObjectFind("H4 label") != 0) {
         ObjectCreate("H4 label", OBJ_TEXT, 0, g_time_184, g_price_224);
         ObjectSetText("H4 label", "Cam H4", CamFontSize, "Arial", CamFontColor);
      } else ObjectMove("H4 label", 0, g_time_184, g_price_224);
      if (ObjectFind("H3 label") != 0) {
         ObjectCreate("H3 label", OBJ_TEXT, 0, g_time_184, g_price_216);
         ObjectSetText("H3 label", "Cam H3", CamFontSize, "Arial", CamFontColor);
      } else ObjectMove("H3 label", 0, g_time_184, g_price_216);
      if (UseH1H2L1L2) {
         if (ObjectFind("H2 label") != 0) {
            ObjectCreate("H2 label", OBJ_TEXT, 0, g_time_184, g_price_208);
            ObjectSetText("H2 label", "Cam H2", CamFontSize, "Arial", CamFontColor);
         } else ObjectMove("H1 label", 0, g_time_184, gd_200);
         if (ObjectFind("H1 label") != 0) {
            ObjectCreate("H1 label", OBJ_TEXT, 0, g_time_184, gd_200);
            ObjectSetText("H1 label", "Cam H1", CamFontSize, "Arial", CamFontColor);
         } else ObjectMove("H1 label", 0, g_time_184, gd_200);
         if (ObjectFind("L1 label") != 0) {
            ObjectCreate("L1 label", OBJ_TEXT, 0, g_time_184, g_price_240);
            ObjectSetText("L1 label", "Cam L1", CamFontSize, "Arial", CamFontColor);
         } else ObjectMove("L1 label", 0, g_time_184, g_price_240);
         if (ObjectFind("L2 label") != 0) {
            ObjectCreate("L2 label", OBJ_TEXT, 0, g_time_184, g_price_248);
            ObjectSetText("L2 label", "Cam L2", CamFontSize, "Arial", CamFontColor);
         } else ObjectMove("L2 label", 0, g_time_184, g_price_248);
      }
      if (ObjectFind("L3 label") != 0) {
         ObjectCreate("L3 label", OBJ_TEXT, 0, g_time_184, g_price_256);
         ObjectSetText("L3 label", "Cam L3", CamFontSize, "Arial", CamFontColor);
      } else ObjectMove("L3 label", 0, g_time_184, g_price_256);
      if (ObjectFind("L4 label") != 0) {
         ObjectCreate("L4 label", OBJ_TEXT, 0, g_time_184, g_price_264);
         ObjectSetText("L4 label", "Cam L4", CamFontSize, "Arial", CamFontColor);
      } else ObjectMove("L4 label", 0, g_time_184, g_price_264);
      if (ObjectFind("L5 label") != 0) {
         ObjectCreate("L5 label", OBJ_TEXT, 0, g_time_184, g_price_272);
         ObjectSetText("L5 label", "Cam L5", CamFontSize, "Arial", CamFontColor);
      } else ObjectMove("L5 label", 0, g_time_184, g_price_272);
      if (ObjectFind("H5 line") != 0) {
         ObjectCreate("H5 line", OBJ_HLINE, 0, g_time_188, g_price_232);
         ObjectSet("H5 line", OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("H5 line", OBJPROP_COLOR, SpringGreen);
         ObjectSet("H5 line", OBJPROP_WIDTH, 1);
      } else ObjectMove("H5 line", 0, g_time_188, g_price_232);
      if (ObjectFind("H4 line") != 0) {
         ObjectCreate("H4 line", OBJ_HLINE, 0, g_time_188, g_price_224);
         ObjectSet("H4 line", OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("H4 line", OBJPROP_COLOR, SpringGreen);
         ObjectSet("H4 line", OBJPROP_WIDTH, 1);
      } else ObjectMove("H4 line", 0, g_time_188, g_price_224);
      if (ObjectFind("H3 line") != 0) {
         ObjectCreate("H3 line", OBJ_HLINE, 0, g_time_188, g_price_216);
         ObjectSet("H3 line", OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("H3 line", OBJPROP_COLOR, SpringGreen);
         ObjectSet("H3 line", OBJPROP_WIDTH, 1);
      } else ObjectMove("H3 line", 0, g_time_188, g_price_216);
      if (UseH1H2L1L2) {
         if (ObjectFind("H2 line") != 0) {
            ObjectCreate("H2 line", OBJ_HLINE, 0, g_time_188, g_price_208);
            ObjectSet("H2 line", OBJPROP_STYLE, STYLE_SOLID);
            ObjectSet("H2 line", OBJPROP_COLOR, SpringGreen);
            ObjectSet("H2 line", OBJPROP_WIDTH, 1);
         } else ObjectMove("H2 line", 0, g_time_188, g_price_208);
         if (ObjectFind("H1 line") != 0) {
            ObjectCreate("H1 line", OBJ_HLINE, 0, g_time_188, gd_200);
            ObjectSet("H1 line", OBJPROP_STYLE, STYLE_SOLID);
            ObjectSet("H1 line", OBJPROP_COLOR, SpringGreen);
            ObjectSet("H1 line", OBJPROP_WIDTH, 1);
         } else ObjectMove("H1 line", 0, g_time_188, gd_200);
         if (ObjectFind("L1 line") != 0) {
            ObjectCreate("L1 line", OBJ_HLINE, 0, g_time_188, g_price_240);
            ObjectSet("L1 line", OBJPROP_STYLE, STYLE_SOLID);
            ObjectSet("L1 line", OBJPROP_COLOR, Red);
            ObjectSet("L1 line", OBJPROP_WIDTH, 1);
         } else ObjectMove("L1 line", 0, g_time_188, g_price_240);
         if (ObjectFind("L2 line") != 0) {
            ObjectCreate("L2 line", OBJ_HLINE, 0, g_time_188, g_price_248);
            ObjectSet("L2 line", OBJPROP_STYLE, STYLE_SOLID);
            ObjectSet("L2 line", OBJPROP_COLOR, Red);
            ObjectSet("L2 line", OBJPROP_WIDTH, 1);
         } else ObjectMove("L2 line", 0, g_time_188, g_price_248);
      }
      if (ObjectFind("L3 line") != 0) {
         ObjectCreate("L3 line", OBJ_HLINE, 0, g_time_188, g_price_256);
         ObjectSet("L3 line", OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("L3 line", OBJPROP_COLOR, Red);
         ObjectSet("L3 line", OBJPROP_WIDTH, 1);
      } else ObjectMove("L3 line", 0, g_time_188, g_price_256);
      if (ObjectFind("L4 line") != 0) {
         ObjectCreate("L4 line", OBJ_HLINE, 0, g_time_188, g_price_264);
         ObjectSet("L4 line", OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("L4 line", OBJPROP_COLOR, Red);
         ObjectSet("L4 line", OBJPROP_WIDTH, 1);
      } else ObjectMove("L4 line", 0, g_time_188, g_price_264);
      if (ObjectFind("L5 line") != 0) {
         ObjectCreate("L5 line", OBJ_HLINE, 0, g_time_188, g_price_272);
         ObjectSet("L5 line", OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("L5 line", OBJPROP_COLOR, Red);
         ObjectSet("L5 line", OBJPROP_WIDTH, 1);
      } else ObjectMove("L5 line", 0, g_time_188, g_price_272);
   }
   return (0);
}

bool ChecarValidadeConta(int ai_0, int ai_4, int ai_8, string as_12) {
   int l_datetime_20 = TimeCurrent();
   int l_str2time_24 = StrToTime(as_12);
   if (l_datetime_20 >= l_str2time_24) {
      Comment("--Indicator has beend expired--");
      ObjectsDeleteAll();
      return (TRUE);
   }
   if (!ai_4 && IsDemo()) return (TRUE);
   if (!IsDemo() && AccountNumber() != ai_8) return (FALSE);
   if (ai_0 != 0) {
      if (Period() != ai_0) {
         Comment(" -- Periodo Incorreto --");
         return (TRUE);
      }
      Comment(" -- Working --");
   }
   return (FALSE);
}