
// Original Sidus Method filtered with RSI and CCI.
// Edited by Anthony Pham using EMA-Crossover_Signal.mq4 as a
// template.
//(Jason Robinson, jnrtrading, http://www.jnrtrading.co.uk)

/*
  +------------------------------------------------------------------+
  | Shows an arrow when there is a Sidus signal.  Shows dots when    |
  | the Sidus tunnel crosses.   Blue dot confirms uptrend.  Red dot  |
  | confirms downtrend.  Alerts on Sidus signal by default - Sounds  |
  | alert and sends e-mail.                                          |
  +------------------------------------------------------------------+
*/   

extern bool Alerts = true;
extern bool Tunnel_Alerts= false;
extern bool Email_Alerts = false;

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Aqua
#property indicator_color2 Red
#property indicator_color3 Blue
#property indicator_color4 Red

#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1

double CrossUp[];
double CrossDown[];
double Tup[];
double Tdown[];
bool   DownTunnel = false;
bool   UpTunnel = false;
bool   Signal = false;

extern int FasterEMA = 5;
extern int SlowerEMA = 12;
extern int FasterSidusEMA = 18;
extern int SlowerSidusEMA = 28;

int upalert=false,downalert=false;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW, EMPTY);
   SetIndexArrow(0, 241);
   SetIndexBuffer(0, CrossUp);
   SetIndexStyle(1, DRAW_ARROW, EMPTY);
   SetIndexArrow(1, 242);
   SetIndexBuffer(1, CrossDown);
   SetIndexStyle(2, DRAW_ARROW, EMPTY);
   SetIndexArrow(2, 167);
   SetIndexBuffer(2, Tup);
   SetIndexStyle(3, DRAW_ARROW, EMPTY);
   SetIndexArrow(3, 167);
   SetIndexBuffer(3, Tdown);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int limit, i, counter;
   double RSI, RSIp, CCI, FasterEMAnow, SlowerEMAnow, FasterEMAprevious, SlowerEMAprevious, FasterEMAafter, SlowerEMAafter, fasterSidusEMAnow, fasterSidusEMAprevious, fasterSidusEMAafter, slowerSidusEMAnow, slowerSidusEMAprevious, slowerSidusEMAafter;
   double Range, AvgRange;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

   limit=Bars-counted_bars;
   
   for(i = 0; i <= limit; i++) {

      counter=i;
      Range=0;
      AvgRange=0;
   
      for (counter=i ;counter<=i+9;counter++)
      {
         AvgRange=AvgRange+MathAbs(High[counter]-Low[counter]);
      }

      Range=AvgRange/10;
       
      FasterEMAnow = iMA(NULL, 0, FasterEMA, 0, MODE_EMA, PRICE_CLOSE, i);
      FasterEMAprevious = iMA(NULL, 0, FasterEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
      FasterEMAafter = iMA(NULL, 0, SlowerEMA, 0, MODE_EMA, PRICE_CLOSE, i-1);

      SlowerEMAnow = iMA(NULL, 0, SlowerEMA, 0, MODE_EMA, PRICE_CLOSE, i);
      SlowerEMAprevious = iMA(NULL, 0, SlowerEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
      SlowerEMAafter = iMA(NULL, 0, SlowerEMA, 0, FasterEMA, PRICE_CLOSE, i-1);

      fasterSidusEMAnow = iMA(NULL, 0, FasterSidusEMA, 0, MODE_EMA, PRICE_CLOSE, i);
      fasterSidusEMAprevious = iMA(NULL, 0, FasterSidusEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
      fasterSidusEMAafter = iMA(NULL, 0, FasterSidusEMA, 0, MODE_EMA, PRICE_CLOSE, i-1);

      slowerSidusEMAnow = iMA(NULL, 0, SlowerSidusEMA, 0, MODE_EMA, PRICE_CLOSE, i);
      slowerSidusEMAprevious = iMA(NULL, 0, SlowerSidusEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
      slowerSidusEMAafter = iMA(NULL, 0, SlowerSidusEMA, 0, MODE_EMA, PRICE_CLOSE, i-1);
      
      RSI=iRSI(NULL,0,21,PRICE_CLOSE,i);
      RSIp=iRSI(NULL,0,21,PRICE_CLOSE,i+1);
      
      CCI=iCCI(NULL,0,50,PRICE_CLOSE,i);
      
      if (   fasterSidusEMAnow > slowerSidusEMAnow &&
             fasterSidusEMAprevious <= slowerSidusEMAprevious &&
             fasterSidusEMAafter > slowerSidusEMAafter )
      { 
         UpTunnel=true; DownTunnel=false; Tup[i] = Low[i] - Range*1;
         if( i<=2 && Alerts && !upalert && Tunnel_Alerts )
         {
            upalert=true; downalert=false;
            Alert (Symbol()," ",Period(),"M  Sidus Tunnel UP ");
            if ( Email_Alerts ) { SendMail("Sidus Tunnel UP "+Symbol(),""); }
         }
      }

      if ( fasterSidusEMAnow < slowerSidusEMAnow &&
           fasterSidusEMAprevious >= slowerSidusEMAprevious &&
           fasterSidusEMAafter < slowerSidusEMAafter )
      {
         DownTunnel=true; UpTunnel=false; Tdown[i] = High[i] + Range*1.2;
         if( i<=2 && Alerts && !downalert && Tunnel_Alerts )
         {
            upalert=false; downalert=true;
            Alert (Symbol()," ",Period(),"M  Sidus Tunnel DOWN ");
            if ( Email_Alerts ) { SendMail("Sidus Tunnel DOWN "+Symbol(),""); }
         }
      }
      
      if (  
           ( // Conditions for up signal for EMA-Sidus crosses
             (( FasterEMAnow > fasterSidusEMAnow && FasterEMAnow > slowerSidusEMAnow ) ||
              ( SlowerEMAnow > fasterSidusEMAnow && SlowerEMAnow > slowerSidusEMAnow )) &&
             ( FasterEMAprevious <= fasterSidusEMAprevious || FasterEMAprevious <= slowerSidusEMAprevious ) &&
             ( SlowerEMAprevious <= fasterSidusEMAprevious || SlowerEMAprevious <= slowerSidusEMAprevious ) &&
             RSI > 50 &&
             CCI > 0 &&
             UpTunnel
           )
         )
         {   // IF all that above is correct, then do this:
             UpTunnel=false;
             DownTunnel=false;
             Signal=true;
             CrossUp[i] = Low[i] - Range*1.6;
             if(i<=2 && Alerts && !upalert)
               {
                  Alert (Symbol()," ",Period(),"M  Sidus BUY ");
                  if ( Email_Alerts ) { SendMail("Sidus BUY "+Symbol(),""); }
                  upalert=true;
                  downalert=false;
               }
         }
      
      if (  
           ( // Conditions for down signal for EMA-Sidus crosses too
             (( FasterEMAnow < fasterSidusEMAnow && FasterEMAnow < slowerSidusEMAnow ) ||
              ( SlowerEMAnow < fasterSidusEMAnow && SlowerEMAnow < slowerSidusEMAnow )) &&
             ( FasterEMAprevious >= fasterSidusEMAprevious || FasterEMAprevious >= slowerSidusEMAprevious ) &&
             ( SlowerEMAprevious >= fasterSidusEMAprevious || SlowerEMAprevious >= slowerSidusEMAprevious ) &&
             RSI < 50 &&
             CCI < 0 &&
             DownTunnel
           )
         )
         {   // IF all that above is correct, then do this:
             UpTunnel=false;
             DownTunnel=false;
             Signal=true;
             CrossDown[i] = High[i] + Range*1.2;
             if(i<=2 && Alerts && !downalert)
               {
                  Alert (Symbol()," ",Period(),"M  Sidus SELL ");
                  if ( Email_Alerts ) { SendMail("Sidus SELL "+Symbol(),""); }
                  downalert=true;
                  upalert=false;
               }
         }
   }
   
   return(0);
}



