#property copyright "Copyright  2008, Rone_IS & FXIBANK."
#property link      "rone.sergey@gmail.com, sergey@fxibank.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Gray
#property indicator_color2 Red

extern int First_Period = 25;
extern int Second_Period = 13;
extern int Signal_Period = 5;
double g_ibuf_88[];
double g_ibuf_92[];
double g_ibuf_96[];
double g_ibuf_100[];
double g_ibuf_104[];
double g_ibuf_108[];

int init() {
   IndicatorBuffers(6);
   SetIndexBuffer(0, g_ibuf_88);
   SetIndexStyle(0, DRAW_LINE);
   SetIndexDrawBegin(0, 10 * First_Period);
   SetIndexBuffer(1, g_ibuf_92);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexDrawBegin(1, 10 * First_Period);
   SetIndexBuffer(2, g_ibuf_96);
   SetIndexBuffer(3, g_ibuf_100);
   SetIndexBuffer(4, g_ibuf_104);
   SetIndexBuffer(5, g_ibuf_108);
   IndicatorShortName("TSI (" + First_Period + "," + Second_Period + ") Signal Line (" + Signal_Period + ")");
   SetIndexLabel(0, "TSI");
   SetIndexLabel(1, "Signal Line");
   return (0);
}

int deinit() {
   ObjectDelete("TSI");
   for (int count_0 = 0; count_0 <= Bars; count_0++) {
      ObjectDelete("TSIBuySignal" + count_0);
      ObjectDelete("TSISellSignal" + count_0);
   }
   return (0);
}

int start() {
   double ima_on_arr_0;
   double ima_on_arr_8;
   int ind_counted_16;
   int li_20;
   int li_24;
   int li_28;
   int li_32;
   /*if (CheckTerminal() != 0) {*/
      ind_counted_16 = IndicatorCounted();
      if (ind_counted_16 == 0) {
         li_20 = Bars - 1;
         li_24 = li_20 - First_Period;
         li_28 = li_24 - Second_Period;
         li_32 = li_28 - Signal_Period;
      }
      if (ind_counted_16 > 0) {
         li_20 = Bars - ind_counted_16;
         li_24 = li_20;
         li_28 = li_20;
         li_32 = li_20;
      }
      for (int li_36 = li_20; li_36 >= 0; li_36--) {
         g_ibuf_96[li_36] = Close[li_36] - (Close[li_36 + 1]);
         g_ibuf_104[li_36] = MathAbs(Close[li_36] - (Close[li_36 + 1]));
      }
      for (li_36 = li_24; li_36 >= 0; li_36--) {
         g_ibuf_100[li_36] = iMAOnArray(g_ibuf_96, 0, First_Period, 0, MODE_EMA, li_36);
         g_ibuf_108[li_36] = iMAOnArray(g_ibuf_104, 0, First_Period, 0, MODE_EMA, li_36);
      }
      for (li_36 = li_28; li_36 >= 0; li_36--) {
         ima_on_arr_0 = iMAOnArray(g_ibuf_100, 0, Second_Period, 0, MODE_EMA, li_36);
         ima_on_arr_8 = iMAOnArray(g_ibuf_108, 0, Second_Period, 0, MODE_EMA, li_36);
         g_ibuf_88[li_36] = 100.0 * ima_on_arr_0 / ima_on_arr_8;
      }
      for (li_36 = li_32; li_36 >= 0; li_36--) g_ibuf_92[li_36] = iMAOnArray(g_ibuf_88, 0, Signal_Period, 0, MODE_EMA, li_36);
      ObjectCreate("TSI", OBJ_LABEL, WindowFind("TSI (" + First_Period + "," + Second_Period + ") Signal Line (" + Signal_Period + ")"), 0, 0);
      ObjectSetText("TSI", "www.fxibank.com", 12, "Arial ", DarkGray);
      ObjectSet("TSI", OBJPROP_CORNER, 0);
      ObjectSet("TSI", OBJPROP_XDISTANCE, 5);
      ObjectSet("TSI", OBJPROP_YDISTANCE, 20);
   }
   //return (0);
/*}*/

/*int CheckTerminal() {
   if (AccountCompany() == "Joint-Stock Commercial Bank \"Integral\"") return (1);
   return (0);
}*/