//+------------------------------------------------------------------+
//|                                             CandleAverage_v1.mq4 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Blue

//---- input parameters
extern int       Length=31;
extern int       H_period=25;
extern int       L_period=27;
extern int       C_period= 9;
//---- buffers
double CandleAvg[];
double BarValue[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,CandleAvg);
   SetIndexBuffer(1,BarValue);
//---- name for DataWindow and indicator subwindow label
   string short_name="CandleAverage("+Length+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"CandleAvg");
   SetIndexDrawBegin(0,Length);
//----
   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int shift, limit, counted_bars=IndicatorCounted();
   double UpDel,DnDel,H,L,C;
//---- 
   if(counted_bars<0) return(-1);
   if (counted_bars==0) limit=Bars-Length-1;
//---- last counted bar will be recounted
   if(counted_bars>0) limit=Bars-counted_bars;
   limit--;
   
   for(shift=limit; shift>=0; shift--)
   {
   H = iMA(NULL,0, H_period,0, MODE_EMA, PRICE_HIGH, shift);
   L = iMA(NULL,0, L_period,0, MODE_EMA, PRICE_LOW, shift);
   C = iMA(NULL,0, C_period,0, MODE_EMA, PRICE_CLOSE, shift);
   
   UpDel = H - C;
   DnDel = C - L;
   
   if ( UpDel < DnDel )  BarValue[shift] =  1;
   if ( UpDel > DnDel )  BarValue[shift] = -1;   
   if ( UpDel == DnDel ) BarValue[shift] =  0;
   }
   
   for(shift=limit; shift>=0; shift--)
   {
   CandleAvg[shift] = iMAOnArray(BarValue,0,Length,0,MODE_SMA,shift); 
   }
   
//----
   return(0);
  }
//+------------------------------------------------------------------+