
#property indicator_chart_window

extern int NumberOfDays = 7;
extern string AsiaBegin = "01:00";
extern string AsiaEnd = "10:00";
extern color AsiaColor = DarkGreen;
extern string EurBegin = "07:00";
extern string EurEnd = "16:00";
extern color EurColor = DarkSlateGray;
extern string USABegin = "14:00";
extern string USAEnd = "23:00";
extern color USAColor = Navy;
extern bool ShowPrice = TRUE;
extern color clFont = Blue;
extern int SizeFont = 8;
extern int OffSet = 10;

void init() {
   DeleteObjects();
   for (int l_count_0 = 0; l_count_0 < NumberOfDays; l_count_0++) {
      CreateObjects("AS" + l_count_0, AsiaColor);
      CreateObjects("EU" + l_count_0, EurColor);
      CreateObjects("US" + l_count_0, USAColor);
   }
   Comment("");
}

void deinit() {
   DeleteObjects();
   Comment("");
}

void CreateObjects(string a_name_0, color a_color_8) {
   ObjectCreate(a_name_0, OBJ_RECTANGLE, 0, 0, 0, 0, 0);
   ObjectSet(a_name_0, OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet(a_name_0, OBJPROP_COLOR, a_color_8);
   ObjectSet(a_name_0, OBJPROP_BACK, TRUE);
}

void DeleteObjects() {
   for (int l_count_0 = 0; l_count_0 < NumberOfDays; l_count_0++) {
      ObjectDelete("AS" + l_count_0);
      ObjectDelete("EU" + l_count_0);
      ObjectDelete("US" + l_count_0);
   }
   ObjectDelete("ASup");
   ObjectDelete("ASdn");
   ObjectDelete("EUup");
   ObjectDelete("EUdn");
   ObjectDelete("USup");
   ObjectDelete("USdn");
}

void start() {
   int l_datetime_0 = TimeCurrent();
   for (int l_count_4 = 0; l_count_4 < NumberOfDays; l_count_4++) {
      if (ShowPrice && l_count_4 == 0) {
         DrawPrices(l_datetime_0, "AS", AsiaBegin, AsiaEnd);
         DrawPrices(l_datetime_0, "EU", EurBegin, EurEnd);
         DrawPrices(l_datetime_0, "US", USABegin, USAEnd);
      }
      DrawObjects(l_datetime_0, "AS" + l_count_4, AsiaBegin, AsiaEnd);
      DrawObjects(l_datetime_0, "EU" + l_count_4, EurBegin, EurEnd);
      DrawObjects(l_datetime_0, "US" + l_count_4, USABegin, USAEnd);
      for (l_datetime_0 = decDateTradeDay(l_datetime_0); TimeDayOfWeek(l_datetime_0) > 5; l_datetime_0 = decDateTradeDay(l_datetime_0)) {
      }
   }
}

void DrawObjects(int ai_0, string a_name_4, string as_12, string as_20) {
   int l_str2time_28 = StrToTime(TimeToStr(ai_0, TIME_DATE) + " " + as_12);
   int l_str2time_32 = StrToTime(TimeToStr(ai_0, TIME_DATE) + " " + as_20);
   int l_shift_52 = iBarShift(NULL, 0, l_str2time_28);
   int l_shift_56 = iBarShift(NULL, 0, l_str2time_32);
   double l_high_36 = High[iHighest(NULL, 0, MODE_HIGH, l_shift_52 - l_shift_56, l_shift_56)];
   double l_low_44 = Low[iLowest(NULL, 0, MODE_LOW, l_shift_52 - l_shift_56, l_shift_56)];
   ObjectSet(a_name_4, OBJPROP_TIME1, l_str2time_28);
   ObjectSet(a_name_4, OBJPROP_PRICE1, l_high_36);
   ObjectSet(a_name_4, OBJPROP_TIME2, l_str2time_32);
   ObjectSet(a_name_4, OBJPROP_PRICE2, l_low_44);
}

void DrawPrices(int ai_0, string as_4, string as_12, string as_20) {
   int l_str2time_28 = StrToTime(TimeToStr(ai_0, TIME_DATE) + " " + as_12);
   int l_str2time_32 = StrToTime(TimeToStr(ai_0, TIME_DATE) + " " + as_20);
   int l_shift_52 = iBarShift(NULL, 0, l_str2time_28);
   int l_shift_56 = iBarShift(NULL, 0, l_str2time_32);
   double l_high_36 = High[iHighest(NULL, 0, MODE_HIGH, l_shift_52 - l_shift_56, l_shift_56)];
   double l_low_44 = Low[iLowest(NULL, 0, MODE_LOW, l_shift_52 - l_shift_56, l_shift_56)];
   if (ObjectFind(as_4 + "up") < 0) ObjectCreate(as_4 + "up", OBJ_TEXT, 0, 0, 0);
   ObjectSet(as_4 + "up", OBJPROP_TIME1, l_str2time_32);
   ObjectSet(as_4 + "up", OBJPROP_PRICE1, l_high_36 + OffSet * Point);
   ObjectSet(as_4 + "up", OBJPROP_COLOR, clFont);
   ObjectSet(as_4 + "up", OBJPROP_FONTSIZE, SizeFont);
   ObjectSetText(as_4 + "up", DoubleToStr(l_high_36 + Ask - Bid, Digits));
   if (ObjectFind(as_4 + "dn") < 0) ObjectCreate(as_4 + "dn", OBJ_TEXT, 0, 0, 0);
   ObjectSet(as_4 + "dn", OBJPROP_TIME1, l_str2time_32);
   ObjectSet(as_4 + "dn", OBJPROP_PRICE1, l_low_44);
   ObjectSet(as_4 + "dn", OBJPROP_COLOR, clFont);
   ObjectSet(as_4 + "dn", OBJPROP_FONTSIZE, SizeFont);
   ObjectSetText(as_4 + "dn", DoubleToStr(l_low_44, Digits));
}

int decDateTradeDay(int ai_0) {
   int li_4 = TimeYear(ai_0);
   int li_8 = TimeMonth(ai_0);
   int li_12 = TimeDay(ai_0);
   int l_hour_16 = TimeHour(ai_0);
   int l_minute_20 = TimeMinute(ai_0);
   li_12--;
   if (li_12 == 0) {
      li_8--;
      if (li_8 == 0) {
         li_4--;
         li_8 = 12;
      }
      if (li_8 == 1 || li_8 == 3 || li_8 == 5 || li_8 == 7 || li_8 == 8 || li_8 == 10 || li_8 == 12) li_12 = 31;
      if (li_8 == 2) {
         if (MathMod(li_4, 4) == 0.0) li_12 = 29;
         else li_12 = 28;
      }
      if (li_8 == 4 || li_8 == 6 || li_8 == 9 || li_8 == 11) li_12 = 30;
   }
   return (StrToTime(li_4 + "." + li_8 + "." + li_12 + " " + l_hour_16 + ":" + l_minute_20));
}