//+------------------------------------------------------------------+
//|                                   Copyright  2010, Ivan Kornilov|
//|                                                    TrendValue.mq4|
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Ivan Kornilov. All rights reserved."
#property link "excelf@gmail.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color2 Magenta
#property indicator_color1 Lime

extern int period = 13;
extern double shiftPercent = 0;
extern int atrPeriod = 15;
extern double atrSensitivity = 1.5;

double upValue[];
double downValue[];

double highMovingAverages[];
double lowMovingAverages[];
double buffer[];

int init() {
   IndicatorBuffers(5);
   SetIndexStyle(0, DRAW_LINE, EMPTY, 2);
   SetIndexBuffer(0, upValue);
   SetIndexLabel(0, "Up Value");
   
   SetIndexStyle(1, DRAW_LINE, EMPTY, 2);
   SetIndexBuffer(1, downValue);
   SetIndexLabel(1, "Down Value");
   
   IndicatorDigits(Digits + 1);   
   SetIndexBuffer(2, buffer);
   SetIndexStyle(2, DRAW_NONE);
   
   SetIndexBuffer(3, highMovingAverages);
   SetIndexStyle(3, DRAW_NONE);
   SetIndexBuffer(4, lowMovingAverages);
   SetIndexStyle(4, DRAW_NONE);
   IndicatorShortName("Trand Value (" + period + "," + shiftPercent+ ")");
   return (0);
}

int start() {
   if (Bars <= period) { 
        return (0);
   }
   int indicatorCounted = IndicatorCounted();
   if (indicatorCounted < 0) { 
        return (-1);
   }
   if (indicatorCounted > 0) {
        indicatorCounted--;
   }
   int limit = Bars - indicatorCounted;
   for (int i = limit-1; i >= 0; i--) {
      double atr = iATR(NULL, 0, atrPeriod, i) * atrSensitivity;
      highMovingAverages[i] = iMA(NULL, 0, period, 0, MODE_LWMA, PRICE_HIGH, i) * (1 + shiftPercent / 100) + atr * atrSensitivity;
      lowMovingAverages[i] = iMA(NULL, 0, period, 0, MODE_LWMA, PRICE_LOW, i) * (1 - shiftPercent / 100) - atr * atrSensitivity;
      
      buffer[i] = buffer[i + 1];
      if (Close[i] > highMovingAverages[i + 1]) {
        buffer[i] = 1;
      }
      if (Close[i] < lowMovingAverages[i + 1]) {
        buffer[i] = -1;
      }
      if (buffer[i] > 0.0) {
         if (lowMovingAverages[i] < lowMovingAverages[i + 1]) {
            lowMovingAverages[i] = lowMovingAverages[i + 1];
         }
         
         /*
         if (highMovingAverages[i] < highMovingAverages[i + 1]) {
            highMovingAverages[i] = highMovingAverages[i + 1];
         }
         */
         upValue[i] = lowMovingAverages[i];
         downValue[i] = EMPTY_VALUE;
        
      } else {
         if (highMovingAverages[i] > highMovingAverages[i + 1]) {
            highMovingAverages[i] = highMovingAverages[i + 1];
         }
         
         /*  
         if (lowMovingAverages[i] > lowMovingAverages[i + 1]) {
            lowMovingAverages[i] = lowMovingAverages[i + 1];
         }*/
         
         downValue[i] = highMovingAverages[i];
         upValue[i] = EMPTY_VALUE;
      }
   }
}