//--------------------------------------------------------------------
// roc.mq4 (Priliv)
//         MQL4.
//--------------------------------------------------------------- 1 --
#property copyright "Copyright  SK, 2007"
#property link      "http://AutoGraf.dp.ua"
//--------------------------------------------------------------------
#property indicator_chart_window    // .    
#property indicator_buffers 6       //  
#property indicator_color1 Black    //   0 
#property indicator_color2 DarkOrange//  1 
#property indicator_color3 Green    //   2 
#property indicator_color4 Brown    //   3 
#property indicator_color5 Blue     //   4 
#property indicator_color6 Red      //   5 
//--------------------------------------------------------------- 2 --
extern int History    =5000;      // .   
extern int Period_MA_0=13;        //     . 
extern int Period_MA_1=21;        //   
extern int Bars_V     =13;        // .   
extern int Aver_Bars  =5;         // .   
extern double K       =2;         //  
//--------------------------------------------------------------- 3 --
int
   Period_MA_2,  Period_MA_3,       //     . 
   Period_MA_02, Period_MA_03,      //     
   K2, K3;                          //   
double
   Line_0[],                        // .   MA
   Line_1[], Line_2[], Line_3[],    // .    
   Line_4[],                        // .  
   Line_5[],                        // .  
   Sh_1, Sh_2, Sh_3;                // .  . 
//--------------------------------------------------------------- 4 --
int init()                          //   init()
  {
   SetIndexBuffer(0,Line_0);        //   
   SetIndexBuffer(1,Line_1);        //   
   SetIndexBuffer(2,Line_2);        //   
   SetIndexBuffer(3,Line_3);        //   
   SetIndexBuffer(4,Line_4);        //   
   SetIndexBuffer(5,Line_5);        //   
   SetIndexStyle (5,DRAW_LINE,STYLE_SOLID,3);//  
//--------------------------------------------------------------- 5 --
   switch(Period())                 //   ..
     {                             // ..  
      case     1: K2=5;K3=15; break;//  1
      case     5: K2=3;K3= 6; break;//  5
      case    15: K2=2;K3= 4; break;//  15
      case    30: K2=2;K3= 8; break;//  30
      case    60: K2=4;K3=24; break;//  H1
      case   240: K2=6;K3=42; break;//  H4
      case  1440: K2=7;K3=30; break;//  D1
      case 10080: K2=4;K3=12; break;//  W1
      case 43200: K2=3;K3=12; break;//  N
     }
//--------------------------------------------------------------- 6 --
   Sh_1=Bars_V;                   //    ()
   Sh_2=K2*Sh_1;                  //  .  . 
   Sh_3=K3*Sh_1;                  //  .  . 
   Period_MA_2 =K2*Period_MA_1;   // .   . 
   Period_MA_3 =K3*Period_MA_1;   // .   . 
   Period_MA_02=K2*Period_MA_0;   //     . 
   Period_MA_03=K3*Period_MA_0;   //     . 
//--------------------------------------------------------------- 7 --
   return;                          //   .  init()
  }
//--------------------------------------------------------------- 8 --
int start()                         //   start()
  {
//--------------------------------------------------------------- 9 --
   double
   MA_0, MA_02, MA_03,           //     
   MA_c, MA_p,                   //   . . 
   Sum;                          // .  . 
   int
   i,                            //  
   n,                            // . ( )
   Counted_bars;                 //    
//-------------------------------------------------------------- 10 --
   Counted_bars=IndicatorCounted(); //    
   i=Bars-Counted_bars-1;           //   
   if (i>History-1)                 //     ..
      i=History-1;                  // ..  .
//-------------------------------------------------------------- 11 --
   while(i>=0)                      //    
     {
      //-------------------------------------------------------- 12 --
      MA_0=iMA(NULL,0,Period_MA_0,0,MODE_LWMA,PRICE_TYPICAL,i);
      Line_0[i]=MA_0;               //   
      //-------------------------------------------------------- 13 --
      MA_c=iMA(NULL,0,Period_MA_1,0,MODE_LWMA,PRICE_TYPICAL,i);
      MA_p=iMA(NULL,0,Period_MA_1,0,MODE_LWMA,PRICE_TYPICAL,i+Sh_1);
      Line_1[i]= MA_0+K*(MA_c-MA_p);//  1  
      //-------------------------------------------------------- 14 --
      MA_c=iMA(NULL,0,Period_MA_2,0,MODE_LWMA,PRICE_TYPICAL,i);
      MA_p=iMA(NULL,0,Period_MA_2,0,MODE_LWMA,PRICE_TYPICAL,i+Sh_2);
      MA_02= iMA(NULL,0,Period_MA_02,0,MODE_LWMA,PRICE_TYPICAL,i);
      Line_2[i]=MA_02+K*(MA_c-MA_p);//  2  
      //-------------------------------------------------------- 15 --
      MA_c=iMA(NULL,0,Period_MA_3,0,MODE_LWMA,PRICE_TYPICAL,i);
      MA_p=iMA(NULL,0,Period_MA_3,0,MODE_LWMA,PRICE_TYPICAL,i+Sh_3);
      MA_03= iMA(NULL,0,Period_MA_03,0,MODE_LWMA,PRICE_TYPICAL,i);
      Line_3[i]=MA_03+K*(MA_c-MA_p);//  3  
      //-------------------------------------------------------- 16 --
      Line_4[i]=(Line_1[i]+Line_2[i]+Line_3[i])/3;//  
      //-------------------------------------------------------- 17 --
      if (Aver_Bars<0)              //    
         Aver_Bars=0;               // ..    
      Sum=0;                        //  
      for(n=i; n<=i+Aver_Bars; n++) //   .
         Sum=Sum + Line_4[n];     //   . .
      Line_5[i]= Sum/(Aver_Bars+1); // .   
      //-------------------------------------------------------- 18 --
      i--;                          //    
      //-------------------------------------------------------- 19 --
     }
   return;                          //   . - start()
  }
//-------------------------------------------------------------- 20 --