#property copyright "taurus"
#property link      "http:www..."

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_color2 Black
#property indicator_color3 Aqua

extern int NumberOfBars = 300;
double G_ibuf_80[];
double G_ibuf_84[];
double G_ibuf_88[];

int init() {
   IndicatorBuffers(3);
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 2);
   SetIndexDrawBegin(0, 0);
   SetIndexStyle(1, DRAW_LINE, STYLE_SOLID, 2);
   SetIndexDrawBegin(1, 0);
   SetIndexStyle(2, DRAW_LINE, STYLE_DOT, 0);
   SetIndexDrawBegin(2, 0);
   IndicatorDigits(MarketInfo(Symbol(), MODE_DIGITS));
   
   SetIndexBuffer(0, G_ibuf_80);
   SetIndexBuffer(1, G_ibuf_84);
   SetIndexBuffer(2, G_ibuf_88);
   IndicatorShortName("DIM");
   return (0);
}

int start() {
   double ima_4;
   double ima_12;
   double ima_20;
   double ima_28;
   double ima_36;
   double ima_44;
   double ima_52;
   double ima_60;
   double Ld_68;
   double Ld_76;
   double Ld_84;
   double Ld_92;
   double Ld_100;
   if (Bars < 270) return(0)/*(WARN)*/;
   int Li_0 = MathMin(Bars - 270, NumberOfBars);
   for (int Li_108 = Li_0; Li_108 >= 0; Li_108--) {
      ima_4 = iMA(NULL, 0, 1, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      ima_12 = iMA(NULL, 0, 5, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      ima_20 = iMA(NULL, 0, 10, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      ima_28 = iMA(NULL, 0, 15, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      ima_36 = iMA(NULL, 0, 22, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      ima_44 = iMA(NULL, 0, 65, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      ima_52 = iMA(NULL, 0, 130, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      ima_60 = iMA(NULL, 0, 260, 0, MODE_LWMA, PRICE_WEIGHTED, Li_108);
      Ld_68 = (ima_12 + ima_20 + ima_36 + ima_44) / 4.0;
      Ld_76 = (ima_36 + ima_44 + ima_52 + ima_60) / 4.0;
      Ld_84 = Ld_68 - Ld_76;
      Ld_100 = Ld_84 - Ld_92;
      Ld_92 = Ld_84;
      G_ibuf_80[Li_108] = ima_4 - 5.0 * Ld_100;
      G_ibuf_84[Li_108] = ima_4 - 10.0 * Ld_100;
      G_ibuf_88[Li_108] = ima_4 - 15.0 * Ld_100;
      Comment(DoubleToStr(G_ibuf_80[Li_108], 4) + ", " + DoubleToStr(G_ibuf_84[Li_108], 4) + ", " + DoubleToStr(G_ibuf_88[Li_108], 4));
   }
   return (0);
}
