//+------------------------------------------------------------------+
//|                                            Pivot-point-vTEXT.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|           Included is the PRICE based Pivot calculator           |
//|                (Daily Pivot,R1,R2,R3 & S1,S2,S3)                 |
//|                                                                  |
//|                                 Email: Xard777@connectfree.co.uk |
//|                   edited by Server.Uang@gmail.com  Feb, 18, 2008 |
//+------------------------------------------------------------------+
#property copyright ""
#property link      "Comments & M Levels added by cja     "
#property link      "Color edited by ServerUang           "
#property link      "Locator / Pointer added by ServerUang"

#property indicator_chart_window

extern string IIIIIIIIIIIIIIIIIIIIIIIII="<<<< Show/Lines/Comments >>>>>>>>>>>>>>>>>";
extern bool Draw_Main_Lines=false;
extern bool Draw_M_Lines = false;
extern bool Show_Comments_Main_Levels = true;
extern bool Show_Comments_M_Levels = true;
extern string IIIIIIIIIIIIIIIIIIIIIIIIII="<<<< Line/Comments/Colors >>>>>>>>>>>>>>>>";
extern string IIIIIIIIIIIIIIIIIIIIIIIIIIIII="<<<< Main Level/Colors >>>>>>>>>>>>>>>>";
extern color R3_color = C'0,91,191';//Blue;//SlateGray;
extern color R2_color = DodgerBlue;//SlateGray;
extern color R1_color = DeepSkyBlue;//LightSkyBlue;//SlateGray;
extern color PP_color = Silver;//DimGray;//Peru;
extern color S1_color = Goldenrod;//SlateGray;
extern color S2_color = OrangeRed;//
extern color S3_color = Brown;//SlateGray;
extern string IIIIIIIIIIIIIIIIIIIIIIIIIIIIII="<<<< M Level/Colors >>>>>>>>>>>>>>>>";
extern color M5_color = RoyalBlue;//DarkGray;
extern color M4_color = CornflowerBlue;//DeepSkyBlue;//DarkGray;
extern color M3_color = Aqua;//DarkGray;
extern color M2_color = Orange;//DarkGray;
extern color M1_color = Chocolate;//DarkGray;
extern color M0_color = Crimson;//DarkGray;

extern string IIIIIIIIIIIIIIIIIIIIIIIIIII="<<<< Comment Movements >>>>>>>>>>>>>>>>>>";
extern int AdjustComments_UP_DOWN  = 0;
extern int AdjustComments_Sideways = 0;
extern int sebelah                 = 3;
extern int     Shift_Y             =  -5; 
extern int     Shift_X             = -23; //default = 8
extern bool Set_Comments_TopRight  = false;
extern color Pointer_color=Lime;

//---- input parameters ----
extern string IIIIIIIIIIIIIIIIIIIIIIIIIIII ="<<<< Comments/font size >>>>>>>>>>>>>>>>>";
extern int fontsize = 8;

double LastHigh, LastLow, x,x1,x2,y1,y2; 

//----- Input Additioanal -----
string Label_Teks="", labelname="", teks="", fontname="";
color  textcolor;
double corner, tx, ty, n, hrg, sprd ;

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   ObjectsDeleteAll(0,OBJ_LABEL);
  
  Comment(""); 
  ObjectDelete("p_Line");
  ObjectDelete("r1_Line");
  ObjectDelete("r2_Line");
  ObjectDelete("r3_Line");
  ObjectDelete("s1_Line");
  ObjectDelete("s2_Line");
  ObjectDelete("s3_Line");
  ObjectDelete("P label");
  ObjectDelete("R1 label");
  ObjectDelete("R2 label");
  ObjectDelete("R3 label");
  ObjectDelete("S1 label");
  ObjectDelete("S2 label");
  ObjectDelete("S3 label");
  
  ObjectDelete("m5_Line");
  ObjectDelete("m4_Line");
  ObjectDelete("m3_Line");
  ObjectDelete("m2_Line");
  ObjectDelete("m1_Line");
  ObjectDelete("m0_Line");
    
  ObjectDelete("M5 label");
  ObjectDelete("M4 label");
  ObjectDelete("M3 label");
  ObjectDelete("M2 label");
  ObjectDelete("M1 label");
  ObjectDelete("M0 label");
  
  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {



//---- Name for DataWindow and indicator subwindow label
   IndicatorShortName("XA"); 
   SetIndexDrawBegin(0,1);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));

   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
  //{
   int counted_bars = IndicatorCounted();
   int limit, i;
   
//---- Indicator Calculation ----
   if(counted_bars == 0)
     {
       x = Period();
       if(x > 240) 
           return(-1);       
     }
   if(counted_bars < 0) 
       return(-1);
   //---- last counted bar will be recounted
   //   if(counted_bars>0) counted_bars--;
      limit = (Bars - counted_bars) - 1;
//----
   for(i = limit; i >= 0; i--)
     { 
       if(High[i+1] > LastHigh) 
           LastHigh = High[i+1];
       //----
       if(Low[i+1] < LastLow) 
           LastLow=Low[i+1];
       if(TimeDay(Time[i]) != TimeDay(Time[i+1]))
         { 
         
           LastLow = Open[i]; 
           LastHigh = Open[i];
           
         }
      
//---- Pivot Setup ----
double rates[1][6],yesterday_volume,yesterday_close,yesterday_high,yesterday_low,yesterday_open;
ArrayCopyRates(rates, Symbol(), PERIOD_D1);

if(DayOfWeek() == 1)
{
   if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,1)) == 5)
   {
       yesterday_volume = rates[1][5];
       yesterday_close = rates[1][4];
       yesterday_high = rates[1][3];
       yesterday_low = rates[1][2];
       yesterday_open = rates[1][1];
       
   }
   else
   {
      for(int d = 5;d>=0;d--)
      {
         if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,d)) == 5)
         {
             yesterday_volume = rates[d][5];
             yesterday_close = rates[d][4];
             yesterday_high = rates[d][3];
             yesterday_low = rates[d][2];
             yesterday_open = rates[d][1];
         }
         
      }  
      
   }
}
else
{
    yesterday_close = rates[1][4];
    yesterday_high = rates[1][3];
    yesterday_low = rates[1][2];
    yesterday_open = rates[1][1];
}

//---- Calculate Pivots ----
double R = yesterday_high - yesterday_low;//range
double p = (yesterday_high + yesterday_low + yesterday_close)/3;// Standard Pivot
double r3 = (2*p)+(yesterday_high-(2*yesterday_low));// Resistance 3
double r2 = p+(yesterday_high - yesterday_low);// Resistance point 2
double r1 = (2*p)-yesterday_low;// Resistance point 1
double s1 = (2*p)-yesterday_high;// Support point 1
double s2 = p-(yesterday_high - yesterday_low);// Support point 2
double s3 = (2*p)-((2* yesterday_high)-yesterday_low);// Support point 3

double m0 = (s2 + s3)/2;
double m1 = (s1 + s2)/2;
double m2 = (p + s1)/2;
double m3 = (p + r1)/2; 
double m4 = (r1 + r2)/2;
double m5 = (r2 + r3)/2; 

if(Show_Comments_Main_Levels==true) 
   {
    if(Show_Comments_M_Levels==false)
      {
       corner=Set_Comments_TopRight; tx=30+AdjustComments_Sideways; fontname="Arial Bold";
       n=1; x1=10;
       while (n<=7)
          {
           if  ((sebelah==2)||(sebelah==3))
               {
               switch (n)
               {
                  case 1: labelname="PPR3"; ty= (x1*7)+AdjustComments_UP_DOWN; teks="R3 = "+DoubleToStr(r3,Digits); textcolor=R3_color; break;
                  case 2: labelname="PPR2"; ty= (x1*6)+AdjustComments_UP_DOWN; teks="R2 = "+DoubleToStr(r2,Digits); textcolor=R2_color; break;
                  case 3: labelname="PPR1"; ty= (x1*5)+AdjustComments_UP_DOWN; teks="R1 = "+DoubleToStr(r1,Digits); textcolor=R1_color; break;
                  case 4: labelname="PP";   ty= (x1*4)+AdjustComments_UP_DOWN; teks="P   = "+DoubleToStr(p,Digits);  textcolor=PP_color; break;
                  case 5: labelname="PPS1"; ty= (x1*3)+AdjustComments_UP_DOWN; teks="S1 = "+DoubleToStr(s1,Digits); textcolor=S1_color; break;
                  case 6: labelname="PPS2"; ty= (x1*2)+AdjustComments_UP_DOWN; teks="S2 = "+DoubleToStr(s2,Digits); textcolor=S2_color; break;
                  case 7: labelname="PPS3"; ty= (x1*1)+AdjustComments_UP_DOWN; teks="S3 = "+DoubleToStr(s3,Digits); textcolor=S3_color; break;
               }} else
               switch (n)
               {
                  case 1: labelname="PPR3"; ty= (x1*1)+AdjustComments_UP_DOWN; teks="R3 = "+DoubleToStr(r3,Digits); textcolor=R3_color; break;
                  case 2: labelname="PPR2"; ty= (x1*2)+AdjustComments_UP_DOWN; teks="R2 = "+DoubleToStr(r2,Digits); textcolor=R2_color; break;
                  case 3: labelname="PPR1"; ty= (x1*3)+AdjustComments_UP_DOWN; teks="R1 = "+DoubleToStr(r1,Digits); textcolor=R1_color; break;
                  case 4: labelname="PP";   ty= (x1*4)+AdjustComments_UP_DOWN; teks="P   = "+DoubleToStr(p,Digits);  textcolor=PP_color; break;
                  case 5: labelname="PPS1"; ty= (x1*5)+AdjustComments_UP_DOWN; teks="S1 = "+DoubleToStr(s1,Digits); textcolor=S1_color; break;
                  case 6: labelname="PPS2"; ty= (x1*6)+AdjustComments_UP_DOWN; teks="S2 = "+DoubleToStr(s2,Digits); textcolor=S2_color; break;
                  case 7: labelname="PPS3"; ty= (x1*7)+AdjustComments_UP_DOWN; teks="S3 = "+DoubleToStr(s3,Digits); textcolor=S3_color; break;
               }//switch
           Write(labelname, corner, tx, ty, teks, fontsize, fontname, textcolor);
           n++;
          } //while
          
       //--- Menampilkan Pointer ---
       sprd=(Ask - Bid)/Point;
       hrg=iMA(Symbol(),0,1,0,MODE_EMA,PRICE_CLOSE,0);
       tx=10+AdjustComments_Sideways; x1=5;
         if  ((sebelah==2)||(sebelah==3))
             {
               if (hrg>(r3))                  {ty= (x1*0)+AdjustComments_UP_DOWN;}
               else if (hrg==(r3))            {ty= (x1*15)+AdjustComments_UP_DOWN;}
               else if ((hrg<r3) && (hrg>r2)) {ty= (x1*14)+AdjustComments_UP_DOWN;}
               else if ((hrg==r2))            {ty= (x1*13)+AdjustComments_UP_DOWN;}
               else if ((hrg<r2) && (hrg>r1)) {ty= (x1*12)+AdjustComments_UP_DOWN;}
               else if ((hrg==r1))            {ty= (x1*11)+AdjustComments_UP_DOWN;}
               else if ((hrg<r1) && (hrg>p))  {ty= (x1*10)+AdjustComments_UP_DOWN;}
               else if ((hrg==p))             {ty= (x1*9)+AdjustComments_UP_DOWN;}
               else if ((hrg<p) && (hrg>s1))  {ty= (x1*8)+AdjustComments_UP_DOWN;}
               else if ((hrg==s1))            {ty=(x1*7)+AdjustComments_UP_DOWN;}
               else if ((hrg<s1) && (hrg>s2)) {ty=(x1*6)+AdjustComments_UP_DOWN;}
               else if ((hrg==s2))            {ty=(x1*5)+AdjustComments_UP_DOWN;}
               else if ((hrg<s2) && (hrg>s3)) {ty=(x1*4)+AdjustComments_UP_DOWN;}
               else if ((hrg==s3))            {ty=(x1*3)+AdjustComments_UP_DOWN;}
               else if ((hrg<s3))             {ty=(x1*2)+AdjustComments_UP_DOWN;}
               Write("PPP0", corner, tx+5,   ty, ">", fontsize, fontname, Pointer_color);
               Write("PPP1", corner, tx+100, ty, "<", fontsize, fontname, Pointer_color); 
             } else
               if (hrg>(r3))                  {ty= (x1*0)+AdjustComments_UP_DOWN;}
               else if (hrg==(r3))            {ty= (x1*2)+AdjustComments_UP_DOWN;}
               else if ((hrg<r3) && (hrg>r2)) {ty= (x1*3)+AdjustComments_UP_DOWN;}
               else if ((hrg==r2))            {ty= (x1*4)+AdjustComments_UP_DOWN;}
               else if ((hrg<r2) && (hrg>r1)) {ty= (x1*5)+AdjustComments_UP_DOWN;}
               else if ((hrg==r1))            {ty= (x1*6)+AdjustComments_UP_DOWN;}
               else if ((hrg<r1) && (hrg>p))  {ty= (x1*7)+AdjustComments_UP_DOWN;}
               else if ((hrg==p))             {ty= (x1*8)+AdjustComments_UP_DOWN;}
               else if ((hrg<p) && (hrg>s1))  {ty= (x1*9)+AdjustComments_UP_DOWN;}
               else if ((hrg==s1))            {ty=(x1*10)+AdjustComments_UP_DOWN;}
               else if ((hrg<s1) && (hrg>s2)) {ty=(x1*11)+AdjustComments_UP_DOWN;}
               else if ((hrg==s2))            {ty=(x1*12)+AdjustComments_UP_DOWN;}
               else if ((hrg<s2) && (hrg>s3)) {ty=(x1*13)+AdjustComments_UP_DOWN;}
               else if ((hrg==s3))            {ty=(x1*14)+AdjustComments_UP_DOWN;}
               else if ((hrg<s3))             {ty=(x1*15)+AdjustComments_UP_DOWN;}
               Write("PPP0", corner, tx+5,   ty, "<", fontsize, fontname, Pointer_color);
               Write("PPP1", corner, tx+100, ty, ">", fontsize, fontname, Pointer_color); 
      } //if Show_Comments_M_Levels==false
   } //if Show_Comments_Main_Levels==true
   
// M Levels
   
if(Show_Comments_M_Levels==true)
  { 
   corner=Set_Comments_TopRight; tx=30+AdjustComments_Sideways; fontname="Arial Bold";
   n=1; x1=10;
   while (n<=13)
         {
         if  ((sebelah==2)||(sebelah==3))
             {
          switch (n)
              {
               case 1:  labelname="PPR3"; ty= (x1*13)+AdjustComments_UP_DOWN; teks="R3 = " +DoubleToStr(r3,Digits);  textcolor=R3_color; break;
               case 2:  labelname="PPM5"; ty= (x1*12)+AdjustComments_UP_DOWN; teks="M5 = " +DoubleToStr(m5,Digits);  textcolor=M5_color; break;
               case 3:  labelname="PPR2"; ty= (x1*11)+AdjustComments_UP_DOWN; teks="R2 = " +DoubleToStr(r2,Digits);  textcolor=R2_color; break;
               case 4:  labelname="PPM4"; ty= (x1*10)+AdjustComments_UP_DOWN; teks="M4 = " +DoubleToStr(m4,Digits);  textcolor=M4_color; break;
               case 5:  labelname="PPR1"; ty= (x1*9)+AdjustComments_UP_DOWN; teks="R1 = " +DoubleToStr(r1,Digits);  textcolor=R1_color; break;
               case 6:  labelname="PPM3"; ty= (x1*8)+AdjustComments_UP_DOWN; teks="M3 = " +DoubleToStr(m3,Digits);  textcolor=M3_color; break;
               case 7:  labelname="PP";   ty= (x1*7)+AdjustComments_UP_DOWN; teks="P   = "+DoubleToStr(p,Digits);   textcolor=PP_color; break;
               case 8:  labelname="PPM2"; ty= (x1*6)+AdjustComments_UP_DOWN; teks="M2 = " +DoubleToStr(m2,Digits);  textcolor=M2_color; break;
               case 9:  labelname="PPS1"; ty= (x1*5)+AdjustComments_UP_DOWN; teks="S1 = " +DoubleToStr(s1,Digits);  textcolor=S1_color; break;
               case 10: labelname="PPM1"; ty=(x1*4)+AdjustComments_UP_DOWN; teks="M1 = " +DoubleToStr(m1,Digits);  textcolor=M1_color; break;
               case 11: labelname="PPS2"; ty=(x1*3)+AdjustComments_UP_DOWN; teks="S2 = " +DoubleToStr(s2,Digits);  textcolor=S2_color; break;
               case 12: labelname="PPM0"; ty=(x1*2)+AdjustComments_UP_DOWN; teks="M0 = " +DoubleToStr(m0,Digits);  textcolor=M0_color; break;
               case 13: labelname="PPS3"; ty=(x1*1)+AdjustComments_UP_DOWN; teks="S3 = " +DoubleToStr(s3,Digits);  textcolor=S3_color; break;
               }} else
               switch (n)
               {
               case 1:  labelname="PPR3"; ty= (x1*1)+AdjustComments_UP_DOWN; teks="R3 = " +DoubleToStr(r3,Digits);  textcolor=R3_color; break;
               case 2:  labelname="PPM5"; ty= (x1*2)+AdjustComments_UP_DOWN; teks="M5 = " +DoubleToStr(m5,Digits);  textcolor=M5_color; break;
               case 3:  labelname="PPR2"; ty= (x1*3)+AdjustComments_UP_DOWN; teks="R2 = " +DoubleToStr(r2,Digits);  textcolor=R2_color; break;
               case 4:  labelname="PPM4"; ty= (x1*4)+AdjustComments_UP_DOWN; teks="M4 = " +DoubleToStr(m4,Digits);  textcolor=M4_color; break;
               case 5:  labelname="PPR1"; ty= (x1*5)+AdjustComments_UP_DOWN; teks="R1 = " +DoubleToStr(r1,Digits);  textcolor=R1_color; break;
               case 6:  labelname="PPM3"; ty= (x1*6)+AdjustComments_UP_DOWN; teks="M3 = " +DoubleToStr(m3,Digits);  textcolor=M3_color; break;
               case 7:  labelname="PP";   ty= (x1*7)+AdjustComments_UP_DOWN; teks="P   = "+DoubleToStr(p,Digits);   textcolor=PP_color; break;
               case 8:  labelname="PPM2"; ty= (x1*8)+AdjustComments_UP_DOWN; teks="M2 = " +DoubleToStr(m2,Digits);  textcolor=M2_color; break;
               case 9:  labelname="PPS1"; ty= (x1*9)+AdjustComments_UP_DOWN; teks="S1 = " +DoubleToStr(s1,Digits);  textcolor=S1_color; break;
               case 10: labelname="PPM1"; ty=(x1*10)+AdjustComments_UP_DOWN; teks="M1 = " +DoubleToStr(m1,Digits);  textcolor=M1_color; break;
               case 11: labelname="PPS2"; ty=(x1*11)+AdjustComments_UP_DOWN; teks="S2 = " +DoubleToStr(s2,Digits);  textcolor=S2_color; break;
               case 12: labelname="PPM0"; ty=(x1*12)+AdjustComments_UP_DOWN; teks="M0 = " +DoubleToStr(m0,Digits);  textcolor=M0_color; break;
               case 13: labelname="PPS3"; ty=(x1*13)+AdjustComments_UP_DOWN; teks="S3 = " +DoubleToStr(s3,Digits);  textcolor=S3_color; break;

              }//switch
          Write(labelname, corner, tx, ty, teks, fontsize, fontname, textcolor);
          n++;
         } //while
      
   //--- Menampilkan Pointer ---
   sprd=(Ask - Bid)/Point;
   hrg=iMA(Symbol(),0,1,0,MODE_EMA,PRICE_CLOSE,0);
   tx=10+AdjustComments_Sideways;  x1=5;
   if  ((sebelah==2)||(sebelah==3))
       {
   if (hrg>(r3))                  {ty= (x1*0)+AdjustComments_UP_DOWN;}
   else if (hrg==(r3))            {ty= (x1*27)+AdjustComments_UP_DOWN;}
   else if ((hrg<r3) && (hrg>m5)) {ty= (x1*26)+AdjustComments_UP_DOWN;}
   else if ((hrg==m5))            {ty= (x1*25)+AdjustComments_UP_DOWN;}
   else if ((hrg<m5) && (hrg>r2)) {ty= (x1*24)+AdjustComments_UP_DOWN;}
   else if ((hrg==r2))            {ty= (x1*23)+AdjustComments_UP_DOWN;}
   else if ((hrg<r2) && (hrg>m4)) {ty= (x1*22)+AdjustComments_UP_DOWN;}
   else if ((hrg==m4))            {ty= (x1*21)+AdjustComments_UP_DOWN;}
   else if ((hrg<m4) && (hrg>r1)) {ty= (x1*20)+AdjustComments_UP_DOWN;}
   else if ((hrg==r1))            {ty=(x1*19)+AdjustComments_UP_DOWN;}
   else if ((hrg<r1) && (hrg>m3)) {ty=(x1*18)+AdjustComments_UP_DOWN;}
   else if ((hrg==m3))            {ty=(x1*17)+AdjustComments_UP_DOWN;}
   else if ((hrg<m3) && (hrg>p))  {ty=(x1*16)+AdjustComments_UP_DOWN;}
   else if ((hrg==p))             {ty=(x1*15)+AdjustComments_UP_DOWN;}
   else if ((hrg<p) && (hrg>m2))  {ty=(x1*14)+AdjustComments_UP_DOWN;}
   else if ((hrg==m2))            {ty=(x1*13)+AdjustComments_UP_DOWN;}
   else if ((hrg<m2) && (hrg>s1)) {ty=(x1*12)+AdjustComments_UP_DOWN;}
   else if ((hrg==s1))            {ty=(x1*11)+AdjustComments_UP_DOWN;}
   else if ((hrg<s1) && (hrg>m1)) {ty=(x1*10)+AdjustComments_UP_DOWN;}
   else if ((hrg==m1))            {ty=(x1*9)+AdjustComments_UP_DOWN;}
   else if ((hrg<m1) && (hrg>s2)) {ty=(x1*8)+AdjustComments_UP_DOWN;}
   else if ((hrg==s2))            {ty=(x1*7)+AdjustComments_UP_DOWN;}
   else if ((hrg<s2) && (hrg>m0)) {ty=(x1*6)+AdjustComments_UP_DOWN;}
   else if ((hrg==m0))            {ty=(x1*5)+AdjustComments_UP_DOWN;}
   else if ((hrg<m0) && (hrg>s3)) {ty=(x1*4)+AdjustComments_UP_DOWN;}
   else if ((hrg==s3))            {ty=(x1*3)+AdjustComments_UP_DOWN;}
   else if ((hrg<s3))             {ty=(x1*2)+AdjustComments_UP_DOWN;}
   Write("PPP0", corner, tx+85, ty, "", fontsize, "Wingdings 3", Pointer_color);
   Write("PPP1", corner, tx+ 5, ty, "", fontsize, "Wingdings 3", Pointer_color); 
   } else
   if (hrg>(r3))                  {ty= (x1*0)+AdjustComments_UP_DOWN;}
   else if (hrg==(r3))            {ty= (x1*2)+AdjustComments_UP_DOWN;}
   else if ((hrg<r3) && (hrg>m5)) {ty= (x1*3)+AdjustComments_UP_DOWN;}
   else if ((hrg==m5))            {ty= (x1*4)+AdjustComments_UP_DOWN;}
   else if ((hrg<m5) && (hrg>r2)) {ty= (x1*5)+AdjustComments_UP_DOWN;}
   else if ((hrg==r2))            {ty= (x1*6)+AdjustComments_UP_DOWN;}
   else if ((hrg<r2) && (hrg>m4)) {ty= (x1*7)+AdjustComments_UP_DOWN;}
   else if ((hrg==m4))            {ty= (x1*8)+AdjustComments_UP_DOWN;}
   else if ((hrg<m4) && (hrg>r1)) {ty= (x1*9)+AdjustComments_UP_DOWN;}
   else if ((hrg==r1))            {ty=(x1*10)+AdjustComments_UP_DOWN;}
   else if ((hrg<r1) && (hrg>m3)) {ty=(x1*11)+AdjustComments_UP_DOWN;}
   else if ((hrg==m3))            {ty=(x1*12)+AdjustComments_UP_DOWN;}
   else if ((hrg<m3) && (hrg>p))  {ty=(x1*13)+AdjustComments_UP_DOWN;}
   else if ((hrg==p))             {ty=(x1*14)+AdjustComments_UP_DOWN;}
   else if ((hrg<p) && (hrg>m2))  {ty=(x1*15)+AdjustComments_UP_DOWN;}
   else if ((hrg==m2))            {ty=(x1*16)+AdjustComments_UP_DOWN;}
   else if ((hrg<m2) && (hrg>s1)) {ty=(x1*17)+AdjustComments_UP_DOWN;}
   else if ((hrg==s1))            {ty=(x1*18)+AdjustComments_UP_DOWN;}
   else if ((hrg<s1) && (hrg>m1)) {ty=(x1*19)+AdjustComments_UP_DOWN;}
   else if ((hrg==m1))            {ty=(x1*20)+AdjustComments_UP_DOWN;}
   else if ((hrg<m1) && (hrg>s2)) {ty=(x1*21)+AdjustComments_UP_DOWN;}
   else if ((hrg==s2))            {ty=(x1*22)+AdjustComments_UP_DOWN;}
   else if ((hrg<s2) && (hrg>m0)) {ty=(x1*23)+AdjustComments_UP_DOWN;}
   else if ((hrg==m0))            {ty=(x1*24)+AdjustComments_UP_DOWN;}
   else if ((hrg<m0) && (hrg>s3)) {ty=(x1*25)+AdjustComments_UP_DOWN;}
   else if ((hrg==s3))            {ty=(x1*26)+AdjustComments_UP_DOWN;}
   else if ((hrg<s3))             {ty=(x1*27)+AdjustComments_UP_DOWN;}
   Write("PPP0", corner, tx+ 5, ty, "", fontsize, "Wingdings 3", Pointer_color);
   Write("PPP1", corner, tx+85, ty, "", fontsize, "Wingdings 3", Pointer_color); 

}//if Show_Comments_M_Levels==true
   
//Pivot, Support & Resistance Lines

if (Draw_Main_Lines)
    {
     Draw_H_Line("p_Line",  p,  PP_color);
     Draw_H_Line("r1_Line",  r1, R1_color);
     Draw_H_Line("r2_Line",  r2, R2_color);
     Draw_H_Line("r3_Line",  r3, R3_color);
     Draw_H_Line("s1_Line",  s1, S1_color);
     Draw_H_Line("s2_Line",  s2, S2_color);
     Draw_H_Line("s3_Line",  s3, S3_color);

     // M Level Lines
     if (Draw_M_Lines==true)
         {
          Draw_H_Line("m5_Line",  m5, M5_color);
          Draw_H_Line("m4_Line",  m4, M4_color);
          Draw_H_Line("m3_Line",  m3, M3_color);
          Draw_H_Line("m2_Line",  m2, M2_color);
          Draw_H_Line("m1_Line",  m1, M1_color);
          Draw_H_Line("m0_Line",  m0, M0_color);
         }

     ObjectsRedraw();

     // ---- Typing Labels ----

     Label_H_Line("R3 label", r3, " R3 ", R3_color);
     Label_H_Line("S3 label", s3, " S3 ", S3_color);

     Label_H_Line("R2 label", r2, " R2 ", R2_color);
     Label_H_Line("S2 label", s2, " S2 ", S2_color);

     Label_H_Line("R1 label", r1, " R1 ", R1_color);
     Label_H_Line("S1 label", s1, " S1 ", S1_color);

     Label_H_Line("P label", p, " Pivot ", PP_color);

     // M Level Labels 
     if (Draw_M_Lines==true)
        {
         Label_H_Line("M5 label", m5, " M5 ", M5_color);
         Label_H_Line("M4 label", m4, " M4 ", M4_color);
         Label_H_Line("M3 label", m3, " M3 ", M3_color);
         Label_H_Line("M2 label", m2, " M2 ", M2_color);
         Label_H_Line("M1 label", m1, " M1 ", M1_color);
         Label_H_Line("M0 label", m0, " M0 ", M0_color);
        }//Draw_M_Lines==true

}//if Draw_Main_Lines
}
   return(0);

}//iteration function
//Job Done
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
// Write Procedure
void Write(string LBL, double sebelah1, int pos_x, int pos_y, string teks, int ukuran_huruf, string nama_huruf, color warna=CLR_NONE)
     {
       sebelah1=sebelah1+sebelah;
       Label_Teks=LBL;
       ObjectCreate(LBL, OBJ_LABEL, 0, 0, 0);
       ObjectSetText(LBL,teks, ukuran_huruf, nama_huruf, warna);
       ObjectSet(LBL, OBJPROP_CORNER, sebelah);
       ObjectSet(LBL, OBJPROP_XDISTANCE, pos_x+Shift_X);
       ObjectSet(LBL, OBJPROP_YDISTANCE, pos_y+Shift_Y);
     }

// Draw_H_Line Procedure     
void Draw_H_Line(string Label_name, double Position, color Line_color)
       {
        ObjectDelete(Label_name);
        ObjectCreate(Label_name, OBJ_HLINE,0, CurTime(), Position);
        ObjectSet(Label_name, OBJPROP_COLOR, Line_color);
        ObjectSet(Label_name, OBJPROP_STYLE, STYLE_SOLID);
        ObjectSet(Label_name, OBJPROP_WIDTH, 1);
       }

// Label_H_Line Procedure  
void Label_H_Line (string LabelLine, double Pos_Label, string Text_Label, color Label_color)
          {
            if (ObjectFind(LabelLine) != 0)
               {
                ObjectCreate(LabelLine, OBJ_TEXT, 0, Time[3], Pos_Label);
                ObjectSetText(LabelLine, Text_Label, 9, "Verdana", Label_color);
               }
            else
              {
               ObjectMove(LabelLine, 0, Time[3], Pos_Label);
              }
          }       