//+------------------------------------------------------------------+
//|                                                     Range_v2.mq4 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 DodgerBlue
#property indicator_color2 Tomato
#property indicator_width1 2
#property indicator_width2 2

extern int TimeFrame=1440;

double UpBuffer[];
double DnBuffer[];
double Buffer1[];
double Buffer2[];

int init()
{
   string short_name;
   IndicatorBuffers(4);
   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,UpBuffer);
   SetIndexLabel(0,"Up");
   SetIndexDrawBegin(0,0);
   
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,DnBuffer);
   SetIndexLabel(1,"Down");
   SetIndexDrawBegin(1,0);
   
   SetIndexBuffer(2,Buffer1);
   SetIndexBuffer(3,Buffer2);
   short_name="Range_v2("+TimeFrame+")";
   IndicatorShortName(short_name);
   
   
   switch(TimeFrame) 
   {
   case 1    : TimeFrame=PERIOD_M1;  break; 
   case 5    : TimeFrame=PERIOD_M5;  break;
   case 15   : TimeFrame=PERIOD_M15; break;
   case 30   : TimeFrame=PERIOD_M30; break;
   case 60   : TimeFrame=PERIOD_H1;  break;
   case 240  : TimeFrame=PERIOD_H4;  break;
   case 1440 : TimeFrame=PERIOD_D1;  break;
   case 7200 : TimeFrame=PERIOD_W1;  break;
   case 28800: TimeFrame=PERIOD_MN1; break;
   default  : TimeFrame=Period();   break;
   }
return(0);
}

int start()
{
   datetime TimeArray[];
   int i=0,y=0;  
   int counted_bars=IndicatorCounted();
   double LowArray[],HighArray[];
   
   
      if (TimeFrame<Period()) 
      {
      SetIndexDrawBegin(0,Bars);  
      SetIndexDrawBegin(1,Bars);
      Comment("Incorrect TimeFrame");
      return(0);
      }

   if ( counted_bars > 0 )  int limit=Bars-counted_bars;
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-1; 
     
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame);
   ArrayCopySeries(LowArray,MODE_LOW,Symbol(),TimeFrame);  
   ArrayCopySeries(HighArray,MODE_HIGH,Symbol(),TimeFrame);
   
      for(i=0,y=0;i<Bars;i++)
      {
      if (Time[i]<TimeArray[y]) y++;
      UpBuffer[i]=HighArray[y];    
      DnBuffer[i]=LowArray[y];
      } 
   return(0);
}