//+------------------------------------------------------------------+
//|                                         channel_breakout_atr.mq4 | 
//|                                   with ATR Stop Loss calculation |
//|            use this one for drawing 2nd, 3rd and 4th entry point |
//|                         as described in the turtle trading rules |
//+------------------------------------------------------------------+

#property copyright "darmasdt"
#property link      "http://indotraders.org"

#property indicator_chart_window 
#property indicator_buffers 8 
#property indicator_color1 DarkGray 
#property indicator_color2 DarkGray
#property indicator_color3 Blue 
#property indicator_color4 Blue
#property indicator_color5 DarkOrange
#property indicator_color6 Green
#property indicator_color7 Plum
#property indicator_color8 Plum

//---- input parameters 
//extern int Range1=10; 
extern int Range2=20;
extern int Range3=55;
extern double atr_factor=2;
extern int atr_range=14;
extern double add_atr_factor=0.5;
extern double spread=5;

//---- buffers

double RISK_NxATR[];
double UpBuffer2[]; 
double DnBuffer2[]; 
double UpBuffer3[]; 
double DnBuffer3[]; 

double add_atr1[];
double add_atr2[];
double add_atr3[];



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() 
  {
   string short_name; 
//---- indicator line
   SetIndexStyle(0,DRAW_NONE,1); 
   SetIndexStyle(1,DRAW_NONE,1); 
   SetIndexStyle(2,DRAW_NONE,1); 
   SetIndexStyle(3,DRAW_NONE,1); 

   SetIndexStyle(4,DRAW_ARROW);
   SetIndexArrow(4,159);
   SetIndexStyle(5,DRAW_ARROW);
   SetIndexArrow(5,159);
   SetIndexStyle(6,DRAW_ARROW);
   SetIndexArrow(6,159);

   SetIndexStyle(7,DRAW_NONE,1);    

   SetIndexBuffer(0,UpBuffer2); 
   SetIndexLabel(0,"");
   SetIndexBuffer(1,DnBuffer2); 
   SetIndexLabel(1,"");
   SetIndexBuffer(2,UpBuffer3); 
   SetIndexLabel(2,"");
   SetIndexBuffer(3,DnBuffer3); 
   SetIndexLabel(3,"");

   SetIndexBuffer(4,add_atr1); 
   SetIndexLabel(4,"2nd pos");
   SetIndexBuffer(5,add_atr2);
   SetIndexLabel(5,"3rd pos");
   SetIndexBuffer(6,add_atr3); 
   SetIndexLabel(6,"4th pos");
   
   SetIndexBuffer(7,RISK_NxATR); 
   SetIndexLabel(7,"RISK_NxATR");
   
   
//---- name for DataWindow and indicator subwindow label
   short_name="CBO_atr("+Range2+","+Range3+")"; 
                                                  
   IndicatorShortName(short_name);  

//----
   SetIndexDrawBegin(0,0); 
   SetIndexDrawBegin(1,0); 
   SetIndexDrawBegin(2,0); 
   SetIndexDrawBegin(3,0); 
   SetIndexDrawBegin(4,0); 
   SetIndexDrawBegin(5,0); 
   SetIndexDrawBegin(6,0); 
   SetIndexDrawBegin(7,0); 
   
//----
   return(0); 
  }
//+------------------------------------------------------------------+
//| Channel Trend System                                             |
//+------------------------------------------------------------------+
int start() 
  {
   int i; 

//----
   
   for(i=Bars-1;i>=0;i--)
   {

      //Calculating Channel
      //-------------------
          
      UpBuffer2[i]=High[Highest(NULL,0,MODE_HIGH,Range2,i+1)];
      DnBuffer2[i]=Low[Lowest(NULL,0,MODE_LOW,Range2,i+1)];
      
      UpBuffer3[i]=High[Highest(NULL,0,MODE_HIGH,Range3,i+1)];
      DnBuffer3[i]=Low[Lowest(NULL,0,MODE_LOW,Range3,i+1)];


      //Calculating ATR PYramiding
      //---------------------
      
      RISK_NxATR[i]=atr_factor*(iATR(NULL,0,atr_range,i+1))/Point;

      if(High[i+1]<=UpBuffer2[i+1] && High[i]>UpBuffer2[i]) 
         {
         add_atr1[i]=  UpBuffer2[i] + (iATR(NULL,0,atr_range,i+1)*add_atr_factor);
         add_atr2[i]=  UpBuffer2[i] + (iATR(NULL,0,atr_range,i+1)*add_atr_factor*2);
         add_atr3[i]=  UpBuffer2[i] + (iATR(NULL,0,atr_range,i+1)*add_atr_factor*3);
         }
      if(High[i+1]<=UpBuffer3[i+1] && High[i]>UpBuffer3[i]) 
         {
         add_atr1[i]=  UpBuffer3[i] + (iATR(NULL,0,atr_range,i+1)*add_atr_factor);
         add_atr2[i]=  UpBuffer3[i] + (iATR(NULL,0,atr_range,i+1)*add_atr_factor*2);
         add_atr3[i]=  UpBuffer3[i] + (iATR(NULL,0,atr_range,i+1)*add_atr_factor*3);
         }



      if(Low[i+1]>=DnBuffer2[i+1] && Low[i]<DnBuffer2[i]) 
         {
         add_atr1[i]=  DnBuffer2[i] - (iATR(NULL,0,atr_range,i+1)*add_atr_factor)+(spread*Point);  
         add_atr2[i]=  DnBuffer2[i] - (iATR(NULL,0,atr_range,i+1)*add_atr_factor*2)+(spread*Point);
         add_atr3[i]=  DnBuffer2[i] - (iATR(NULL,0,atr_range,i+1)*add_atr_factor*3)+(spread*Point);
         }
      if(Low[i+1]>=DnBuffer3[i+1] && Low[i]<DnBuffer3[i]) 
         {
         add_atr1[i]=  DnBuffer3[i] - (iATR(NULL,0,atr_range,i+1)*add_atr_factor)+(spread*Point);
         add_atr2[i]=  DnBuffer3[i] - (iATR(NULL,0,atr_range,i+1)*add_atr_factor*2)+(spread*Point);
         add_atr3[i]=  DnBuffer3[i] - (iATR(NULL,0,atr_range,i+1)*add_atr_factor*3)+(spread*Point);
         }


   }
   return(0);
  }
//+------------------------------------------------------------------+