//+------------------------------------------------------------------+
//|                                           Reversal_Indicator.mq4 |
//|                                                         Zen_Leow |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Zen_Leow"
#property link      ""

#property indicator_chart_window

// The number of buffers for calculation, up to 8
#property indicator_buffers 2

// The color for displaying arrows
#property indicator_color1 Green       // Long signal
#property indicator_color2 Maroon         // Short signal

// Width of the arrows
#property indicator_width1 2  // Long signal arrow
#property indicator_width2 2  // Short signal arrow

extern bool UseFullCandleSize = false;
extern int NumberOfCandles = 2;
extern int ArrowDistance = 3;

// Buffers for the calculations
double Up_Arrow_Buffer[];    // Long buffer for display
double Down_Arrow_Buffer[];   // Short buffer for display
int PipFactor = 1;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   // Cater for fractional pips
   if (Digits == 3 || Digits == 5)
   {
      PipFactor = 10;
   }
//---- indicators
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexBuffer(0, Up_Arrow_Buffer);
   SetIndexArrow(0, 233); // Up arrow
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexBuffer(1, Down_Arrow_Buffer);
   SetIndexArrow(1, 234); // Down arrow
//----
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
//----
   
//----
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int i;                           // Bar index       
   int Counted_bars;                // Number of counted bars
   //--------------------------------------------------------------------   
   Counted_bars=IndicatorCounted(); // Number of counted bars   
   i=Bars-Counted_bars-1;           // Index of the first uncounted   
   
   while(i>=0)                      // Loop for uncounted bars     
   {  
      Up_Arrow_Buffer[i] = EMPTY_VALUE;
      Down_Arrow_Buffer[i] = EMPTY_VALUE;
      
      if (isUpReversalCandle(i))
      {
         Up_Arrow_Buffer[i] = Low[i] - (ArrowDistance * Point * PipFactor);
         Down_Arrow_Buffer[i] = EMPTY_VALUE;
      }
      if (isDownReversalCandle(i))
      {
         Down_Arrow_Buffer[i] = High[i] + (ArrowDistance * Point * PipFactor);
         Up_Arrow_Buffer[i] = EMPTY_VALUE;
      }
      i--;
   }
//----
   return(0);
}

bool isUpReversalCandle(int index)
{
   if (AllDownCandles(index))
   {
      if (UseFullCandleSize)
      {
         if (High[index] - Low[index] > High[index+1] - Low[index+1])
         {
            return (true);
         }
         return (false);
      }
      else
      {
         if (Close[index] - Low[index] > Close[index+1] - Low[index+1])
         {
            return (true);
         }
         return (false);
      }
   }
   return (false);
}

bool isDownReversalCandle(int index)
{
   if (AllUpCandles(index))
   {
      if (UseFullCandleSize)
      {
         if (High[index] - Low[index] > High[index+1] - Low[index+1])
         {
            return (true);
         }
         return (false);
      }
      else
      {
         if (High[index] - Close[index] > High[index+1] - Close[index+1])
         {
            return (true);
         }
         return (false);
      }
   }
   return (false);
}

bool AllUpCandles(int index)
{
   for (int i=index; i<index+NumberOfCandles; i++)
   {
      if (!isUpCandle(i))
      {
         return (false);
      }
   }
   return (true);
}

bool AllDownCandles(int index)
{
   for (int i=index; i<index+NumberOfCandles; i++)
   {
      if (!isDownCandle(i))
      {
         return (false);
      }
   }
   return (true);
}

bool isUpCandle(int index)
{
   if (Close[index] > Open[index])
   {
      return (true);
   }
   return (false);
}

bool isDownCandle(int index)
{
   if (Close[index] < Open[index])
   {
      return (true);
   }
   return (false);
}
//+------------------------------------------------------------------+