
#property copyright "U"
#property link      "U"

#property indicator_chart_window

extern bool AutoScale = FALSE;
extern bool ShowText = TRUE;
extern int Frame = 1440;
extern color cPivot = Yellow;
extern color cRS1 = Aqua;
extern color cRS2 = DarkSalmon;
extern color cRS3 = Red;
extern int LineLength = 10;
extern int PivotTime = 1;

int init() {
   return (0);
}

int deinit() {
   ObjectDelete("PIVOTLINE");
   ObjectDelete("R1LINE");
   ObjectDelete("S1LINE");
   ObjectDelete("R2LINE");
   ObjectDelete("S2LINE");
   ObjectDelete("R3LINE");
   ObjectDelete("S3LINE");
   ObjectDelete("PIVOTTEXT");
   ObjectDelete("R1TEXT");
   ObjectDelete("S1TEXT");
   ObjectDelete("R2TEXT");
   ObjectDelete("S2TEXT");
   ObjectDelete("R3TEXT");
   ObjectDelete("S3TEXT");
   return (0);
}

int start() {
   int ind_counted_0 = IndicatorCounted();
   int timeframe_4 = 0;
   double Ld_8 = 0;
   double Ld_16 = 0;
   double Ld_24 = 0;
   double price_32 = 0;
   double price_40 = 0;
   double price_48 = 0;
   double price_56 = 0;
   double price_64 = 0;
   double price_72 = 0;
   double price_80 = 0;
   if (AutoScale) {
      Ld_8 = High[PivotTime];
      Ld_16 = Low[PivotTime];
      Ld_24 = Close[PivotTime];
   } else {
      switch (Frame) {
      case 1:
         timeframe_4 = 1;
         break;
      case 5:
         timeframe_4 = 5;
         break;
      case 15:
         timeframe_4 = 15;
         break;
      case 30:
         timeframe_4 = 30;
         break;
      case 60:
         timeframe_4 = 60;
         break;
      case 240:
         timeframe_4 = 240;
         break;
      case 1440:
         timeframe_4 = 1440;
         break;
      case 10080:
         timeframe_4 = 10080;
         break;
      case 43200:
         timeframe_4 = 43200;
         break;
      default:
         timeframe_4 = 1440;
      }
      Ld_8 = iHigh(NULL, timeframe_4, PivotTime);
      Ld_16 = iLow(NULL, timeframe_4, PivotTime);
      Ld_24 = iClose(NULL, timeframe_4, PivotTime);
   }
   price_32 = (Ld_8 + Ld_16 + Ld_24) / 3.0;
   price_48 = 2.0 * price_32 - Ld_16;
   price_40 = 2.0 * price_32 - Ld_8;
   price_64 = price_32 + (price_48 - price_40);
   price_56 = price_32 - (price_48 - price_40);
   price_80 = Ld_8 + 2.0 * (price_32 - Ld_16);
   price_72 = Ld_16 - 2.0 * (Ld_8 - price_32);
   ObjectCreate("PIVOTLINE", OBJ_TREND, 0, Time[LineLength], price_32, Time[0], price_32);
   ObjectSet("PIVOTLINE", OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet("PIVOTLINE", OBJPROP_WIDTH, 1);
   ObjectSet("PIVOTLINE", OBJPROP_COLOR, cPivot);
   if (ShowText) {
      ObjectCreate("PIVOTTEXT", OBJ_TEXT, 0, 0, 0);
      ObjectSetText("PIVOTTEXT", DoubleToStr(price_32, Digits) + "          ", 14, "Verdana", cPivot);
      ObjectMove("PIVOTTEXT", 0, Time[0], price_32);
   }
   ObjectCreate("R1LINE", OBJ_TREND, 0, Time[LineLength], price_48, Time[0], price_48);
   ObjectSet("R1LINE", OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet("R1LINE", OBJPROP_WIDTH, 1);
   ObjectSet("R1LINE", OBJPROP_COLOR, cRS1);
   if (ShowText) {
      ObjectCreate("R1TEXT", OBJ_TEXT, 0, 0, 0);
      ObjectSetText("R1TEXT", DoubleToStr(price_48, Digits) + "          ", 8, "Verdana", cRS1);
      ObjectMove("R1TEXT", 0, Time[0], price_48);
   }
   ObjectCreate("S1LINE", OBJ_TREND, 0, Time[LineLength], price_40, Time[0], price_40);
   ObjectSet("S1LINE", OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet("S1LINE", OBJPROP_WIDTH, 1);
   ObjectSet("S1LINE", OBJPROP_COLOR, cRS1);
   if (ShowText) {
      ObjectCreate("S1TEXT", OBJ_TEXT, 0, 0, 0);
      ObjectSetText("S1TEXT", DoubleToStr(price_40, Digits) + "          ", 8, "Verdana", cRS1);
      ObjectMove("S1TEXT", 0, Time[0], price_40);
   }
   ObjectCreate("r2LINE", OBJ_TREND, 0, Time[LineLength], price_64, Time[0], price_64);
   ObjectSet("r2LINE", OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet("r2LINE", OBJPROP_WIDTH, 1);
   ObjectSet("r2LINE", OBJPROP_COLOR, cRS2);
   if (ShowText) {
      ObjectCreate("R2TEXT", OBJ_TEXT, 0, 0, 0);
      ObjectSetText("R2TEXT", DoubleToStr(price_64, Digits) + "          ", 8, "Verdana", cRS2);
      ObjectMove("R2TEXT", 0, Time[0], price_64);
   }
   ObjectCreate("S2LINE", OBJ_TREND, 0, Time[LineLength], price_56, Time[0], price_56);
   ObjectSet("S2LINE", OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet("S2LINE", OBJPROP_WIDTH, 1);
   ObjectSet("S2LINE", OBJPROP_COLOR, cRS2);
   if (ShowText) {
      ObjectCreate("S2TEXT", OBJ_TEXT, 0, 0, 0);
      ObjectSetText("S2TEXT", DoubleToStr(price_56, Digits) + "          ", 8, "Verdana", cRS2);
      ObjectMove("S2TEXT", 0, Time[0], price_56);
   }
   ObjectCreate("R3LINE", OBJ_TREND, 0, Time[LineLength], price_80, Time[0], price_80);
   ObjectSet("R3LINE", OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet("R3LINE", OBJPROP_WIDTH, 1);
   ObjectSet("R3LINE", OBJPROP_COLOR, cRS3);
   if (ShowText) {
      ObjectCreate("R3TEXT", OBJ_TEXT, 0, 0, 0);
      ObjectSetText("R3TEXT", DoubleToStr(price_80, Digits) + "          ", 8, "Verdana", cRS3);
      ObjectMove("R3TEXT", 0, Time[0], price_80);
   }
   ObjectCreate("S3LINE", OBJ_TREND, 0, Time[LineLength], price_72, Time[0], price_72);
   ObjectSet("S3LINE", OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet("S3LINE", OBJPROP_WIDTH, 1);
   ObjectSet("S3LINE", OBJPROP_COLOR, cRS3);
   if (ShowText) {
      ObjectCreate("S3TEXT", OBJ_TEXT, 0, 0, 0);
      ObjectSetText("S3TEXT", DoubleToStr(price_72, Digits) + "          ", 8, "Verdana", cRS3);
      ObjectMove("S3TEXT", 0, Time[0], price_72);
   }
   return (0);
}
