//+------------------------------------------------------------------+
//|                                                       i-Zone.mq4 |
//|                                 Copyright  2010, Dmitry Zhebrak |
//|                                                  www.mqlcoder.ru |
//+******************************************************************+
//|              |
//|.           |
//| ( Necron ).     |
//|   ,    .  |
//|     .                    |
//|      ,    |
//|  .                              |
//|  ,                  |
//|       email:           |
//|mqlcoder@yandex.ru                                                |
//+******************************************************************+
#property copyright "Copyright  2010, D.Zhebrak aka Necron"
#property link      "www.mqlcoder.ru"
#property link      "mailto: mqlcoder@yandex.ru"

#define   version   "1.0.0.3"

//----    Profitunity_MT4
#include <b-Profitunity_MT4.mqh>
//----    
#property indicator_chart_window 
#property indicator_buffers 8    
#property indicator_color1 Lime  //   
#property indicator_color2 Lime  //   
#property indicator_color3 Red   //   
#property indicator_color4 Red   //   
#property indicator_color5 Gray  //   
#property indicator_color6 Gray  //   
#property indicator_color7 Lime  //      
#property indicator_color8 Red   //      

//----   
//extern int     BarsToProcess=200;   //      (-1 )
extern bool    alert=true;          // true    
extern bool    show_5Bars=true;     // true      
extern color   clr_dn=Red;          //     5     
extern color   clr_up=Lime;         //     5    
extern bool    Show_MFI=true;       // true   MFI
extern double  mult_mfi=1;          //      MFI
extern int     mfi_size=0;          //  mfi
extern double  mult=1.618;          //     
extern int     ATR_Period=34;       // ATR       , 
                                    //    High[i]( Low[i]   ) + (-   ) mult*atr/10.0;
extern bool    Show_Lime=false;     //  MFI
extern bool    Show_Brown=false;    //  MFI ()
extern bool    Show_Pink=false;     //  MFI ()
extern bool    Show_Blue=false;      //  MFI ()

//----    
double   UpBuffer1[],
         DnBuffer1[],
         UpBuffer2[],
         DnBuffer2[],
         UpBuffer3[],
         DnBuffer3[];
//----    
double   up[],dn[];
//----   
datetime bar;
bool     s1=false,
         s2=false,
         up5=false,
         dn5=false;
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
int init()
  {
   bar=0;
   s1=false;
   s2=false;
//----        
   SetIndexBuffer(0,UpBuffer1);
   SetIndexBuffer(1,DnBuffer1);
   SetIndexBuffer(2,UpBuffer2);
   SetIndexBuffer(3,DnBuffer2);
   SetIndexBuffer(4,UpBuffer3);
   SetIndexBuffer(5,DnBuffer3);  
   SetIndexBuffer(6,up);
   SetIndexBuffer(7,dn);

   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexStyle(3,DRAW_HISTOGRAM);
   SetIndexStyle(4,DRAW_HISTOGRAM);
   SetIndexStyle(5,DRAW_HISTOGRAM);   
   SetIndexStyle(6,DRAW_ARROW);
   SetIndexStyle(7,DRAW_ARROW);

   SetIndexArrow(6,251);
   SetIndexArrow(7,251);
   
   SetIndexLabel(0,NULL);
   SetIndexLabel(1,NULL);
   SetIndexLabel(2,NULL);
   SetIndexLabel(3,NULL);
   SetIndexLabel(4,NULL);
   SetIndexLabel(5,NULL);
   SetIndexLabel(6,"5    ");
   SetIndexLabel(7,"5    ");
   
   return(0);
  }
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+
int deinit()
  {
//  
   string nm="";
   for(int j=ObjectsTotal()-1;j>=0;j--)
    {
     nm=ObjectName(j);
     if(StringFind(nm," ( +Volume | +MFI )_",0)||
        StringFind(nm," ( -Volume | -MFI )_",0)||
        StringFind(nm," ( -Volume | +MFI )_",0)||
        StringFind(nm," (+Volume | -MFI )_",0))
     ObjectDelete(nm);
    }
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
int start()
  {
//---- ,      
   int      limit,i,limit1,limit2,
            counted_bars=IndicatorCounted(),
            pip;
   bool     up.mfi=false,
            up.volume=false;
   double   mfi0=0.0,
            mfi1=0.0;
   
//----    
   if(counted_bars<0) return(-1);
//----     
   if(iBars(Symbol(),Period())<35) 
    {
     Print("    !");
     return(-1); 
    }    
//----      
   limit =Bars-counted_bars-1;
   if(Bars-counted_bars>2) limit = Bars-35;
   if(limit>BarsToProcess && BarsToProcess>0) limit=BarsToProcess;
   limit1=limit;
   limit2=limit;
//----           
   for(i=limit;i>=0;i--) 
      {	 
       UpBuffer1[i] =EMPTY;
       UpBuffer2[i] =EMPTY; 
       UpBuffer3[i] =EMPTY;
   
       DnBuffer1[i] =EMPTY;
       DnBuffer2[i] =EMPTY;
       DnBuffer3[i] =EMPTY;

       if(Zone(i)==1)
         {
          UpBuffer1[i] = High[i];
          DnBuffer1[i] = Low[i];
          SetIndexLabel(0," ");
          SetIndexLabel(1," ");
         }
       else   
       if(Zone(i)==-1)
         {
          UpBuffer2[i] = Low[i];
          DnBuffer2[i] = High[i];
          SetIndexLabel(2," ");
          SetIndexLabel(3," ");
         }
       else   
       if(UpBuffer1[i] == EMPTY && UpBuffer2[i] == EMPTY)  
         {
          UpBuffer3[i] = High[i];
          DnBuffer3[i] = Low[i];
          SetIndexLabel(4," ");
          SetIndexLabel(5," ");
         }
      } 
//----   "     "      
   if(show_5Bars)
    {   
     for(i=limit1;i>=0;i--)
      {
       double atr=iATR(Symbol(),Period(),ATR_Period,i);
      
       dn[i]=EMPTY_VALUE;
       up[i]=EMPTY_VALUE;
      
       if(consbars(MODE_LOWER,i) && Zone(i+5)!=-1)
        { 
         dn5=true;
         dn[i]=High[i]+mult*atr/10.0;
        }
       if(consbars(MODE_UPPER,i) && Zone(i+5)!=1) 
        {
        up5=true;
        up[i]=Low[i]-mult*atr/10.0;
        }
      }
    }
//----   MFI
   if(Show_MFI)
       {
        for(i=limit2;i>=0;i--)
         {
          mfi0=iBWMFI(Symbol(),Period(),i);
          mfi1=iBWMFI(Symbol(),Period(),i+1);
     
          if(mfi0>mfi1)up.mfi=true;
          else up.mfi=false;
     
          if(Volume[i]>Volume[i+1])up.volume=true;  
          else up.volume=false;
      
          if(up.mfi && up.volume && Show_Lime)
           {
            Create.Arrow(" ( +Volume | +MFI )_"+i+"",Time[i],High[i]+mult_mfi*atr/10.0,119,Lime,mfi_size);
           }
          else if(!up.mfi && !up.volume && Show_Brown)
           {
            Create.Arrow(" ( -Volume | -MFI )_"+i+"",Time[i],High[i]+mult_mfi*atr/10.0,119,SaddleBrown,mfi_size);
           }
         else if(up.mfi && !up.volume && Show_Pink)
           {
            Create.Arrow(" ( -Volume | +MFI )_"+i+"",Time[i],High[i]+mult_mfi*atr/10.0,119,Pink,mfi_size);
           }  
         else if(!up.mfi && up.volume && Show_Blue)
           {
            Create.Arrow(" (+Volume | -MFI )_"+i+"",Time[i],High[i]+mult_mfi*atr/10.0,119,Blue,mfi_size);
           }          
         }        
       }
//----    
   if(alert)
    { 
     if(bar<Time[0])
      { 
       if(s1)
        {
         Alert("iZone:  <5    >  ",Symbol(),"_",Period(),"");
        }
       if(s2)
        {
         Alert("iZone:  <5    >  ",Symbol(),"_",Period(),"");
        }
      }
     bar=Time[0];  
     s1=false;
     s2=false;
    }
   return(0);
  }
//+------------------------------------------------------------------+


