//+------------------------------------------------------------------+
//|                                                    i-Fractal.mq4 |
//|                          Copyright  2010, D. Zhebrak aka Necron |
//|                                                  www.mqlcoder.ru |
//+------------------------------------------------------------------+
//|                        |
//|.           |
//| ( Necron ).     |
//|   ,    .  |
//|     .                    |
//|      ,    |
//|  .                              |
//|  ,                  |
//|       email:           |
//|mqlcoder@yandex.ru                                                |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, D.Zhebrak aka Necron"
#property link      "www.mqlcoder.ru"
#property link      "mailto: mqlcoder@yandex.ru"

#define   version   "1.0.0.1"
//----    Profitunity_MT4
#include <b-Profitunity_MT4.mqh>
//----    
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Lime
#property indicator_color2 Red
//----     
#property indicator_width1 1
#property indicator_width2 1

//----   
//extern int     BarsToProcess=200;   //     (-1 )
extern bool    alert=false;         // true    
extern double  multiplier=2;        //         
extern bool    show_level=false;    // true      
extern color   fr_up_color=Lime;    //     
extern color   fr_dn_color=Red;     //     
extern int     width=1;             //     
extern int     style=0;             //    
extern int     LastBar=1;           //   : 0-, 1- 
extern bool    UseEqualExt=false;   //     ,..    . Fractal (true) 
                                    //  (false)-   .
//----    
double   Upper[],
         Lower[];
//----               
int      Bars_ATR=233,               //  ATR                                                          
         Code_Arrow_UP=217,          //                                                                       
         Code_Arrow_DN=218;          //  
double   fr_h=0.0,
         fr_l=0.0;
datetime fr_up_t,
         fr_dn_t,
         bar;
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
int init()
  {
//----   
   bar=0;
//----        
   SetIndexBuffer(0, Upper);
   SetIndexBuffer(1, Lower);
//----    
   SetIndexStyle( 0, DRAW_ARROW);
   SetIndexStyle( 1, DRAW_ARROW);
//----         
   SetIndexArrow( 1, 218);
   SetIndexArrow( 0, 217);  
//----     
   SetIndexLabel(0," ");
   SetIndexLabel(1," ");
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+
int deinit()
  {
//----     
    ObjectDelete("fr_up");
    ObjectDelete("fr_dn");
    ObjectDelete("fr_dn_price");
    ObjectDelete("fr_up_price");
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int      counted_bars=IndicatorCounted(),
            limit,i,j;
   bool     up_found=true,
            lw_found=true;
   double   range=iATR(NULL,0,Bars_ATR,0);
//----    
   if(counted_bars<0) return(-1);
//----     
   if(iBars(Symbol(),Period())<6) 
    {
     Print("    !");
     return(-1); 
    }    
//----      
   limit = Bars - counted_bars-1;
   if(Bars - counted_bars > 2) limit = Bars-35;
   if(limit>BarsToProcess && BarsToProcess>0) limit=BarsToProcess;

//----  
   for(i=limit;i>=LastBar;i--)
    {
     if((High[i+2]>High[i+1] && High[i+2]>High[i] && High[i+2]>High[i+3] && High[i+2]>High[i+4])||
         (UseEqualExt && High[i+2]>=High[i+1] && High[i+2]>=High[i] && High[i+2]>High[i+3] && High[i+2]>High[i+4]))
      {
       Upper[i+2]=High[i+2]+range*multiplier/10;
       fr_h=High[i+2];
       fr_up_t=Time[i+2];
      }
     if((Low[i+2]<Low[i+1] && Low[i+2]<Low[i+3] && Low[i+2]<Low[i+4] && Low[i+2]<Low[i])||
        (UseEqualExt && Low[i+2]<=Low[i+1] && Low[i+2]<Low[i+3] && Low[i+2]<Low[i+4] && Low[i+2]<=Low[i])) 
      {
       Lower[i+2]=Low[i+2]-range*multiplier/10;
       fr_l=Low[i+2];
       fr_dn_t=Time[i+2];
      }
//----       
    if(show_level)
     { 
      Create.TL("fr_up",fr_up_t,fr_h,Time[i-1],fr_h,width,style,fr_up_color,false);
      Create.Arrow("fr_up_price",Time[0],fr_h,6,fr_up_color,width);
      Create.TL("fr_dn",fr_dn_t,fr_l,Time[i-1],fr_l,width,style,fr_dn_color,false);  
      Create.Arrow("fr_dn_price",Time[0],fr_l,6,fr_dn_color,width);
     }
    }  
//----     
   if(alert)   {
      if(High[0]>=fr_h && High[1]<fr_h)   {
         if(bar<Time[0])   {
            Alert("    ",Symbol(),"_",Period(),"");
            bar=Time[0];  
         }
      }
      if(Low[0]<=fr_l && Low[1]>fr_l)  {
         if(bar<Time[0])   {
            Alert("    ",Symbol(),"_",Period(),"");
            bar=Time[0];  
         }
      }
   } 
           

   return(0);
  }
//+------------------------------------------------------------------+