//+------------------------------------------------------------------+
//|                                                  i-BLSignals.mq4 |
//|                      Copyright  2010, Dmitry Zhebrak aka Necron |
//|                                                  www.mqlcoder.ru |
//+------------------------------------------------------------------+
//|                        |
//|.           |
//| ( Necron ).     |
//|   ,    .  |
//|     .                    |
//|      ,    |
//|  .                              |
//|  ,                  |
//|       email:           |
//|mqlcoder@yandex.ru                                                |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, D.Zhebrak aka Necron"
#property link      "www.mqlcoder.ru"
#property link      "mailto: mqlcoder@yandex.ru"

#define   version   "1.0.0.1"
//----    Profitunity_MT4
#include <b-Profitunity_MT4.mqh>
//----    
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Lime

//----   
//extern int     BarsToProcess=200;   //     (-1 )
extern int     width=0;             // 

//----    
double   dn[],
         up[]; 
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
int init()
  {
//----    
//----           
  SetIndexBuffer(0,dn);
  SetIndexBuffer(1,up);
//----    
  SetIndexStyle(0,DRAW_ARROW,0,width);
  SetIndexStyle(1,DRAW_ARROW,0,width);
//----     
  SetIndexArrow(0,159);
  SetIndexArrow(1,159);
//----         
  IndicatorShortName("i-BLSignals");
  SetIndexLabel(0,"  ");
  SetIndexLabel(1,"  ");
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+   
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+ 
//|                                                  | 
//+------------------------------------------------------------------+   
int start()
  {
   int   limit,counted_bars=IndicatorCounted();
   double jaw,atr;
//----    
   if(counted_bars<0) return(-1);
//----     
   if(iBars(Symbol(),Period())<14) 
    {
     Print("    !");
     return(-1); 
    }    
//----      
   limit = Bars - counted_bars-1;
   if(Bars - counted_bars > 2) limit = Bars-14;
   if(limit>BarsToProcess && BarsToProcess>0) limit=BarsToProcess;
//----   
   for(int i=limit; i>=0; i--)
    {
     jaw=iAlligator(Symbol(),Period(),13,8,8,5,5,3,MODE_SMMA,PRICE_MEDIAN,MODE_GATORJAW,i+1);
     
     if(Low[i]>Low[i+1])
      {
       if(Low[i+1]<jaw)
        {
         if(Zone(i)==1)
          {
           dn[i]=Low[GetSecond(i+1,MODE_LOWER)];
          }
         else dn[i]=Low[i+1];
        }
       else if(Low[i+1]>jaw)
        {
         if(Zone(i)==1)
          {
           dn[i]=Low[GetSecond(GetSecond(GetSecond(i+1,MODE_LOWER),MODE_LOWER),MODE_LOWER)];
          }
         else dn[i]=Low[GetSecond(i+1,MODE_LOWER)];
        }
      }  
     if(High[i]<High[i+1])
      {
       if(High[i+1]>jaw)
        {
         if(Zone(i)==-1)
          {
           up[i]=High[GetSecond(i+1,MODE_UPPER)];
          }
         else up[i]=High[i+1];
        }  
       else if(High[i+1]<jaw)
        {
         if(Zone(i)==-1)
          {
           up[i]=High[GetSecond(GetSecond(GetSecond(i+1,MODE_UPPER),MODE_UPPER),MODE_UPPER)];   
          }
         else up[i]=High[GetSecond(i+1,MODE_UPPER)];        
        }  
      }  
   }
   return(0);
  }
//+------------------------------------------------------------------+


