//+------------------------------------------------------------------+
//|                                                  i-Alligator.mq4 |
//|                       Copyright  2010, Dmitry Zhebrak aka Necron|
//|                                                  www.mqlcoder.ru |
//+------------------------------------------------------------------+
//|                        |
//|.           |
//| ( Necron ).     |
//|   ,    .  |
//|     .                    |
//|      ,    |
//|  .                              |
//|  ,                  |
//|       email:           |
//|mqlcoder@yandex.ru                                                |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, D.Zhebrak aka Necron"
#property link      "www.mqlcoder.ru"
#property link      "mailto: mqlcoder@yandex.ru"

#define   version   "1.0.0.0"
//----    Profitunity_MT4
#include <b-Profitunity_MT4.mqh>
//----    
#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_color3 Lime
#property indicator_color4 Magenta

//----   
//extern int  BarsToProcess=200;               //     (-1 )
extern bool Show_AddLines=false;             //  
extern int  width=1;                         //  
extern int  FastGator.Period=3;              //  
extern int  FastGator.Shift=1;               //  
extern int  Lips.Period=5;                   //  
extern int  Lips.Shift=3;                    //  
extern int  Teeth.Period=8;                  //  
extern int  Teeth.Shift=5;                   //  
extern int  Jaw.Period=13;                   //  
extern int  Jaw.Shift=8;                     //  

//----    
double   Jaw.Buffer[],
         Teeth.Buffer[],
         Lips.Buffer[],
         FastGator.Buffer[];
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
int init()
  {
//----     
//----        
   SetIndexBuffer(0,Jaw.Buffer);
   SetIndexBuffer(1,Teeth.Buffer);
   SetIndexBuffer(2,Lips.Buffer);
   SetIndexBuffer(3,FastGator.Buffer);
//----    
   SetIndexShift(0,Jaw.Shift);
   SetIndexShift(1,Teeth.Shift);
   SetIndexShift(2,Lips.Shift);
   SetIndexShift(3,FastGator.Shift);
//----    
   SetIndexDrawBegin(0,Jaw.Shift+Jaw.Period);
   SetIndexDrawBegin(1,Teeth.Shift+Teeth.Period);
   SetIndexDrawBegin(2,Lips.Shift+Lips.Period);
   SetIndexDrawBegin(3,FastGator.Shift+FastGator.Period);
//----    
   SetIndexStyle(0,DRAW_LINE,0,width);
   SetIndexStyle(1,DRAW_LINE,0,width);
   SetIndexStyle(2,DRAW_LINE,0,width);
   SetIndexStyle(3,DRAW_LINE,0,width);
//----         
   IndicatorShortName("i-Alligator");
   SetIndexLabel(0,"Gator Jaws");
   SetIndexLabel(1,"Gator Teeth");
   SetIndexLabel(2,"Gator Lips");
   SetIndexLabel(3,"Gator Fast");
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| Bill Williams' Alligator                                         |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
//----    
   if(counted_bars<0) return(-1);
//----     
   if(iBars(Symbol(),Period())<14) 
    {
     Print("    !");
     return(-1); 
    }
//----              
   limit=Bars-counted_bars-1;
   if(Bars-counted_bars>2) limit=Bars-Jaw.Period-1;
   if(limit>BarsToProcess && BarsToProcess>0)limit=BarsToProcess;
//----   
   for(int i=limit;i>=0;i--)
     {     
      Jaw.Buffer[i]      =iMA(NULL,0,Jaw.Period,0,MODE_SMMA,PRICE_MEDIAN,i);
      Teeth.Buffer[i]    =iMA(NULL,0,Teeth.Period,0,MODE_SMMA,PRICE_MEDIAN,i);
      Lips.Buffer[i]     =iMA(NULL,0,Lips.Period,0,MODE_SMMA,PRICE_MEDIAN,i);
      
      if (Show_AddLines)
       {
        FastGator.Buffer[i]=iMA(NULL,0,FastGator.Period,0,MODE_SMMA,PRICE_MEDIAN,i);
       }
     }
   return(0);
  }
//+------------------------------------------------------------------+