//+------------------------------------------------------------------+
//|                                           DoubleCCI-With_EMA.mq4 |
//+------------------------------------------------------------------+
#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1 DarkOrange
#property indicator_color2 DarkGreen
#property indicator_color3 Maroon
#property indicator_color4 DarkGreen
#property indicator_color5 Aqua
#property indicator_color6 Black
#property indicator_color7 Yellow

#property indicator_width1 2
#property indicator_width2 17
#property indicator_width3 17
#property indicator_width4 2
#property indicator_width5 2
#property indicator_width6 2
#property indicator_width7 2

#property indicator_level1 100
#property indicator_level2 250
#property indicator_level3 350
#property indicator_level4 -350
#property indicator_level5 -250
#property indicator_level6 -100
#property indicator_levelcolor DimGray
#property indicator_levelstyle STYLE_DOT
//---- input parameters
extern int TrendCCI_period = 70;
extern int EntryCCI_period = 30;
extern bool Show_SMA1 = true;
extern int SMA1_period=30;
extern string SMA1_of_TrendCCI_or_EntryCCI = "EntryCCI_period";
extern bool Show_SMA2 = true;
extern int SMA2_period=5;
extern string SMA2_of_TrendCCI_or_EntryCCI = "EntryCCI_period";
extern int SMA3_period=2;
double TrendBuffer[], UpBuffer[], DownBuffer[], EntryBuffer[], SMA1[], SMA2[], SMA3[], ZerroBuffer[];
//+------------------------------------------------------------------+
int init()  {
   IndicatorBuffers(8);
   SetIndexStyle (0, DRAW_LINE);        SetIndexBuffer(0, ZerroBuffer);
   SetIndexStyle (1, DRAW_HISTOGRAM);   SetIndexBuffer(1, UpBuffer);
   SetIndexStyle (2, DRAW_HISTOGRAM);   SetIndexBuffer(2, DownBuffer);
   SetIndexStyle (3, DRAW_LINE);        SetIndexBuffer(3, TrendBuffer);
   SetIndexStyle (4, DRAW_LINE);        SetIndexBuffer(4, SMA1);
   SetIndexStyle (5, DRAW_LINE);        SetIndexBuffer(5, SMA2);
   SetIndexStyle (6, DRAW_LINE);        SetIndexBuffer(6, SMA3);
   SetIndexBuffer(7, EntryBuffer);
   return(0);
  }
//+------------------------------------------------------------------+
int deinit()  {  return(0);  }
//+------------------------------------------------------------------+
int start() {
   static datetime prevtime = 0;
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
   int limit=Bars-counted_bars;

   IndicatorShortName("(TrendCCI_period: " + TrendCCI_period + ", EntryCCI_period: " + EntryCCI_period + ") ");   
   for(int i = 0; i <= limit; i++) {
      TrendBuffer[i] = iCCI(NULL, 0, TrendCCI_period, PRICE_TYPICAL, i);
      EntryBuffer[i] = iCCI(NULL, 0, EntryCCI_period, PRICE_TYPICAL, i);
      if(TrendBuffer[i] >=0)    UpBuffer[i]   = TrendBuffer[i];  else  UpBuffer[i] = 0;
      if(TrendBuffer[i] < 0)    DownBuffer[i] = TrendBuffer[i];  else  DownBuffer[i]=0;
      ZerroBuffer[i] = 0; 
   }
   if (Show_SMA1 == true) {
      if(SMA1_of_TrendCCI_or_EntryCCI == "TrendCCI_period")
        for(i=0; i<limit; i++)   SMA1[i] = iMAOnArray(TrendBuffer, 0, SMA1_period, 0, MODE_SMA, i);
      else if (SMA1_of_TrendCCI_or_EntryCCI == "EntryCCI_period")
        for(i=0; i<limit; i++)   SMA1[i] = iMAOnArray(EntryBuffer, 0, SMA1_period, 0, MODE_SMA, i);
   }
   if (Show_SMA2 == true) {
      if(SMA2_of_TrendCCI_or_EntryCCI == "TrendCCI_period")
        for(i=0; i<limit; i++)   SMA2[i] = iMAOnArray(TrendBuffer, 0, SMA2_period, 0, MODE_SMA, i);
      else if (SMA2_of_TrendCCI_or_EntryCCI == "EntryCCI_period")
        for(i=0; i<limit; i++)   SMA2[i] = iMAOnArray(EntryBuffer, 0, SMA2_period, 0, MODE_SMA, i);
        for(i=0; i<limit; i++)   SMA3[i] = iMAOnArray(EntryBuffer, 0, SMA3_period, 0, MODE_SMA, i);
   }
   return(0);
  }
//+------------------------------------------------------------------+