/*
 * Filename:    DogiStars.mq4
 * Author:      DriverDan
 * Date:        Oct 28, 2005
 *
 * Description: Indicator that displays Dogis and Morning and Evening Dogi stars.
 *
 * Version:     1.0
 *              Initial release
 */

#property copyright "Copyright  2005, DriverDan"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1  Yellow
#property indicator_color2  Red
#property indicator_color3  Red

#define UP                  1
#define DOWN                2

extern int showDogis      = 1;     // 1 = Show a star for Dogis
extern int showArrows     = 1;     // 1 = Arrows for morning and evening Dogi stars

double dogiBuffer[];
double upBuffer[];
double downBuffer[];

/*
 * Initialization function
 */
int init() {
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexStyle(2, DRAW_ARROW);
   SetIndexArrow(0, 171);
   SetIndexArrow(1, 225);
   SetIndexArrow(2, 226);
   SetIndexBuffer(0, dogiBuffer);
   SetIndexBuffer(1, upBuffer);
   SetIndexBuffer(2, downBuffer);
   SetIndexLabel(0, "Dogi");
   SetIndexLabel(1, "Up Signal");
   SetIndexLabel(2, "Down Signal");
   return(0);
}

/*
 * Function to find a Dogi
 */
int findDogi(int i) {
   int retVal = 0;

   if(Low[i] < Low[i + 1] && Open[i] == Close[i]) {
      retVal = UP;
   } else if(High[i] > High[i + 1] && Open[i] == Close[i]) {
      retVal = DOWN;
   }
   
   return(retVal);
}

/*
 * Main program
 */
int start() {
   int i, dogiVal;
   int counted_bars = IndicatorCounted();

   if(Bars < 3) return(0);

   // Loop and look for pivots
   for(i = Bars - counted_bars; i >= 0; i--) {
      if(i < Bars - 3) {
         
         // If we are showing Dogis look for them
         if(showDogis == 1) {
            dogiVal = findDogi(i);
            
            // If we found a dogi mark it
            if(dogiVal == UP) {
               dogiBuffer[i] = Low[i] - 4 * Point;
            } else if(dogiVal == DOWN) {
               dogiBuffer[i] = High[i] + 4 * Point;
            }
         }
         
         // If we are showing morning and evening dogi stars look for them
         if(showArrows == 1) {
            dogiVal = findDogi(i + 2);

            // If we found a morning or evening dogi star mark it
            if(dogiVal == UP && Open[i + 3] > Close[i + 3] && Open[i + 1] < Close[i + 1]) {
               upBuffer[i + 1] = Low[i + 1] - 4 * Point;
            } else if(dogiVal == DOWN && Open[i + 3] < Close[i + 3] && Open[i + 1] > Close[i + 1]) {
               downBuffer[i + 1] = High[i + 1] + 4 * Point;
            }
         }
      }
   }

   return(0);
}