//+------------------------------------------------------------------+
//|                                                          STD.mq4 |
//|                      Copyright  2010, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#define SIGNAL_NONE 0
#define SIGNAL_BUY   1
#define SIGNAL_SELL  2
#define SIGNAL_CLOSEBUY 3
#define SIGNAL_CLOSESELL 4

#property copyright "Expert Advisor Builder"
#property link      "http://sufx.core.t3-ism.net/ExpertAdvisorBuilder/"

extern int MagicNumber = 27374;
extern bool SignalMail = False;
extern bool EachTickMode = False;
extern double Lots = 0.01;
extern int Slippage = 9;
extern bool UseStopLossLong = True;
extern bool UseTakeProfitLong = True;
extern bool UseStopLossShort= True;
extern bool UseTakeProfitShort = True;
extern bool UseTrailingStop = True;
extern double Balancefactor  =10000;
extern bool  microlots      =True;
extern bool          TimeEntry      = True;
extern int           StartHour      = 0;
extern int           StopHour       = 23;
extern string        WaitTime       = "Wait time is in seconds";
extern int           NewBarWaitTime = 0; //Wait for 5 minutes = 300 
extern string        ClosingHours         = "CLOSING HOURS";
extern bool          UseHourClose         = True;
extern int           CloseHour            = 23;
extern int           CloseMinute          = 0;
extern double MinLots        = 0.01;
extern double MaxLots        = 30;
extern double Ratio=1.02;//


int BarCount, curprof;
int Current;
bool TickCheck = False;
bool tickvalue;
string sWaiting;
double dXPoint = 1;
string sTrading;
bool exit;
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init() {
   BarCount = Bars;

   if (EachTickMode) Current = 0; else Current = 1;
   if(Digits==3||Digits==5){
   dXPoint=10;
   MagicNumber    = subGenerateMagicNumber(MagicNumber, Symbol(), Period());
   tickvalue = MarketInfo(Symbol(),MODE_TICKVALUE);
   return(0);

}
}
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit() {
   return(0);
}

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start() {


   int Order = SIGNAL_NONE;
   int Total, Ticket;
   double StopLossLevel, TakeProfitLevel;
   CheckTradeContext();
   CommentMe();

   if (EachTickMode && Bars != BarCount) TickCheck = False;
   Total = OrdersTotal();
   Order = SIGNAL_NONE;
   if (AccountEquity()/AccountBalance()>Ratio) closeOrders();
      if (UseHourClose){
   if(Hour()==CloseHour && Minute()==CloseMinute && OrdersTotal()>0){
   closeOrders();
   }


   //+------------------------------------------------------------------+
   //| Variable Begin                                                   |
   //+------------------------------------------------------------------+
   double high = iHigh(Symbol(),PERIOD_D1,1);
   double low = iLow(Symbol(),PERIOD_D1,1);
   double close = iClose(Symbol(),PERIOD_D1,1);
   double open= iOpen(Symbol(),0,0);
   double pivot = (high+low+close)/3;
   
   double D1_H = iHigh(Symbol(),0,1);
   double D1_L = iLow(Symbol(),0,1);
   double D1_C = iClose(Symbol(),0,1);   
   double MP = (D1_H+D1_L+D1_C)/3;
   

   double mean1 = (high+pivot)/2; 
   double variance1 = ((high-pivot)*(high-pivot))/2; 
   double stdev1 = MathSqrt(variance1); 

   double mean2 = (low+pivot)/2; 
   double variance2 = ((low-pivot)*(low-pivot))/2; 
   double stdev2 = MathSqrt(variance2); 

   double mean = (stdev1+stdev2)/2; 
   double variance = ((stdev1-stdev2)*(stdev1-stdev2))/2; 
   double stdev = MathSqrt(variance);   
   
   
   double StopLossLong = (stdev2)/dXPoint/Point;
   double StopLossShort = (stdev1)/dXPoint/Point;         
   double TrailingStop = (stdev)/dXPoint/Point;
   double TakeProfitLong = (stdev1)/dXPoint/Point;  
   double TakeProfitShort = (stdev2)/dXPoint/Point;

   //+------------------------------------------------------------------+
   //| Variable End                                                     |
   //+------------------------------------------------------------------+

   //Check position
   bool IsTrade = False;
         sTrading = "";
      if (TimeEntry)
      {
         
         bool cond = IsEntryTime();
         if (!cond) 
         {
            sTrading = "Outside of Trading time!!";
            return(0);
         }
      }
      bool TimeToWait = False;
      sWaiting="";
      if(TimeCurrent()<iTime(Symbol(),Period(),0)+NewBarWaitTime) 
      {
         TimeToWait=True;
         sWaiting = "NEW BAR DETECTED." + "\n" + "Waiting another " + ((iTime(Symbol(),Period(),0)+NewBarWaitTime)-TimeCurrent()) + " seconds before trading";
      }
   for (int i = 0; i < Total; i ++) {
      OrderSelect(i, SELECT_BY_POS, MODE_TRADES);
      if(OrderType() <= OP_SELL &&  OrderSymbol() == Symbol()) {
         IsTrade = True;
         if(OrderType() == OP_BUY) {
            //Close

            //+------------------------------------------------------------------+
            //| Signal Begin(Exit Buy)                                           |
            //+------------------------------------------------------------------+
   
            //+------------------------------------------------------------------+
            //| Signal End(Exit Buy)                                             |
            //+------------------------------------------------------------------+

             if (Order == SIGNAL_CLOSEBUY && ((EachTickMode && !TickCheck) || (!EachTickMode && (Bars != BarCount || exit)))) {
               OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, MediumSeaGreen);
               if (SignalMail) SendMail("[Signal Alert]", "[" + Symbol() + "] " + DoubleToStr(Bid, Digits) + " Close Buy");
               if (!EachTickMode) BarCount = Bars;
               IsTrade = False;
               continue;
            }
            //Trailing stop
            if(UseTrailingStop && TrailingStop > 0) {                 
               if(Bid - OrderOpenPrice() >NormalizeDouble( TrailingStop*dXPoint*Point,Digits)) {
                  if(OrderStopLoss() <NormalizeDouble( Bid - TrailingStop*dXPoint*Point,Digits)) {
                     OrderModify(OrderTicket(), OrderOpenPrice(),NormalizeDouble (Bid - TrailingStop*dXPoint*Point,Digits), OrderTakeProfit(), 0, MediumSeaGreen);
                     if (!EachTickMode) BarCount = Bars;
                     continue;
                  }
               }
            }
         } else {
            //Close

            //+------------------------------------------------------------------+
            //| Signal Begin(Exit Sell)                                          |
            //+------------------------------------------------------------------+
     
            //+------------------------------------------------------------------+
            //| Signal End(Exit Sell)                                            |
            //+------------------------------------------------------------------+

            if (Order == SIGNAL_CLOSESELL && ((EachTickMode && !TickCheck) || (!EachTickMode && (Bars != BarCount || exit)))) {
               OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, DarkOrange);
               if (SignalMail) SendMail("[Signal Alert]", "[" + Symbol() + "] " + DoubleToStr(Ask, Digits) + " Close Sell");
               if (!EachTickMode) BarCount = Bars;
               IsTrade = False;
               continue;
            }
            //Trailing stop
            if(UseTrailingStop && TrailingStop > 0) {                 
               if((OrderOpenPrice() - Ask) >NormalizeDouble (TrailingStop*dXPoint*Point,Digits)) {
                  if((OrderStopLoss() >NormalizeDouble (Ask + TrailingStop*dXPoint*Point,Digits)) || (OrderStopLoss() == 0)) {
                     OrderModify(OrderTicket(), OrderOpenPrice(),NormalizeDouble(Ask + TrailingStop*dXPoint*Point,Digits), OrderTakeProfit(), 0, DarkOrange);
                     if (!EachTickMode) BarCount = Bars;
                     continue;
                  }
               }
            }
         }
      }
   }

   //+------------------------------------------------------------------+
   //| Signal Begin(Entry)                                              |
   //+------------------------------------------------------------------+
 

   if (Bid>= MP) Order = SIGNAL_BUY;

   if (Bid <= MP) Order = SIGNAL_SELL;

   //+------------------------------------------------------------------+
   //| Signal End                                                       |
   //+------------------------------------------------------------------+

   //Buy
   if (Order == SIGNAL_BUY && ((EachTickMode && !TickCheck) || (!EachTickMode && (Bars != BarCount)))) {
      if(!IsTrade) {
         //Check free margin
         if (AccountFreeMargin() < (1000 * LotsOptimized())) {
            Print("We have no money. Free Margin = ", AccountFreeMargin());
            return(0);
         }
         RefreshRates();
         if (UseStopLossLong) StopLossLevel = Ask - (StopLossLong*dXPoint)*Point; else StopLossLevel = 0.0;
         if (UseTakeProfitLong) TakeProfitLevel = Bid + (TakeProfitLong*dXPoint)*Point; else TakeProfitLevel = 0.0;
         RefreshRates();
         Ticket = OrderSend(Symbol(), OP_BUY, LotsOptimized(), Ask, Slippage, StopLossLevel, TakeProfitLevel, "Buy(#" + MagicNumber + ")", MagicNumber, 0, DodgerBlue);
         if(Ticket > 0) {
            if (OrderSelect(Ticket, SELECT_BY_TICKET, MODE_TRADES)) {
				Print("BUY order opened : ", OrderOpenPrice());
                if (SignalMail) SendMail("[Signal Alert]", "[" + Symbol() + "] " + DoubleToStr(Ask, Digits) + " Open Buy");
			} else {
				Print("Error opening BUY order : ", GetLastError());
			}
         }
         if (EachTickMode) TickCheck = True;
         if (!EachTickMode) BarCount = Bars;
         return(0);
      }
   }

   //Sell
   if (Order == SIGNAL_SELL && ((EachTickMode && !TickCheck) || (!EachTickMode && (Bars != BarCount)))) {
      if(!IsTrade) {
         //Check free margin
         if (AccountFreeMargin() < (1000 * LotsOptimized())) {
            Print("We have no money. Free Margin = ", AccountFreeMargin());
            return(0);
         }
         RefreshRates();
         if (UseStopLossShort) StopLossLevel = Bid + (StopLossShort*dXPoint)*Point; else StopLossLevel = 0.0;
         if (UseTakeProfitShort) TakeProfitLevel = Ask - (TakeProfitShort*dXPoint)*Point; else TakeProfitLevel = 0.0;
         RefreshRates();
         Ticket = OrderSend(Symbol(), OP_SELL, LotsOptimized(), Bid, Slippage, StopLossLevel, TakeProfitLevel, "Sell(#" + MagicNumber + ")", MagicNumber, 0, DeepPink);
         if(Ticket > 0) {
            if (OrderSelect(Ticket, SELECT_BY_TICKET, MODE_TRADES)) {
				Print("SELL order opened : ", OrderOpenPrice());
                if (SignalMail) SendMail("[Signal Alert]", "[" + Symbol() + "] " + DoubleToStr(Bid, Digits) + " Open Sell");
			} else {
				Print("Error opening SELL order : ", GetLastError());
			}
         }
         if (EachTickMode) TickCheck = True;
         if (!EachTickMode) BarCount = Bars;
         return(0);
      }
   }

   if (!EachTickMode) BarCount = Bars;

   return(0);
}
}
  //+----------------------------------------------------------------------------+
  double LotsOptimized()
   {
   if(microlots==true)
      {
      Lots = NormalizeDouble(MathFloor(AccountFreeMargin()/Balancefactor)*0.01-0.005,2);
      if(Lots>MaxLots){Lots=MaxLots;}
      else if(Lots<MinLots){Lots=MinLots;}
      }
   else
      {    
      Lots = NormalizeDouble(MathFloor(AccountFreeMargin()/Balancefactor)*0.01-0.05, 1);
      if(Lots>MaxLots){Lots=MaxLots;}
      else if(Lots<MinLots){Lots=MinLots;}
}
return(Lots);
}
   
         RefreshRates();   
bool IsEntryTime()
{
  datetime Now = TimeCurrent();

  bool result = false; 
   int Hr = TimeHour(TimeCurrent());

   if ( StartHour>0 || StopHour>0 )
   {
      if( StartHour > StopHour )
      {
         if( Hr >= StartHour || Hr < StopHour ) result = True;
      }
      else if(Hr >= StartHour && Hr < StopHour ) result = True;      
   } 
   else 
      result = True; //Both and start time = 0, so trading sessions not being used.  
  
  return (result);
} 

//+----------------------------------------------------------------------------+

void CheckTradeContext()
{
   if(!IsTradeAllowed())
      {
//        Print("Trade context is busy! Wait until it is free...");
        // infinite loop
        while(true)
          {
            // if the expert was stopped by the user, stop operation
            if(IsStopped()) 
              { 
//                Print("The expert was stopped by the user!"); 
                return(-1); 
              }
            // if trade context has become free, terminate the loop and start trading
            if(IsTradeAllowed())
              {
//                Print("Trade context has become free!");
                break;
              }
            // if no loop breaking condition has been met, "wait" for 0.1 sec
            // and restart checking
            Sleep(100);
          }
      }
}


int closeOrders()
  {
//----
   // ???????? ??? ?????, ? ???? ??? ?? ???? ???? ??????? ?????????????
   // ? ???????? ?????? ???????
   if (!IsDemo()) {Alert("?? ???????? ????? ?????? ?????????"); return;}
   
   int total=OrdersTotal(); // ?????????? ???????  
   int ordertype;// ???  ??????   
   if (total==0) {Alert("??? ??????? ??? ????????/????????");return;}
   int ticket; // ????? ?????????? ???? ????? ??????
   double priceClose;// ????, ?? ??????? ????? ????????? ???????? ??????
   for(int i=total-1;i>=0;i--)
      {
      if (OrderSelect(i,SELECT_BY_POS))
         {
         ordertype=OrderType();
         ticket=OrderTicket();
         switch(ordertype)
            {
            case 0:
               // ??????? ??????? 
               //??????? ???? Bid ?? ???????
               priceClose=MarketInfo(OrderSymbol(),MODE_BID);
               Print("????????? ?? ",i," ??????? ????? ? ??????? No",ticket);
               OrderClose(ticket,OrderLots(),priceClose,3,Red);
               break;// ????? ?? ????? switch    
            case 1:
               // ??????? ???????
               //??????? ???? Ask ?? ???????
               priceClose=MarketInfo(OrderSymbol(),MODE_ASK);
               Print("????????? ?? ",i," ??????? ????? ? ??????? No",ticket);
               OrderClose(ticket,OrderLots(),priceClose,3,Red);
               break;// ????? ?? ????? switch    
            default:
               // ???????? ?? 2 ?? 5, ??????? ?????????? ?????
               Print("??????? ?? ",i," ??????? ????? ? ??????? No",ticket);
               OrderDelete(ticket);  
               break;// ????? ?? ????? switch    
            }    
         }
         
      }   
//----
   return(0);
  }
//+--------------------------END OF PROGRAM--------------------------+
//----------------------------------------- COMMENT FUNCTION ----------------------------------------------------

int CommentMe()    //Comments out needed parameters on a chart
{
   RefreshRates();
   double Eq.CM = AccountEquity();
   double Bal.CM = AccountBalance();
   double Mar.CM = AccountMargin();
   double Prof.CM = AccountProfit();
   double Lev.CM = AccountLeverage();
   double TV.CM = MarketInfo(Symbol(), MODE_TICKVALUE);   
   double MNL.CM = MarketInfo(Symbol(), MODE_MINLOT);
   double MXL.CM = MarketInfo(Symbol(), MODE_MAXLOT);
   double Sprd.CM = (Ask-Bid)/dXPoint/Point;
   double SWL.CM = MarketInfo(Symbol(), MODE_SWAPLONG);
   double SWS.CM = MarketInfo(Symbol(), MODE_SWAPSHORT);
   double STP.CM = MarketInfo(Symbol(),MODE_STOPLEVEL)/dXPoint;
   double Odr.CM = OrderOpenPrice();
   double High.CM = iHigh(NULL,0,0);
   double Low.CM = iLow(NULL,0,0);
   double Close.CM = iClose(NULL,0,0);
   double Open.CM = iOpen(NULL,0,0);
   double D1_H = iHigh(Symbol(),PERIOD_D1,1);
   double D1_L = iLow(Symbol(),PERIOD_D1,1);
   int D1_Rng = (D1_H-D1_L)/dXPoint/Point; 
   int TS = (D1_H-D1_L)/6/dXPoint/Point;      
   double MP.CM = (High.CM+Low.CM)/2;

   Comment("Account balance is ",DoubleToStr(Bal.CM,2),"\n",
           "Account equity is ",DoubleToStr(Eq.CM,2),"\n",
           "Account profit is ",DoubleToStr(Prof.CM,2),"\n",
           "Account margin is ",DoubleToStr(Mar.CM,2),"\n",
           "Account Leverage is ",DoubleToStr(Lev.CM,2),"\n",        
           "Tick Value is ",DoubleToStr(TV.CM,4),"\n",
           "Min Lot is ",DoubleToStr(MNL.CM,4),"\n",           
           "Max Lot is ",DoubleToStr(MXL.CM,4),"\n",           
           "Spread is ",DoubleToStr(Sprd.CM,1),"\n",
           "Swap Long is ",DoubleToStr(SWL.CM,4),"\n",
           "Swap Short is ",DoubleToStr(SWS.CM,4),"\n",
           "Bar Pivot Point is ",DoubleToStr(MP.CM,4),"\n",
           "Bar Open is ",DoubleToStr(Open.CM,4),"\n",
           "Bar Range is ",DoubleToStr(D1_Rng,4),"\n",
           "Bar Trailing Stop is ",DoubleToStr(TS,4),"\n",                                      
           "Minimum StopLevel is ",DoubleToStr(STP.CM,0),"\n",
           "Order Open Price is ",DoubleToStr(Odr.CM,Digits),"\n",                              
           "Current Server time is ",TimeToStr(TimeCurrent()),"\n",
           sTrading,"\n",sWaiting);
           
   return(0);
}


//----------------------- GENERATE MAGIC NUMBER BASE ON SYMBOL AND TIME FRAME FUNCTION
//----------------------- SOURCE   : PENGIE

int subGenerateMagicNumber(int Magic_Number, string symbol, int timeFrame)
{
   int isymbol = 0;
   if (symbol == "AUDCAD")       isymbol = 1;
   else if (symbol == "AUDCHF")  isymbol = 2;
   else if (symbol == "AUDJPY")  isymbol = 3;
   else if (symbol == "AUDDKK")  isymbol = 4;
   else if (symbol == "AUDNZD")  isymbol = 5;
   else if (symbol == "AUDPLN")  isymbol = 6;
   else if (symbol == "AUDSGD")  isymbol = 7;
   else if (symbol == "AUDUSD")  isymbol = 8;
   else if (symbol == "CADCHF")  isymbol = 9;
   else if (symbol == "CADJPY")  isymbol = 10;
   else if (symbol == "CHFCAD")  isymbol = 11;
   else if (symbol == "CHFJPY")  isymbol = 12;
   else if (symbol == "CHFSGD")  isymbol = 13;
   else if (symbol == "EURAUD")  isymbol = 14;
   else if (symbol == "EURCAD")  isymbol = 15;
   else if (symbol == "EURCHF")  isymbol = 16;
   else if (symbol == "EURDKK")  isymbol = 17;
   else if (symbol == "EURGBP")  isymbol = 18;
   else if (symbol == "EURHKD")  isymbol = 19;
   else if (symbol == "EURHUF")  isymbol = 20;
   else if (symbol == "EURJPY")  isymbol = 21;
   else if (symbol == "EURLVL")  isymbol = 22;
   else if (symbol == "EURNOK")  isymbol = 23;
   else if (symbol == "EURNZD")  isymbol = 24;
   else if (symbol == "EURPLN")  isymbol = 25;
   else if (symbol == "EURSEK")  isymbol = 26;
   else if (symbol == "EURSGD")  isymbol = 27;
   else if (symbol == "EURSKK")  isymbol = 28;
   else if (symbol == "EURUSD")  isymbol = 29;
   else if (symbol == "EURZAR")  isymbol = 30;
   else if (symbol == "GBPAUD")  isymbol = 31;
   else if (symbol == "GBPCAD")  isymbol = 32;
   else if (symbol == "GBPCHF")  isymbol = 33;
   else if (symbol == "GBPDKK")  isymbol = 34;
   else if (symbol == "GBPJPY")  isymbol = 35;
   else if (symbol == "GBPNOK")  isymbol = 36;
   else if (symbol == "GBPNZD")  isymbol = 37;
   else if (symbol == "GBPSEK")  isymbol = 38;
   else if (symbol == "GBPSGD")  isymbol = 39;
   else if (symbol == "GBPUSD")  isymbol = 40;
   else if (symbol == "GBPZAR")  isymbol = 41;
   else if (symbol == "NZDCAD")  isymbol = 42;
   else if (symbol == "NZDCHF")  isymbol = 43;
   else if (symbol == "NZDJPY")  isymbol = 44;
   else if (symbol == "NZDSGD")  isymbol = 45;
   else if (symbol == "NZDUSD")  isymbol = 46;
   else if (symbol == "SGDJPY")  isymbol = 47;
   else if (symbol == "USDCAD")  isymbol = 48;
   else if (symbol == "USDCHF")  isymbol = 49;
   else if (symbol == "USDCCK")  isymbol = 50;
   else if (symbol == "USDDKK")  isymbol = 51;
   else if (symbol == "USDHKD")  isymbol = 52;
   else if (symbol == "USDHRK")  isymbol = 53;
   else if (symbol == "USDHUF")  isymbol = 54;
   else if (symbol == "USDJPY")  isymbol = 55;
   else if (symbol == "USDLVL")  isymbol = 56;
   else if (symbol == "USDLTL")  isymbol = 57;
   else if (symbol == "USDMXN")  isymbol = 58;
   else if (symbol == "USDNOK")  isymbol = 59;
   else if (symbol == "USDPLN")  isymbol = 60;
   else if (symbol == "USDSEK")  isymbol = 61;
   else if (symbol == "USDSGD")  isymbol = 62;
   else if (symbol == "USDSKK")  isymbol = 63;
   else if (symbol == "USDZAR")  isymbol = 64;
   else if (symbol == "#AA")  isymbol = 65;
   else if (symbol == "#AXP")  isymbol = 66;
   else if (symbol == "#BA")  isymbol = 67;
   else if (symbol == "#C")  isymbol = 68;
   else if (symbol == "#DD")  isymbol = 69;
   else if (symbol == "#DIS")  isymbol = 70;
   else if (symbol == "#AIG")  isymbol = 71;
   else if (symbol == "#GE")  isymbol = 72;
   else if (symbol == "#GM")  isymbol = 73;
   else if (symbol == "#HD")  isymbol = 74;
   else if (symbol == "#HON")  isymbol = 75;
   else if (symbol == "#HPQ")  isymbol = 76;
   else if (symbol == "#IBM")  isymbol = 77;
   else if (symbol == "#VZ")  isymbol = 78;
   else if (symbol == "#INTC")  isymbol = 79;
   else if (symbol == "#JNJ")  isymbol = 80;
   else if (symbol == "#JPM")  isymbol = 81;
   else if (symbol == "#KO")  isymbol = 82;
   else if (symbol == "#MCD")  isymbol = 83;
   else if (symbol == "#MMM")  isymbol = 84;
   else if (symbol == "#MO")  isymbol = 85;
   else if (symbol == "#MRK")  isymbol = 86;
   else if (symbol == "#MSFT")  isymbol = 87;
   else if (symbol == "#PG")  isymbol = 88;
   else if (symbol == "#T")  isymbol = 89;
   else if (symbol == "#PFE")  isymbol = 90;
   else if (symbol == "#UTX")  isymbol = 91;
   else if (symbol == "#WMT")  isymbol = 92;
   else if (symbol == "#XOM")  isymbol = 93;
   else if (symbol == "Gold")  isymbol = 94;
   else if (symbol == "Silver")  isymbol = 95;
   else if (symbol == "#EP")  isymbol = 96;
   else if (symbol == "#ENQ")  isymbol = 97;
   else if (symbol == "#YM")  isymbol = 98;
   else if (symbol == "#CL")  isymbol = 99;
   else if (symbol == "#NG")  isymbol = 100;
   else if (symbol == "#W")  isymbol = 101;
   else if (symbol == "#C")  isymbol = 102;
   else if (symbol == "#S")  isymbol = 103;
   else                          isymbol = 104;
   if(isymbol<10) Magic_Number = MagicNumber * 10;
   return (StrToInteger(StringConcatenate(MagicNumber, isymbol, timeFrame)));
   
}
//+------------------------------------------------------------------+

