//+------------------------------------------------------------------+
//|                                   FerruFx_Multi_info+_2_v1.2.mq4 |
//|                                        Copyright  2007, FerruFx |
//|                                                                  |
//+------------------------------------------------------------------+

// Version v1.2:

// 1. In this version, you can choose which indicators and TF you want to calculate the trend



#property indicator_separate_window

#property indicator_minimum 0
#property indicator_maximum 1

#property indicator_buffers 2

//---- For the small screens
extern string    Display_infos         = "=== If true, displayed on the chart ===";
extern bool      display_on_chart      =    false;  // If true, the open trade analysis, daily pivots and daily range will be displayed on the chart window

//---- Open trade info parameters
extern string    Trade_info            = "=== Trade Info ===";
extern bool      AccountMini           =     true;  // If false, account is standard
extern double    LeverageToTrade       =      5.0;  // Leverage which you want to trade per position (e.g. you have a 200:1 account and you want to trade 10:1 of this leverage, just put 10)
extern double    PipValue              =    0.832;  // Pip Value

//---- Level to change the strength "weak" to "strong"
extern double TrendStrongLevel = 75.00;

//---- Indicators to display and calculate the trend
extern string    Trend_calculation     = "=== Trend calculation and display ===";
extern bool      display_fast_MA       =     true;
extern bool      display_medium_MA     =     true;
extern bool      display_slow_MA       =     true;
extern bool      display_CCI           =     true;
extern bool      display_MACD          =     true;
extern bool      display_ADX           =     true;
extern bool      display_BULLS         =     true;
extern bool      display_BEARS         =     true;
extern bool      display_STOCH         =     true;
extern bool      display_RSI           =     true;
extern bool      display_FORCE         =     true;
extern bool      display_MOMENTUM      =     true;
extern bool      display_DeMARKER      =     true;
extern bool      display_WAE           =     true;

//---- Timeframes to display and calculate the trend
extern string    TF_calculation        = "=== If display false, set coef to 0 ===";
extern string    Coefs_TF              = "3 TF true, SUM of their coef must be 3";
extern bool      display_M1            =     true;
extern double    coef_m1               =      1.0;
extern bool      display_M5            =     true;
extern double    coef_m5               =      1.0;
extern bool      display_M15           =     true;
extern double    coef_m15              =      1.0;
extern bool      display_M30           =     true;
extern double    coef_m30              =      1.0;
extern bool      display_H1            =     true;
extern double    coef_H1               =      1.0;
extern bool      display_H4            =     true;
extern double    coef_H4               =      1.0;
extern bool      display_D1            =     true;
extern double    coef_D1               =      1.0;

// indicators parameters

extern string    Shift_Settings_test_only        = "=== Format: 2007.05.02 00:00 ===";
extern datetime  look_time_shift       = D'2007.05.07 00:00';  // Shift for test if "test" is true
extern double    shift_indicators      =                   0;  // Shift for indicators if "test" is false
extern bool      test                  =               false;

//---- buffers
double TrendUPBuffer[];
double TrendDOWNBuffer[];

string    STOCHASTIC_Settings   = "=== STOCHASTIC Settings ===";
int       STOKPeriod            =            5;  // Stochastic %K  period
int       STODPeriod            =            3;  // Stochastic %D  period
int       STOSlowing            =            3;  // Stochastic slowing

string    RSI_Settings          = "=== RSI Settings ===";
int       RSIPeriod             =           14;  // RSI  period

string    FORCE_Settings        = "=== FORCE INDEX Settings ===";
int       FIPeriod              =           14;  // Force Index period
int       FIMethod              =     MODE_SMA;  // Force Index method
int       FIPrice               =  PRICE_CLOSE;  // Force Index price

string    MOMENTUM_Settings     = "=== MOMENTUM INDEX Settings ===";
int       MOMPeriod             =           14;  // Momentum period
int       MOMPrice              =  PRICE_CLOSE;  // Momentum price

string    DeMARKER_Settings     = "=== DeMARKER Settings ===";
int       DEMPeriod             =           14;  // DeMarker  period

int TimeZone=0;
bool pivots = true;
bool alert = true;

double yesterday_high=0;
double yesterday_open=0;
double yesterday_low=0;
double yesterday_close=0;
double today_open=0;
double today_high=0;
double today_low=0;

double rates_h1[2][6];
double rates_d1[2][6];




//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- name for indicator window

   string short_name=" ";
   IndicatorShortName(short_name);
   
   SetIndexBuffer(0,TrendUPBuffer);
   SetIndexBuffer(1,TrendDOWNBuffer);
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   
   ObjectDelete("pivots");
   ObjectDelete("line5");
   ObjectDelete("R3_Label");
   ObjectDelete("R3_Value");
   ObjectDelete("R2_Label");
   ObjectDelete("R2_Value");
   ObjectDelete("R1_Label");
   ObjectDelete("R1_Value");
   ObjectDelete("Pivot_Label");
   ObjectDelete("Pivot_Value");
   ObjectDelete("S1_Label");
   ObjectDelete("S1_Value");
   ObjectDelete("S2_Label");
   ObjectDelete("S2_Value");
   ObjectDelete("S3_Label");
   ObjectDelete("S3_Value");
   ObjectDelete("daily_range");
   ObjectDelete("line6");
   ObjectDelete("today");
   ObjectDelete("today_range");
   ObjectDelete("yesterday");
   ObjectDelete("yesterday_range");
   ObjectDelete("5_days");
   ObjectDelete("5_days_range");
   ObjectDelete("10_days");
   ObjectDelete("10_days_range");
   ObjectDelete("20_days");
   ObjectDelete("20_days_range");
   ObjectDelete("50_days");
   ObjectDelete("50_days_range");
   ObjectDelete("line7");
   ObjectDelete("Average");
   ObjectDelete("Average_range");
   ObjectDelete("line8");
   ObjectDelete("Trend_STOCH_1");ObjectDelete("Trend_STOCH_5");ObjectDelete("Trend_STOCH_15");ObjectDelete("Trend_STOCH_30");
   ObjectDelete("Trend_STOCH_60");ObjectDelete("Trend_STOCH_240");ObjectDelete("Trend_STOCH_1440");
   ObjectDelete("Trend_RSI_1");ObjectDelete("Trend_RSI_5");ObjectDelete("Trend_RSI_15");ObjectDelete("Trend_RSI_30");
   ObjectDelete("Trend_RSI_60");ObjectDelete("Trend_RSI_240");ObjectDelete("Trend_RSI_1440");
   ObjectDelete("Trend_FI_1");ObjectDelete("Trend_FI_5");ObjectDelete("Trend_FI_15");ObjectDelete("Trend_FI_30");
   ObjectDelete("Trend_FI_60");ObjectDelete("Trend_FI_240");ObjectDelete("Trend_FI_1440");
   ObjectDelete("Trend_MOM_1");ObjectDelete("Trend_MOM_5");ObjectDelete("Trend_MOM_15");ObjectDelete("Trend_MOM_30");
   ObjectDelete("Trend_MOM_60");ObjectDelete("Trend_MOM_240");ObjectDelete("Trend_MOM_1440");
   ObjectDelete("Trend_DEM_1");ObjectDelete("Trend_DEM_5");ObjectDelete("Trend_DEM_15");ObjectDelete("Trend_DEM_30");
   ObjectDelete("Trend_DEM_60");ObjectDelete("Trend_DEM_240");ObjectDelete("Trend_DEM_1440");
   ObjectDelete("Trend_WAE_1");ObjectDelete("Trend_WAE_5");ObjectDelete("Trend_WAE_15");ObjectDelete("Trend_WAE_30");
   ObjectDelete("Trend_WAE_60");ObjectDelete("Trend_WAE_240");ObjectDelete("Trend_WAE_1440");
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
double UP_65, UP_66, UP_67, UP_68, UP_69, UP_70;
double UP_71, UP_72, UP_73, UP_74, UP_75, UP_76, UP_77, UP_78, UP_79, UP_80;
double UP_81, UP_82, UP_83, UP_84, UP_85, UP_86, UP_87, UP_88, UP_89, UP_90;
double UP_91, UP_92, UP_93, UP_94, UP_95, UP_96, UP_97, UP_98, UP_99, UP_100;
double UP_101, UP_102, UP_103, UP_104, UP_105, UP_106, UP_107, UP_108, UP_109, UP_110;
double UP_111, UP_112;

double DOWN_65, DOWN_66, DOWN_67, DOWN_68, DOWN_69, DOWN_70;
double DOWN_71, DOWN_72, DOWN_73, DOWN_74, DOWN_75, DOWN_76, DOWN_77, DOWN_78, DOWN_79, DOWN_80;
double DOWN_81, DOWN_82, DOWN_83, DOWN_84, DOWN_85, DOWN_86, DOWN_87, DOWN_88, DOWN_89, DOWN_90;
double DOWN_91, DOWN_92, DOWN_93, DOWN_94, DOWN_95, DOWN_96, DOWN_97, DOWN_98, DOWN_99, DOWN_100;
double DOWN_101, DOWN_102, DOWN_103, DOWN_104, DOWN_105, DOWN_106, DOWN_107, DOWN_108, DOWN_109, DOWN_110;
double DOWN_111, DOWN_112;

double count_m1, count_m5, count_m15, count_m30, count_h1, count_h4, count_d1;

  if ( display_M1 == true) { count_m1 = 1; }
  if ( display_M5 == true) { count_m5 = 1; }
  if ( display_M15 == true) { count_m15 = 1; }
  if ( display_M30 == true) { count_m30 = 1; }
  if ( display_H1 == true) { count_h1 = 1; }
  if ( display_H4 == true) { count_h4 = 1; }
  if ( display_D1 == true) { count_d1 = 1; }
  
  double count_tf = count_m1 + count_m5 + count_m15 + count_m30 + count_h1 + count_h4 + count_d1;
  double coef = coef_m1 + coef_m5 + coef_m15 + coef_m30 + coef_H1 + coef_H4 + coef_D1;
  if( coef != count_tf ) { Alert("The sum of the coefs must be ",  count_tf,". Your setting is ", coef,"!!!"); }
  
  int j,total=OrdersTotal();
   for(j=0;j<total;j++)
   {
    OrderSelect(j, SELECT_BY_POS, MODE_TRADES);
   }
   
   color color_common_line = White;
   color color_common_text = White;
   color color_ind = PowderBlue;
   color color_indic;
   color color_pivots_1=PaleVioletRed;
   double x;
   
// Shift calculation for indicators (tests only)

   double shift_1, shift_5, shift_15, shift_30, shift_60, shift_240, shift_1440, shift_10080;
   
   if( test == true )
   {
    shift_1=iBarShift(NULL,PERIOD_M1,look_time_shift,false);
    shift_5=iBarShift(NULL,PERIOD_M5,look_time_shift,false);
    shift_15=iBarShift(NULL,PERIOD_M15,look_time_shift,false);
    shift_30=iBarShift(NULL,PERIOD_M30,look_time_shift,false);
    shift_60=iBarShift(NULL,PERIOD_H1,look_time_shift,false);
    shift_240=iBarShift(NULL,PERIOD_H4,look_time_shift,false);
    shift_1440=iBarShift(NULL,PERIOD_D1,look_time_shift,false);
    shift_10080=iBarShift(NULL,PERIOD_W1,look_time_shift,false);
   }
   else
   {
    shift_1=shift_indicators;
    shift_5=shift_indicators;
    shift_15=shift_indicators;
    shift_30=shift_indicators;
    shift_60=shift_indicators;
    shift_240=shift_indicators;
    shift_1440=shift_indicators;
    shift_10080=shift_indicators;
  }
   
//---- calculation for the label's X/Y

   int add_x, add_y;
   
   if(display_on_chart == true)
   {   
    add_x = -160;
    add_y = 25;
   }
   else
   {
    add_x = 0;
    add_y = 10;
   }
   
// Indicator (STOCH)

   ObjectCreate("stoch", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("stoch","STOCH",9, "Verdana", color_ind);
   ObjectSet("stoch", OBJPROP_CORNER, 0);
   ObjectSet("stoch", OBJPROP_XDISTANCE, 601+add_x);
   ObjectSet("stoch", OBJPROP_YDISTANCE, -5+add_y);
   
   string STOCH_Trend_1, STOCH_Trend_5, STOCH_Trend_15, STOCH_Trend_30, STOCH_Trend_60, STOCH_Trend_240, STOCH_Trend_1440, STOCH_Trend_10080;
   
   if( display_STOCH == true )
   {
   if( display_M1 == true )
   {
   double stoch_m_1=iStochastic(NULL,PERIOD_M1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,shift_1);
   double stoch_s_1=iStochastic(NULL,PERIOD_M1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,shift_1);

   if (stoch_m_1 >= stoch_s_1) { STOCH_Trend_1 = "UP"; x = 616; color_indic = Lime; UP_65 = 1; DOWN_65 = 0; }
   if (stoch_m_1 < stoch_s_1) { STOCH_Trend_1 = "DOWN"; x = 606; color_indic = Red; UP_65 = 0; DOWN_65 = 1; }
   ObjectCreate("Trend_STOCH_1", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_STOCH_1",STOCH_Trend_1,7, "Verdana", color_indic);
   ObjectSet("Trend_STOCH_1", OBJPROP_CORNER, 0);
   ObjectSet("Trend_STOCH_1", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_STOCH_1", OBJPROP_YDISTANCE, 22+add_y);
   }
   
   if( display_M5 == true )
   {
   double stoch_m_5=iStochastic(NULL,PERIOD_M5,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,shift_5);
   double stoch_s_5=iStochastic(NULL,PERIOD_M5,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,shift_5);

   if (stoch_m_5 >= stoch_s_5) { STOCH_Trend_5 = "UP"; x = 616; color_indic = Lime; UP_66 = 1; DOWN_66 = 0; }
   if (stoch_m_5 < stoch_s_5) { STOCH_Trend_5 = "DOWN"; x = 606; color_indic = Red; UP_66 = 0; DOWN_66 = 1; }
   ObjectCreate("Trend_STOCH_5", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_STOCH_5",STOCH_Trend_5,7, "Verdana", color_indic);
   ObjectSet("Trend_STOCH_5", OBJPROP_CORNER, 0);
   ObjectSet("Trend_STOCH_5", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_STOCH_5", OBJPROP_YDISTANCE, 37+add_y);
   }
   
   if( display_M15 == true )
   {
   double stoch_m_15=iStochastic(NULL,PERIOD_M15,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,shift_15);
   double stoch_s_15=iStochastic(NULL,PERIOD_M15,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,shift_15);

   if (stoch_m_15 >= stoch_s_15) { STOCH_Trend_15 = "UP"; x = 616; color_indic = Lime; UP_67 = 1; DOWN_67 = 0; }
   if (stoch_m_15 < stoch_s_15) { STOCH_Trend_15 = "DOWN"; x = 606; color_indic = Red; UP_67 = 0; DOWN_67 = 1; }
   ObjectCreate("Trend_STOCH_15", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_STOCH_15",STOCH_Trend_15,7, "Verdana", color_indic);
   ObjectSet("Trend_STOCH_15", OBJPROP_CORNER, 0);
   ObjectSet("Trend_STOCH_15", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_STOCH_15", OBJPROP_YDISTANCE, 52+add_y);
   }
   
   if( display_M30 == true )
   {
   double stoch_m_30=iStochastic(NULL,PERIOD_M30,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,shift_30);
   double stoch_s_30=iStochastic(NULL,PERIOD_M30,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,shift_30);

   if (stoch_m_30 >= stoch_s_30) { STOCH_Trend_30 = "UP"; x = 616; color_indic = Lime; UP_68 = 1; DOWN_68 = 0; }
   if (stoch_m_30 < stoch_s_30) { STOCH_Trend_30 = "DOWN"; x = 606; color_indic = Red; UP_68 = 0; DOWN_68 = 1; }
   ObjectCreate("Trend_STOCH_30", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_STOCH_30",STOCH_Trend_30,7, "Verdana", color_indic);
   ObjectSet("Trend_STOCH_30", OBJPROP_CORNER, 0);
   ObjectSet("Trend_STOCH_30", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_STOCH_30", OBJPROP_YDISTANCE, 67+add_y);
   }
   
   if( display_H1 == true )
   {
   double stoch_m_60=iStochastic(NULL,PERIOD_H1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,shift_60);
   double stoch_s_60=iStochastic(NULL,PERIOD_H1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,shift_60);

   if (stoch_m_60 >= stoch_s_60) { STOCH_Trend_60 = "UP"; x = 616; color_indic = Lime; UP_69 = 1; DOWN_69 = 0; }
   if (stoch_m_60 < stoch_s_60) { STOCH_Trend_60 = "DOWN"; x = 606; color_indic = Red; UP_69 = 0; DOWN_69 = 1; }
   ObjectCreate("Trend_STOCH_60", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_STOCH_60",STOCH_Trend_60,7, "Verdana", color_indic);
   ObjectSet("Trend_STOCH_60", OBJPROP_CORNER, 0);
   ObjectSet("Trend_STOCH_60", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_STOCH_60", OBJPROP_YDISTANCE, 82+add_y);
   }
   
   if( display_H4 == true )
   {
   double stoch_m_240=iStochastic(NULL,PERIOD_H4,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,shift_240);
   double stoch_s_240=iStochastic(NULL,PERIOD_H4,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,shift_240);

   if (stoch_m_240 >= stoch_s_240) { STOCH_Trend_240 = "UP"; x = 616; color_indic = Lime; UP_70 = 1; DOWN_70 = 0; }
   if (stoch_m_240 < stoch_s_240) { STOCH_Trend_240 = "DOWN"; x = 606; color_indic = Red; UP_70 = 0; DOWN_70 = 1; }
   ObjectCreate("Trend_STOCH_240", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_STOCH_240",STOCH_Trend_240,7, "Verdana", color_indic);
   ObjectSet("Trend_STOCH_240", OBJPROP_CORNER, 0);
   ObjectSet("Trend_STOCH_240", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_STOCH_240", OBJPROP_YDISTANCE, 97+add_y);
   }
   
   if( display_D1 == true )
   {
   double stoch_m_1440=iStochastic(NULL,PERIOD_D1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,shift_1440);
   double stoch_s_1440=iStochastic(NULL,PERIOD_D1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,shift_1440);

   if (stoch_m_1440 >= stoch_s_1440) { STOCH_Trend_1440 = "UP"; x = 616; color_indic = Lime; UP_71 = 1; DOWN_71 = 0; }
   if (stoch_m_1440 < stoch_s_1440) { STOCH_Trend_1440 = "DOWN"; x = 606; color_indic = Red; UP_71 = 0; DOWN_71 = 1; }
   ObjectCreate("Trend_STOCH_1440", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_STOCH_1440",STOCH_Trend_1440,7, "Verdana", color_indic);
   ObjectSet("Trend_STOCH_1440", OBJPROP_CORNER, 0);
   ObjectSet("Trend_STOCH_1440", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_STOCH_1440", OBJPROP_YDISTANCE, 112+add_y);
   }
   }
   
// Indicator (RSI)

   ObjectCreate("rsi", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("rsi","RSI",9, "Verdana", color_ind);
   ObjectSet("rsi", OBJPROP_CORNER, 0);
   ObjectSet("rsi", OBJPROP_XDISTANCE, 662+add_x);
   ObjectSet("rsi", OBJPROP_YDISTANCE, -5+add_y);
   
   string RSI_Trend_1, RSI_Trend_5, RSI_Trend_15, RSI_Trend_30, RSI_Trend_60, RSI_Trend_240, RSI_Trend_1440, RSI_Trend_10080;
   
   if( display_RSI == true )
   {
   if( display_M1 == true )
   {
   double rsi_1=iRSI(NULL,PERIOD_M1,RSIPeriod,PRICE_CLOSE,shift_1);
   
   if (rsi_1 >= 50) { RSI_Trend_1 = "UP"; x = 666; color_indic = Lime; UP_73 = 1; DOWN_73 = 0; }
   if (rsi_1 < 50) { RSI_Trend_1 = "DOWN"; x = 656; color_indic = Red; UP_73 = 0; DOWN_73 = 1; }
   ObjectCreate("Trend_RSI_1", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_RSI_1",RSI_Trend_1,7, "Verdana", color_indic);
   ObjectSet("Trend_RSI_1", OBJPROP_CORNER, 0);
   ObjectSet("Trend_RSI_1", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_RSI_1", OBJPROP_YDISTANCE, 22+add_y);
   }
   
   if( display_M5 == true )
   {
   double rsi_5=iRSI(NULL,PERIOD_M5,RSIPeriod,PRICE_CLOSE,shift_5);
   
   if (rsi_5 >= 50) { RSI_Trend_5 = "UP"; x = 666; color_indic = Lime; UP_74 = 1; DOWN_74 = 0; }
   if (rsi_5 < 50) { RSI_Trend_5 = "DOWN"; x = 656; color_indic = Red; UP_74 = 0; DOWN_74 = 1; }
   ObjectCreate("Trend_RSI_5", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_RSI_5",RSI_Trend_5,7, "Verdana", color_indic);
   ObjectSet("Trend_RSI_5", OBJPROP_CORNER, 0);
   ObjectSet("Trend_RSI_5", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_RSI_5", OBJPROP_YDISTANCE, 37+add_y);
   }
   
   if( display_M15 == true )
   {
   double rsi_15=iRSI(NULL,PERIOD_M15,RSIPeriod,PRICE_CLOSE,shift_15);
   
   if (rsi_15 >= 50) { RSI_Trend_15 = "UP"; x = 666; color_indic = Lime; UP_75 = 1; DOWN_75 = 0; }
   if (rsi_15 < 50) { RSI_Trend_15 = "DOWN"; x = 656; color_indic = Red; UP_75 = 0; DOWN_75 = 1; }
   ObjectCreate("Trend_RSI_15", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_RSI_15",RSI_Trend_15,7, "Verdana", color_indic);
   ObjectSet("Trend_RSI_15", OBJPROP_CORNER, 0);
   ObjectSet("Trend_RSI_15", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_RSI_15", OBJPROP_YDISTANCE, 52+add_y);
   }
   
   if( display_M30 == true )
   {
   double rsi_30=iRSI(NULL,PERIOD_M30,RSIPeriod,PRICE_CLOSE,shift_30);
   
   if (rsi_30 >= 50) { RSI_Trend_30 = "UP"; x = 666; color_indic = Lime; UP_76 = 1; DOWN_76 = 0; }
   if (rsi_30 < 50) { RSI_Trend_30 = "DOWN"; x = 656; color_indic = Red; UP_76 = 0; DOWN_76 = 1; }
   ObjectCreate("Trend_RSI_30", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_RSI_30",RSI_Trend_30,7, "Verdana", color_indic);
   ObjectSet("Trend_RSI_30", OBJPROP_CORNER, 0);
   ObjectSet("Trend_RSI_30", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_RSI_30", OBJPROP_YDISTANCE, 67+add_y);
   }
   
   if( display_H1 == true )
   {
   double rsi_60=iRSI(NULL,PERIOD_H1,RSIPeriod,PRICE_CLOSE,shift_60);
   
   if (rsi_60 >= 50) { RSI_Trend_60 = "UP"; x = 666; color_indic = Lime; UP_77 = 1; DOWN_77 = 0; }
   if (rsi_60 < 50) { RSI_Trend_60 = "DOWN"; x = 656; color_indic = Red; UP_77 = 0; DOWN_77 = 1; }
   ObjectCreate("Trend_RSI_60", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_RSI_60",RSI_Trend_60,7, "Verdana", color_indic);
   ObjectSet("Trend_RSI_60", OBJPROP_CORNER, 0);
   ObjectSet("Trend_RSI_60", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_RSI_60", OBJPROP_YDISTANCE, 82+add_y);
   }
   
   if( display_H4 == true )
   {
   double rsi_240=iRSI(NULL,PERIOD_H4,RSIPeriod,PRICE_CLOSE,shift_240);
   
   if (rsi_240 >= 50) { RSI_Trend_240 = "UP"; x = 666; color_indic = Lime; UP_78 = 1; DOWN_78 = 0; }
   if (rsi_240 < 50) { RSI_Trend_240 = "DOWN"; x = 656; color_indic = Red; UP_78 = 0; DOWN_78 = 1; }
   ObjectCreate("Trend_RSI_240", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_RSI_240",RSI_Trend_240,7, "Verdana", color_indic);
   ObjectSet("Trend_RSI_240", OBJPROP_CORNER, 0);
   ObjectSet("Trend_RSI_240", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_RSI_240", OBJPROP_YDISTANCE, 97+add_y);
   }
   
   if( display_D1 == true )
   {
   double rsi_1440=iRSI(NULL,PERIOD_D1,RSIPeriod,PRICE_CLOSE,shift_1440);
   
   if (rsi_1440 >= 50) { RSI_Trend_1440 = "UP"; x = 666; color_indic = Lime; UP_79 = 1; DOWN_79 = 0; }
   if (rsi_1440 < 50) { RSI_Trend_1440 = "DOWN"; x = 656; color_indic = Red; UP_79 = 0; DOWN_79 = 1; }
   ObjectCreate("Trend_RSI_1440", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_RSI_1440",RSI_Trend_1440,7, "Verdana", color_indic);
   ObjectSet("Trend_RSI_1440", OBJPROP_CORNER, 0);
   ObjectSet("Trend_RSI_1440", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_RSI_1440", OBJPROP_YDISTANCE, 112+add_y);
   }
   }
   
// Indicator (FORCE INDEX)

   ObjectCreate("force", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("force","FORCE",9, "Verdana", color_ind);
   ObjectSet("force", OBJPROP_CORNER, 0);
   ObjectSet("force", OBJPROP_XDISTANCE, 701+add_x);
   ObjectSet("force", OBJPROP_YDISTANCE, -5+add_y);
   
   string FI_Trend_1, FI_Trend_5, FI_Trend_15, FI_Trend_30, FI_Trend_60, FI_Trend_240, FI_Trend_1440, FI_Trend_10080;
   
   if( display_FORCE == true )
   {
   if( display_M1 == true )
   {
   double fi_1=iForce(NULL,PERIOD_M1,FIPeriod,FIMethod,FIPrice,shift_1);
   
   if (fi_1 >= 0) { FI_Trend_1 = "UP"; x = 716; color_indic = Lime; UP_81 = 1; DOWN_81 = 0; }
   if (fi_1 < 0) { FI_Trend_1 = "DOWN"; x = 706; color_indic = Red; UP_81 = 0; DOWN_81 = 1; }
   ObjectCreate("Trend_FI_1", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_FI_1",FI_Trend_1,7, "Verdana", color_indic);
   ObjectSet("Trend_FI_1", OBJPROP_CORNER, 0);
   ObjectSet("Trend_FI_1", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_FI_1", OBJPROP_YDISTANCE, 22+add_y);
   }
   
   if( display_M5 == true )
   {
   double fi_5=iForce(NULL,PERIOD_M5,FIPeriod,FIMethod,FIPrice,shift_5);
   
   if (fi_5 >= 0) { FI_Trend_5 = "UP"; x = 716; color_indic = Lime; UP_82 = 1; DOWN_82 = 0; }
   if (fi_5 < 0) { FI_Trend_5 = "DOWN"; x = 706; color_indic = Red; UP_82 = 0; DOWN_82 = 1; }
   ObjectCreate("Trend_FI_5", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_FI_5",FI_Trend_5,7, "Verdana", color_indic);
   ObjectSet("Trend_FI_5", OBJPROP_CORNER, 0);
   ObjectSet("Trend_FI_5", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_FI_5", OBJPROP_YDISTANCE, 37+add_y);
   }
   
   if( display_M15 == true )
   {
   double fi_15=iForce(NULL,PERIOD_M15,FIPeriod,FIMethod,FIPrice,shift_15);
   
   if (fi_15 >= 0) { FI_Trend_15 = "UP"; x = 716; color_indic = Lime; UP_83 = 1; DOWN_83 = 0; }
   if (fi_15 < 0) { FI_Trend_15 = "DOWN"; x = 706; color_indic = Red; UP_83 = 0; DOWN_83 = 1; }
   ObjectCreate("Trend_FI_15", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_FI_15",FI_Trend_15,7, "Verdana", color_indic);
   ObjectSet("Trend_FI_15", OBJPROP_CORNER, 0);
   ObjectSet("Trend_FI_15", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_FI_15", OBJPROP_YDISTANCE, 52+add_y);
   }
   
   if( display_M30 == true )
   {
   double fi_30=iForce(NULL,PERIOD_M30,FIPeriod,FIMethod,FIPrice,shift_30);
   
   if (fi_30 >= 0) { FI_Trend_30 = "UP"; x = 716; color_indic = Lime; UP_84 = 1; DOWN_84 = 0; }
   if (fi_30 < 0) { FI_Trend_30 = "DOWN"; x = 706; color_indic = Red; UP_84 = 0; DOWN_84 = 1; }
   ObjectCreate("Trend_FI_30", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_FI_30",FI_Trend_30,7, "Verdana", color_indic);
   ObjectSet("Trend_FI_30", OBJPROP_CORNER, 0);
   ObjectSet("Trend_FI_30", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_FI_30", OBJPROP_YDISTANCE, 67+add_y);
   }
   
   if( display_H1 == true )
   {
   double fi_60=iForce(NULL,PERIOD_H1,FIPeriod,FIMethod,FIPrice,shift_60);
   
   if (fi_60 >= 0) { FI_Trend_60 = "UP"; x = 716; color_indic = Lime; UP_85 = 1; DOWN_85 = 0; }
   if (fi_60 < 0) { FI_Trend_60 = "DOWN"; x = 706; color_indic = Red; UP_85 = 0; DOWN_85 = 1; }
   ObjectCreate("Trend_FI_60", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_FI_60",FI_Trend_60,7, "Verdana", color_indic);
   ObjectSet("Trend_FI_60", OBJPROP_CORNER, 0);
   ObjectSet("Trend_FI_60", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_FI_60", OBJPROP_YDISTANCE, 82+add_y);
   }
   
   if( display_H4 == true )
   {
   double fi_240=iForce(NULL,PERIOD_H4,FIPeriod,FIMethod,FIPrice,shift_240);
   
   if (fi_240 >= 0) { FI_Trend_240 = "UP"; x = 716; color_indic = Lime; UP_86 = 1; DOWN_86 = 0; }
   if (fi_240 < 0) { FI_Trend_240 = "DOWN"; x = 706; color_indic = Red; UP_86 = 0; DOWN_86 = 1; }
   ObjectCreate("Trend_FI_240", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_FI_240",FI_Trend_240,7, "Verdana", color_indic);
   ObjectSet("Trend_FI_240", OBJPROP_CORNER, 0);
   ObjectSet("Trend_FI_240", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_FI_240", OBJPROP_YDISTANCE, 97+add_y);
   }
   
   if( display_D1 == true )
   {
   double fi_1440=iForce(NULL,PERIOD_D1,FIPeriod,FIMethod,FIPrice,shift_1440);
   
   if (fi_1440 >= 0) { FI_Trend_1440 = "UP"; x = 716; color_indic = Lime; UP_87 = 1; DOWN_87 = 0; }
   if (fi_1440 < 0) { FI_Trend_1440 = "DOWN"; x = 706; color_indic = Red; UP_87 = 0; DOWN_87 = 1; }
   ObjectCreate("Trend_FI_1440", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_FI_1440",FI_Trend_1440,7, "Verdana", color_indic);
   ObjectSet("Trend_FI_1440", OBJPROP_CORNER, 0);
   ObjectSet("Trend_FI_1440", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_FI_1440", OBJPROP_YDISTANCE, 112+add_y);
   }
   }
   
// Indicator (MOMENTUM)

   ObjectCreate("momentum", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("momentum","MOM",9, "Verdana", color_ind);
   ObjectSet("momentum", OBJPROP_CORNER, 0);
   ObjectSet("momentum", OBJPROP_XDISTANCE, 758+add_x);
   ObjectSet("momentum", OBJPROP_YDISTANCE, -5+add_y);
   
   string MOM_Trend_1, MOM_Trend_5, MOM_Trend_15, MOM_Trend_30, MOM_Trend_60, MOM_Trend_240, MOM_Trend_1440, MOM_Trend_10080;
   
   if( display_MOMENTUM == true )
   {
   if( display_M1 == true )
   {
   double momentum_1=iMomentum(NULL,PERIOD_M1,MOMPeriod,MOMPrice,shift_1);
   
   if (momentum_1 >= 100) { MOM_Trend_1 = "UP"; x = 766; color_indic = Lime; UP_89 = 1; DOWN_89 = 0; }
   if (momentum_1 < 100) { MOM_Trend_1 = "DOWN"; x = 756; color_indic = Red; UP_89 = 0; DOWN_89 = 1; }
   ObjectCreate("Trend_MOM_1", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_MOM_1",MOM_Trend_1,7, "Verdana", color_indic);
   ObjectSet("Trend_MOM_1", OBJPROP_CORNER, 0);
   ObjectSet("Trend_MOM_1", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_MOM_1", OBJPROP_YDISTANCE, 22+add_y);
   }
   
   if( display_M5 == true )
   {
   double momentum_5=iMomentum(NULL,PERIOD_M5,MOMPeriod,MOMPrice,shift_5);
   
   if (momentum_5 >= 100) { MOM_Trend_5 = "UP"; x = 766; color_indic = Lime; UP_90 = 1; DOWN_90 = 0; }
   if (momentum_5 < 100) { MOM_Trend_5 = "DOWN"; x = 756; color_indic = Red; UP_90 = 0; DOWN_90 = 1; }
   ObjectCreate("Trend_MOM_5", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_MOM_5",MOM_Trend_5,7, "Verdana", color_indic);
   ObjectSet("Trend_MOM_5", OBJPROP_CORNER, 0);
   ObjectSet("Trend_MOM_5", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_MOM_5", OBJPROP_YDISTANCE, 37+add_y);
   }
   
   if( display_M15 == true )
   {
   double momentum_15=iMomentum(NULL,PERIOD_M15,MOMPeriod,MOMPrice,shift_15);
   
   if (momentum_15 >= 100) { MOM_Trend_15 = "UP"; x = 766; color_indic = Lime; UP_91 = 1; DOWN_91 = 0; }
   if (momentum_15 < 100) { MOM_Trend_15 = "DOWN"; x = 756; color_indic = Red; UP_91 = 0; DOWN_91 = 1; }
   ObjectCreate("Trend_MOM_15", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_MOM_15",MOM_Trend_15,7, "Verdana", color_indic);
   ObjectSet("Trend_MOM_15", OBJPROP_CORNER, 0);
   ObjectSet("Trend_MOM_15", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_MOM_15", OBJPROP_YDISTANCE, 52+add_y);
   }
   
   if( display_M30 == true )
   {
   double momentum_30=iMomentum(NULL,PERIOD_M30,MOMPeriod,MOMPrice,shift_30);
   
   if (momentum_30 >= 100) { MOM_Trend_30 = "UP"; x = 766; color_indic = Lime; UP_92 = 1; DOWN_92 = 0; }
   if (momentum_30 < 100) { MOM_Trend_30 = "DOWN"; x = 756; color_indic = Red; UP_92 = 0; DOWN_92 = 1; }
   ObjectCreate("Trend_MOM_30", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_MOM_30",MOM_Trend_30,7, "Verdana", color_indic);
   ObjectSet("Trend_MOM_30", OBJPROP_CORNER, 0);
   ObjectSet("Trend_MOM_30", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_MOM_30", OBJPROP_YDISTANCE, 67+add_y);
   }
   
   if( display_H1 == true )
   {
   double momentum_60=iMomentum(NULL,PERIOD_H1,MOMPeriod,MOMPrice,shift_60);
   
   if (momentum_60 >= 100) { MOM_Trend_60 = "UP"; x = 766; color_indic = Lime; UP_93 = 1; DOWN_93 = 0; }
   if (momentum_60 < 100) { MOM_Trend_60 = "DOWN"; x = 756; color_indic = Red; UP_93 = 0; DOWN_93 = 1; }
   ObjectCreate("Trend_MOM_60", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_MOM_60",MOM_Trend_60,7, "Verdana", color_indic);
   ObjectSet("Trend_MOM_60", OBJPROP_CORNER, 0);
   ObjectSet("Trend_MOM_60", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_MOM_60", OBJPROP_YDISTANCE, 82+add_y);
   }
   
   if( display_H4 == true )
   {
   double momentum_240=iMomentum(NULL,PERIOD_H4,MOMPeriod,MOMPrice,shift_240);
   
   if (momentum_240 >= 100) { MOM_Trend_240 = "UP"; x = 766; color_indic = Lime; UP_94 = 1; DOWN_94 = 0; }
   if (momentum_240 < 100) { MOM_Trend_240 = "DOWN"; x = 756; color_indic = Red; UP_94 = 0; DOWN_94 = 1; }
   ObjectCreate("Trend_MOM_240", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_MOM_240",MOM_Trend_240,7, "Verdana", color_indic);
   ObjectSet("Trend_MOM_240", OBJPROP_CORNER, 0);
   ObjectSet("Trend_MOM_240", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_MOM_240", OBJPROP_YDISTANCE, 97+add_y);
   }
   
   if( display_D1 == true )
   {
   double momentum_1440=iMomentum(NULL,PERIOD_D1,MOMPeriod,MOMPrice,shift_1440);
   
   if (momentum_1440 >= 100) { MOM_Trend_1440 = "UP"; x = 766; color_indic = Lime; UP_95 = 1; DOWN_95 = 0; }
   if (momentum_1440 < 100) { MOM_Trend_1440 = "DOWN"; x = 756; color_indic = Red; UP_95 = 0; DOWN_95 = 1; }
   ObjectCreate("Trend_MOM_1440", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_MOM_1440",MOM_Trend_1440,7, "Verdana", color_indic);
   ObjectSet("Trend_MOM_1440", OBJPROP_CORNER, 0);
   ObjectSet("Trend_MOM_1440", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_MOM_1440", OBJPROP_YDISTANCE, 112+add_y);
   }
   }
   
// Indicator (DE MARKER)

   ObjectCreate("demarker", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("demarker","DeM",9, "Verdana", color_ind);
   ObjectSet("demarker", OBJPROP_CORNER, 0);
   ObjectSet("demarker", OBJPROP_XDISTANCE, 808+add_x);
   ObjectSet("demarker", OBJPROP_YDISTANCE, -5+add_y);
   
   string DEM_Trend_1, DEM_Trend_5, DEM_Trend_15, DEM_Trend_30, DEM_Trend_60, DEM_Trend_240, DEM_Trend_1440, DEM_Trend_10080;

   if( display_DeMARKER == true )
   {
   if( display_M1 == true )
   {
   double demarker_1_0=iDeMarker(NULL,PERIOD_M1,DEMPeriod,shift_1);
   double demarker_1_1=iDeMarker(NULL,PERIOD_M1,DEMPeriod,shift_1+1);
   
   if (demarker_1_0 >= demarker_1_1) { DEM_Trend_1 = "UP"; x = 816; color_indic = Lime; UP_97 = 1; DOWN_97 = 0; }
   if (demarker_1_0 < demarker_1_1) { DEM_Trend_1 = "DOWN"; x = 806; color_indic = Red; UP_97 = 0; DOWN_97 = 1; }
   ObjectCreate("Trend_DEM_1", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DEM_1",DEM_Trend_1,7, "Verdana", color_indic);
   ObjectSet("Trend_DEM_1", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DEM_1", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_DEM_1", OBJPROP_YDISTANCE, 22+add_y);
   }
   
   if( display_M5 == true )
   {
   double demarker_5_0=iDeMarker(NULL,PERIOD_M5,DEMPeriod,shift_5);
   double demarker_5_1=iDeMarker(NULL,PERIOD_M5,DEMPeriod,shift_5+1);
   
   if (demarker_5_0 >= demarker_5_1) { DEM_Trend_5 = "UP"; x = 816; color_indic = Lime; UP_98 = 1; DOWN_98 = 0; }
   if (demarker_5_0 < demarker_5_1) { DEM_Trend_5 = "DOWN"; x = 806; color_indic = Red; UP_98 = 0; DOWN_98 = 1; }
   ObjectCreate("Trend_DEM_5", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DEM_5",DEM_Trend_5,7, "Verdana", color_indic);
   ObjectSet("Trend_DEM_5", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DEM_5", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_DEM_5", OBJPROP_YDISTANCE, 37+add_y);
   }
   
   if( display_M15 == true )
   {
   double demarker_15_0=iDeMarker(NULL,PERIOD_M15,DEMPeriod,shift_15);
   double demarker_15_1=iDeMarker(NULL,PERIOD_M15,DEMPeriod,shift_15+1);
   
   if (demarker_15_0 >= demarker_15_1) { DEM_Trend_15 = "UP"; x = 816; color_indic = Lime; UP_99 = 1; DOWN_99 = 0; }
   if (demarker_15_0 < demarker_15_1) { DEM_Trend_15 = "DOWN"; x = 806; color_indic = Red; UP_99 = 0; DOWN_99 = 1; }
   ObjectCreate("Trend_DEM_15", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DEM_15",DEM_Trend_15,7, "Verdana", color_indic);
   ObjectSet("Trend_DEM_15", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DEM_15", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_DEM_15", OBJPROP_YDISTANCE, 52+add_y);
   }
   
   if( display_M30 == true )
   {
   double demarker_30_0=iDeMarker(NULL,PERIOD_M30,DEMPeriod,shift_30);
   double demarker_30_1=iDeMarker(NULL,PERIOD_M30,DEMPeriod,shift_30+1);
   
   if (demarker_30_0 >= demarker_30_1) { DEM_Trend_30 = "UP"; x = 816; color_indic = Lime; UP_100 = 1; DOWN_100 = 0; }
   if (demarker_30_0 < demarker_30_1) { DEM_Trend_30 = "DOWN"; x = 806; color_indic = Red; UP_100 = 0; DOWN_100 = 1; }
   ObjectCreate("Trend_DEM_30", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DEM_30",DEM_Trend_30,7, "Verdana", color_indic);
   ObjectSet("Trend_DEM_30", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DEM_30", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_DEM_30", OBJPROP_YDISTANCE, 67+add_y);
   }
   
   if( display_H1 == true )
   {
   double demarker_60_0=iDeMarker(NULL,PERIOD_H1,DEMPeriod,shift_60);
   double demarker_60_1=iDeMarker(NULL,PERIOD_H1,DEMPeriod,shift_60+1);
   
   if (demarker_60_0 >= demarker_60_1) { DEM_Trend_60 = "UP"; x = 816; color_indic = Lime; UP_101 = 1; DOWN_101 = 0; }
   if (demarker_60_0 < demarker_60_1) { DEM_Trend_60 = "DOWN"; x = 806; color_indic = Red; UP_101 = 0; DOWN_101 = 1; }
   ObjectCreate("Trend_DEM_60", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DEM_60",DEM_Trend_60,7, "Verdana", color_indic);
   ObjectSet("Trend_DEM_60", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DEM_60", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_DEM_60", OBJPROP_YDISTANCE, 82+add_y);
   }
   
   if( display_H4 == true )
   {
   double demarker_240_0=iDeMarker(NULL,PERIOD_H4,DEMPeriod,shift_240);
   double demarker_240_1=iDeMarker(NULL,PERIOD_H4,DEMPeriod,shift_240+1);
   
   if (demarker_240_0 >= demarker_240_1) { DEM_Trend_240 = "UP"; x = 816; color_indic = Lime; UP_102 = 1; DOWN_102 = 0; }
   if (demarker_240_0 < demarker_240_1) { DEM_Trend_240 = "DOWN"; x = 806; color_indic = Red; UP_102 = 0; DOWN_102 = 1; }
   ObjectCreate("Trend_DEM_240", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DEM_240",DEM_Trend_240,7, "Verdana", color_indic);
   ObjectSet("Trend_DEM_240", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DEM_240", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_DEM_240", OBJPROP_YDISTANCE, 97+add_y);
   }
   
   if( display_D1 == true )
   {
   double demarker_1440_0=iDeMarker(NULL,PERIOD_D1,DEMPeriod,shift_1440);
   double demarker_1440_1=iDeMarker(NULL,PERIOD_D1,DEMPeriod,shift_1440+1);
   
   if (demarker_1440_0 >= demarker_1440_1) { DEM_Trend_1440 = "UP"; x = 816; color_indic = Lime; UP_103 = 1; DOWN_103 = 0; }
   if (demarker_1440_0 < demarker_1440_1) { DEM_Trend_1440 = "DOWN"; x = 806; color_indic = Red; UP_103 = 0; DOWN_103 = 1; }
   ObjectCreate("Trend_DEM_1440", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DEM_1440",DEM_Trend_1440,7, "Verdana", color_indic);
   ObjectSet("Trend_DEM_1440", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DEM_1440", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_DEM_1440", OBJPROP_YDISTANCE, 112+add_y);
   }
   }
   
// Indicator (Waddah Attar Explosion)

   ObjectCreate("wae", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("wae","WAE",9, "Verdana", color_ind);
   ObjectSet("wae", OBJPROP_CORNER, 0);
   ObjectSet("wae", OBJPROP_XDISTANCE, 858+add_x);
   ObjectSet("wae", OBJPROP_YDISTANCE, -5+add_y);
   
   string WAE_Trend_1, WAE_Trend_5, WAE_Trend_15, WAE_Trend_30, WAE_Trend_60, WAE_Trend_240, WAE_Trend_1440, WAE_Trend_10080;
   
   if( display_WAE == true )
   {
   if( display_M1 == true )
   {
   double wae_histo_up_1_0 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_1);
   double wae_histo_up_1_1 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_1+1);
   double wae_histo_down_1_0 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_1);
   double wae_histo_down_1_1 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_1+1);
   
   if (wae_histo_up_1_0 > wae_histo_up_1_1 || wae_histo_down_1_0 < wae_histo_down_1_1) { WAE_Trend_1 = "UP"; x = 866; color_indic = Lime; UP_105 = 1; DOWN_105 = 0; }
   if (wae_histo_up_1_0 < wae_histo_up_1_1 || wae_histo_down_1_0 > wae_histo_down_1_1) { WAE_Trend_1 = "DOWN"; x = 856; color_indic = Red; UP_105 = 0; DOWN_105 = 1; }
   ObjectCreate("Trend_WAE_1", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_WAE_1",WAE_Trend_1,7, "Verdana", color_indic);
   ObjectSet("Trend_WAE_1", OBJPROP_CORNER, 0);
   ObjectSet("Trend_WAE_1", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_WAE_1", OBJPROP_YDISTANCE, 22+add_y);
   }
   
   if( display_M5 == true )
   {
   double wae_histo_up_5_0 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_5);
   double wae_histo_up_5_1 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_5+1);
   double wae_histo_down_5_0 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_5);
   double wae_histo_down_5_1 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_5+1);
   
   if (wae_histo_up_5_0 > wae_histo_up_5_1 || wae_histo_down_5_0 < wae_histo_down_5_1) { WAE_Trend_5 = "UP"; x = 866; color_indic = Lime; UP_106 = 1; DOWN_106 = 0; }
   if (wae_histo_up_5_0 < wae_histo_up_5_1 || wae_histo_down_5_0 > wae_histo_down_5_1) { WAE_Trend_5 = "DOWN"; x = 856; color_indic = Red; UP_106 = 0; DOWN_106 = 1; }
   ObjectCreate("Trend_WAE_5", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_WAE_5",WAE_Trend_5,7, "Verdana", color_indic);
   ObjectSet("Trend_WAE_5", OBJPROP_CORNER, 0);
   ObjectSet("Trend_WAE_5", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_WAE_5", OBJPROP_YDISTANCE, 37+add_y);
   }
   
   if( display_M15 == true )
   {
   double wae_histo_up_15_0 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_15);
   double wae_histo_up_15_1 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_15+1);
   double wae_histo_down_15_0 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_15);
   double wae_histo_down_15_1 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_15+1);
   
   if (wae_histo_up_15_0 > wae_histo_up_15_1 || wae_histo_down_15_0 < wae_histo_down_15_1) { WAE_Trend_15 = "UP"; x = 866; color_indic = Lime; UP_107 = 1; DOWN_107 = 0; }
   if (wae_histo_up_15_0 < wae_histo_up_15_1 || wae_histo_down_15_0 > wae_histo_down_15_1) { WAE_Trend_15 = "DOWN"; x = 856; color_indic = Red; UP_107 = 0; DOWN_107 = 1; }
   ObjectCreate("Trend_WAE_15", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_WAE_15",WAE_Trend_15,7, "Verdana", color_indic);
   ObjectSet("Trend_WAE_15", OBJPROP_CORNER, 0);
   ObjectSet("Trend_WAE_15", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_WAE_15", OBJPROP_YDISTANCE, 52+add_y);
   }
   
   if( display_M30 == true )
   {
   double wae_histo_up_30_0 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_30);
   double wae_histo_up_30_1 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_30+1);
   double wae_histo_down_30_0 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_30);
   double wae_histo_down_30_1 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_30+1);
   
   if (wae_histo_up_30_0 > wae_histo_up_30_1 || wae_histo_down_30_0 < wae_histo_down_30_1) { WAE_Trend_30 = "UP"; x = 866; color_indic = Lime; UP_108 = 1; DOWN_108 = 0; }
   if (wae_histo_up_30_0 < wae_histo_up_30_1 || wae_histo_down_30_0 > wae_histo_down_30_1) { WAE_Trend_30 = "DOWN"; x = 856; color_indic = Red; UP_108 = 0; DOWN_108 = 1; }
   ObjectCreate("Trend_WAE_30", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_WAE_30",WAE_Trend_30,7, "Verdana", color_indic);
   ObjectSet("Trend_WAE_30", OBJPROP_CORNER, 0);
   ObjectSet("Trend_WAE_30", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_WAE_30", OBJPROP_YDISTANCE, 67+add_y);
   }
   
   if( display_H1 == true )
   {
   double wae_histo_up_60_0 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_60);
   double wae_histo_up_60_1 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_60+1);
   double wae_histo_down_60_0 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_60);
   double wae_histo_down_60_1 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_60+1);
   
   if (wae_histo_up_60_0 > wae_histo_up_60_1 || wae_histo_down_60_0 < wae_histo_down_60_1) { WAE_Trend_60 = "UP"; x = 866; color_indic = Lime; UP_109 = 1; DOWN_109 = 0; }
   if (wae_histo_up_60_0 < wae_histo_up_60_1 || wae_histo_down_60_0 > wae_histo_down_60_1) { WAE_Trend_60 = "DOWN"; x = 856; color_indic = Red; UP_109 = 0; DOWN_109 = 1; }
   ObjectCreate("Trend_WAE_60", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_WAE_60",WAE_Trend_60,7, "Verdana", color_indic);
   ObjectSet("Trend_WAE_60", OBJPROP_CORNER, 0);
   ObjectSet("Trend_WAE_60", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_WAE_60", OBJPROP_YDISTANCE, 82+add_y);
   }
   
   if( display_H4 == true )
   {
   double wae_histo_up_240_0 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_240);
   double wae_histo_up_240_1 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_240+1);
   double wae_histo_down_240_0 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_240);
   double wae_histo_down_240_1 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_240+1);
   
   if (wae_histo_up_240_0 > wae_histo_up_240_1 || wae_histo_down_240_0 < wae_histo_down_240_1) { WAE_Trend_240 = "UP"; x = 866; color_indic = Lime; UP_110 = 1; DOWN_110 = 0; }
   if (wae_histo_up_240_0 < wae_histo_up_240_1 || wae_histo_down_240_0 > wae_histo_down_240_1) { WAE_Trend_240 = "DOWN"; x = 856; color_indic = Red; UP_110 = 0; DOWN_110 = 1; }
   ObjectCreate("Trend_WAE_240", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_WAE_240",WAE_Trend_240,7, "Verdana", color_indic);
   ObjectSet("Trend_WAE_240", OBJPROP_CORNER, 0);
   ObjectSet("Trend_WAE_240", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_WAE_240", OBJPROP_YDISTANCE, 97+add_y);
   }
   
   if( display_D1 == true )
   {
   double wae_histo_up_1440_0 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_1440);
   double wae_histo_up_1440_1 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,shift_1440+1);
   double wae_histo_down_1440_0 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_1440);
   double wae_histo_down_1440_1 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,shift_1440+1);
   
   if (wae_histo_up_1440_0 > wae_histo_up_1440_1 || wae_histo_down_1440_0 < wae_histo_down_1440_1) { WAE_Trend_1440 = "UP"; x = 866; color_indic = Lime; UP_111 = 1; DOWN_111 = 0; }
   if (wae_histo_up_1440_0 < wae_histo_up_1440_1 || wae_histo_down_1440_0 > wae_histo_down_1440_1) { WAE_Trend_1440 = "DOWN"; x = 856; color_indic = Red; UP_111 = 0; DOWN_111 = 1; }
   ObjectCreate("Trend_WAE_1440", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_WAE_1440",WAE_Trend_1440,7, "Verdana", color_indic);
   ObjectSet("Trend_WAE_1440", OBJPROP_CORNER, 0);
   ObjectSet("Trend_WAE_1440", OBJPROP_XDISTANCE, x+add_x);
   ObjectSet("Trend_WAE_1440", OBJPROP_YDISTANCE, 112+add_y);
   }
   }
   
//---- Count Indicators

   double Indy_count_2 = UP_65 + UP_73 + UP_81 + UP_89 + UP_97 + UP_105
                       + UP_66 + UP_74 + UP_82 + UP_90 + UP_98 + UP_106
                       + UP_67 + UP_75 + UP_83 + UP_91 + UP_99 + UP_107
                       + UP_68 + UP_76 + UP_84 + UP_92 + UP_100 + UP_108
                       + UP_69 + UP_77 + UP_85 + UP_93 + UP_101 + UP_109
                       + UP_70 + UP_78 + UP_86 + UP_94 + UP_102 + UP_110
                       + UP_71 + UP_79 + UP_87 + UP_95 + UP_103 + UP_111
                       + DOWN_65 + DOWN_73 + DOWN_81 + DOWN_89 + DOWN_97 + DOWN_105
                       + DOWN_66 + DOWN_74 + DOWN_82 + DOWN_90 + DOWN_98 + DOWN_106
                       + DOWN_67 + DOWN_75 + DOWN_83 + DOWN_91 + DOWN_99 + DOWN_107
                       + DOWN_68 + DOWN_76 + DOWN_84 + DOWN_92 + DOWN_100 + DOWN_108
                       + DOWN_69 + DOWN_77 + DOWN_85 + DOWN_93 + DOWN_101 + DOWN_109
                       + DOWN_70 + DOWN_78 + DOWN_86 + DOWN_94 + DOWN_102 + DOWN_110
                       + DOWN_71 + DOWN_79 + DOWN_87 + DOWN_95 + DOWN_103 + DOWN_111;
   
//---- Calculation of the trend. Let's give high TFs more "force"
   
   double Trend_UP_1 = iCustom(NULL,0,"FerruFx_Multi_info+_v1.2","=== If true, displayed on the chart ===",display_on_chart,"=== Trade Info ===",AccountMini,LeverageToTrade,PipValue,"=== Trend calculation and display ===",display_fast_MA,display_medium_MA,display_slow_MA,display_CCI,display_MACD,display_ADX,display_BULLS,display_BEARS,"=== If display false, set coef to 0 ===","3 TF true, SUM of their coef must be 3",display_M1,coef_m1,display_M5,coef_m5,display_M15,coef_m15,display_M30,coef_m30,display_H1,coef_H1,display_H4,coef_H4,display_D1,coef_D1,"=== Format: 2007.05.07 00:00 ===",look_time_shift,shift_indicators,test,0,0);
   double Trend_DOWN_1 = iCustom(NULL,0,"FerruFx_Multi_info+_v1.2","=== If true, displayed on the chart ===",display_on_chart,"=== Trade Info ===",AccountMini,LeverageToTrade,PipValue,"=== Trend calculation and display ===",display_fast_MA,display_medium_MA,display_slow_MA,display_CCI,display_MACD,display_ADX,display_BULLS,display_BEARS,"=== If display false, set coef to 0 ===","3 TF true, SUM of their coef must be 3",display_M1,coef_m1,display_M5,coef_m5,display_M15,coef_m15,display_M30,coef_m30,display_H1,coef_H1,display_H4,coef_H4,display_D1,coef_D1,"=== Format: 2007.05.07 00:00 ===",look_time_shift,shift_indicators,test,1,0);
   double Indy_count_1 = iCustom(NULL,0,"FerruFx_Multi_info+_v1.2","=== If true, displayed on the chart ===",display_on_chart,"=== Trade Info ===",AccountMini,LeverageToTrade,PipValue,"=== Trend calculation and display ===",display_fast_MA,display_medium_MA,display_slow_MA,display_CCI,display_MACD,display_ADX,display_BULLS,display_BEARS,"=== If display false, set coef to 0 ===","3 TF true, SUM of their coef must be 3",display_M1,coef_m1,display_M5,coef_m5,display_M15,coef_m15,display_M30,coef_m30,display_H1,coef_H1,display_H4,coef_H4,display_D1,coef_D1,"=== Format: 2007.05.07 00:00 ===",look_time_shift,shift_indicators,test,2,0);
       
   double UP_m1 = (UP_65 + UP_73 + UP_81 + UP_89 + UP_97 + UP_105) * coef_m1;
   double UP_m5 = (UP_66 + UP_74 + UP_82 + UP_90 + UP_98 + UP_106) * coef_m5;
   double UP_m15 = (UP_67 + UP_75 + UP_83 + UP_91 + UP_99 + UP_107) * coef_m15;
   double UP_m30 = (UP_68 + UP_76 + UP_84 + UP_92 + UP_100 + UP_108) * coef_m30;
   double UP_H1 = (UP_69 + UP_77 + UP_85 + UP_93 + UP_101 + UP_109) * coef_H1;
   double UP_H4 = (UP_70 + UP_78 + UP_86 + UP_94 + UP_102 + UP_110) * coef_H4;
   double UP_D1 = (UP_71 + UP_79 + UP_87 + UP_95 + UP_103 + UP_111) * coef_D1;
   
   
   double Trend_UP_2 = UP_m1 + UP_m5 + UP_m15 + UP_m30 + UP_H1 + UP_H4 + UP_D1;
       
   double DOWN_m1 = (DOWN_65 + DOWN_73 + DOWN_81 + DOWN_89 + DOWN_97 + DOWN_105) * coef_m1;
   double DOWN_m5 = (DOWN_66 + DOWN_74 + DOWN_82 + DOWN_90 + DOWN_98 + DOWN_106) * coef_m5;
   double DOWN_m15 = (DOWN_67 + DOWN_75 + DOWN_83 + DOWN_91 + DOWN_99 + DOWN_107) * coef_m15;
   double DOWN_m30 = (DOWN_68 + DOWN_76 + DOWN_84 + DOWN_92 + DOWN_100 + DOWN_108) * coef_m30;
   double DOWN_H1 = (DOWN_69 + DOWN_77 + DOWN_85 + DOWN_93 + DOWN_101 + DOWN_109) * coef_H1;
   double DOWN_H4 = (DOWN_70 + DOWN_78 + DOWN_86 + DOWN_94 + DOWN_102 + DOWN_110) * coef_H4;
   double DOWN_D1 = (DOWN_71 + DOWN_79 + DOWN_87 + DOWN_95 + DOWN_103 + DOWN_111) * coef_D1;
                               
   double Trend_DOWN_2 = DOWN_m1 + DOWN_m5 + DOWN_m15 + DOWN_m30 + DOWN_H1 + DOWN_H4 + DOWN_D1;
   
   double Total_Indy_count = Indy_count_1 + Indy_count_2;
   
   string Trend_UP = DoubleToStr((((Trend_UP_1 + Trend_UP_2)/Total_Indy_count)*100),0);
   string Trend_DOWN = DoubleToStr((100 - StrToDouble(Trend_UP)),0);
   

//---- Buffers for EA
   
   TrendUPBuffer[0] = ((Trend_UP_1 + Trend_UP_2)/Total_Indy_count)*100;
   TrendDOWNBuffer[0] = 100 - (((Trend_UP_1 + Trend_UP_2)/Total_Indy_count)*100);

//----

   
   ObjectCreate("Trend_UP", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_UP","+   Trend   +",9, "Verdana", DarkOrange);
   ObjectSet("Trend_UP", OBJPROP_CORNER, 0);
   ObjectSet("Trend_UP", OBJPROP_XDISTANCE, 908+add_x);
   ObjectSet("Trend_UP", OBJPROP_YDISTANCE, -5+add_y);
   
   ObjectCreate("line9", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("line9","----------------",8, "Verdana", DarkOrange);
   ObjectSet("line9", OBJPROP_CORNER, 0);
   ObjectSet("line9", OBJPROP_XDISTANCE, 907+add_x);
   ObjectSet("line9", OBJPROP_YDISTANCE, 6+add_y);
   
   ObjectCreate("Trend_UP_text", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_UP_text","UP",9, "Verdana", Lime);
   ObjectSet("Trend_UP_text", OBJPROP_CORNER, 0);
   ObjectSet("Trend_UP_text", OBJPROP_XDISTANCE, 909+add_x);
   ObjectSet("Trend_UP_text", OBJPROP_YDISTANCE, 20+add_y);
   
   ObjectCreate("Trend_UP_value", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_UP_value",Trend_UP+"%",9, "Verdana", PeachPuff);
   ObjectSet("Trend_UP_value", OBJPROP_CORNER, 0);
   ObjectSet("Trend_UP_value", OBJPROP_XDISTANCE, 955+add_x);
   ObjectSet("Trend_UP_value", OBJPROP_YDISTANCE, 20+add_y);
   
   ObjectCreate("Trend_DOWN_text", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DOWN_text","DOWN",9, "Verdana", Red);
   ObjectSet("Trend_DOWN_text", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DOWN_text", OBJPROP_XDISTANCE, 909+add_x);
   ObjectSet("Trend_DOWN_text", OBJPROP_YDISTANCE, 40+add_y);
   
   ObjectCreate("Trend_DOWN_value", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_DOWN_value",Trend_DOWN+"%",9, "Verdana", PeachPuff);
   ObjectSet("Trend_DOWN_value", OBJPROP_CORNER, 0);
   ObjectSet("Trend_DOWN_value", OBJPROP_XDISTANCE, 955+add_x);
   ObjectSet("Trend_DOWN_value", OBJPROP_YDISTANCE, 40+add_y);
   
   string trend;
   string comment;
   color coltrend;
   color colcomment;
   double xt, xc;
   
   if(StrToDouble(Trend_UP) >= TrendStrongLevel) { trend = "UP"; coltrend = Lime; xt = 935; comment = "[strong]"; xc = 921; colcomment = Lime; /* if (alert == true) { Alert(TimeToStr(TimeCurrent(),TIME_SECONDS)," Trend UP > "TrendStrongLevel"% on ",Symbol()," ", Bid); PlaySound("tick.wav"); } */ }
   else if(StrToDouble(Trend_UP) < TrendStrongLevel && StrToDouble(Trend_UP) >= 50) { trend = "UP"; coltrend = Lime; xt = 935; comment = "[weak]"; xc = 924; colcomment = Orange; }
   else if(StrToDouble(Trend_DOWN) >= TrendStrongLevel) { trend = "DOWN"; coltrend = Red; xt = 918; comment = "[strong]"; xc = 921; colcomment = Red; /* if (alert == true) { Alert(TimeToStr(TimeCurrent(),TIME_SECONDS)," Trend DOWN > "TrendStrongLevel"% on ",Symbol()," ", Bid); PlaySound("tick.wav"); } */ }
   else if(StrToDouble(Trend_DOWN) < TrendStrongLevel && StrToDouble(Trend_DOWN) > 50) { trend = "DOWN"; coltrend = Red; xt = 918; comment = "[weak]"; xc = 924; colcomment = Orange; }
   
   ObjectCreate("line10", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("line10","----------------",8, "Verdana", coltrend);
   ObjectSet("line10", OBJPROP_CORNER, 0);
   ObjectSet("line10", OBJPROP_XDISTANCE, 907+add_x);
   ObjectSet("line10", OBJPROP_YDISTANCE, 55+add_y);
   
   ObjectCreate("line12", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("line12","----------------",8, "Verdana", coltrend);
   ObjectSet("line12", OBJPROP_CORNER, 0);
   ObjectSet("line12", OBJPROP_XDISTANCE, 907+add_x);
   ObjectSet("line12", OBJPROP_YDISTANCE, 58+add_y);
   
   ObjectCreate("Trend", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend",trend,18, "Impact", coltrend);
   ObjectSet("Trend", OBJPROP_CORNER, 0);
   ObjectSet("Trend", OBJPROP_XDISTANCE, xt+add_x);
   ObjectSet("Trend", OBJPROP_YDISTANCE, 70+add_y);
   
   ObjectCreate("Trend_comment", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("Trend_comment",comment,10, "Verdana", colcomment);
   ObjectSet("Trend_comment", OBJPROP_CORNER, 0);
   ObjectSet("Trend_comment", OBJPROP_XDISTANCE, xc+add_x);
   ObjectSet("Trend_comment", OBJPROP_YDISTANCE, 100+add_y);
   
   ObjectCreate("line13", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("line13","----------------",8, "Verdana", coltrend);
   ObjectSet("line13", OBJPROP_CORNER, 0);
   ObjectSet("line13", OBJPROP_XDISTANCE, 907+add_x);
   ObjectSet("line13", OBJPROP_YDISTANCE, 117+add_y);
   
   ObjectCreate("line11", OBJ_LABEL, WindowFind("FerruFx_Multi_info+"), 0, 0);
   ObjectSetText("line11","----------------",8, "Verdana", coltrend);
   ObjectSet("line11", OBJPROP_CORNER, 0);
   ObjectSet("line11", OBJPROP_XDISTANCE, 907+add_x);
   ObjectSet("line11", OBJPROP_YDISTANCE, 120+add_y);
   
   
// DAILY PIVOTS AND RANGE
   
//---- Get new daily prices

   ArrayCopyRates(rates_d1, Symbol(), PERIOD_D1);
   
//---- modifs ibfx
   int offset = 0;
   if(DayOfWeek()==1) offset=1;
//----

   double day50_high = rates_d1[50+offset][3];
   double day50_low = rates_d1[50+offset][2]; 
   double day49_high = rates_d1[49+offset][3];
   double day49_low = rates_d1[49+offset][2]; 
   double day48_high = rates_d1[48+offset][3];
   double day48_low = rates_d1[48+offset][2]; 
   double day47_high = rates_d1[47+offset][3];
   double day47_low = rates_d1[47+offset][2]; 
   double day46_high = rates_d1[46+offset][3];
   double day46_low = rates_d1[46+offset][2]; 
   double day45_high = rates_d1[45+offset][3];
   double day45_low = rates_d1[45+offset][2]; 
   double day44_high = rates_d1[44+offset][3];
   double day44_low = rates_d1[44+offset][2]; 
   double day43_high = rates_d1[43+offset][3];
   double day43_low = rates_d1[43+offset][2]; 
   double day42_high = rates_d1[42+offset][3];
   double day42_low = rates_d1[42+offset][2]; 
   double day41_high = rates_d1[41+offset][3];
   double day41_low = rates_d1[41+offset][2]; 
   double day40_high = rates_d1[40+offset][3];
   double day40_low = rates_d1[40+offset][2]; 
   double day39_high = rates_d1[39+offset][3];
   double day39_low = rates_d1[39+offset][2]; 
   double day38_high = rates_d1[38+offset][3];
   double day38_low = rates_d1[38+offset][2]; 
   double day37_high = rates_d1[37+offset][3];
   double day37_low = rates_d1[37+offset][2]; 
   double day36_high = rates_d1[36+offset][3];
   double day36_low = rates_d1[36+offset][2]; 
   double day35_high = rates_d1[35+offset][3];
   double day35_low = rates_d1[35+offset][2]; 
   double day34_high = rates_d1[34+offset][3];
   double day34_low = rates_d1[34+offset][2]; 
   double day33_high = rates_d1[33+offset][3];
   double day33_low = rates_d1[33+offset][2]; 
   double day32_high = rates_d1[32+offset][3];
   double day32_low = rates_d1[32+offset][2]; 
   double day31_high = rates_d1[31+offset][3];
   double day31_low = rates_d1[31+offset][2]; 
   double day30_high = rates_d1[30+offset][3];
   double day30_low = rates_d1[30+offset][2]; 
   double day29_high = rates_d1[29+offset][3];
   double day29_low = rates_d1[29+offset][2]; 
   double day28_high = rates_d1[28+offset][3];
   double day28_low = rates_d1[28+offset][2]; 
   double day27_high = rates_d1[27+offset][3];
   double day27_low = rates_d1[27+offset][2]; 
   double day26_high = rates_d1[26+offset][3];
   double day26_low = rates_d1[26+offset][2]; 
   double day25_high = rates_d1[25+offset][3];
   double day25_low = rates_d1[25+offset][2]; 
   double day24_high = rates_d1[24+offset][3];
   double day24_low = rates_d1[24+offset][2]; 
   double day23_high = rates_d1[23+offset][3];
   double day23_low = rates_d1[23+offset][2]; 
   double day22_high = rates_d1[22+offset][3];
   double day22_low = rates_d1[22+offset][2]; 
   double day21_high = rates_d1[21+offset][3];
   double day21_low = rates_d1[21+offset][2]; 
   double day20_high = rates_d1[20+offset][3];
   double day20_low = rates_d1[20+offset][2]; 
   double day19_high = rates_d1[19+offset][3];
   double day19_low = rates_d1[19+offset][2]; 
   double day18_high = rates_d1[18+offset][3];
   double day18_low = rates_d1[18+offset][2]; 
   double day17_high = rates_d1[17+offset][3];
   double day17_low = rates_d1[17+offset][2]; 
   double day16_high = rates_d1[16+offset][3];
   double day16_low = rates_d1[16+offset][2]; 
   double day15_high = rates_d1[15+offset][3];
   double day15_low = rates_d1[15+offset][2]; 
   double day14_high = rates_d1[14+offset][3];
   double day14_low = rates_d1[14+offset][2]; 
   double day13_high = rates_d1[13+offset][3];
   double day13_low = rates_d1[13+offset][2]; 
   double day12_high = rates_d1[12+offset][3];
   double day12_low = rates_d1[12+offset][2]; 
   double day11_high = rates_d1[11+offset][3];
   double day11_low = rates_d1[11+offset][2]; 
   double day10_high = rates_d1[10+offset][3];
   double day10_low = rates_d1[10+offset][2]; 
   double day9_high = rates_d1[9+offset][3];
   double day9_low = rates_d1[9+offset][2];
   double day8_high = rates_d1[8+offset][3];
   double day8_low = rates_d1[8+offset][2]; 
   double day7_high = rates_d1[7+offset][3];
   double day7_low = rates_d1[7+offset][2]; 
   double day6_high = rates_d1[6+offset][3];
   double day6_low = rates_d1[6+offset][2]; 
   double day5_high = rates_d1[5+offset][3];
   double day5_low = rates_d1[5+offset][2]; 
   double day4_high = rates_d1[4+offset][3];
   double day4_low = rates_d1[4+offset][2]; 
   double day3_high = rates_d1[3+offset][3];
   double day3_low = rates_d1[3+offset][2]; 
   double day2_high = rates_d1[2+offset][3];
   double day2_low = rates_d1[2+offset][2]; 
   double yesterday_high = rates_d1[1+offset][3];
   double yesterday_low = rates_d1[1+offset][2];
   double yesterday_close = rates_d1[1+offset][4];
   double day_high = rates_d1[0][3];
   double day_low = rates_d1[0][2];
   
/*
   int i=0;

   ArrayCopyRates(rates_h1, Symbol(), PERIOD_H1);
   for (i=0;i<=25;i++)
   {
    if (TimeMinute(rates_h1[i][0])==0 && (TimeHour(rates_h1[i][0])-TimeZone)==0)
    {
     yesterday_close = rates_h1[i+1][4];      
     yesterday_open = rates_h1[i+24][1];
     today_open = rates_h1[i][1];      
     break;
    }
   }
*/

//---- Calculate Pivots et range

   double D = (day_high - day_low);
   double Q = (yesterday_high - yesterday_low);
   double Q2 = (day2_high - day2_low);
   double Q3 = (day3_high - day3_low);
   double Q4 = (day4_high - day4_low);
   double Q5 = (day5_high - day5_low);
   double Q6 = (day6_high - day6_low);
   double Q7 = (day7_high - day7_low);
   double Q8 = (day8_high - day8_low);
   double Q9 = (day9_high - day9_low);
   double Q10 = (day10_high - day10_low);
   double Q11 = (day11_high - day11_low);
   double Q12 = (day12_high - day12_low);
   double Q13 = (day13_high - day13_low);
   double Q14 = (day14_high - day14_low);
   double Q15 = (day15_high - day15_low);
   double Q16 = (day16_high - day16_low);
   double Q17 = (day17_high - day17_low);
   double Q18 = (day18_high - day18_low);
   double Q19 = (day19_high - day19_low);
   double Q20 = (day20_high - day20_low);
   double Q21 = (day21_high - day21_low);
   double Q22 = (day22_high - day22_low);
   double Q23 = (day23_high - day23_low);
   double Q24 = (day24_high - day24_low);
   double Q25 = (day25_high - day25_low);
   double Q26 = (day26_high - day26_low);
   double Q27 = (day27_high - day27_low);
   double Q28 = (day28_high - day28_low);
   double Q29 = (day29_high - day29_low);
   double Q30 = (day30_high - day30_low);
   double Q31 = (day31_high - day31_low);
   double Q32 = (day32_high - day32_low);
   double Q33 = (day33_high - day33_low);
   double Q34 = (day34_high - day34_low);
   double Q35 = (day35_high - day35_low);
   double Q36 = (day36_high - day36_low);
   double Q37 = (day37_high - day37_low);
   double Q38 = (day38_high - day38_low);
   double Q39 = (day39_high - day39_low);
   double Q40 = (day40_high - day40_low);
   double Q41 = (day41_high - day41_low);
   double Q42 = (day42_high - day42_low);
   double Q43 = (day43_high - day43_low);
   double Q44 = (day44_high - day44_low);
   double Q45 = (day45_high - day45_low);
   double Q46 = (day46_high - day46_low);
   double Q47 = (day47_high - day47_low);
   double Q48 = (day48_high - day48_low);
   double Q49 = (day49_high - day49_low);
   double Q50 = (day50_high - day50_low);
   double P = (yesterday_high + yesterday_low + yesterday_close) / 3;
   double R1 = (2*P)-yesterday_low;
   double S1 = (2*P)-yesterday_high;
   double R2 = P+(R1 - S1);
   double S2 = P-(R1 - S1);
	double R3 = (2*P)+(yesterday_high-(2*yesterday_low));
	double S3 = (2*P)-((2* yesterday_high)-yesterday_low);
	
	
	
	
	
	int Precision, dig;
{
   if( StringFind( Symbol(), "JPY", 0) != -1 ) { Precision = 100; dig = 2;}
   else                                        { Precision = 10000; dig = 4; }
} 
	double D0 = D * Precision;
	double Q0 = Q * Precision;
	double Q5_av = ((Q + Q2 + Q3 + Q4 + Q5) / 5) * Precision;
	double Q10_av = ((Q + Q2 + Q3 + Q4 + Q5 + Q6 + Q7 + Q8 + Q9 + Q10) / 10) * Precision;
	double Q20_av = ((Q + Q2 + Q3 + Q4 + Q5 + Q6 + Q7 + Q8 + Q9
	                 + Q10 + Q11 + Q12 + Q13 + Q14 + Q15 + Q16 + Q17 + Q18 + Q19 + Q20) / 20) * Precision;
	/*
	double Q30_av = ((Q + Q2 + Q3 + Q4 + Q5 + Q6 + Q7 + Q8 + Q9
	                 + Q10 + Q11 + Q12 + Q13 + Q14 + Q15 + Q16 + Q17 + Q18 + Q19
	                 + Q20 + Q21 + Q22 + Q23 + Q24 + Q25 + Q26 + Q27 + Q28 + Q29 + Q30) / 30) * Precision;
	double Q40_av = ((Q + Q2 + Q3 + Q4 + Q5 + Q6 + Q7 + Q8 + Q9
	                 + Q10 + Q11 + Q12 + Q13 + Q14 + Q15 + Q16 + Q17 + Q18 + Q19
	                 + Q20 + Q21 + Q22 + Q23 + Q24 + Q25 + Q26 + Q27 + Q28 + Q29
	                 + Q30 + Q31 + Q32 + Q33 + Q34 + Q35 + Q36 + Q37 + Q38 + Q39 + Q40) / 40) * Precision;
	*/
	double Q50_av = ((Q + Q2 + Q3 + Q4 + Q5 + Q6 + Q7 + Q8 + Q9
	                 + Q10 + Q11 + Q12 + Q13 + Q14 + Q15 + Q16 + Q17 + Q18 + Q19
	                 + Q20 + Q21 + Q22 + Q23 + Q24 + Q25 + Q26 + Q27 + Q28 + Q29
	                 + Q30 + Q31 + Q32 + Q33 + Q34 + Q35 + Q36 + Q37 + Q38 + Q39
	                 + Q40 + Q41 + Q42 + Q43 + Q44 + Q45 + Q46 + Q47 + Q48 + Q49 + Q50) / 50) * Precision;
	
	double average_range = (Q0 + Q5_av + Q10_av + Q20_av + Q50_av) / 5;
	
	
//---- Set Pivots labels

   int WindowToUse;
   int Corner_line, Xdist_line;
   int Corner_text, Corner_value, Xdist_text, Xdist_value;
   int Ydist_line5;
   int Corner_pivots, Xdist_pivots, Ydist_pivots;
   int Ydist_R3, Ydist_R2, Ydist_R1, Ydist_PV, Ydist_S1, Ydist_S2, Ydist_S3;
  
   if(display_on_chart == true)
   {   
    WindowToUse =  0;
    Corner_line = 1;
    Corner_text = 1; Corner_value = 1;
    Xdist_line = 21; Xdist_text = 93; Xdist_value = 23;
    Ydist_line5 = 179;
    Corner_pivots = 1; Xdist_pivots = 21; Ydist_pivots = 168;
    Ydist_R3 = 193; Ydist_R2 = 208; Ydist_R1 = 223; Ydist_PV = 238; Ydist_S1 = 253; Ydist_S2 = 268; Ydist_S3 = 283;
   }
   else
   {
    WindowToUse = WindowFind("FerruFx_Multi_info+");
    Corner_line = 0; Corner_text = 0; Corner_value = 0;
    Xdist_line = 1010; Xdist_text = 1013; Xdist_value = 1050;
    Ydist_line5 = 16;
    Corner_pivots = 0; Xdist_pivots = 1010; Ydist_pivots = 5;
    Ydist_R3 = 30; Ydist_R2 = 45; Ydist_R1 = 60; Ydist_PV = 75; Ydist_S1 = 90; Ydist_S2 = 105; Ydist_S3 = 120;
   }

   ObjectCreate("pivots", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("pivots","+Daily Pivots+",9, "Verdana", color_pivots_1);
   ObjectSet("pivots", OBJPROP_CORNER, Corner_pivots);
   ObjectSet("pivots", OBJPROP_XDISTANCE, Xdist_pivots);
   ObjectSet("pivots", OBJPROP_YDISTANCE, Ydist_pivots);
   
   ObjectCreate("line5", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("line5","------------------",7, "Verdana", color_pivots_1);
   ObjectSet("line5", OBJPROP_CORNER, Corner_line);
   ObjectSet("line5", OBJPROP_XDISTANCE, Xdist_line);
   ObjectSet("line5", OBJPROP_YDISTANCE, Ydist_line5);
   
   ObjectCreate("R3_Label", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R3_Label","R3",9, "Verdana", Gainsboro);
   ObjectSet("R3_Label", OBJPROP_CORNER, Corner_text);
   ObjectSet("R3_Label", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("R3_Label", OBJPROP_YDISTANCE, Ydist_R3);
   
   ObjectCreate("R3_Value", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R3_Value"," "+DoubleToStr(R3,dig),9, "Verdana", Gainsboro);
   ObjectSet("R3_Value", OBJPROP_CORNER, Corner_value);
   ObjectSet("R3_Value", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("R3_Value", OBJPROP_YDISTANCE, Ydist_R3);
   
   ObjectCreate("R2_Label", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R2_Label","R2",9, "Verdana", Silver);
   ObjectSet("R2_Label", OBJPROP_CORNER, Corner_text);
   ObjectSet("R2_Label", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("R2_Label", OBJPROP_YDISTANCE, Ydist_R2);
   
   ObjectCreate("R2_Value", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R2_Value"," "+DoubleToStr(R2,dig),9, "Verdana", Silver);
   ObjectSet("R2_Value", OBJPROP_CORNER, Corner_value);
   ObjectSet("R2_Value", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("R2_Value", OBJPROP_YDISTANCE, Ydist_R2);
   
   ObjectCreate("R1_Label", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R1_Label","R1",9, "Verdana", DarkGray);
   ObjectSet("R1_Label", OBJPROP_CORNER, Corner_text);
   ObjectSet("R1_Label", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("R1_Label", OBJPROP_YDISTANCE, Ydist_R1);
   
   ObjectCreate("R1_Value", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R1_Value"," "+DoubleToStr(R1,dig),9, "Verdana", DarkGray);
   ObjectSet("R1_Value", OBJPROP_CORNER, Corner_value);
   ObjectSet("R1_Value", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("R1_Value", OBJPROP_YDISTANCE, Ydist_R1);
   
   ObjectCreate("Pivot_Label", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("Pivot_Label","PV",9, "Verdana", Gray);
   ObjectSet("Pivot_Label", OBJPROP_CORNER, Corner_text);
   ObjectSet("Pivot_Label", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("Pivot_Label", OBJPROP_YDISTANCE, Ydist_PV);
   
   ObjectCreate("Pivot_Value", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("Pivot_Value"," "+DoubleToStr(P,dig),9, "Verdana", Gray);
   ObjectSet("Pivot_Value", OBJPROP_CORNER, Corner_value);
   ObjectSet("Pivot_Value", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("Pivot_Value", OBJPROP_YDISTANCE, Ydist_PV);
   
   ObjectCreate("S1_Label", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("S1_Label","S1",9, "Verdana", DarkGray);
   ObjectSet("S1_Label", OBJPROP_CORNER, Corner_text);
   ObjectSet("S1_Label", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("S1_Label", OBJPROP_YDISTANCE, Ydist_S1);
   
   ObjectCreate("S1_Value", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("S1_Value"," "+DoubleToStr(S1,dig),9, "Verdana", DarkGray);
   ObjectSet("S1_Value", OBJPROP_CORNER, Corner_value);
   ObjectSet("S1_Value", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("S1_Value", OBJPROP_YDISTANCE, Ydist_S1);
   
   ObjectCreate("S2_Label", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("S2_Label","S2",9, "Verdana", Silver);
   ObjectSet("S2_Label", OBJPROP_CORNER, Corner_text);
   ObjectSet("S2_Label", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("S2_Label", OBJPROP_YDISTANCE, Ydist_S2);
   
   ObjectCreate("S2_Value", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("S2_Value"," "+DoubleToStr(S2,dig),9, "Verdana", Silver);
   ObjectSet("S2_Value", OBJPROP_CORNER, Corner_value);
   ObjectSet("S2_Value", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("S2_Value", OBJPROP_YDISTANCE, Ydist_S2);
   
   ObjectCreate("S3_Label", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("S3_Label","S3",9, "Verdana", Gainsboro);
   ObjectSet("S3_Label", OBJPROP_CORNER, Corner_text);
   ObjectSet("S3_Label", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("S3_Label", OBJPROP_YDISTANCE, Ydist_S3);
   
   ObjectCreate("S3_Value", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("S3_Value"," "+DoubleToStr(S3,dig),9, "Verdana", Gainsboro);
   ObjectSet("S3_Value", OBJPROP_CORNER, Corner_value);
   ObjectSet("S3_Value", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("S3_Value", OBJPROP_YDISTANCE, Ydist_S3);
   
   
   
// DAILY RANGE

   int Ydist_line6, Ydist_line7, Ydist_line8;
   int Corner_range, Xdist_range, Ydist_range;
   int Ydist_today, Ydist_yesterday, Ydist_5, Ydist_10, Ydist_20, Ydist_50;
   int Ydist_average;
  
   if(display_on_chart == true)
   {   
    WindowToUse =  0;
    Corner_line = 1;
    Corner_text = 1; Corner_value = 1;
    Xdist_line = 21; Xdist_text = 55; Xdist_value = 23;
    Ydist_line6 = 314; Ydist_line7 = 415; Ydist_line8 = 430;
    Corner_range = 1; Xdist_range = 21; Ydist_range = 303;
    Ydist_today = 328; Ydist_yesterday = 343; Ydist_5 = 358; Ydist_10 = 373; Ydist_20 = 388; Ydist_50 = 403; Ydist_average = 421;
   }
   else
   {
    WindowToUse = WindowFind("FerruFx_Multi_info+");
    Corner_line = 0; Corner_text = 0; Corner_value = 1;
    Xdist_line = 1121; Xdist_text = 1124; Xdist_value = 24;
    Ydist_line6 = 16; Ydist_line7 = 112; Ydist_line8 = 127;
    Corner_range = 0; Xdist_range = 1120; Ydist_range = 5;
    Ydist_today = 28; Ydist_yesterday = 42; Ydist_5 = 57; Ydist_10 = 72; Ydist_20 = 87; Ydist_50 = 102; Ydist_average = 118;
   }

   ObjectCreate("daily_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("daily_range","+Daily Range+",9, "Verdana", MediumTurquoise);
   ObjectSet("daily_range", OBJPROP_CORNER, Corner_range);
   ObjectSet("daily_range", OBJPROP_XDISTANCE, Xdist_range);
   ObjectSet("daily_range", OBJPROP_YDISTANCE, Ydist_range);
   
   ObjectCreate("line6", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("line6","------------------",8, "Verdana", MediumTurquoise);
   ObjectSet("line6", OBJPROP_CORNER, Corner_line);
   ObjectSet("line6", OBJPROP_XDISTANCE, Xdist_line);
   ObjectSet("line6", OBJPROP_YDISTANCE, Ydist_line6);
   
   ObjectCreate("today", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("today","Today",9, "Verdana", WhiteSmoke);
   ObjectSet("today", OBJPROP_CORNER, Corner_text);
   ObjectSet("today", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("today", OBJPROP_YDISTANCE, Ydist_today);
   
   ObjectCreate("today_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("today_range",DoubleToStr(D0,0),9, "Verdana", WhiteSmoke);
   ObjectSet("today_range", OBJPROP_CORNER, Corner_value);
   ObjectSet("today_range", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("today_range", OBJPROP_YDISTANCE, Ydist_today);
   
   ObjectCreate("yesterday", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("yesterday","1 Day",9, "Verdana", Gainsboro);
   ObjectSet("yesterday", OBJPROP_CORNER, Corner_text);
   ObjectSet("yesterday", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("yesterday", OBJPROP_YDISTANCE, Ydist_yesterday);
   
   ObjectCreate("yesterday_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("yesterday_range",DoubleToStr(Q0,0),9, "Verdana", Gainsboro);
   ObjectSet("yesterday_range", OBJPROP_CORNER, Corner_value);
   ObjectSet("yesterday_range", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("yesterday_range", OBJPROP_YDISTANCE, Ydist_yesterday);
   
   ObjectCreate("5_days", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("5_days","5 Days",9, "Verdana", LightGray);
   ObjectSet("5_days", OBJPROP_CORNER, Corner_text);
   ObjectSet("5_days", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("5_days", OBJPROP_YDISTANCE, Ydist_5);
   
   ObjectCreate("5_days_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("5_days_range",DoubleToStr(Q5_av,0),9, "Verdana", LightGray);
   ObjectSet("5_days_range", OBJPROP_CORNER, Corner_value);
   ObjectSet("5_days_range", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("5_days_range", OBJPROP_YDISTANCE, Ydist_5);
   
   ObjectCreate("10_days", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("10_days","10 Days",9, "Verdana", Silver);
   ObjectSet("10_days", OBJPROP_CORNER, Corner_text);
   ObjectSet("10_days", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("10_days", OBJPROP_YDISTANCE, Ydist_10);
   
   ObjectCreate("10_days_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("10_days_range",DoubleToStr(Q10_av,0),9, "Verdana", Silver);
   ObjectSet("10_days_range", OBJPROP_CORNER, Corner_value);
   ObjectSet("10_days_range", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("10_days_range", OBJPROP_YDISTANCE, Ydist_10);
   
   ObjectCreate("20_days", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("20_days","20 Days",9, "Verdana", DarkGray);
   ObjectSet("20_days", OBJPROP_CORNER, Corner_text);
   ObjectSet("20_days", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("20_days", OBJPROP_YDISTANCE, Ydist_20);
   
   ObjectCreate("20_days_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("20_days_range",DoubleToStr(Q20_av,0),9, "Verdana", DarkGray);
   ObjectSet("20_days_range", OBJPROP_CORNER, Corner_value);
   ObjectSet("20_days_range", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("20_days_range", OBJPROP_YDISTANCE, Ydist_20);
   
   ObjectCreate("50_days", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("50_days","50 Days",9, "Verdana", Gray);
   ObjectSet("50_days", OBJPROP_CORNER, Corner_text);
   ObjectSet("50_days", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("50_days", OBJPROP_YDISTANCE, Ydist_50);
   
   ObjectCreate("50_days_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("50_days_range",DoubleToStr(Q50_av,0),9, "Verdana", Gray);
   ObjectSet("50_days_range", OBJPROP_CORNER, Corner_value);
   ObjectSet("50_days_range", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("50_days_range", OBJPROP_YDISTANCE, Ydist_50);
   
   ObjectCreate("line7", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("line7","------------------",8, "Verdana", PeachPuff);
   ObjectSet("line7", OBJPROP_CORNER, Corner_line);
   ObjectSet("line7", OBJPROP_XDISTANCE, Xdist_line);
   ObjectSet("line7", OBJPROP_YDISTANCE, Ydist_line7);
   
   ObjectCreate("Average", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("Average","Average",9, "Verdana", Coral);
   ObjectSet("Average", OBJPROP_CORNER, Corner_text);
   ObjectSet("Average", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("Average", OBJPROP_YDISTANCE, Ydist_average);
   
   ObjectCreate("Average_range", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("Average_range",DoubleToStr(average_range,0),9, "Verdana", SandyBrown);
   ObjectSet("Average_range", OBJPROP_CORNER, Corner_value);
   ObjectSet("Average_range", OBJPROP_XDISTANCE, Xdist_value);
   ObjectSet("Average_range", OBJPROP_YDISTANCE, Ydist_average);
   
   ObjectCreate("line8", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("line8","------------------",8, "Verdana", PeachPuff);
   ObjectSet("line8", OBJPROP_CORNER, Corner_line);
   ObjectSet("line8", OBJPROP_XDISTANCE, Xdist_line);
   ObjectSet("line8", OBJPROP_YDISTANCE, Ydist_line8);
   
   return(0);
  }