//+------------------------------------------------------------------+
//|                         Pivot Points v6                          |
//|                      GMT code - Shimodax                         |
//|    Styling,flexibility,candle and price label - Traderathome     |
//|                       Modified by Domas4                         |
//+------------------------------------------------------------------+
#property copyright "public domain code"
#property link      "n/a"
#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color1 Green
#property indicator_color2 FireBrick
#property indicator_color3 Lime
#property indicator_color4 Red
#property indicator_color5 CLR_NONE
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 5
#property indicator_width4 5
#property indicator_width5 1
//
extern bool Indicator_On? = true;
extern bool UsedForForex? = true;
extern string GMTSettings = "GMT Settings";
extern int LocalTimeZone = 0;
extern int DestTimeZone = 0;
//
extern string AddSettings = "ADDITIONAL SETTINGS SECTION";
extern bool ShowPanel = true;
extern color PanelBackgroundColor = Black;
extern bool ShowTodayBoxColor = false;
extern color TodayBoxColor = C'28,30,32';
extern bool ShowYesterdayBoxColor = false;
extern color YesterdayBoxColor = C'30,33,36';
extern bool ShowDayCandle = true;
extern int ShiftDayCandleRight = 32;
//
extern string MainSettings = "MAIN SETTINGS SECTION";
extern string AllLinePlacement_ = "0 - Lines seperately adjustable";
extern string AllLinePlacement__ = "1 - All lines next to candle";
extern string AllLinePlacement___ = "2 - All lines horizontal";
extern int AllLinePlacement = 0;
extern bool LimitLinesToCandle = false;
extern bool AllLabelsInMiddle = false;
extern string Show1Daily2FibonacciLevels_ = "1 - Daily formula,2 - Fibonacci formula";
extern int Show1Daily2FibonacciLevels = 1;
extern string DrawLinesUntilPeriod_ = "M1, M5, M15, M30, H1, H4, D1";
extern string DrawLinesUntilPeriod = "H1";
//
extern string LabelSettings = "SETTINGS OF LINE LABELS";
extern bool ShowLevelPrices = true;
extern bool LabelsInFront = false;
extern string LabelsPosition = "0 - today,1 - right";
extern int MainLabelsPosition = 1;
extern int OpenLabelsPosition = 0;
extern string HLLabelsPosition_ = "0 - yesterday,1 - today,2 - right";
extern int HLLabelsPosition = 0;
extern bool LabelsFontsBold = false;
extern int LabelsFontSize = 8;
extern color LabelsColor = DarkGray;
//
extern string PeriodLabelSettings = "SETTINGS OF PERIOD LABELS";
extern bool ShowPeriodLabels = true;
extern bool DetailedPeriodLabels = true;
extern string PeriodLabelsPosition_ = "0 - bottom,1 - top";
extern int PeriodLabelsPosition = 1;
extern bool PeriodFontsBold = false;
extern int PeriodFontSize = 9;
extern color PeriodLabelsColor = DarkGray;
//
extern string PeriodSettings = "SETTINGS OF PERIOD LINES";
extern bool ShowTodayLine = true;
extern bool ShowYesterdayLine = false;
extern int PeriodLineStyle = 2;
extern int PeriodLineThickness = 1;
extern color PeriodLineColor = DarkSlateGray;
//
extern string LineSettings = "SETTINGS OF LINES";
extern string LinePlacement_ = "0 - Lines since start of day";
extern string LinePlacement__ = "1 - Lines next to candle";
extern string LinePlacement___ = "2 - Lines horizontal";
extern bool ShowSupportResistance = true;
extern bool ShowPivotPoint = true;
extern int SRLineStyle = 0;
extern int SRLineThickness = 1;
extern int SRLinePlacement = 0;
extern int PivotLineStyle = 0;
extern int PivotLineThickness = 1;
extern int PivotLinePlacement = 0;
extern color SupportColor = DarkGreen;
extern color ResistanceColor = C'139,0,0';
extern color PivotColor = C'114,36,150';
//
extern bool ShowMidPivots = true;
extern int MidLineStyle = 2;
extern int MidLineThickness = 1;
extern int MidLinePlacement = 0;
extern color MidColor = C'85,85,0';
//
extern bool ShowQtrPivots = false;
extern int QtrLineStyle = 2;
extern int QtrLineThickness = 1;
extern int QtrLinePlacement = 0;
extern color QtrColor = DarkSlateGray;
//
extern bool ShowCamarilla = false;
extern bool ShowWeakerCamarilla = false;
extern int CamLineStyle = 2;
extern int CamLineThickness = 1;
extern int CamLinePlacement = 0;
extern int WeakerCamLinePlacement = 0;
extern color CamColor = Teal;
//
extern bool ShowHighLow = true;
extern bool ShowOpen = false;
extern string HLhistoricLineStyle_ = "Available if LinePlacement=0";
extern int HLhistoricLineStyle = 0;
extern int HLLineStyle = 2;
extern int HLLineThickness = 1;
extern int HLLinePlacement = 0;
extern int OpenLineStyle = 2;
extern int OpenLineThickness = 1;
extern int OpenLinePlacement = 0;
extern color HLColor = DarkSlateBlue;
extern color OpenColor = C'34,90,148';
//
extern bool ShowInnerFibs = false;
extern bool ShowOuterFibs = false;
extern int FibLineStyle = 2;
extern int FibLineThickness = 1;
extern int FibLinePlacementI = 1;
extern int FibLinePlacementO = 1;
extern color FibColor = DarkSlateGray;
//
extern string SweetSpots_ = "Keep false if spread is < 1";
extern bool ShowSweetSpots = false;
extern int SweetLineStyle = 2;
extern int SweetLineThickness = 1;
extern int SweetLinePlacement = 1;
extern color SweetColor = C'130,18,130';
//
int digits, fxdigits, E;
string Yesterday, Today, Price;
double DayHigh[], DayLow[], DayOpen[], DayClose[];

//+------------------------------------------------------------------+
//| Custom indicator init and deinit function                        |
//+------------------------------------------------------------------+
int init()
    {
    if(DrawLinesUntilPeriod== "M1") {E= 1;}
    if(DrawLinesUntilPeriod== "M5") {E= 5;}
    if(DrawLinesUntilPeriod== "M15") {E= 15;}
    if(DrawLinesUntilPeriod== "M30") {E= 30;}
    if(DrawLinesUntilPeriod== "H1") {E= 60;}
    if(DrawLinesUntilPeriod== "H4") {E= 240;}
    if(DrawLinesUntilPeriod== "D1") {E= 1440;}

    if(UsedForForex?==true) {
    string sub=StringSubstr(Symbol(), 3, 3);
    if(sub == "JPY") {fxdigits = 2;} else {fxdigits = 4;}
    }
    SetIndexBuffer(0, DayHigh);
    SetIndexBuffer(1, DayLow);
    SetIndexBuffer(2, DayClose);
    SetIndexBuffer(3, DayOpen);
      if (ShowDayCandle) for (int i=0;i<4;i++)
    {
    SetIndexStyle(i,DRAW_HISTOGRAM);
    SetIndexShift(i,ShiftDayCandleRight);
    SetIndexLabel(i,"[PivotsD Day Candle]");
    }                 
    return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator de-initialization function                      |
//+------------------------------------------------------------------+
int deinit()
    {
    int obj_total= ObjectsTotal();
    for(int k= obj_total; k>=0; k--)
      {
      string name= ObjectName(k);
      if(StringSubstr(name,0,8)=="[PivotsD") {ObjectDelete(name);}
      }
    Comment(" "); return(0);
}
  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   if(Indicator_On? == false) {deinit(); return(0);} deinit();

   datetime stopline= 0, startofy= 0, startofy2= 0, startofo= 0, startofsnr= 0, startoffibos= 0, startoffibos2= 0,
            startofp= 0, startofqtr= 0, startofmsr= 0, startofcam= 0, startofcam2= 0, startofsweet= 0,
            startlabel= 0, startlabel2= 0, startolabel= 0, startylabel= 0, starty2label= 0;

   double   today_high= 0, today_low= 0, today_open= 0,
            yesterday_high= 0, yesterday_open= 0, yesterday_low= 0, yesterday_close= 0;

   int idxfirstbartoday= 0, idxlastbartoday= 0, idxfirstbaryesterday= 0, idxlastbaryesterday= 0;

   // Find out which hour bars make today and yesterday

   ComputeDayIndices(LocalTimeZone, DestTimeZone, idxfirstbartoday, idxfirstbaryesterday, idxlastbaryesterday);

   stopline= Time[0];
   startofy= Time[1];
   startofy2= iTime(NULL, PERIOD_H1, idxfirstbaryesterday);
   startofo= Time[1];
   startofsnr= Time[1];
   startoffibos= Time[1];
   startoffibos2= Time[1];
   startofp= Time[1];
   startofqtr= Time[1];
   startofmsr= Time[1];
   startofcam= Time[1]; 
   startofcam2= Time[1];
   startofsweet= Time[1];

   // does not allow for lines to dissapear after a day change

   if (Time[0] > iTime(NULL, PERIOD_H1, idxfirstbartoday)){
   startofy= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startofo= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startofsnr= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startoffibos= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startoffibos2= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startofp= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startofqtr= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startofmsr= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startofcam= iTime(NULL, PERIOD_H1, idxfirstbartoday); 
   startofcam2= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startofsweet= iTime(NULL, PERIOD_H1, idxfirstbartoday);}

   //Move the labels for zoom-ins zoom-outs

   int A = Time[WindowFirstVisibleBar()];
   int B = iTime(NULL, PERIOD_H1, idxfirstbartoday);
   int C = iTime(NULL, PERIOD_H1, idxfirstbaryesterday);

   if (B <= A) {
   startlabel= Time[WindowFirstVisibleBar()*90/100];
   startolabel= Time[WindowFirstVisibleBar()*90/100];
   starty2label= Time[WindowFirstVisibleBar()*90/100];}

   else {
   startlabel= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   startolabel= iTime(NULL, PERIOD_H1, idxfirstbartoday);
   starty2label= iTime(NULL, PERIOD_H1, idxfirstbartoday);}

   if (C <= A)
   {startylabel= Time[WindowFirstVisibleBar()];} else
   {startylabel= iTime(NULL, PERIOD_H1, idxfirstbaryesterday);}

   if (HLLabelsPosition==1) {startylabel= starty2label;}

   if (Period() == 1440) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_D1, idxlastbartoday) +144000;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_D1, idxlastbartoday) +144000;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_D1, idxlastbartoday) +144000;}}

   if (Period() == 480) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_H4, idxlastbartoday) +48000;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_H4, idxlastbartoday) +48000;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_H4, idxlastbartoday) +48000;}}

   if (Period() == 240) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_H4, idxlastbartoday) +24000;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_H4, idxlastbartoday) +24000;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_H4, idxlastbartoday) +24000;}}

   if (Period() == 60) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_H1, idxlastbartoday) +6000;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_H1, idxlastbartoday) +6000;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_H1, idxlastbartoday) +6000;}}

   if (Period() == 30) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_M30, idxlastbartoday) +3000;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_M30, idxlastbartoday) +3000;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_M30, idxlastbartoday) +3000;}}

   if (Period() == 15) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_M15, idxlastbartoday) +1500;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_M15, idxlastbartoday) +1500;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_M15, idxlastbartoday) +1500;}}

   if (Period() == 5) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_M5, idxlastbartoday) +500;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_M5, idxlastbartoday) +500;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_M5, idxlastbartoday) +500;}}

   if (Period() == 1) {
   if (MainLabelsPosition==1)  {startlabel= iTime(NULL, PERIOD_M1, idxlastbartoday) +100;}
   if (HLLabelsPosition==2) {startylabel= iTime(NULL, PERIOD_M1, idxlastbartoday) +100;}
   if (OpenLabelsPosition==1) {startolabel= iTime(NULL, PERIOD_M1, idxlastbartoday) +100;}}

   // Label spacing

   string space, space2, space3;

   if (MainLabelsPosition==1) {space= "                                                    ";}
   else {space= "                      ";}
   if (HLLabelsPosition==2) {space2= "                                                    ";}
   else {space2= "                      ";}
   if (OpenLabelsPosition==1) {space3= "                                                    ";}
   else {space3= "                      ";}

   if (AllLabelsInMiddle) {space= "                                                    "; space2= ""; space3= "";}

   // walk forward through yestday's start and collect high/lows within the same day

   yesterday_high= -99999;
   yesterday_low=  +99999;

   for (int idxbar= idxfirstbaryesterday; idxbar>=idxlastbaryesterday; idxbar--) {
      if (yesterday_open==0)
      yesterday_open= iOpen(NULL, PERIOD_H1, idxbar);                      
      yesterday_high= MathMax(iHigh(NULL, PERIOD_H1, idxbar), yesterday_high);
      yesterday_low= MathMin(iLow(NULL, PERIOD_H1, idxbar), yesterday_low);
      yesterday_close= iClose(NULL, PERIOD_H1, idxbar);
   }

   // walk forward through today and collect high/lows within the same day

   today_open= iOpen(NULL, PERIOD_H1, idxfirstbartoday);
   today_high= -99999;
   today_low=  +99999;

   for (int j= idxfirstbartoday; j>=0; j--) {
      today_high= MathMax(today_high, iHigh(NULL, PERIOD_H1, j));
      today_low= MathMin(today_low, iLow(NULL, PERIOD_H1, j));
   }

   // time left to next bar

   int gmt= LocalTimeZone - DestTimeZone, h, m, s, t, v;
   t=Time[0]+(Period()*60)-CurTime();
   s=t%60; string seconds = (s); if (s<10) {seconds = ("0"+seconds);}
   m=(t-t%60)/60;
   for(v=0; v<24; v++) {
   if(m>=60){m=m-60;h=h+1;}
      string minutes = (m); if (m<10) {minutes = ("0"+minutes);}
      string hours = (h); if (h<10) {hours = ("0"+hours);}
      string timeleft = (minutes+":"+seconds);
   if (h>=1) {timeleft = (hours+":"+minutes+":"+seconds);}
   if (Period()>1440){timeleft = "OFF";}     
   }

   // day candle and price label and boxes

   if (ShowTodayBoxColor) {
   colorbox("Today Box]", iTime(NULL, PERIOD_H1, idxfirstbartoday), Time[0], today_high, today_low, TodayBoxColor);}

   if (ShowYesterdayBoxColor) {
   colorbox("Yesterday Box]", iTime(NULL, PERIOD_H1, idxfirstbaryesterday), iTime(NULL, PERIOD_H1, idxfirstbartoday), yesterday_high, yesterday_low, YesterdayBoxColor);}

   if (ShowDayCandle) {
      double modifier = 1; if (digits==3 || digits==5) {modifier = 10.0;}
      double open= iOpen(NULL, PERIOD_H1, idxfirstbartoday);
      double current = iClose(NULL,PERIOD_H1,idxlastbartoday);
      double change = (current-open)/(Point*modifier);
      int shift = 0; if(change>0){DayHigh[shift] = today_high; DayLow[shift] = today_low;}       
      else {DayHigh[shift] = today_low; DayLow[shift] = today_high;}
      DayOpen[shift] = open+0.000001; DayClose[shift] = current;
      int i,limit; for(i=0,limit=Bars-1;i<4;i++) SetIndexDrawBegin(i,limit);
      }

   // Calculate Levels

   double p, q, d, r1,r2,r3,r4,r5, s1,s2,s3,s4,s5;
   
   d = (today_high - today_low);
   q = (yesterday_high - yesterday_low);
   p = (yesterday_high + yesterday_low + yesterday_close) / 3;

   if (Show1Daily2FibonacciLevels==1) {   

   r1 = (2*p)-yesterday_low;
   r2 = p+(yesterday_high - yesterday_low);
   r3 = (2*p)+(yesterday_high-(2*yesterday_low));

   s1 = (2*p)-yesterday_high;
   s2 = p-(yesterday_high - yesterday_low);
   s3 = (2*p)-((2* yesterday_high)-yesterday_low);
   }

   if (Show1Daily2FibonacciLevels==2) {

   r1 = p+ (q * 0.382); 
   r2 = p+ (q * 0.618);
   r3 = p+ q;
   r4 = p+ (q * 1.618);
   r5 = p+ (q * 2.618);
   s1 = p- (q * 0.382);
   s2 = p- (q * 0.618);
   s3 = p- q;
   s4 = p- (q * 1.618);
   s5 = p- (q * 2.618);
   }

   // Support and resistance pivots

   if (ShowSupportResistance==true) {
      if (SRLinePlacement==1){startofsnr = Time[1];}
      if (SRLinePlacement==2){startofsnr = WindowFirstVisibleBar();}

      SetLevel(space, "R1", r1, ResistanceColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);
      SetLevel(space, "R2", r2, ResistanceColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);
      SetLevel(space, "R3", r3, ResistanceColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);

      SetLevel(space, "S1", s1, SupportColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);
      SetLevel(space, "S2", s2, SupportColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);
      SetLevel(space, "S3", s3, SupportColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);

   if (Show1Daily2FibonacciLevels==2) {

      SetLevel(space, "R4", r4, ResistanceColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);
      SetLevel(space, "R5", r5, ResistanceColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);

      SetLevel(space, "S4", s4, SupportColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);
      SetLevel(space, "S5", s5, SupportColor, SRLineStyle, SRLineThickness, startofsnr, stopline, startlabel);}
   }

   // Pivot points
 
  if (ShowPivotPoint==true && Show1Daily2FibonacciLevels==1) {
      if (PivotLinePlacement==1){startofp = Time[1];}
      if (PivotLinePlacement==2){startofp = WindowFirstVisibleBar();}

      SetLevel(space, "DPV", p, PivotColor, PivotLineStyle, PivotLineThickness, startofp, stopline, startlabel);
   }

  if (ShowPivotPoint==true && Show1Daily2FibonacciLevels==2) {
      if (PivotLinePlacement==1){startofp = Time[1];}
      if (PivotLinePlacement==2){startofp = WindowFirstVisibleBar();}

      SetLevel(space, "FPV", p, PivotColor, PivotLineStyle, PivotLineThickness, startofp, stopline, startlabel);
   }

   // Midpoint pivots 

   if (ShowMidPivots==true) {
      if (MidLinePlacement==1){startofmsr = Time[1];}
      if (MidLinePlacement==2){startofmsr = WindowFirstVisibleBar();}

      SetLevel(space, "mR3", (r2+r3)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);
      SetLevel(space, "mR2", (r1+r2)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);
      SetLevel(space, "mR1", (p+r1)/2,  MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);
      SetLevel(space, "mS1", (p+s1)/2,  MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);
      SetLevel(space, "mS2", (s1+s2)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);
      SetLevel(space, "mS3", (s2+s3)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);

      if (Show1Daily2FibonacciLevels==2) {

      SetLevel(space, "mR5", (r4+r5)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);
      SetLevel(space, "mR4", (r3+r4)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);

      SetLevel(space, "mS4", (s3+s4)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);
      SetLevel(space, "mS5", (s4+s5)/2, MidColor, MidLineStyle, MidLineThickness, startofmsr, stopline, startlabel);}
   }

   // Quarterpoint pivots

   if (ShowQtrPivots==true) {
      if (QtrLinePlacement==1){startofqtr = Time[1];}
      if (QtrLinePlacement==2){startofqtr = WindowFirstVisibleBar();}

      SetLevel(space, "qR6", r2+((r3-r2)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR5", r2+(r3-r2)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR4", r1+((r2-r1)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR3", r1+(r2-r1)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR2", p+((r1-p)/4)*3,   QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR1", p+(r1-p)/4,       QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);     
 
      SetLevel(space, "qS1", p-(p-s1)/4,       QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qS2", p-((p-s1)/4)*3,   QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);     
      SetLevel(space, "qS3", s1-(s1-s2)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qS4", s1-((s1-s2)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel); 
      SetLevel(space, "qS5", s2-(s2-s3)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qS6", s2-((s2-s3)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);     

   if (Show1Daily2FibonacciLevels==2) {

      SetLevel(space, "qR0", r4+((r5-r4)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR9", r4+(r5-r4)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR8", r3+((r4-r3)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);
      SetLevel(space, "qR7", r3+(r4-r3)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);

      SetLevel(space, "qS7", s3-(s3-s4)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);   
      SetLevel(space, "qS8", s3-((s3-s4)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);   
      SetLevel(space, "qS9", s4-(s4-s5)/4,     QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);   
      SetLevel(space, "qS0", s4-((s4-s5)/4)*3, QtrColor, QtrLineStyle, QtrLineThickness, startofqtr, stopline, startlabel);}
      }

   // Camarilla pivots

   if (ShowCamarilla==true) {
      if (CamLinePlacement==1){startofcam = Time[1];}
      if (CamLinePlacement==2){startofcam = WindowFirstVisibleBar();}

      double h4,h3,l4,l3;
      h4 = (q*0.55)+yesterday_close;
      h3 = (q*0.275)+yesterday_close;
      l3 = yesterday_close-(q*0.275);  
      l4 = yesterday_close-(q*0.55);   
      
      SetLevel(space, "cH3", h3, CamColor, CamLineStyle, CamLineThickness, startofcam, stopline, startlabel);
      SetLevel(space, "cH4", h4, CamColor, CamLineStyle, CamLineThickness, startofcam, stopline, startlabel);
      SetLevel(space, "cL3", l3, CamColor, CamLineStyle, CamLineThickness, startofcam, stopline, startlabel);
      SetLevel(space, "cL4", l4, CamColor, CamLineStyle, CamLineThickness, startofcam, stopline, startlabel);
   }

   if (ShowWeakerCamarilla==true) {
      if (WeakerCamLinePlacement==1){startofcam2 = Time[1];}
      if (WeakerCamLinePlacement==2){startofcam2 = WindowFirstVisibleBar();}
 
      double h2,h1,l2,l1;
      h1 = (q*1.1/12)+yesterday_close;
      h2 = (q*1.1/6)+yesterday_close;
      l1 = yesterday_close-(q*1.1/12); 
      l2 = yesterday_close-(q*1.1/6);  
      
      SetLevel(space, "cH1", h1, CamColor, CamLineStyle, CamLineThickness, startofcam2, stopline, startlabel);
      SetLevel(space, "cH2", h2, CamColor, CamLineStyle, CamLineThickness, startofcam2, stopline, startlabel);
      SetLevel(space, "cL1", l1, CamColor, CamLineStyle, CamLineThickness, startofcam2, stopline, startlabel);
      SetLevel(space, "cL2", l2, CamColor, CamLineStyle, CamLineThickness, startofcam2, stopline, startlabel);
   }

   // Yesterdays High Low and Open pivots

   if (ShowHighLow) {
      if (HLLinePlacement==1){startofy2 = Time[1];}
      if (HLLinePlacement==2){startofy2 = WindowFirstVisibleBar();}
      if (HLLinePlacement==3){startofy2 = startofy;}
      if (AllLinePlacement==0 && HLLinePlacement==0) {

      SetLevel(space2, "yH ", yesterday_high, HLColor, HLhistoricLineStyle, HLLineThickness, startofy2, startofy, 0);
      SetLevel(space2, "yL ", yesterday_low,  HLColor, HLhistoricLineStyle, HLLineThickness, startofy2, startofy, 0);

      SetLevel(space2, "yH", yesterday_high,  HLColor, HLLineStyle, HLLineThickness, startofy, stopline, startylabel);
      SetLevel(space2, "yL", yesterday_low,   HLColor, HLLineStyle, HLLineThickness, startofy, stopline, startylabel);}

      else {

      SetLevel(space2, "yH", yesterday_high,  HLColor, HLLineStyle, HLLineThickness, startofy2, stopline, startylabel);
      SetLevel(space2, "yL", yesterday_low,   HLColor, HLLineStyle, HLLineThickness, startofy2, stopline, startylabel);}
   }

   if (ShowOpen) {
      if (OpenLinePlacement==1){startofo = Time[1];}
      if (OpenLinePlacement==2){startofo = WindowFirstVisibleBar();}
     
      SetLevel(space3, "Op", today_open, OpenColor, OpenLineStyle, OpenLineThickness, startofo, stopline, startolabel);
   }

   // Fibo pivots
 
   if (ShowOuterFibs) {
      if (FibLinePlacementO==1){startoffibos2 = Time[1];}
      if (FibLinePlacementO==2){startoffibos2 = WindowFirstVisibleBar();}
 
      SetLevel(space, "-62", yesterday_low - q*0.618,   FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "-38", yesterday_low - q*0.382,   FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);

      SetLevel(space, "+38", yesterday_high + q*0.382,  FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "+62", yesterday_high +  q*0.618, FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);

      SetLevel(space, "-12", yesterday_low - q*0.118,   FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "-88", yesterday_low - q*0.882,   FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);

      SetLevel(space, "+12", yesterday_high + q*0.118,  FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "+88", yesterday_high +  q*0.882, FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);

      SetLevel(space, "-76", yesterday_low - q*0.764,   FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "-24", yesterday_low - q*0.236,   FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);

      SetLevel(space, "+24", yesterday_high + q*0.236,  FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "+76", yesterday_high +  q*0.764, FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);

      SetLevel(space, "-50", yesterday_low - q*0.5,     FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "+50", yesterday_high + q*0.5,    FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);

      SetLevel(space, "-100", yesterday_low - q*1.0,    FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
      SetLevel(space, "+100", yesterday_high + q*1.0,   FibColor, FibLineStyle, FibLineThickness, startoffibos2, stopline, startlabel);
   }

   if (ShowInnerFibs) {
      if (FibLinePlacementI==1){startoffibos = Time[1];}
      if (FibLinePlacementI==2){startoffibos = WindowFirstVisibleBar();}

      SetLevel(space, "50", yesterday_low + q*0.5,       FibColor, FibLineStyle, FibLineThickness, startoffibos, stopline, startlabel);

      SetLevel(space, "38/62", yesterday_low + q*0.382,  FibColor, FibLineStyle, FibLineThickness, startoffibos, stopline, startlabel);
      SetLevel(space, "62/38", yesterday_high - q*0.382, FibColor, FibLineStyle, FibLineThickness, startoffibos, stopline, startlabel);

      SetLevel(space, "12/88", yesterday_low + q*0.118,  FibColor, FibLineStyle, FibLineThickness, startoffibos, stopline, startlabel);
      SetLevel(space, "88/12", yesterday_high - q*0.118, FibColor, FibLineStyle, FibLineThickness, startoffibos, stopline, startlabel);

      SetLevel(space, "24/76", yesterday_low + q*0.236,  FibColor, FibLineStyle, FibLineThickness, startoffibos, stopline, startlabel);
      SetLevel(space, "76/24", yesterday_high - q*0.236, FibColor, FibLineStyle, FibLineThickness, startoffibos, stopline, startlabel);
   }

   // SweetSpot pivots

   if (ShowSweetSpots) {
      if (SweetLinePlacement==1){startofsweet = Time[1];}
      if (SweetLinePlacement==2){startofsweet = WindowFirstVisibleBar();}

      int ssp1, ssp2;
      double ds1, ds2;
      
      ssp1= Bid / Point;
      ssp1= ssp1 - ssp1%50;
      ssp2= ssp1 + 50;
      
      ds1= ssp1*Point;
      ds2= ssp2*Point;
      
      SetLevel(space, DoubleToStr(ds1,Digits), ds1, SweetColor, SweetLineStyle, SweetLineThickness, startofsweet, stopline, startlabel);
      SetLevel(space, DoubleToStr(ds2,Digits), ds2, SweetColor, SweetLineStyle, SweetLineThickness, startofsweet, stopline, startlabel);
   }

   // draw the vertical bars that marks the time span

   if(Period() < 1440) {
   double top = WindowPriceMax(),
          bottom = WindowPriceMin(),
          scaler = top - bottom,
          adjustTop = scaler/5000,
          adjustBot = scaler/(350/PeriodFontSize),
          location = bottom + adjustBot;

   if (PeriodLabelsPosition==1) {location = top - adjustTop;}

   if (ShowYesterdayLine==true) {
   SetTimeLine("Yesterday", Yesterday, idxfirstbaryesterday, PeriodLabelsColor, location);}
   
   if (ShowTodayLine==true) {
   SetTimeLine("Today", Today, idxfirstbartoday, PeriodLabelsColor, location);}
   }

   // Pannel for upper left corner

   if (ShowPanel) {        

      ObjectCreate("[PivotsD Panel]", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSetText("[PivotsD Panel]", "g", 84, "Webdings");
      ObjectSet("[PivotsD Panel]", OBJPROP_CORNER, 0);
      ObjectSet("[PivotsD Panel]", OBJPROP_XDISTANCE, 0);
      ObjectSet("[PivotsD Panel]", OBJPROP_YDISTANCE, 11 );
      ObjectSet("[PivotsD Panel]", OBJPROP_COLOR, PanelBackgroundColor);
      ObjectSet("[PivotsD Panel]", OBJPROP_BACK, false);

      string P= "\n-----------  Panel  -----------\n";
      P=P + " GMT Setting:  " + gmt + "\n";
      P=P + "Range Today:  "+ DoubleToStr(MathRound(d/Point),0)+ "\n";  
      P=P + "     Yesterday:  "+ DoubleToStr(MathRound(q/Point),0) + "\n";        
      P=P + "    Next bar in:  " + timeleft + "\n";
      P=P + "    Swap Long:  "+ DoubleToStr(MarketInfo(Symbol(),MODE_SWAPLONG),2) + "\n";
      P=P + "   Swap Short:  "+ DoubleToStr(MarketInfo(Symbol(),MODE_SWAPSHORT),2) + "\n"; 
      P=P + "          Spread:  " + DoubleToStr(MarketInfo(Symbol(), MODE_SPREAD),0) + "\n";            
      Comment(P);}

   return(0);
}

//+------------------------------------------------------------------+
//| Compute index of first/last bar of yesterday and today           |
//+------------------------------------------------------------------+
void ComputeDayIndices(int tzlocal, int tzdest, int &idxfirstbartoday, int &idxfirstbaryesterday, int &idxlastbaryesterday)
{
   int tzdiff= tzlocal - tzdest, tzdiffsec= tzdiff*3600,
       barsperday= (PERIOD_D1/PERIOD_H1);
   int dayofweektoday= TimeDayOfWeek(iTime(NULL, PERIOD_H1, 0) - tzdiffsec),
       dayofweektofind= -1;

   idxfirstbartoday= 0;
   idxfirstbaryesterday= 0;
   idxlastbaryesterday= 0;

   switch (dayofweektoday) {
      case 6: // sat
      case 0: // sun
      case 1: // mon
            dayofweektofind= 5;
            break;
      default:
            dayofweektofind= dayofweektoday -1;
            break;
   }

   // search  backwards for the last occrrence (backwards) of the day today (today's first bar)

   for (int i=1; i<= barsperday +1; i++) {
        datetime timet= iTime(NULL, PERIOD_H1, i) - tzdiffsec;
        if (TimeDayOfWeek(timet)!=dayofweektoday) {
            idxfirstbartoday= i-1;
            break;
      }
   }

   // search  backwards for the first occrrence (backwards) of the weekday we are looking for (yesterday's last bar)

   for (int j= 0; j<= 2*barsperday +1; j++) {
        datetime timey= iTime(NULL, PERIOD_H1, i+j) - tzdiffsec;
        if (TimeDayOfWeek(timey)==dayofweektofind) {
            idxlastbaryesterday= i+j;
            break;
      }
   }

   // search  backwards for the first occurrence of weekday before yesterday (to determine yesterday's first bar)

   for (j= 1; j<= barsperday; j++) {
        datetime timey2= iTime(NULL, PERIOD_H1, idxlastbaryesterday+j) - tzdiffsec;
        if (TimeDayOfWeek(timey2)!=dayofweektofind) {
            idxfirstbaryesterday= idxlastbaryesterday+j-1;
            break;
      }
   }

   // specify what is the name of today and yesterday

   if (DetailedPeriodLabels==true)
      {
      if (dayofweektofind == 1) {Yesterday = "Monday"; Today = "Tuesday";}  
      if (dayofweektofind == 2) {Yesterday = "Tuesday"; Today = "Wednesday";}
      if (dayofweektofind == 3) {Yesterday = "Wednesday"; Today = "Thursday";}
      if (dayofweektofind == 4) {Yesterday = "Thursday"; Today = "Friday";}
      if (dayofweektofind == 5) {Yesterday = "Friday"; Today = "Monday";}
      }
   else {Yesterday = "Yesterday"; Today = "Today";}
}

//+------------------------------------------------------------------+
//| Set labels and lines                                             |
//+------------------------------------------------------------------+
void SetLevel(string space, string text, double level, color col1, int linestyle, int thickness, datetime startlines, datetime stoplines, datetime startlabels)
{if(Period() <= E) {

   string labelname= "[PivotsD] " + text + " Label", linename= "[PivotsD] " + text + " Line", pricelabel, FontStyle;
   int Z, L;

   // create or move the horizontal line

   if (AllLinePlacement==2) {startlines= WindowFirstVisibleBar();}
   if (AllLinePlacement==1) {startlines= Time[1];}
   if (LimitLinesToCandle && AllLinePlacement != 1) {Z= false;} else {Z= true;}
   if (StringSubstr(text,0,3)=="yH " || StringSubstr(text,0,3) == "yL ") {Z = false;}

   if (ObjectFind(linename) != 0) {
      ObjectCreate(linename, OBJ_TREND, 0, startlines, level, stoplines, level);
      ObjectSet(linename, OBJPROP_STYLE, linestyle);
      ObjectSet(linename, OBJPROP_COLOR, col1);
      ObjectSet(linename, OBJPROP_WIDTH, thickness);
      ObjectSet(linename, OBJPROP_BACK, true);
      ObjectSet(linename, OBJPROP_RAY, Z);
   }
   else {
      ObjectMove(linename, 0, startlines, level);
      ObjectMove(linename, 1, stoplines, level);
   }

   // put a label on the line

   if (UsedForForex?== true) 
   {
   Price= DoubleToStr(level, fxdigits);}
       else {
   Price= DoubleToStr(level, Digits);}

   if (LabelsFontsBold==true) {FontStyle= "Arial Bold";} else {FontStyle = "Arial";}
   if (AllLabelsInMiddle) {startlabels= Time[WindowFirstVisibleBar()*45/100];}
   if (StringSubstr(text,0,3)=="yH " || StringSubstr(text,0,3)=="yL ") {startlabels= 0;}
   if (ShowLevelPrices && StrToInteger(text)==0) {text= text + " " + Price;}
   if (LabelsInFront==true) {L= false;} else {L= true;}
   pricelabel= space + text;

   if (ObjectFind(labelname) != 0) {
      ObjectCreate(labelname, OBJ_TEXT, 0, startlabels, level);
      ObjectSetText(labelname, pricelabel, LabelsFontSize, FontStyle, LabelsColor);
      ObjectSet(labelname, OBJPROP_BACK, L);}

   else {
      ObjectMove(labelname, 0, startlabels, level);}}

}

//+------------------------------------------------------------------+
//| Set vertical lines                                               |
//+------------------------------------------------------------------+
void SetTimeLine(string objname, string text, int idx, color col1, double textlocation) 
{if(Period() <= E) {

   string vline= "[PivotsD] " + objname, vlabel= "[PivotsD]  " + objname, PeriodFontStyle;
   int x= iTime(NULL, PERIOD_H1, idx), VL;

   // Create and move vertical lines

   if (ObjectFind(vline) != 0) {
      ObjectCreate(vline, OBJ_TREND, 0, x, 0, x, 100);
      ObjectSet(vline, OBJPROP_STYLE, PeriodLineStyle);
      ObjectSet(vline, OBJPROP_COLOR, PeriodLineColor);
      ObjectSet(vline, OBJPROP_WIDTH, PeriodLineThickness);
      ObjectSet(vline, OBJPROP_BACK, true);}

   else {
      ObjectMove(vline, 0, x, 0);
      ObjectMove(vline, 1, x, 100);
   }

   // Put labels on vertical lines

   if (ShowPeriodLabels==true){
   if (PeriodFontsBold==true){PeriodFontStyle = "Arial Bold";} else {PeriodFontStyle = "Arial";}
   if (LabelsInFront==true) {VL= false;} else {VL= true;}

   if (ObjectFind(vlabel + " Label") != 0) {
      ObjectCreate(vlabel + " Label", OBJ_TEXT, 0, x, textlocation);
      ObjectSetText(vlabel + " Label", text, PeriodFontSize, PeriodFontStyle, PeriodLabelsColor);
      ObjectSet(vlabel, OBJPROP_BACK, VL);}

   else {
      ObjectMove(vlabel + " Label", 0, x, textlocation);}
   }}
}

//+------------------------------------------------------------------+
//| Colorbor sub-routine to mark trading range of day                |
//+------------------------------------------------------------------+     
void colorbox (string name, double starttime, double endtime, double high, double low, color col2)
   {if(Period() <= E) {

   string box = "[PivotsD " + name;
   if (ObjectFind(box) != 0){
      ObjectCreate(box,OBJ_RECTANGLE,0,0,0);
      ObjectSet(box,OBJPROP_TIME1,starttime);
      ObjectSet(box,OBJPROP_TIME2,endtime);
      ObjectSet(box,OBJPROP_PRICE1,high);
      ObjectSet(box,OBJPROP_PRICE2,low);
      ObjectSet(box,OBJPROP_COLOR,col2);}
   else{      
      ObjectMove(box, 0, starttime, high);
      ObjectMove(box, 1, endtime, low);}}                     
}

//+------------------------------------------------------------------+
//| End of code                                                      |
//+------------------------------------------------------------------+