
#property copyright "MojoFX - Conversion only"
#property link      "http://groups.yahoo.com/group/MetaTrader_Experts_and_Indicators/"

#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color1 Yellow
#property indicator_width1 2
#property indicator_color2 Lime
#property indicator_width2 5 
#property indicator_color3 Red
#property indicator_width3 5
#property indicator_color4 Lime
#property indicator_width4 2
#property indicator_color5 Red
#property indicator_width5 2

bool On_Off = TRUE;
extern int    period = 60;
extern double koef = 0.4;
extern bool   alertsOn        = true;
extern bool   alertsOnCurrent = true;
extern bool   alertsMessage   = true;
extern bool   alertsSound     = true;
extern bool   alertsNotify    = false;
extern bool   alertsEmail     = false;
extern string soundFile       = "alert.wav";
extern int    ArrOtstup       = 5;

double g_ibuf_92[];
double g_ibuf_96[];
double g_ibuf_100[];
double g_ibuf_104[];
double gda_108[];
double gda_112[];
double gda_116[];
double gda_120[];
double gda_124[];
double gda_128[];
double gd_132;
double gd_140;
double gd_148;
double gd_156;
double gd_164;
double gd_172;
double gd_180;
double gd_188;
double gd_196;
double trend[];
double ArrUp[];
double ArrDn[];

int init() {
   IndicatorBuffers(7);
   
   SetIndexBuffer(0, g_ibuf_92);
   SetIndexLabel (0, "Line");
   SetIndexBuffer(1, g_ibuf_96);
   SetIndexLabel (1, "Trend Up");
   SetIndexBuffer(2, g_ibuf_100);
   SetIndexLabel (2, "Trend Dn");
   SetIndexBuffer(3, ArrUp);
   SetIndexLabel (3, "Arrows Up");
   SetIndexStyle (3, DRAW_ARROW);
   SetIndexArrow (3, 233); 
   SetIndexBuffer(4, ArrDn);
   SetIndexLabel (4, "Arrows Dn");
   SetIndexStyle (4, DRAW_ARROW);
   SetIndexArrow (4, 234);
   SetIndexBuffer(5, g_ibuf_104);
   SetIndexBuffer(6, trend);
   SetIndexStyle (0, DRAW_LINE);
   SetIndexStyle (1, DRAW_LINE);
   SetIndexStyle (2, DRAW_LINE);
   
   IndicatorShortName("THV Coral (" + period + ") ");
   gd_188 = koef * koef;
   gd_196 = 0;
   gd_196 = gd_188 * koef;
   gd_132 = -gd_196;
   gd_140 = 3.0 * (gd_188 + gd_196);
   gd_148 = -3.0 * (2.0 * gd_188 + koef + gd_196);
   gd_156 = 3.0 * koef + 1.0 + gd_196 + 3.0 * gd_188;
   gd_164 = period;
   if (gd_164 < 1.0) gd_164 = 1;
   gd_164 = (gd_164 - 1.0) / 2.0 + 1.0;
   gd_172 = 2 / (gd_164 + 1.0);
   gd_180 = 1 - gd_172;
   return (0);
}



int start() {
if (On_Off == FALSE) return (0);

   double ld_0;
   double ld_8;
 
   int li_20 = IndicatorCounted();
   if (li_20 < 0) return (-1);
   if (li_20 > 0) li_20--;
   int li_16 = Bars - li_20 - 1;
   ArrayResize(gda_108, Bars + 1);
   ArrayResize(gda_112, Bars + 1);
   ArrayResize(gda_116, Bars + 1);
   ArrayResize(gda_120, Bars + 1);
   ArrayResize(gda_124, Bars + 1);
   ArrayResize(gda_128, Bars + 1);
   for (int li_24 = li_16; li_24 >= 0; li_24--) {
      gda_108[Bars - li_24] = gd_172 * Close[li_24] + gd_180 * (gda_108[Bars - li_24 - 1]);
      gda_112[Bars - li_24] = gd_172 * (gda_108[Bars - li_24]) + gd_180 * (gda_112[Bars - li_24 - 1]);
      gda_116[Bars - li_24] = gd_172 * (gda_112[Bars - li_24]) + gd_180 * (gda_116[Bars - li_24 - 1]);
      gda_120[Bars - li_24] = gd_172 * (gda_116[Bars - li_24]) + gd_180 * (gda_120[Bars - li_24 - 1]);
      gda_124[Bars - li_24] = gd_172 * (gda_120[Bars - li_24]) + gd_180 * (gda_124[Bars - li_24 - 1]);
      gda_128[Bars - li_24] = gd_172 * (gda_124[Bars - li_24]) + gd_180 * (gda_128[Bars - li_24 - 1]);
      g_ibuf_104[li_24] = gd_132 * (gda_128[Bars - li_24]) + gd_140 * (gda_124[Bars - li_24]) + gd_148 * (gda_120[Bars - li_24]) + gd_156 * (gda_116[Bars - li_24]);
      ld_0 = g_ibuf_104[li_24];
      ld_8 = g_ibuf_104[li_24 + 1];
      g_ibuf_92[li_24] = ld_0;
      g_ibuf_96[li_24] = ld_0;
      g_ibuf_100[li_24] = ld_0;
      if (ld_8 > ld_0) g_ibuf_96[li_24] = EMPTY_VALUE;
      else {
         if (ld_8 < ld_0) g_ibuf_100[li_24] = EMPTY_VALUE;
         else g_ibuf_92[li_24] = EMPTY_VALUE;
      }
      
      trend[li_24] = trend[li_24+1];
      if(g_ibuf_96[li_24]!=EMPTY_VALUE)  trend[li_24] = 1;
      if(g_ibuf_100[li_24]!=EMPTY_VALUE) trend[li_24] =-1;
      
      if(trend[li_24]!=trend[li_24+1] && trend[li_24]==1)   ArrUp[li_24] = Low[li_24]-ArrOtstup*Point;  else ArrUp[li_24] = EMPTY_VALUE;
      if(trend[li_24]!=trend[li_24+1] && trend[li_24]==-1)  ArrDn[li_24] = High[li_24]+ArrOtstup*Point; else ArrDn[li_24] = EMPTY_VALUE;
   }
    //
    //
    //
    //
    //
    
    if (alertsOn)
    {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; 
      
      //
      //
      //
      //
      //
      
      if (g_ibuf_96[whichBar+1] == EMPTY_VALUE && g_ibuf_96[whichBar] != EMPTY_VALUE) doAlert(whichBar,"BUY");
      if (g_ibuf_100[whichBar+1] == EMPTY_VALUE && g_ibuf_100[whichBar] != EMPTY_VALUE) doAlert(whichBar,"SELL");
    }         
return(0);
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[forBar]) {
          previousAlert  = doWhat;
          previousTime   = Time[forBar];

          //
          //
          //
          //
          //

           message =  StringConcatenate(" THV4 Coral ", Symbol()," ",Period()," " ,doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol(), Period(), " THV4 Coral "),message);
             if (alertsSound)   PlaySound(soundFile);
      }
}


