/*
!xMeter.mq4     
Copyright  2007, MetaQuotes Software Corp.     
Price Meter System GPL     
*/

#property copyright "x Meter System GPL"
#property link      "forex-tsd dot com"

#define ARRSIZE  12                     // number of pairs !!!DON'T CHANGE THIS NUMBER!!!
#define PAIRSIZE 7                      // number of currencies !!!DON'T CHANGE THIS NUMBER!!!
#define TABSIZE  10                     // scale of currency's power !!!DON'T CHANGE THIS NUMBER!!!

string aPair[ARRSIZE]   = {"EURUSD","GBPUSD","AUDUSD","USDJPY","USDCHF","USDCAD",
                           "EURJPY","EURGBP","EURCHF","EURAUD","GBPJPY","GBPCHF"};
//+------------------------------------------------------------------+
//     expert initialization function                                |       
//+------------------------------------------------------------------+
int init()
  {
//----
   initPair();
   initGraph();
   while (true)                                                             // infinite loop for main program
      {
      if (IsConnected()) main();
      if (!IsConnected()) objectBlank();
      WindowRedraw();
      Sleep(1000);                                                          // give your PC a breath
      }
//----
   return(0);                                                               // end of init function
  }
//+------------------------------------------------------------------+
//     expert deinitialization function                              |       
//+------------------------------------------------------------------+
int deinit()
  {
//----
   deleteObject();
   Print("shutdown error - ",GetLastError());                               // system is detached from platform
//----
   return(0);                                                               // end of deinit function
  }
//+------------------------------------------------------------------+
//     expert start function                                         |       
//+------------------------------------------------------------------+
int start()
  {
//----

//----
   return(0);                                                               // end of start funtion
  }
//+------------------------------------------------------------------+
//     expert custom function                                        |       
//+------------------------------------------------------------------+    
void main()                                                                 // this a control center
  {
//----
   string aMajor[PAIRSIZE] = {"USD","EUR","GBP","CHF","CAD","AUD","JPY"};
   double aMeter[PAIRSIZE];
   double aHigh[ARRSIZE];
   double aLow[ARRSIZE];
   double aBid[ARRSIZE];
   double aAsk[ARRSIZE];
   double aRatio[ARRSIZE];
   double aRange[ARRSIZE];
   double aLookup[ARRSIZE];
   double aStrength[ARRSIZE];
   double point;
   int    index;
   
   for (index = 0; index < ARRSIZE; index++)                                // initialize all pairs required value 
      {
      RefreshRates();                                                       // refresh all currency's instrument
      point            = getPoint(aPair[index]);                            // get a point basis
      aHigh[index]     = MarketInfo(aPair[index],MODE_HIGH);                // set a high today
      aLow[index]      = MarketInfo(aPair[index],MODE_LOW);                 // set a low today
      aBid[index]      = MarketInfo(aPair[index],MODE_BID);                 // set a last bid
      aAsk[index]      = MarketInfo(aPair[index],MODE_ASK);                 // set a last ask
      aRange[index]    = MathMax((aHigh[index]-aLow[index])/point,1);       // calculate range today
      aRatio[index]    = (aBid[index]-aLow[index])/aRange[index]/point;     // calculate pair ratio
      aLookup[index]   = iLookup(aRatio[index]*100);                        // set a pair grade
      aStrength[index] = 9-aLookup[index];                                  // set a pair strengh
      } 

   // calculate all currencies meter         
   aMeter[0] = NormalizeDouble((aLookup[3]+aLookup[4]+aLookup[5]+aStrength[0]+aStrength[1]+aStrength[2])/6,1);
   aMeter[1] = NormalizeDouble((aLookup[0]+aLookup[6]+aLookup[7]+aLookup[8]+aLookup[9])/5,1);
   aMeter[2] = NormalizeDouble((aLookup[1]+aLookup[10]+aLookup[11]+aStrength[7])/4,1);
   aMeter[3] = NormalizeDouble((aStrength[4]+aStrength[8]+aStrength[11])/3,1);
   aMeter[4] = NormalizeDouble((aStrength[5]),1);
   aMeter[5] = NormalizeDouble((aLookup[2]+aStrength[9])/2,1);
   aMeter[6] = NormalizeDouble((aStrength[3]+aStrength[6]+aStrength[10])/3,1);     
             
   objectBlank();   
   paintUSD(aMeter[0]);
   paintEUR(aMeter[1]);
   paintGBP(aMeter[2]);
   paintCHF(aMeter[3]);
   paintCAD(aMeter[4]);
   paintAUD(aMeter[5]);
   paintJPY(aMeter[6]);
   paintLine();
                                                                            
//----
  }
  
int iLookup(double ratio)                                                   // this function will return a grade value
  {                                                                         // based on its power.
   int    aTable[TABSIZE]  = {0,3,10,25,40,50,60,75,90,97};                 // grade table for currency's power
   int    index;
   
        if (ratio < aTable[1])  index = 0;
   else if (ratio < aTable[2])  index = 1;
   else if (ratio < aTable[3])  index = 2;
   else if (ratio < aTable[4])  index = 3;
   else if (ratio < aTable[5])  index = 4;
   else if (ratio < aTable[6])  index = 5;
   else if (ratio < aTable[7])  index = 6;
   else if (ratio < aTable[8])  index = 7;
   else if (ratio < aTable[9])  index = 8;
   else                         index = 9;
   return(index);                                                           // end of iLookup function
  }
  
double getPoint(string pair)
  {
   double point;
   
   point = 0.01;
   if (StringFind(pair,"JPY") == EMPTY) point = 0.0001;
   return(point);
  }

int initPair()                                                              // this function will initialize pair
  {                                                                         // string based on type of account
   int index;

   if (StringFind(Symbol(),"m") == EMPTY) return(0);
   for (index = 0; index < ARRSIZE; index++)
      {
      aPair[index] = StringConcatenate(aPair[index],"m");
      }
   return(0);                                                               // end of initPair function
  }

void initGraph()
  {
   deleteObject();

   objectCreate("usd_1",130,43);
   objectCreate("usd_2",130,35);
   objectCreate("usd_3",130,27);
   objectCreate("usd_4",130,19);
   objectCreate("usd_5",130,11);
   objectCreate("usd",132,12,"USD",7,"Arial Narrow",SkyBlue);
   objectCreate("usdp",134,21,DoubleToStr(9,1),8,"Arial Narrow",Silver);
   
   objectCreate("eur_1",110,43);
   objectCreate("eur_2",110,35);
   objectCreate("eur_3",110,27);
   objectCreate("eur_4",110,19);
   objectCreate("eur_5",110,11);
   objectCreate("eur",112,12,"EUR",7,"Arial Narrow",SkyBlue);
   objectCreate("eurp",114,21,DoubleToStr(9,1),8,"Arial Narrow",Silver);
   
   objectCreate("gbp_1",90,43);
   objectCreate("gbp_2",90,35);
   objectCreate("gbp_3",90,27);
   objectCreate("gbp_4",90,19);
   objectCreate("gbp_5",90,11);
   objectCreate("gbp",92,12,"GBP",7,"Arial Narrow",SkyBlue);
   objectCreate("gbpp",94,21,DoubleToStr(9,1),8,"Arial Narrow",Silver);
   
   objectCreate("chf_1",70,43);
   objectCreate("chf_2",70,35);
   objectCreate("chf_3",70,27);
   objectCreate("chf_4",70,19);
   objectCreate("chf_5",70,11);
   objectCreate("chf",72,12,"CHF",7,"Arial Narrow",SkyBlue);
   objectCreate("chfp",74,21,DoubleToStr(9,1),8,"Arial Narrow",Silver);

   objectCreate("cad_1",50,43);
   objectCreate("cad_2",50,35);   
   objectCreate("cad_3",50,27);
   objectCreate("cad_4",50,19);
   objectCreate("cad_5",50,11);
   objectCreate("cad",52,12,"CAD",7,"Arial Narrow",SkyBlue);
   objectCreate("cadp",54,21,DoubleToStr(9,1),8,"Arial Narrow",Silver);
   
   objectCreate("aud_1",30,43);
   objectCreate("aud_2",30,35);
   objectCreate("aud_3",30,27);
   objectCreate("aud_4",30,19);
   objectCreate("aud_5",30,11);
   objectCreate("aud",32,12,"AUD",7,"Arial Narrow",SkyBlue);
   objectCreate("audp",34,21,DoubleToStr(9,1),8,"Arial Narrow",Silver);

   objectCreate("jpy_1",10,43);
   objectCreate("jpy_2",10,35);
   objectCreate("jpy_3",10,27);
   objectCreate("jpy_4",10,19);
   objectCreate("jpy_5",10,11);
   objectCreate("jpy",13,12,"JPY",7,"Arial Narrow",SkyBlue);
   objectCreate("jpyp",14,21,DoubleToStr(9,1),8,"Arial Narrow",Silver);
   
   objectCreate("line99",10, 6,"-----------------------------------",10,"Arial",DimGray);  
   objectCreate("line98",10,27,"-----------------------------------",10,"Arial",DimGray);  
   objectCreate("line97",10,69,"-----------------------------------",10,"Arial",DimGray);
   objectCreate("sign",11,1," Price Meter System GPL ",8,"Arial Narrow",DimGray);
  }
//+------------------------------------------------------------------+
void objectCreate(string name,int x,int y,string text="-",int size=42,
                  string font="Arial",color colour=CLR_NONE)
  {
   ObjectCreate(name,OBJ_LABEL,0,0,0);
   ObjectSet(name,OBJPROP_CORNER,3);
   ObjectSet(name,OBJPROP_COLOR,colour);
   ObjectSet(name,OBJPROP_XDISTANCE,x);
   ObjectSet(name,OBJPROP_YDISTANCE,y);
   ObjectSetText(name,text,size,font,colour);
  }

void deleteObject()
  {
   ObjectDelete("usd_1");
   ObjectDelete("usd_2");
   ObjectDelete("usd_3");
   ObjectDelete("usd_4");
   ObjectDelete("usd_5");
   ObjectDelete("usd");
   ObjectDelete("usdp");
   
   ObjectDelete("eur_1");
   ObjectDelete("eur_2");
   ObjectDelete("eur_3");
   ObjectDelete("eur_4");
   ObjectDelete("eur_5");
   ObjectDelete("eur");
   ObjectDelete("eurp");
   
   ObjectDelete("gbp_1");
   ObjectDelete("gbp_2");
   ObjectDelete("gbp_3");
   ObjectDelete("gbp_4");
   ObjectDelete("gbp_5");
   ObjectDelete("gbp");
   ObjectDelete("gbpp");
   
   ObjectDelete("chf_1");
   ObjectDelete("chf_2");
   ObjectDelete("chf_3");
   ObjectDelete("chf_4");
   ObjectDelete("chf_5");
   ObjectDelete("chf");
   ObjectDelete("chfp");

   ObjectDelete("cad_1");
   ObjectDelete("cad_2");   
   ObjectDelete("cad_3");
   ObjectDelete("cad_4");
   ObjectDelete("cad_5");
   ObjectDelete("cad");
   ObjectDelete("cadp");
   
   ObjectDelete("aud_1");
   ObjectDelete("aud_2");
   ObjectDelete("aud_3");
   ObjectDelete("aud_4");
   ObjectDelete("aud_5");
   ObjectDelete("aud");
   ObjectDelete("audp");

   ObjectDelete("jpy_1");
   ObjectDelete("jpy_2");
   ObjectDelete("jpy_3");
   ObjectDelete("jpy_4");
   ObjectDelete("jpy_5");
   ObjectDelete("jpy");
   ObjectDelete("jpyp");
   
   ObjectDelete("line99");  
   ObjectDelete("line98");  
   ObjectDelete("line97");
   ObjectDelete("sign");

  }

void objectBlank()
  {
   ObjectSet("usd_1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("usd_2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("usd_3",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("usd_4",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("usd_5",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("usd",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("usdp",OBJPROP_COLOR,CLR_NONE);

   ObjectSet("eur_1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("eur_2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("eur_3",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("eur_4",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("eur_5",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("eur",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("eurp",OBJPROP_COLOR,CLR_NONE);

   ObjectSet("gbp_1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("gbp_2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("gbp_3",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("gbp_4",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("gbp_5",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("gbp",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("gbpp",OBJPROP_COLOR,CLR_NONE);

   ObjectSet("chf_1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("chf_2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("chf_3",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("chf_4",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("chf_5",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("chf",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("chfp",OBJPROP_COLOR,CLR_NONE);

   ObjectSet("cad_1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("cad_2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("cad_3",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("cad_4",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("cad_5",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("cad",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("cadp",OBJPROP_COLOR,CLR_NONE);

   ObjectSet("aud_1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("aud_2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("aud_3",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("aud_4",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("aud_5",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("aud",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("audp",OBJPROP_COLOR,CLR_NONE);

   ObjectSet("jpy_1",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("jpy_2",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("jpy_3",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("jpy_4",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("jpy_5",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("jpy",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("jpyp",OBJPROP_COLOR,CLR_NONE);
   
   ObjectSet("line98",OBJPROP_COLOR,CLR_NONE);
   ObjectSet("line97",OBJPROP_COLOR,CLR_NONE); 
  }
  
void paintUSD(double value)
  {
   if (value > 0) ObjectSet("usd_5",OBJPROP_COLOR,Red);
   if (value > 2) ObjectSet("usd_4",OBJPROP_COLOR,Orange);
   if (value > 4) ObjectSet("usd_3",OBJPROP_COLOR,Gold);   
   if (value > 6) ObjectSet("usd_2",OBJPROP_COLOR,YellowGreen);
   if (value > 7) ObjectSet("usd_1",OBJPROP_COLOR,Lime);
   ObjectSet("usd",OBJPROP_COLOR,SkyBlue);
   ObjectSetText("usdp",DoubleToStr(value,1),8,"Arial Narrow",Silver);
   GlobalVariableSet("USD",value);
  }

void paintEUR(double value)
  {
   if (value > 0) ObjectSet("eur_5",OBJPROP_COLOR,Red);
   if (value > 2) ObjectSet("eur_4",OBJPROP_COLOR,Orange);
   if (value > 4) ObjectSet("eur_3",OBJPROP_COLOR,Gold);   
   if (value > 6) ObjectSet("eur_2",OBJPROP_COLOR,YellowGreen);
   if (value > 7) ObjectSet("eur_1",OBJPROP_COLOR,Lime);
   ObjectSet("eur",OBJPROP_COLOR,SkyBlue);
   ObjectSetText("eurp",DoubleToStr(value,1),8,"Arial Narrow",Silver);
   GlobalVariableSet("EUR",value);
  }

void paintGBP(double value)
  {
   if (value > 0) ObjectSet("gbp_5",OBJPROP_COLOR,Red);
   if (value > 2) ObjectSet("gbp_4",OBJPROP_COLOR,Orange);
   if (value > 4) ObjectSet("gbp_3",OBJPROP_COLOR,Gold);   
   if (value > 6) ObjectSet("gbp_2",OBJPROP_COLOR,YellowGreen);
   if (value > 7) ObjectSet("gbp_1",OBJPROP_COLOR,Lime);
   ObjectSet("gbp",OBJPROP_COLOR,SkyBlue);
   ObjectSetText("gbpp",DoubleToStr(value,1),8,"Arial Narrow",Silver);
   GlobalVariableSet("GBP",value);
  }

void paintCHF(double value)
  {
   if (value > 0) ObjectSet("chf_5",OBJPROP_COLOR,Red);
   if (value > 2) ObjectSet("chf_4",OBJPROP_COLOR,Orange);
   if (value > 4) ObjectSet("chf_3",OBJPROP_COLOR,Gold);   
   if (value > 6) ObjectSet("chf_2",OBJPROP_COLOR,YellowGreen);
   if (value > 7) ObjectSet("chf_1",OBJPROP_COLOR,Lime);
   ObjectSet("chf",OBJPROP_COLOR,SkyBlue);
   ObjectSetText("chfp",DoubleToStr(value,1),8,"Arial Narrow",Silver);
   GlobalVariableSet("CHF",value);
  }

void paintCAD(double value)
  {
   if (value > 0) ObjectSet("cad_5",OBJPROP_COLOR,Red);
   if (value > 2) ObjectSet("cad_4",OBJPROP_COLOR,Orange);
   if (value > 4) ObjectSet("cad_3",OBJPROP_COLOR,Gold);   
   if (value > 6) ObjectSet("cad_2",OBJPROP_COLOR,YellowGreen);
   if (value > 7) ObjectSet("cad_1",OBJPROP_COLOR,Lime);
   ObjectSet("cad",OBJPROP_COLOR,SkyBlue);
   ObjectSetText("cadp",DoubleToStr(value,1),8,"Arial Narrow",Silver);
   GlobalVariableSet("CAD",value);
  }

void paintAUD(double value)
  {
   if (value > 0) ObjectSet("aud_5",OBJPROP_COLOR,Red);
   if (value > 2) ObjectSet("aud_4",OBJPROP_COLOR,Orange);
   if (value > 4) ObjectSet("aud_3",OBJPROP_COLOR,Gold);   
   if (value > 6) ObjectSet("aud_2",OBJPROP_COLOR,YellowGreen);
   if (value > 7) ObjectSet("aud_1",OBJPROP_COLOR,Lime);
   ObjectSet("aud",OBJPROP_COLOR,SkyBlue);
   ObjectSetText("audp",DoubleToStr(value,1),8,"Arial Narrow",Silver);
   GlobalVariableSet("AUD",value);
  }

void paintJPY(double value)
  {
   if (value > 0) ObjectSet("jpy_5",OBJPROP_COLOR,Red);
   if (value > 2) ObjectSet("jpy_4",OBJPROP_COLOR,Orange);
   if (value > 4) ObjectSet("jpy_3",OBJPROP_COLOR,Gold);   
   if (value > 6) ObjectSet("jpy_2",OBJPROP_COLOR,YellowGreen);
   if (value > 7) ObjectSet("jpy_1",OBJPROP_COLOR,Lime);
   ObjectSet("jpy",OBJPROP_COLOR,SkyBlue);
   ObjectSetText("jpyp",DoubleToStr(value,1),8,"Arial Narrow",Silver);
   GlobalVariableSet("JPY",value);
  }
  
void paintLine()
  {
   ObjectSet("line98",OBJPROP_COLOR,DimGray);
   ObjectSet("line97",OBJPROP_COLOR,DimGray);
  }