//+------------------------------------------------------------------+
//|                                                          AWADIS  |
//|                                         Copyright  2010, AWADIS |
//|                                            http://www.awadis.com |
//+------------------------------------------------------------------+

//----
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Lime
#property indicator_color2 Aqua
#property indicator_color3 Magenta

#define major   3
#define minor   4

//---- input parameters
extern string prefix = "AwadisEx_";

extern int TakeProfit = 0;
extern int StopLoss = 0;
extern bool UseStartDate = false;
extern datetime StartDate = D'2007.07.23 0:00';

extern int AwadisPeriod = 13;
extern double dy = 0.02;

extern color FiboColor = Yellow;
extern int FiboStyle = STYLE_DOT;

extern color UpArrowColor = DodgerBlue;
extern color DownArrowColor = Red;

extern bool UseMail = true;
extern string MailSubj = "Awadis"; 

extern bool AllowSound = true;
extern string BuyWav = "alert.wav";
extern string SellWav = "alert.wav";
extern int PlayCnt = 3;


//---- fibo_levels
#define FIBO_LEVELS_CNT    7
double FiboLevels[FIBO_LEVELS_CNT] = {0, 0.177, 0.7,   2.973};
string FiboDescr[FIBO_LEVELS_CNT] = {"0.0", "17.7", "70.0",  "297.3"};

//---- buffers
double bb[];
double up[];
double lo[];
//----

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int i,j;
int BuySnd, SellSnd;

int init()
{
  SetIndexStyle(0,DRAW_LINE);
  SetIndexBuffer(0,bb);
  SetIndexStyle(1,DRAW_ARROW);
  SetIndexBuffer(1,up);
  SetIndexEmptyValue(1,EMPTY_VALUE);
  SetIndexArrow(1,159);
  SetIndexStyle(2,DRAW_ARROW);
  SetIndexBuffer(2,lo);
  SetIndexEmptyValue(2,EMPTY_VALUE);
  SetIndexArrow(2,159);
  
  BuySnd = 0;
  SellSnd = 0;
  
  return(0);
}
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{

  int counted_bars=IndicatorCounted();
  int shift,limit;
  double diff,d,ku,kd,km;

  //----
  if (counted_bars<0) return(-1);
  if (counted_bars>0) counted_bars--;
  limit=Bars-31;
  if(counted_bars>=31) limit=Bars-counted_bars-1;

  //----
  for(shift=limit+30;shift>=0;shift--)
  {
    bb[shift]=0;
    d=iStdDev(NULL,0,AwadisPeriod,MODE_SMA,0,PRICE_CLOSE,shift);
    if(d<0.0001) d=0.0001;
    bb[shift]=((Close[shift]+2*d - iMA(NULL,0,AwadisPeriod,0,MODE_SMA,PRICE_CLOSE,shift))/(4*d))*4-2;
    bb[shift]=bb[shift]/3;
    up[shift]=EMPTY_VALUE;
    lo[shift]=EMPTY_VALUE;
    
    if (bb[shift]>0)
    {
      up[shift]=1;
    }
    if (bb[shift]<0)
    {
      lo[shift]=-1;
    }
  }
   
  //-----
  
  string obj_name = "fibo";
  int win = 1;
  
  ObjectDelete(prefix+obj_name);
  
  if (ObjectFind(prefix+obj_name) == -1)
  {
    datetime tm1 = 0;
    
    if (UseStartDate)
      tm1 = StartDate;
    else
      tm1 = StrToTime(TimeToStr(TimeCurrent(), TIME_DATE));
      
    int bar = iBarShift(NULL, 0, tm1);
    
    int up_cnt = 0;
    int lo_cnt = 0;
    for (i = 1; i <= bar; i++)
    {
      if (up[i] != EMPTY_VALUE) up_cnt++;
      if (lo[i] != EMPTY_VALUE) lo_cnt++;
    }
    
    if (up_cnt == 0 || lo_cnt == 0)
    {
      Print("No first reverse condition for Fibo");
      return;
    }
    
    //-----
     
    double price1 = bb[bar];
    datetime tm2 = Time[1];
        
    double price2 = 0;
    if (up[1] != EMPTY_VALUE) price2 = up[1];
    if (lo[1] != EMPTY_VALUE) price2 = lo[1];
/*    
    if (price1 < price2)
    {
      double tmp = price1;
      price1 = price2;
      price2 = tmp;
    }
*/    
    ObjectCreate(prefix+obj_name, OBJ_FIBO, win, tm1, price1, tm2, price2);
    ObjectSet(prefix+obj_name, OBJPROP_LEVELCOLOR, FiboColor);
    ObjectSet(prefix+obj_name, OBJPROP_LEVELSTYLE, FiboStyle);
    
    ObjectSet(prefix+obj_name, OBJPROP_FIBOLEVELS, FIBO_LEVELS_CNT);
    
    for (i = 0; i < FIBO_LEVELS_CNT; i++) 
    {
      ObjectSet(prefix+obj_name, OBJPROP_FIRSTLEVEL+i, FiboLevels[i]);
      ObjectSetFiboDescription(prefix+obj_name, i, FiboDescr[i]); 
    }
  }
  
  double level;
      
  for (i = 0; i < FIBO_LEVELS_CNT; i++)
  {
    level = 0;
    
    if (price1 > price2)
    {
      level = price2 + (price1-price2)*FiboLevels[i];  
    }

    if (price1 < price2)
    {
      level = price2 - (price2-price1)*FiboLevels[i];  
    }
    
//Print(i, " ", level, " ", MathAbs(bb[1]-level));
   //Getting system time in specific format
   
string sTime = TimeToStr(TimeLocal(),TIME_MINUTES) + " (MCK) (GMT+3) ";      
    if (MathAbs(bb[1]-level) <= dy)
    {
      if (bb[1] < bb[2])
      {
        obj_name = "up_arr_"+Time[0];
        if (ObjectFind(prefix+obj_name) != -1) continue;
        
        ObjectCreate(prefix+obj_name, OBJ_ARROW, win, Time[0], bb[1]);
        ObjectSet(prefix+obj_name, OBJPROP_ARROWCODE, SYMBOL_ARROWUP);
        ObjectSet(prefix+obj_name, OBJPROP_COLOR, UpArrowColor);
        
        
        if (UseMail) SendMail(MailSubj,
          sTime+"BUY "
          + Symbol()
          + " " + DoubleToStr(Ask, Digits)
          + " TP " + DoubleToStr(Ask+TakeProfit*Point, Digits)
          + " SL " + DoubleToStr(Ask-StopLoss*Point, Digits)
          );
        BuySnd = PlayCnt;
      }

      if (bb[1] > bb[2])      
      {   
        obj_name = "down_arr_"+Time[0];
        if (ObjectFind(prefix+obj_name) != -1) continue;
        
        ObjectCreate(prefix+obj_name, OBJ_ARROW, win, Time[0], bb[1]);
        ObjectSet(prefix+obj_name, OBJPROP_ARROWCODE, SYMBOL_ARROWDOWN);
        ObjectSet(prefix+obj_name, OBJPROP_COLOR, DownArrowColor);
      
        
        if (UseMail) SendMail(MailSubj,
          sTime+"SELL "
          + Symbol()
          + " " + DoubleToStr(Bid, Digits)
          + " TP " + DoubleToStr(Bid-TakeProfit*Point, Digits)
          + " SL " + DoubleToStr(Bid+StopLoss*Point, Digits)
          );                        
        SellSnd = PlayCnt;
      }      
    }
  }
  
  if (BuySnd > 0)
  {
    if (AllowSound) PlaySound(BuyWav);  
    BuySnd--;
  }

  if (SellSnd > 0)
  {
    if (AllowSound) PlaySound(SellWav);  
    SellSnd--;
  }
      
  return(0);
}
//+------------------------------------------------------------------+