//+------------------------------------------------------------------+
//|                                                      b-clock.mq4 |
//|                                     Core time code by Nick Bilak |
//|        http://metatrader.50webs.com/         beluck[at]gmail.com |
//|                                  modified by adoleh2000 and dwt5 | 
//| Dec 2007 modified by Andrew Love                                     | 
//| - fix init function                                              | 
//| - add deinit function to remove time objects                     | 
//| - add controls for text visibility                               | 
//| - add text label for top right display                           | 
//| - add option to display hours on long timeframes                 | 
//+------------------------------------------------------------------+

#property copyright "Copyright  2005, Nick Bilak"
#property link      "http://metatrader.50webs.com/"

#property indicator_chart_window

extern bool ShowComment = true;
extern bool ShowBarTime = true;
extern bool ShowLabel = true;
extern bool ShowHours = true;
extern color TextColour = White;

//---- buffers
// none

//+------------------------------------------------------------------+
//| Custom indicator de-initialization function                         |
//+------------------------------------------------------------------+

int deinit()
{
   ObjectDelete("BarTime");
   ObjectDelete("TimeLabel");
   
   return(0);
}
   
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
{
   return(0);
}

  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {

   int h,m,s,bigm,t;
   string TimeStr;
   
   t = Time[0]+Period()*60-CurTime();
   
   s = t % 60;
   bigm = t / 60;
   h = bigm / 60;
   m = bigm - h * 60;
   
   if (ShowHours && Period() > 60)
   {
     TimeStr = h + ":" + m + ":" + s;
     Comment(h + " hours " + m + " minutes " + s + " seconds left to bar end");
   }
   else
   {
     TimeStr = bigm + ":" + s;
     Comment(bigm + " minutes " + s + " seconds left to bar end");
   }
   
   if (ShowBarTime)
   {
     if(ObjectFind("BarTime") != 0)
     {
       ObjectCreate("BarTime", OBJ_TEXT, 0, Time[0], Close[0]);
     } 

     ObjectSetText("BarTime", "                        < "+TimeStr, 9, "Courier New", TextColour);
     ObjectMove("BarTime", 0, Time[0], Close[0] + 15 * Point);
   }

   if (ShowLabel)
   {
     if (ObjectFind("TimeLabel") != 0)
     {
       ObjectCreate("TimeLabel", OBJ_LABEL, 0, 0,0);
     }
     
     ObjectSetText("TimeLabel", TimeStr, 9, "Arial", TextColour);
     ObjectSet("TimeLabel", OBJPROP_XDISTANCE, 20);
     ObjectSet("TimeLabel", OBJPROP_YDISTANCE, 20);
     ObjectSet("TimeLabel", OBJPROP_CORNER, 1);
   }
   
   return(0);
  }
//+------------------------------------------------------------------+


