//+------------------------------------------------------------------+
//|                                             Keltner Channels.mq4 |
//|                                                  Coded by Gilani |
//|   set up by RK                   Copyright  2005, MetaQuotes Software Corp. |
//|   fIXED BY mLADEN may29,2013           http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 4 //3
#property indicator_color1 Magenta
#property indicator_color2 Blue
#property indicator_color3 Magenta
#property indicator_style1 2
#property indicator_style2 2
#property indicator_style3 2

extern int    tf          = 0;
extern int    KCperiod   = 7;
extern double  NumATRs  =0.75;
extern int     price    = 0;               //0-6; 4-median
extern bool  addmidzero = false;
extern int     maxBars  = 400;

extern bool   alertsOn          = true;
extern bool   alertsOnCurrent   = False;
extern bool   alertsMessage     = true;
extern bool   alertsSound       = True;
extern bool   alertsEmail       = false;

extern bool   showArrows       = true;
extern double  arrowloc        = 1.0; //arrow location
extern string arrowsIdentifier = "KC8arr";
extern color  ArrowUpColor     = SkyBlue; //Green;
extern color  ArrowDownColor   = Magenta; //Crimson; //Red;

extern bool   showValues        = true;
extern double  Valueloc        = 0.4;
extern string valueIdentifier = "KC8val";
extern color  txtUpColor     = SkyBlue; //Green;
extern color  txtDownColor   = Magenta; //Magenta; //Crimson; //Red;


double upper[], middle[], lower[], trend[];
datetime prevtime = 0;


int init()
  {
   IndicatorBuffers(4);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexShift(0,0);
   SetIndexDrawBegin(0,0);
   SetIndexBuffer(0,upper);

   SetIndexStyle(1,DRAW_LINE);
   SetIndexShift(1,0);
   SetIndexDrawBegin(1,0);
   SetIndexBuffer(1,middle);

   SetIndexStyle(2,DRAW_LINE); //,STYLE_DOT,2);
   SetIndexShift(2,0);
   SetIndexDrawBegin(2,0);
   SetIndexBuffer(2,lower);
   
   SetIndexBuffer(3,trend);
   
   
   IndicatorShortName("RK-KCv6-wtxt-Zo-trend_arrows ("+KCperiod+") "+DoubleToStr(NumATRs,2)+")"); 
   SetIndexLabel(0,"KC-upper");
   SetIndexLabel(1,"Kc-middle");
   SetIndexLabel(2,"KC-lower");     
   SetIndexLabel(3,"KC-trend("+KCperiod+") "+DoubleToStr(NumATRs,2)+")");

return(0);
}
int deinit()
{
  if (showArrows) deleteArrows();
   
  if (showValues) deleteValues();
          
          
   

return(0);
}
int start() {
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   if ( limit > maxBars )
   {
      limit = maxBars;
   }
   double avg;
   for(int x=limit; x>=0; x--)
   {
      middle[x] = iMA(NULL,tf, KCperiod, 0, MODE_SMA, price, x);
      avg  = findAvg(KCperiod, x);
      upper[x] = middle[x] + (avg*NumATRs);
      lower[x] = middle[x] - (avg*NumATRs);
      trend[x] = trend[x+1];
       if (Close[x] >= upper[x])  trend[x] =  1;
       if (Close[x] <= lower[x])  trend[x] = -1;   
       if(addmidzero)
       {       
         if (Close[x] <= upper[x] && Close[x] >= lower[x])  trend[x] = 0; 
       } 
       if (showArrows) manageArrow(x);
       if (showValues) manageValue(x);
   }
   
   manageAlerts();  
   return(0);
  }
//+------------------------------------------------------------------+
   
 void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      
      //if ((Close [whichBar]>= lower[whichBar]) && (Close[whichBar] <= upper[whichBar])) //{ prevtime = 0;
       
      if ((Close[whichBar] > upper[whichBar]) && (prevtime != Time[0]))doAlert(whichBar,"up"  ,1);
      //if (trendsBuffer[whichBar] ==  1) doAlert(whichBar,"up"  ,valuesBuffer[whichBar]);
     // if (trendsBuffer[whichBar] == -1) doAlert(whichBar,"down",valuesBuffer[whichBar]);
      if ((Close[whichBar] < lower[whichBar]) && (prevtime != Time[0]))doAlert(whichBar,"down",-1);
   
   }
}
void doAlert(int forBar, string doWhat,double value)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       message =  StringConcatenate(Symbol()," tf-",(Period())," at ",
       TimeToStr(TimeLocal(),TIME_SECONDS)," RK-KC Alert "+"  Bid -"+DoubleToStr(Bid,Digits)+"  Ask -"+DoubleToStr(Ask,Digits)+"  "
       +DoubleToStr(value,2)+" KC Breakout-",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"Keltner breakout "),message);
          if (alertsSound)   PlaySound("boxing_bell_multiple.wav"); //gun_44mag_11.wav");
          if (alertsSound)   PlaySound("gun_44mag_11.wav");
   }
}

void manageArrow(int x)
{
   if (showArrows)
   {
      double dist = iATR(NULL,0,20,x)/arrowloc;
      string name = arrowsIdentifier+":"+Time[x];
      ObjectDelete(name);         
                
      if (trend[x] != trend[x+1])
         {
            if (trend[x] == 1)
            {
               ObjectCreate(name,OBJ_ARROW,0, Time[x],Low[x]-dist );
                  ObjectSet(name,OBJPROP_ARROWCODE,233);
                  ObjectSet(name,OBJPROP_COLOR,ArrowUpColor);
            }
            else
            if (trend[x] == -1)
            {
               ObjectCreate(name,OBJ_ARROW,0, Time[x],High[x]+dist );
                  ObjectSet(name,OBJPROP_ARROWCODE,234);
                  ObjectSet(name,OBJPROP_COLOR,ArrowDownColor);
            }
         }
   }
}

void manageValue(int x)
{
   if (showValues)
   {
      double dist = iATR(NULL,0,20,x)/Valueloc;
      string on = valueIdentifier+":"+Time[x];
      ObjectDelete(on);         
                
      if (trend[x] != trend[x+1])
         {
            if (trend[x] == 1)
            {
              ObjectCreate(on, OBJ_TEXT, 0, Time[x], Low[x] - dist);
              ObjectSetText(on, DoubleToStr(Close[x], Digits) + " " 
              + TimeToStr(Time[x], TIME_MINUTES), 8, "Arial", txtUpColor);
            }
            else
            if (trend[x] == -1)
            {
              ObjectCreate(on, OBJ_TEXT, 0, Time[x], High[x] + dist);
              ObjectSetText(on, DoubleToStr(Close[x], Digits) + " " 
              + TimeToStr(Time[x], TIME_MINUTES), 8, "Arial", txtDownColor);
            }
         }
   }
}

/////////////////////////////////////////////////////////////////////
void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}
void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}


void deleteValues()
{
   string lookFor       = valueIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}
void deleteValues(datetime time)
{
   string lookFor = valueIdentifier+":"+time; ObjectDelete(lookFor);
}




//-------------------------------------------

double findAvg(int KCperiod, int shift) {
      double sum=0;
      for (int x=shift;x<(shift+KCperiod);x++) {     
         sum += High[x]-Low[x];
      }
      sum = sum/KCperiod;
      return (sum);
   }