#include <stdlib.mqh>   


//+------ CHANGE HERE ALL LINE PROPERTIES --------------------------+

   // Modify below the color for your Bottom and top lines
color    Bottom_Line_Color = LawnGreen;  // Color of bottom lines
color    Top_Line_Color    = Magenta;     // Color of Top lines
string funcao = "SELLLF0";
   // Modify below the properties of the lines
int      Line_Width        = 2;           // From 1 (thin) to 5 (thick) 
int      Line_length       = 4000;        // Length of segment line. 
bool     Line_Ray          = false;       // If "true" all lines will be drawn as a "Ray" (Long Line). If false = as a segment.

   // Modify below the properties of the text
bool     Insert_Text       = true;        // If true the level value will be displayed below or above the line. False = Not displayed
double   Dist_Text         = 4;           // Distance of text from line line (percent value of the window vertical high)
int      Font_Size         = 8;           // Font size of the text 
color    Text_Color        = White;       // Color of the text displayed below or above the line

//+------------------------------------------------------------------+   






//+-----------------------------SCRIPT CODE--------------------------+
int start()
  { 
   double      Price_on_Drop = WindowPriceOnDropped();
   datetime    time = WindowTimeOnDropped();
   int         TimeNow;
   int         timeframe = Period();
   double      Length_Factor;
   int         shift=iBarShift(NULL,timeframe,time);
   double      Max_at_time = High[shift];
   double      Min_at_time = Low[shift];
   double      Dist_to_Max = MathAbs(Price_on_Drop - Max_at_time)*10000;
   double      Dist_to_Min = MathAbs(Price_on_Drop - Min_at_time)*10000;
   double      Window_Max = WindowPriceMax();
   double      Window_Min = WindowPriceMin();
   double      Window_Dist = Window_Max - Window_Min;
   double      Text_Dist;
   color       Line_Color;
   string      Level_Value = DoubleToStr((MathRound(Price_on_Drop*10000)/10000),4);
   
   if(IsConnected()) {TimeNow = TimeCurrent();} else {TimeNow = time;}
   
   if(Dist_to_Max < Dist_to_Min) {Text_Dist = Window_Dist * (Dist_Text/10); Line_Color = Top_Line_Color;}
   if(Dist_to_Max > Dist_to_Min) {Text_Dist = Window_Dist * (-Dist_Text/10) + (0.03 * Window_Dist); Line_Color = Bottom_Line_Color;}
   
   
   switch(timeframe)
      {
      case 1      : Length_Factor = 0.2;   break;
      case 5      : Length_Factor = 1;     break;
      case 15     : Length_Factor = 3;     break;
      case 30     : Length_Factor = 6;     break;
      case 60     : Length_Factor = 12;    break;
      case 240    : Length_Factor = 48;    break;
      case 1440   : Length_Factor = 288;   break;
      case 10080  : Length_Factor = 2016;  break;
      case 43200  : Length_Factor = 8640;  break;
      }
      
   
   int length = Length_Factor * Line_length;

         ObjectDelete(funcao);
         ObjectCreate(funcao ,OBJ_HLINE,0,0,Price_on_Drop);       
         ObjectSet(funcao  ,OBJPROP_COLOR,Line_Color);
         ObjectSet(funcao  ,OBJPROP_WIDTH,Line_Width);
         ObjectSet(funcao  ,OBJPROP_RAY,Line_Ray);
         
         
   return(0);
  }
//+------------------------------------------------------------------+