//+------------------------------------------------------------------+
//|                                                          MMR.mq4 |
//|                                  Based on a strategy by cmillion |
//|             EMA5+LWMA85 crossover with MACD and RSI confirmation |
//+------------------------------------------------------------------+
#property copyright "Copyright @ 2011, downspin"
#property link      "mg@downspin.de"

int deinit(){return(0);}
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 DodgerBlue
#property indicator_color2 Green
#property indicator_color3 Red
#property indicator_level1 0
#property indicator_levelcolor DarkSlateGray

double     direcao_ant = 0;
extern int mac_fast_ma=12,
           mac_slow_ma=26,
           mac_signal=9,
           rsi_period=14,
           ema_period=5,
           lwma_period=85;

double long1[],
       short1[],
       val[];

int init(){
  SetIndexStyle(0,DRAW_LINE); SetIndexBuffer(0,val);
  SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,5); SetIndexBuffer(1,long1);
  SetIndexStyle(2,DRAW_HISTOGRAM,EMPTY,5); SetIndexBuffer(2,short1);
  return(0);
}

int start(){
  double ema,lwma,rsi,mac;
  for(int i=0;i<Bars-IndicatorCounted();i++){
    ema=iMA(Symbol(),0,ema_period,0,1,0,i);
    lwma=iMA(Symbol(),0,lwma_period,0,3,0,i);
    rsi=iRSI(Symbol(),0,rsi_period,0,i);
    mac=iMACD(Symbol(),0,mac_fast_ma,mac_slow_ma,mac_signal,0,0,i);
    mac*=3000;
    rsi-=50;
    val[i]=(ema-lwma)/(Point*10)+mac+rsi;

    if((ema>lwma)&&(rsi>10)&&(mac>0))
    {
      long1[i]=val[i]-10;
    }
    if((ema<lwma)&&(rsi<-10)&&(mac<0))
    {
      short1[i]=val[i]+10;
    }
  }
  
   if (direcao_ant != 0)
   {    
      //Print("P1= "+ExtMapBuffer1[1]+"   p2= "+ExtMapBuffer2[1]);
      if((long1[1] < 50000) || (short1[1] < 50000))   
      {
        if ((long1[1] < 20000) && (short1[1] > 20000) && (direcao_ant != 1))
        {
          newsWrite(Symbol()+" BUY! "+tf()+" MMR  go up "+Period());
          Print(Symbol()+"Sinal Buy"+direcao_ant);
          PlaySound("Buy.wav");        

          direcao_ant = 1;
        } // if ((ExtMapBuffer1[1] != EMPTY_VALUE) && (ExtMapBuffer2[1] == EMPTY_VALUE) && (direcao_ant != 1))
      
        if ((short1[1] < 20000) && (long1[1] > 20000) && (direcao_ant != 2))
        {
          newsWrite(Symbol()+" SELL! "+tf()+" MMR go down  "+Period() + " Direcao = ");
          Print(Symbol()+"Sinal Sell"+direcao_ant);
          PlaySound("Sell.wav");        
          direcao_ant = 2;          
        } // if ((ExtMapBuffer2[1] != EMPTY_VALUE) && (ExtMapBuffer1[1] == EMPTY_VALUE) && (direcao_ant != 2))
      } // if((ExtMapBuffer1[1] != EMPTY_VALUE) && (ExtMapBuffer2[1] != EMPTY_VALUE))   
   } else // if (direcao_ant != 0)
   {
      if((long1[1] != EMPTY_VALUE) && (short1[1] != EMPTY_VALUE))   
      if ((long1[1] != EMPTY_VALUE) && (direcao_ant != 1))
      {
        direcao_ant = 1;
      }
      if ((short1[1] != EMPTY_VALUE) && (direcao_ant != 2))
      {
        direcao_ant = 2;
      }   
   }    // if (direcao_ant != 0)
  
  return(0);
}

//+------------------------------------------------------------------+

void newsWrite(string texto)
{ 
 double handle10 = FileOpen("news.txt", FILE_CSV|FILE_WRITE, ";");            
 if (handle10 > 0) 
   {
     FileWrite(handle10, texto);     
  } 
 FileClose(handle10);
 return (0);
}

string tf()
{
   switch(Period())
   {
      case PERIOD_M1: return("M(1)");
      case PERIOD_M5: return("M(5)");
      case PERIOD_M15: return("M(15)");
      case PERIOD_M30: return("M(30)");
      case PERIOD_H1: return("H(1)");
      case PERIOD_H4: return("H(4)");
      case PERIOD_D1: return("D(1)");
      case PERIOD_W1: return("W(1)");
      case PERIOD_MN1: return("MN(1)");
      default:return("Unknown timeframe");
   }
}

