//+---------------------------------------------------------------------------------+
//+ MA2_Signal                                                                      +
//+     2-                                   +
//+                                                                                 +
//+  :                                                              +
//+  ExtPeriodFastMA -                                           +
//+  ExtPeriodSlowMA -                                        +
//+  ExtModeFastMA   -                                            +
//+  ExtModeSlowMA   -                                         +
//+   : 0 = SMA, 1 = EMA, 2 = SMMA (), 3 = LWMA ()        +
//+  ExtPriceFastMA  -                                             +
//+  ExtPriceSlowMA  -                                          +
//+   : 0 = Close, 1 = Open, 2 = High, 3 = Low, 4 = HL/2, 5 = HLC/3, 6 = HLCC/4 +
//+---------------------------------------------------------------------------------+
#property copyright "Copyright  2006, Karakurt"
#property link      ""

//----  
#property indicator_chart_window
#property indicator_buffers 4
//---- 
#property indicator_color1 Magenta // 5
#property indicator_color2 Blue        // 7
#property indicator_color3 MediumBlue
#property indicator_color4 Tomato
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 1
#property indicator_width4 1


//---- 
extern int    ExtPeriodFastMA = 5;
extern int    ExtPeriodSlowMA = 7;
extern int    ExtModeFastMA   = 1; // 0 = SMA, 1 = EMA, 2 = SMMA, 3 = LWMA
extern int    ExtModeSlowMA   = 1; // 0 = SMA, 1 = EMA, 2 = SMMA, 3 = LWMA
extern int    ExtPriceFastMA  = 0; // 0 = Close, 1 = Open, 2 = High, 3 = Low, 4 = HL/2, 5 = HLC/3, 6 = HLCC/4
extern int    ExtPriceSlowMA  = 1; // 0 = Close, 1 = Open, 2 = High, 3 = Low, 4 = HL/2, 5 = HLC/3, 6 = HLCC/4
extern bool   EnableAlert=true;
extern string ExtSoundFileName = "";

//---- 
double FastMA[];
double SlowMA[];
double CrossUp[];
double CrossDown[];
  static int bBuy  = 0;
  static int bSell = 0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
  //----   
  //     
  SetIndexStyle( 0, DRAW_LINE );
  SetIndexStyle( 1, DRAW_LINE );
  //     
  SetIndexStyle( 2, DRAW_ARROW, EMPTY );
  SetIndexArrow( 2, 233 );
  SetIndexStyle( 3, DRAW_ARROW, EMPTY );
  SetIndexArrow( 3, 234 );
  
  //----  
  SetIndexBuffer( 0, FastMA    );
  SetIndexBuffer( 1, SlowMA    );
  SetIndexBuffer( 2, CrossUp   );
  SetIndexBuffer( 3, CrossDown );
  
  IndicatorDigits( MarketInfo( Symbol(), MODE_DIGITS ) );
  
  //----   
  IndicatorShortName( "MA2_SignalV2(" + ExtPeriodFastMA + "," + ExtPeriodSlowMA );
  SetIndexLabel( 0, "MA("+ ExtPeriodFastMA + "," + ExtPeriodSlowMA+")" + ExtPeriodFastMA );
  SetIndexLabel( 1, "MA(" + ExtPeriodFastMA + "," + ExtPeriodSlowMA+")" + ExtPeriodSlowMA );
  SetIndexLabel( 2, "Buy"  );
  SetIndexLabel( 3, "Sell" );
  
  return ( 0 );
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
  
  bool   bConditionUp;
  bool   bConditionDown;
  double Range;
  double AvgRange;
  int    iLimit;
  int    i;
  int    counter;
  int    counted_bars = IndicatorCounted();
  
  //---- check for possible errors
  if ( counted_bars < 0 ) 
    return ( -1 );
  
  //---- last counted bar will be recounted
  if ( counted_bars > 0 ) counted_bars--;
  
  iLimit = Bars - counted_bars;

  for ( i = iLimit; i >=0; i-- ) {
    FastMA[i] = iMA( NULL, 0, ExtPeriodFastMA, 0, ExtModeFastMA, ExtPriceFastMA, i );
    SlowMA[i] = iMA( NULL, 0, ExtPeriodSlowMA, 0, ExtModeSlowMA, ExtPriceSlowMA, i );
    AvgRange = 0;
    bConditionUp = 0;
    bConditionDown = 0;
    for ( counter = i; counter <= i + 9; counter++ ) {
      AvgRange += MathAbs( High[ counter ] - Low[ counter ] );
    }
    Range = AvgRange/10;
      bConditionUp   = ( FastMA[i+1] >= SlowMA[i+1] ) &&
                       ( FastMA[i+2] <= SlowMA[i+2] ) &&
                       ( FastMA[i] > SlowMA[i] ); //  
      bConditionDown = ( FastMA[i+1] <= SlowMA[i+1] ) &&
                       ( FastMA[i+2] >= SlowMA[i+2] ) &&
                       ( FastMA[i] < SlowMA[i] ); //  
    if ( bConditionUp) {//
      CrossUp[i+1] = SlowMA[i+1]-Range * 0.75;
      CrossDown[i+1] = EMPTY_VALUE; 
      bConditionDown = false;
    }
    
    if ( bConditionDown) {//
      CrossDown[i+1] = SlowMA[i+1]+Range * 0.75;
      CrossUp[i+1] = EMPTY_VALUE;
      bConditionUp = false;
    } 
    
    if (!bConditionUp && !bConditionDown) {
      CrossDown[i+1] = EMPTY_VALUE;
      CrossUp[i+1] = EMPTY_VALUE;
    } 
    
    if (bConditionUp && !bBuy==1 && i==0 && EnableAlert){
      bBuy  = 1;  //   
      bSell = 0; //   
      Alert (Symbol()," ",Period(),"M  Achtung BUY "); //  
      if ( ExtSoundFileName != "" ) PlaySound( ExtSoundFileName );
    }
    if (bConditionDown && !bSell==1 && i==0 && EnableAlert){
      bBuy  = 0;  //   
      bSell = 1; //   
      Alert (Symbol()," ",Period(),"M   Achtung SELL "); //  
      if ( ExtSoundFileName != "" ) PlaySound( ExtSoundFileName );
    }
    //Comment ("Buy-"+bBuy+"\nSell-"+bSell);
  } // for
   
  //return ( 0 );
}
//for buy
//      if (bBuy==0 && i < 1 && EnableAlert) {
//        //Alert (Symbol()," ",Period(),"M  Achtung BUY "); //  
//         Alert ("Buy-",bBuy," ",i," ",EnableAlert);        
//        if ( ExtSoundFileName != "" ) PlaySound( ExtSoundFileName );
//      }

//      if (bSell==0 && i < 1 && EnableAlert) {
//         //Alert (Symbol()," ",Period(),"M   Achtung SELL "); 
//         Alert ("Sell-",bSell," ",i," ",EnableAlert);
//         if ( ExtSoundFileName != "" )    PlaySound( ExtSoundFileName );
//      } 

