//+------------------------------------------------------------------+
//|                                                        S-RoC.mq4 |
//|                                    Copyright (C) 2009 DragoTrade |
//|                        Licensed under GNU General Public License |
//+------------------------------------------------------------------+
#property copyright "DragoTrade" 

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1	DodgerBlue
#property indicator_style1	STYLE_SOLID
#property indicator_width1	4
#property indicator_color2	Red
#property indicator_style2	STYLE_SOLID
#property indicator_width2	4
//---- input parameters
extern int MA_Period=13;
extern int ROC_Period=21;
//---- buffers
double bu[],bd[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,bu);
   SetIndexStyle ( 1, DRAW_HISTOGRAM );
	SetIndexBuffer( 1, bd );
   
   IndicatorShortName("S-RoC("+MA_Period+", "+ROC_Period+")");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int i=Bars-(ROC_Period+MA_Period)-1;
   double t,curr,prev;
   while(i>=0)
   {
      curr=iMA(NULL,0,MA_Period,0,MODE_EMA,PRICE_CLOSE,i);
      prev=iMA(NULL,0,MA_Period,0,MODE_EMA,PRICE_CLOSE,i+ROC_Period);
      if(prev!=0)
      {
         t=(curr-prev)/prev;
      }
     // b[i]=t;
     
      
      if (t>0) {bu[i]=1;bd[i]=0;}
      if (t<0) {bu[i]=0;bd[i]=1;}
       i--;
   }
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+