//+------------------------------------------------------------------+
//|               MACD_4CZ                           Custom MACD.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|       based on  ASilver MACD534       http://www.metaquotes.net/ |
//|                     MACD_4CZ    4colors  up/dn over/under zero;  |
//| MACD_4CZ mtf  ml ki                      2007  www.forexTSD.com  |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2004, MetaQuotes Software Corp."
#property  link      "http://www.metaquotes.net/" 

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 4
#property  indicator_color1  LimeGreen
#property  indicator_color2  DarkGreen
#property  indicator_color3  Red
#property  indicator_color4  Maroon
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1
//#property indicator_level1 0.004
//#property indicator_level2 0.002
//#property indicator_level3 0.0004
#property indicator_level1 0
//#property indicator_level5 -0.0004
//#property indicator_level6 -0.002
//#property indicator_level7 -0.004
#property indicator_levelcolor SlateGray
#property indicator_levelstyle 2
//    3/10/16-LBR; 5/13/4Valeo; 8/17/9CJA; 26/12-std; 34/5/5; 38/120/20Eli
//---- indicator parameters
extern int FastEMA=5;
extern int SlowEMA=34;

extern int TimeFrame = 0;
extern string  note_TimeFrames = "M1;5,15,30,60H1;240H4;1440D1;10080W1;43200MN|0-CurrentTF";
string IndicatorFileName;

//---- indicator buffers
double green_buffer[];
double DarkGreen_buffer[];
double red_buffer[];
double Maroon_buffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(0,green_buffer);
//----
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(1,DarkGreen_buffer);
//----
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(2,red_buffer);
//----
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(3,Maroon_buffer);
//----

   IndicatorDigits(Digits+1);
//---- name for DataWindow and indicator subwindow label
  SetIndexLabel(0,"MACD ["+TimeFrame+"]("+FastEMA+","+SlowEMA+")");
  SetIndexLabel(1,"MACD ["+TimeFrame+"]("+FastEMA+","+SlowEMA+")");
  SetIndexLabel(2,"");
  SetIndexLabel(3,"");

   IndicatorFileName = WindowExpertName(); 
   IndicatorShortName("MACD ["+TimeFrame+"]("+FastEMA+","+SlowEMA+")");
   if (TimeFrame < Period()) TimeFrame = Period();


//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int start()
  {
  
     int counted_bars1=IndicatorCounted();
   int      limit1,i1;
   if(counted_bars1 < 0) return(-1);
   limit1 = Bars-counted_bars1;
   if (TimeFrame != Period())
      {
         limit1 = MathMax(limit1,TimeFrame/Period());
         datetime TimeArray[];
        ArrayCopySeries(TimeArray ,MODE_TIME ,NULL,TimeFrame);
           // for(i1=0,int y=0; i1<limit1; i1++)
           {
             // if(Time[i1]<TimeArray[y]) y++;
             // green_buffer     [i1]   = iCustom(NULL,TimeFrame,IndicatorFileName,0,y);
              //DarkGreen_buffer [i1]   = iCustom(NULL,TimeFrame,IndicatorFileName,1,y);
             // red_buffer       [i1]   = iCustom(NULL,TimeFrame,IndicatorFileName,2,y);
             // Maroon_buffer    [i1]   = iCustom(NULL,TimeFrame,IndicatorFileName,3,y);

 
            }
         return(0);         
      }

  
   double MACD;
   int counted_bars=IndicatorCounted();
   int i;
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   for (i = Bars - Max (counted_bars-1, 1); i>=0; i--) {
      MACD=iMA(NULL,0,FastEMA,0,MODE_EMA,PRICE_MEDIAN,i)-
           iMA(NULL,0,SlowEMA,0,MODE_EMA,PRICE_MEDIAN,i);
if(MACD>0) {
      if ( ( (green_buffer[i+1] != 0) && (MACD >= green_buffer[i+1]) ) ||
           ( (DarkGreen_buffer[i+1] != 0) && (MACD > DarkGreen_buffer[i+1]) ) ) {
        green_buffer[i] = MACD;
        DarkGreen_buffer[i] = 0;
      }
      else {
        green_buffer[i] = 0;
        DarkGreen_buffer[i] = MACD;}
     }
       else {
     if ( ( (red_buffer[i+1] != 0) && (MACD >= red_buffer[i+1]) ) ||
           ( (Maroon_buffer[i+1] != 0) && (MACD > Maroon_buffer[i+1]) ) ) {
        red_buffer[i] = MACD;
        Maroon_buffer[i] = 0;
      }
      else {
        red_buffer[i] = 0;
        Maroon_buffer[i] = MACD;
   } 
      }
   }
//---- done
   return(0);
  }

//+------------------------------------------------------------------+
int Max (int val1, int val2) {
  if (val1 > val2)  return(val1);
  return(val2);
}

