//+----------------------------------------------------------------------+
//|ZigZag                               |
//|----------------------------------------------------------------------+
//|                                                                      |
//|ExtIndicator -   ,             |
//|                                             |
//|           0 - Zigzag  ,                     |
//|           1 - Zigzag ,                                         |
//|           2 -     Ensign                |
//|           3 - ZigZag Ensign    minBars           |
//|           4 - ZigZag,  tauber                              |
//|                                                                      |
//|minBars -   (  )                  |
//|minSize -     (  )  |
//|                                                                      |
//|ExtDeviation  ExtBackstep -    ZigZag  MT4    |
//|                                                                      |
//|minPercent -   ( ,  0.5)       |
//|                -  ,  minSize=0; |
//|----------------------------------------------------------------------|
//|ExtHidden - 0 -   .  ZigZag.                     |
//|            1 -     ,        |
//|                  >0.14  <5.                    |
//|            2 -     ,   -    |
//|                    ( 0.447, 0.886, 2.24,  |
//|                3.14, 3,618    Gartley)         |
//|            3 -  ,    2            |
//|                                                 |
//|            4 -        |
//|                                                                      |
//|ExtFiboZigZag -   "ZiaZag Fibonacci"                    |
//|                                                                      |
//|ExtFractal -   (, ),            |
//|                                    |
//|                                                                      |
//|ExtFractalEnd -  ,                |
//|                            |
//|                 ExtFractalEnd=0           |
//|                  .                        |
//|                  ExtFractalEnd=1                  |
//|                                                                      |
//|ExtDelta - ()   .               |
//|             .                            |
//|                    0<ExtDelta<1                            |
//|                                                                      |
//|ExtDeltaType -    0 -    " "    |
//|                  1 -   (%- )<ExtDelta     |
//|                  2 - ((%- )/ )<ExtDelta  |
//|                                                                      |
//|chHL     = true     -          |
//|PeakDet  = true     -             |
//|                                                            |
//|                                                                      |
//|ExtFiboType = true -                             |
//|              false -                                  |
//|                                                                      |
//|ExtFiboCorrectionExpansion = false -                |
//|                           = true  -               |
//|                                                                      |
//|ExtFiboDinamic -     .            |
//|                           |
//|                 ZigZag-a.                                            |
//|                                                                      |
//|ExtFiboStatic -                   |
//|                                                                      |
//|ExtFiboStaticNum -   ZigZag-a,       |
//|                     . 1<ExtFiboStaticNum<=9 |
//|                                                                      |
//|ExtSizeTxt -                                |
//|                                                                      |
//|ExtLine -                                |
//|                                                                      |
//|ExtPesavento -                                |
//|                                                                      |
//|ExtGartley886 -    .886                                |
//|                                                                      |
//|ExtNotFibo -                              |
//|                                                                      |
//|ExtFiboS  ExtFiboD -      .     |
//|                                                                      |
//|infoTF -    5  .                |
//|           .    .   |
//|             .                |
//|                                                                      |
//|chHL_PeakDet_or_vts - true -            |
//|  ( )     ZigZag. |
//|  false -   i-vts.                                  |
//|                                                                      |
//|NumberOfBars -    (0-)  i-vts.            |
//|                                                                      |
//|NumberOfVTS - ,   ,    i-vts.     |
//|NumberOfVTS1 -      i-vts.           |
//|                                                                      |
//|----------------------------------------------------------------------|
//|                                               |
//|----------------------------------------------------------------------|
//|ExtPitchforkDinamic > 0 (=1)        |
//|                ZigZag                        |
//|             =2 50%                                            |
//|             =3 50%                                               |
//|             =4                                             |
//|                                                                      |
//|ExtPitchforkStatic > 0 (=1)          |
//|              ZigZag   ExtPitchforkStaticNum        |
//|             =2 50%                                            |
//|             =3 50%                                               |
//|             =4                                             |
//|                                                                      |
//|3<ExtPitchforkStaticNum<=9 -   ZigZag,           |
//|                                                                        |
//|                                                                      |
//|ExtLinePitchforkS                                                    | 
//|ExtLinePitchforkD                |
//|ExtPitchforkStaticColor -                  |
//|                                                                      |
//|ExtFiboFanDinamic -    -         |
//|ExtFiboFanStatic -    -           |
//|                                   |
//|                                                                      |
//|ExtFiboFanD -    -                   |
//|                                                                      |
//|ExtFiboFanS -    -                    |
//|                                                                      |
//|ExtFiboFanHidden -            |
//|                                                                      |
//|ExtFiboFanMedianaStaticColor                                         |
//|ExtFiboFanMedianaDinamicColor -                |
//|                             |
//|                                                                      |
//|                     |
//|ExtFiboTime1 -     1.                        |
//|                                                                      |
//|ExtFiboTime2 -     2.                        |
//|                                                                      |
//|ExtFiboTime1C -      1.                   |
//|                                                                      |
//|ExtFiboTime2C -      2.                   |
//|                                                                      |
//|ExtUTL -                     |
//|ExtLTL -                      |
//|                                                                      |
//|ExtUWL -                           |
//|ExtLWL -                            |
//|                                                                      |
//|                |
//|                                                                      |
//|ExtRLine -                   |
//|                                                                      |
//|ExtRLineBase -                        |
//|----------------------------------------------------------------------|
//|                                                                      |
//|ExtFiboFanColor -     .     |
//|                                                                      |
//|ExtFiboFanNum -   ZigZag-a,          |
//|                   . 1<ExtFiboStaticNum<=9       |
//|                                                                      |
//|----------------------------------------------------------------------|
//|                                                                      |
//|ExtFiboExpansion -  ,              |
//|                 < 2                    |
//|                 = 2                    |
//|                 >2  <=9               |
//|                                                                      |
//|ExtFiboExpansionColor -             |
//|----------------------------------------------------------------------|
//|ExtBack -                             |
//|ExtSave -                  |
//|          Fibo Time                                                   |
//|                                                                      |
//|ExtAlert -                 |
//|              ZigZag                           |
//|                                                                      |
//|ExtStyleZZ - = true -    ZigZag      |
//|             = false - Zigzag             |
//|                                                                      |
//|ExtComplekt -   .     |
//|                    .   |
//|                     . |
//+----------------------------------------------------------------------+
#property copyright "nen"
#property link      "hhttp://onix-trade.net/forum/index.php?s=&showtopic=118&view=findpost&p=86361"
//  http://onix-trade.net/forum/index.php?s=&showtopic=373&view=findpost&p=72865

#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color1 Aqua 
#property indicator_color2 Green
#property indicator_color3 Orange
#property indicator_color4 LightSkyBlue
#property indicator_color5 LemonChiffon
//===================================
//---- indicator parameters
extern int    ExtIndicator = 4;
extern int    minBars = 0;
extern int    minSize = 55;
//   ZigZag  
extern int    ExtDeviation = 8;
extern int    ExtBackstep = 21;
//----
extern double minPercent = 0;
//----
extern int    ExtHidden = 1;
extern bool   ExtFiboZigZag = false;
extern int    ExtFractal = 7;
extern int    ExtFractalEnd = 7;
extern double ExtDelta = 0.04;
extern int    ExtDeltaType = 2;
//-------------------------------------
extern bool   ExtFiboType = true;
extern bool   ExtFiboCorrectionExpansion = false;
extern bool   ExtFiboDinamic = false;
extern bool   ExtFiboStatic = false;
extern int    ExtFiboStaticNum = 2;
extern int    ExtSizeTxt = 7;
extern color  ExtLine = DarkBlue;
extern color  ExtNotFibo = SlateGray;
extern color  ExtPesavento = Yellow;
extern color  ExtGartley886 = GreenYellow;
extern color  ExtFiboS = Teal;
extern color  ExtFiboD = Sienna;
//----------------------------------------------------------------------
//  ,     . .
//----------------------------------------------------------------------
//    
extern int    ExtPitchforkDinamic = 0;
extern int    ExtPitchforkStatic = 0;
extern int    ExtPitchforkStaticNum = 3;
extern color  ExtLinePitchforkS = MediumBlue;
extern color  ExtLinePitchforkD = MediumSlateBlue;
extern color  ExtPitchforkStaticColor = CLR_NONE;
//   
extern bool   ExtFiboFanDinamic = false;  //   
extern bool   ExtFiboFanStatic = false;   //      
extern bool   ExtFiboFanHidden = false;
extern color  ExtFiboFanS = Teal;
extern color  ExtFiboFanD = Sienna;

extern color  ExtFiboFanMedianaStaticColor = CLR_NONE;
extern color  ExtFiboFanMedianaDinamicColor = CLR_NONE;

//   
extern bool   ExtFiboTime1 = false;
extern bool   ExtFiboTime2 = false;
extern color  ExtFiboTime1C = Teal;
extern color  ExtFiboTime2C = Sienna;
//extern color  ExtPivotZoneColor = CLR_NONE; //|ExtPivotZoneColor -    Pivot Zone                   |

//     
extern bool   ExtUTL = false;
extern bool   ExtLTL = false;
extern bool   ExtUWL = false;
extern bool   ExtLWL = false;

//   
extern bool   ExtRLine = true;
extern bool   ExtRLineBase =true;
//----------------------------------------------------------------------
//  ,     . .
//----------------------------------------------------------------------
//  
extern color  ExtFiboFanColor = CLR_NONE;
extern int    ExtFiboFanNum = 0;
//  
extern int    ExtFiboExpansion = 0;
extern color  ExtFiboExpansionColor = Yellow;
//--------------------------------------
extern bool   chHL = false;
extern bool   PeakDet = false;
//   i-vts
extern bool   chHL_PeakDet_or_vts = true;
extern int    NumberOfBars = 1000;     //    (0-)
extern int    NumberOfVTS  = 13;
extern int    NumberOfVTS1 = 1;
// --------------------------------
//  
extern bool   infoTF = false;
//     
extern bool   ExtBack = true;
//    , Fibo Time
extern bool   ExtSave = false;
extern bool   ExtStyleZZ = true;
extern bool   ExtAlert = false;
extern int    ExtComplekt=0;
//===================================

//   ZigZag 
//    ZigZag
double zz[];
//   ZigZag
double zzL[];
//   ZigZag
double zzH[];

//   
//    (   )
double fi[]={0.382, 0.447, 0.5, 0.618, 0.707, 0.786, 0.841, 0.886, 1.0, 1.128, 1.272, 1.414, 1.5, 1.618, 2.0, 2.24, 2.414, 2.618, 3.14, 3.618, 4.0};
string fitxt[]={".382", ".447", ".5", ".618", ".707", ".786", ".841", ".886", "1.0", "1.128", "1.272", "1.414", "1.5", "1.618", "2.0", "2.24", "2.414", "2.618", "3.14", "3.618", "4.0"};
double fi1[]={0.146, 0.236, 0.382, 0.5, 0.618, 0.764, 0.854, 1.0, 1.236, 1.618};
string fitxt1[]={"0.146", "0.236", ".382", ".5", ".618", ".764", ".854", "1.0", "1.236", "1.618"};
string nameObj,nameObjtxt,save;
//      afr -            
// afrl - , afrh - 
int afr[]={0,0,0,0,0,0,0,0,0,0};
double afrl[]={0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0}, afrh[]={0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
//  
double openTF[]={0.0,0.0,0.0,0.0,0.0}, closeTF[]={0.0,0.0,0.0,0.0,0.0}, lowTF[]={0.0,0.0,0.0,0.0,0.0}, highTF[]={0.0,0.0,0.0,0.0,0.0};
double close_TF=0;
string TF[]={"MN","W1","D1","H4","H1"};
bool afrm=true;
double HL,HLp,kk,kj,Angle;
// LowPrim,HighPrim,LowLast,HighLast -     
double LowPrim,HighPrim,LowLast,HighLast;
// numLowPrim,numHighPrim,numLowLast,numHighLast - 
int numLowPrim,numHighPrim,numLowLast,numHighLast,k,k1,k2,ki,countLow1,countHigh1,shift,shift1,cPoint=0;
//        
int timeFr1new;
//  
int countFr;
// ,         
int countBarEnd=0,TimeBarEnd;
// ,       
int numBar=0;
//  
int numOb;
// flagFrNew=true -          . =false -  .
bool flagFrNew=false;
//   
int perTF;
bool Demo;

int counted_bars;

//   ZigZag       Ensign
double ha[],la[],hi,li,si,sip,di,hm,lm,ham[],lam[],him,lim,lLast=0,hLast=0;
int fs=0,fsp,countBar;
int ai,aip,bi,bip,ai0,aip0,bi0,bip0;
datetime tai,tbi,taip,tbip,ti;
// fcount0 -       0  fcount0=true.
//    =false     
bool fh=false,fl=false,fcount0;

//      
int mFibo[]={0,0}, mPitch[]={0,0,0}, mFan[]={0,0}, mExpansion[]={0,0,0};
//bool mFiboAdv=false, mPitchAdv=false, mFanAdv=false, mExpansionAdv=false, mAdvanced=false;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string aa,aa1;
   int aa2;

   IndicatorBuffers(7);
 
   if (ExtStyleZZ) {SetIndexStyle(0,DRAW_SECTION);}
   else {SetIndexStyle(0,DRAW_ARROW); SetIndexArrow(0,159);}
     
   SetIndexBuffer(0,zz);
   SetIndexBuffer(5,zzL);
   SetIndexBuffer(6,zzH);
   SetIndexEmptyValue(0,0.0);
   SetIndexEmptyValue(1,0.0);
   SetIndexEmptyValue(2,0.0);
   SetIndexEmptyValue(3,0.0);
   SetIndexEmptyValue(4,0.0);
   SetIndexEmptyValue(5,0.0);
   SetIndexEmptyValue(6,0.0);
//   
   SetIndexStyle(1,DRAW_LINE,STYLE_DOT);
   SetIndexStyle(2,DRAW_LINE,STYLE_DOT); 
   SetIndexBuffer(1,ham);
   SetIndexBuffer(2,lam);
//  
   SetIndexStyle(3,DRAW_LINE,STYLE_DOT);
   SetIndexStyle(4,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(3,ha);
   SetIndexBuffer(4,la);
   if (ExtIndicator==1) if (minSize!=0) di=minSize*Point/2;
   if (ExtIndicator==2) {di=minSize*Point; countBar=minBars;}
   if (ExtIndicator==3) {countBar=minBars;}

   if (Point*10==1) cPoint=1;
      else if (Point*100==1) cPoint=2;
      else if (Point*1000==1) cPoint=3;
      else if (Point*10000==1) cPoint=4;
      else if (Point*100000==1) cPoint=5;

//     
   if (ExtDelta<=0) ExtDelta=0.001;
   if (ExtDelta>1) ExtDelta=0.999;

   if (ExtHidden<0) ExtHidden=0;
   if (ExtHidden>4) ExtHidden=4;
 
   if (ExtDeltaType<0) ExtDeltaType=0;
   if (ExtDeltaType>3) ExtDeltaType=3;

   if (ExtFractalEnd>0)
     {
      if (ExtFractalEnd<1) ExtFractalEnd=1;
     }

   if (ExtPitchforkStatic>4) ExtPitchforkStatic=4;
   if (ExtPitchforkDinamic>4) ExtPitchforkDinamic=4;

//--------------------------------------------
   if (ExtFiboStaticNum<2) ExtFiboStaticNum=2;
   
   if (ExtFiboFanNum<1) ExtFiboFanNum=1;

   if (ExtPitchforkStaticNum<3) ExtPitchforkStaticNum=3;
   
   if (ExtFiboExpansion<2) ExtFiboExpansion=0;
   
   if (ExtFiboStaticNum>9)
     {
      aa=DoubleToStr(ExtFiboStaticNum,0);
      aa1=StringSubstr(aa,0,1);
      mFibo[0]=StrToInteger(aa1);
      aa1=StringSubstr(aa,1,1);
      mFibo[1]=StrToInteger(aa1);
     }
   else
     {
      mFibo[0]=ExtFiboStaticNum;
      mFibo[1]=ExtFiboStaticNum-1;
     }

   if (ExtFiboFanNum>9)
     {
      aa=DoubleToStr(ExtFiboFanNum,0);
      aa1=StringSubstr(aa,0,1);
      mFan[0]=StrToInteger(aa1);
      aa1=StringSubstr(aa,1,1);
      mFan[1]=StrToInteger(aa1);
     }
   else
     {
      mFan[0]=ExtFiboFanNum;
      mFan[1]=ExtFiboFanNum-1;
     }

   if (ExtPitchforkStaticNum>99)
     {
      aa=DoubleToStr(ExtPitchforkStaticNum,0);
      aa1=StringSubstr(aa,0,1);
      mPitch[0]=StrToInteger(aa1);
      aa1=StringSubstr(aa,1,1);
      mPitch[1]=StrToInteger(aa1);
      aa1=StringSubstr(aa,2,1);
      mPitch[2]=StrToInteger(aa1);
     }
   else
     {
      mPitch[0]=ExtPitchforkStaticNum;
      mPitch[1]=ExtPitchforkStaticNum-1;
      mPitch[2]=ExtPitchforkStaticNum-2;
     }

   if (ExtFiboExpansion>0)
     {
      if (ExtFiboExpansion>99)
        {
         aa=DoubleToStr(ExtFiboExpansion,0);
         aa1=StringSubstr(aa,0,1);
         mExpansion[0]=StrToInteger(aa1);
         aa1=StringSubstr(aa,1,1);
         mExpansion[1]=StrToInteger(aa1);
         aa1=StringSubstr(aa,2,1);
         mExpansion[2]=StrToInteger(aa1);
        }
      else
        {
         mExpansion[0]=ExtFiboExpansion;
         mExpansion[1]=ExtFiboExpansion-1;
         mExpansion[2]=ExtFiboExpansion-2;
        }
     }

   if (ExtSave)
     {
      MathSrand(LocalTime());
      save=MathRand();
     }
   
   Comment("                                                                  ");
   perTF=Period();
   Demo=IsDemo();
   delete_objects1();
   return(0);
  }
//+------------------------------------------------------------------+
//| .       
//+------------------------------------------------------------------+
int deinit()
  {
   delete_objects1();
   ObjectDelete("fiboS" + ExtComplekt);ObjectDelete("fiboD" + ExtComplekt);
   ObjectDelete("fiboFanS" + ExtComplekt);ObjectDelete("fiboFanD" + ExtComplekt);
   ObjectDelete("RLineD" + ExtComplekt);ObjectDelete("RLineS" + ExtComplekt);
   ObjectDelete("pitchforkD" + ExtComplekt);ObjectDelete("pitchforkS" + ExtComplekt);
   ObjectDelete("pmedianaD" + ExtComplekt);ObjectDelete("pmedianaS" + ExtComplekt);
   ObjectDelete("1-2pmedianaD" + ExtComplekt);ObjectDelete("1-2pmedianaS" + ExtComplekt);
   ObjectDelete("fiboTime1" + ExtComplekt);ObjectDelete("fiboTime2" + ExtComplekt);
   ObjectDelete("fiboExpansion" + ExtComplekt);
   ObjectDelete("UTL" + ExtComplekt);ObjectDelete("LTL" + ExtComplekt);
   ObjectDelete("UWL" + ExtComplekt);ObjectDelete("LWL" + ExtComplekt);
   ObjectDelete("CL" + ExtComplekt);
//   ObjectDelete("PivotZoneS" + ExtComplekt);
   ObjectDelete("FanMedianaStatic" + ExtComplekt);ObjectDelete("FanMedianaDinamic" + ExtComplekt);
   ObjectDelete("FiboFan" + ExtComplekt);
   return(0);
  }
//********************************************************
// 
int start()
  {
   counted_bars=IndicatorCounted();
  
   if (perTF!=Period())
     {
      delete_objects1();  
      perTF=Period();
     }

   if (Demo!=IsDemo())
     {
      delete_objects1();  
      Demo=IsDemo();
      counted_bars=0;
     }

//-----------------------------------------
//
//     1.
//
//   . . 
//-----------------------------------------   
// zz[] - ,        ZigZag-a
// zzL[] -   
// zzH[] -   
//
//-----------------------------------------   
//
//     ,
//     .
//      ,
//    .
//
//   ,    .
//
//-----------------------------------------

if (ExtIndicator==0) ZigZag_();
if (ExtIndicator==1) ang_AZZ_();
if (ExtIndicator==2) Ensign_ZZ();
if (ExtIndicator==3) Ensign_ZZ();
if (ExtIndicator==4) ZigZag_tauber();
if(!chHL_PeakDet_or_vts) {i_vts(); i_vts1();}
//  
matriza();

if (infoTF) if (close_TF!=Close[0]) info_TF();

//-----------------------------------------
//   . .
//-----------------------------------------   

if (ExtHidden>0) //    . .
  {
//======================
//======================
//======================

//-----------------------------------------
//
//     2.
//
//   . .
//-----------------------------------------   

   if (Bars - counted_bars>2 || flagFrNew)
     {

      //     ,       
      if (countBarEnd==0)
        {
         if (ExtFractalEnd>0)
           {
            k=ExtFractalEnd;
            for (shift=0; shift<Bars && k>0; shift++) 
              { 
               if (zz[shift]>0 && zzH[shift]>0) {countBarEnd=shift; TimeBarEnd=Time[shift]; k--;}
              }
           }
         else 
           {
            countBarEnd=Bars-3;
            TimeBarEnd=Time[Bars-3];
           }
        }
      else
        {
         countBarEnd=iBarShift(Symbol(),Period(),TimeBarEnd); 
        }

     }
//-----------------------------------------
//   . .
//-----------------------------------------   


//-----------------------------------------
//
//     3.
//
//     , 
//  . .
//-----------------------------------------   
//     . .

if (Bars - counted_bars<3)
  {
   //     ,    
   for (shift1=0; shift1<Bars; shift1++) 
     {
      if (zz[shift1]>0.0 && (zzH[shift1]==zz[shift1] || zzL[shift1]==zz[shift1])) 
       {
        timeFr1new=Time[shift1];
        break;
       }
     }
   //  ,      .
   shift=iBarShift(Symbol(),Period(),afr[0]); 


   //    ZigZag
   if ((zzH[shift1]>0 && afrl[0]>0) || (zzL[shift1]>0 && afrh[0]>0))
     {
      ExtFiboStatic=false;
      ExtPitchforkStatic=0;
      ExtFiboExpansion=0;
      ExtFiboFanNum=0;
      
      if (ExtAlert)
       {
        Alert (Symbol(),"  ",Period(),"     ZigZag");
        PlaySound("alert.wav");
       }
     }

   //      ,   

   //   
   if (timeFr1new!=afr[0])
     {
      flagFrNew=true;
      if (shift>=shift1) numBar=shift; else  numBar=shift1;
      afrm=true;
     }

   //       
   if (afrh[0]>0 && zz[shift]==0.0)
     {
      flagFrNew=true;
      if (numBar<shift) numBar=shift;
      afrm=true;
     }
   //       
   if (afrl[0]>0 && zz[shift]==0.0)
     {
      flagFrNew=true;
      if (numBar<shift) numBar=shift;
      afrm=true;
     }


//-----------3    ,      . .

//============= 1  . .
if (afrh[0]-High[shift]!=0 && afrh[0]>0)
  {
   flagFrNew=true;
   numBar=0;
   delete_objects2(afr[0]);
   afrh[0]=High[shift];
   if (ExtFiboDinamic) screenFiboD();
   if (ExtPitchforkDinamic>0) screenPitchforkD();
   if (ExtFiboFanDinamic) screenFiboFanD();
   if (mFibo[1]==0 && ExtFiboStatic) screenFiboS();
   if (mPitch[2]==0 && ExtPitchforkStatic>0) screenPitchforkS();
   if (mExpansion[2]==0 && ExtFiboExpansion>0) FiboExpansion();
   if (mFan[1]==0 && ExtFiboFanNum>0 && ExtFiboFanColor>0) screenFiboFan();
  }
//============= 1  . .
//
//============= 1  . .
if (afrl[0]-Low[shift]!=0 && afrl[0]>0)
  {
   flagFrNew=true;
   numBar=0;
   delete_objects2(afr[0]);
   afrl[0]=Low[shift];
   if (ExtFiboDinamic) screenFiboD();
   if (ExtFiboFanDinamic) screenFiboFanD();
   if (mFibo[1]==0 && ExtFiboStatic) screenFiboS();
   if (ExtPitchforkDinamic>0) screenPitchforkD();
   if (mPitch[2]==0 && ExtPitchforkStatic>0) screenPitchforkS();
   if (mExpansion[2]==0 && ExtFiboExpansion>0) FiboExpansion();
   if (mFan[1]==0 && ExtFiboFanNum>0 && ExtFiboFanColor>0) screenFiboFan();
  }
//============= 1  . .
//-----------3    ,      . .


   //      ,    . .
   countBarEnd=iBarShift(Symbol(),Period(),TimeBarEnd); 
   for (k=0; k<5; k++)
     {

      //  .
      if (afrh[k]>0)
        {
         //  ,     
         shift=iBarShift(Symbol(),Period(),afr[k]); 
         if (zz[shift]==0)
           {
            flagFrNew=true;
            if (shift>numBar) numBar=shift;
            afrm=true;
            numHighPrim=shift; numHighLast=0;HighLast=0.0;
            for (k1=shift+1; k1<=countBarEnd; k1++)
              {
               if (zzH[k1]>0) 
                 {
                  HighLast=High[k1]; numHighLast=k1;

                  nameObj="" + ExtComplekt + "ph" + Time[numHighPrim] + "_" + Time[numHighLast];

                  numOb=ObjectFind(nameObj);
                  if (numOb>-1)
                    {
                     ObjectDelete(nameObj); 

                     nameObjtxt="" + ExtComplekt + "phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                     ObjectDelete(nameObjtxt);
                    }
                 }
              }

           }
        }
      
      //  .
      if (afrl[k]>0)
        {
         //  ,     
         shift=iBarShift(Symbol(),Period(),afr[k]); 
         if (zz[shift]==0)
           {
            flagFrNew=true;
            if (shift>numBar) numBar=shift;

            afrm=true;
            numLowPrim=shift; numLowLast=0;LowLast=10000000;
            for (k1=shift+1; k1<=countBarEnd; k1++)
              {
               if (zzL[k1]>0) 
                 {
                  LowLast=Low[k1]; numLowLast=k1;

                  nameObj="" + ExtComplekt + "pl" + Time[numLowPrim] + "_" + Time[numLowLast];

                  numOb=ObjectFind(nameObj);
                  if (numOb>-1)
                    {
                     ObjectDelete(nameObj); 

                     nameObjtxt="" + ExtComplekt + "pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                     ObjectDelete(nameObjtxt);
                    }
                 }
              }
           }
        }

     }
   //      ,    . .

   //  . .
   matriza ();
   //  . .

  }
//     . .
//-----------------------------------------
//     , 
//  . .
//-----------------------------------------   


  //   . .
  countFractal();
  //   . .

//-----------------------------------------
//
//     4.
//
//    . .
//-----------------------------------------   
if (Bars - counted_bars>2)
  {
//-----------1  . .
//+--------------------------------------------------------------------------+
//|        0.886   ZigZag-a
//|     
//+--------------------------------------------------------------------------+

   numLowPrim=0; numLowLast=0;
   numHighPrim=0; numHighLast=0;

   LowPrim=0.0; LowLast=0.0;
   HighPrim=0.0; HighLast=0.0;
   
   Angle=-100;
   
   if (flagFrNew) countFr=1;
   else countFr=ExtFractal;

   for (k=0; (k<Bars-1 && countHigh1>0 && countFr>0); k++)
     {
      if (zzL[k]>0.0 && LowPrim==0.0 && HighPrim>0 && zzL[k]==zz[k]) {LowPrim=zzL[k]; numLowPrim=k;}
      if (zzL[k]>0.0 && zzL[k]<LowPrim && HighPrim>0 && zzL[k]==zz[k]) {LowPrim=zzL[k]; numLowPrim=k;}
      if (zzH[k]>0.0 && zzH[k]==zz[k])
        {
         if (HighPrim>0) 
           {
            if (HighLast>0) 
              {
               HighLast=High[k]; numHighLast=k;
              }
            else {numHighLast=k; HighLast=High[k];}

            HL=High[numHighLast]-Low[numLowPrim];
            kj=(HighPrim-HighLast)*1000/(numHighLast-numHighPrim);
            if (HL>0 && (Angle>kj || Angle==-100))  //    
              {
               Angle=kj;
               //     
               HLp=High[numHighPrim]-Low[numLowPrim];
               k1=MathCeil((numHighPrim+numHighLast)/2);
               kj=HLp/HL;

               if (kj>0.14 && kj<=5)
                 {
                  //    ( ). %   
                  kk=kj;
                  k2=1;
                  if (!ExtFiboType)
                    {
                     if (ExtDeltaType==2) for (ki=0;ki<=9;ki++) {if (MathAbs((fi1[ki]-kj)/fi1[ki])<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=0;ki<=9;ki++) {if (MathAbs(fi1[ki]-kj)<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                    }
                  else
                    {
                     if (ExtDeltaType==2) for (ki=0;ki<=20;ki++) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=0;ki<=20;ki++) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                    }

                  if (k2<0)
                    //      0.886
                    {
                    if (ExtHidden!=4)
                      {
                       nameObj="" + ExtComplekt + "phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                       ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((High[numHighPrim]+High[numHighLast])/2));

                       if (kk==0.447 ||  kk==0.886 || kk==2.24 || kk==3.14 || kk==3.618) // Gartley
                         ObjectSetText(nameObj,fitxt[ki],ExtSizeTxt,"Arial", ExtGartley886);
                       else
                         if (!ExtFiboType)
                           {
                            ObjectSetText(nameObj, fitxt1[ki],ExtSizeTxt,"Arial",ExtPesavento);
                           }
                         else
                           {
                            ObjectSetText(nameObj, fitxt[ki],ExtSizeTxt,"Arial",ExtPesavento);
                           }
                      }
                     }
                  else
                    //   (   0.886)
                    {
                     if (ExtHidden==1 || ExtHidden==4)
                       {
                        nameObj="" + ExtComplekt + "phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                        ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((High[numHighPrim]+High[numHighLast])/2));
                        ObjectSetText(nameObj,""+DoubleToStr(kk,2),ExtSizeTxt,"Arial",ExtNotFibo);
                       }
                    }

                  if ((ExtHidden==2 && k2<0) || ExtHidden!=2)
                    {
                     nameObj="" + ExtComplekt + "ph" + Time[numHighPrim] + "_" + Time[numHighLast];

                     ObjectCreate(nameObj,OBJ_TREND,0,Time[numHighPrim],High[numHighPrim],Time[numHighLast],High[numHighLast]);
                     ObjectSet(nameObj,OBJPROP_RAY,false);
                     ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                     ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                     ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
                    }
                  if (ExtFiboZigZag) k=countBarEnd;
                 }
              }
           }
         else 
            {numHighPrim=k; HighPrim=High[k];}
        }
       //    
       if (k>countBarEnd) 
         {
          k=numHighPrim+1; countHigh1--; countFr--;
          numLowPrim=0; numLowLast=0;
          numHighPrim=0; numHighLast=0;

          LowPrim=0.0; LowLast=0.0;
          HighPrim=0.0; HighLast=0.0;
   
          Angle=-100;
         }
     }
//-----------1  . .

//-----------2  . .
//+-------------------------------------------------------------------------+
//|        0.886   ZigZag-a
//|     
//+-------------------------------------------------------------------------+

   numLowPrim=0; numLowLast=0;
   numHighPrim=0; numHighLast=0;

   LowPrim=0.0; LowLast=0.0;
   HighPrim=0.0; HighLast=0.0;
   
   Angle=-100;

   if (flagFrNew) countFr=1;
   else countFr=ExtFractal;

   for (k=0; (k<Bars-1 && countLow1>0 && countFr>0); k++)
     {
      if (zzH[k]>HighPrim && LowPrim>0) {HighPrim=High[k]; numHighPrim=k;}
      if (zzL[k]>0.0 && zzL[k]==zz[k]) 
        {
         if (LowPrim>0) 
           {
            if (LowLast>0) 
              {
               LowLast=Low[k]; numLowLast=k;
              }
            else {numLowLast=k; LowLast=Low[k];}

            //      ( )
            HL=High[numHighPrim]-Low[numLowLast];
            kj=(LowPrim-LowLast)*1000/(numLowLast-numLowPrim);
            if (HL>0 && (Angle<kj || Angle==-100))  //    
              {
               Angle=kj;

               HLp=High[numHighPrim]-Low[numLowPrim];
               k1=MathCeil((numLowPrim+numLowLast)/2);
               kj=HLp/HL;

               if ( kj>0.14 && kj<=5)
                 {
                  //    ( ). %   
                  kk=kj;
                  k2=1;

                  if (!ExtFiboType)
                    {
                     if (ExtDeltaType==2) for (ki=0;ki<=9;ki++) {if (MathAbs((fi1[ki]-kj)/fi1[ki])<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=0;ki<=9;ki++) {if (MathAbs(fi1[ki]-kj)<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                    }
                  else
                    {
                     if (ExtDeltaType==2) for (ki=0;ki<=20;ki++) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=0;ki<=20;ki++) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                    }

                  if (k2<0)
                  //      0.886
                    {
                     if (ExtHidden!=4)                  
                       {
                        nameObj="" + ExtComplekt + "pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                        ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((Low[numLowPrim]+Low[numLowLast])/2));
                        if (kk==0.447 ||  kk==0.886 || kk==2.24 || kk==3.14 || kk==3.618) // Gartley
                          ObjectSetText(nameObj,fitxt[ki],ExtSizeTxt,"Arial", ExtGartley886);
                        else
                          if (!ExtFiboType)
                            {
                             ObjectSetText(nameObj, fitxt1[ki],ExtSizeTxt,"Arial",ExtPesavento);
                            }
                          else
                            {
                             ObjectSetText(nameObj, fitxt[ki],ExtSizeTxt,"Arial",ExtPesavento);
                            }
                       }
                    }
                  else 
                    //   (   0.886)
                    { 
                     if (ExtHidden==1 || ExtHidden==4)
                       {
                        nameObj="" + ExtComplekt + "pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                        ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((Low[numLowPrim]+Low[numLowLast])/2));
                        ObjectSetText(nameObj,""+DoubleToStr(kk,2),ExtSizeTxt,"Arial",ExtNotFibo);
                       }
                     }
                     
                   if ((ExtHidden==2 && k2<0) || ExtHidden!=2)
                     {
                      nameObj="" + ExtComplekt + "pl" + Time[numLowPrim] + "_" + Time[numLowLast];

                      ObjectCreate(nameObj,OBJ_TREND,0,Time[numLowPrim],Low[numLowPrim],Time[numLowLast],Low[numLowLast]);
                      ObjectSet(nameObj,OBJPROP_RAY,false);
                      ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                      ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
                     }
                   if (ExtFiboZigZag) k=countBarEnd;
                  }
               }
           }
         else {numLowPrim=k; LowPrim=Low[k];}
        }
       //    
       if (k>countBarEnd) 
         {
          k=numLowPrim+1; countLow1--; countFr--;

          numLowPrim=0; numLowLast=0;
          numHighPrim=0; numHighLast=0;

          LowPrim=0.0; LowLast=0.0;
          HighPrim=0.0; HighLast=0.0;
  
          Angle=-100;
         }
     }

//-----------2  . .

  }
//-----------------------------------------
//    . .
//-----------------------------------------   

//======================
//======================
//======================
  } //    . .
// 
  } // start



//----------------------------------------------------
//    
//----------------------------------------------------

//--------------------------------------------------------
//   .   . .
//--------------------------------------------------------
void countFractal()
  {
   int shift;
   countLow1=0;
   countHigh1=0;
   if (flagFrNew)
     {
      for(shift=0; shift<=numBar; shift++)
        {
         if (zzL[shift]>0.0) {countLow1++;}
         if (zzH[shift]>0.0) {countHigh1++;}    
        }
      flagFrNew=false;
      numBar=0;  
      counted_bars=Bars-4;
     }
   else
     {
      for(shift=0; shift<=countBarEnd; shift++)
        {
         if (zzL[shift]>0.0) {countLow1++;}
         if (zzH[shift]>0.0) {countHigh1++;}
        }
     }
  }
//--------------------------------------------------------
//   .   . .
//--------------------------------------------------------

//--------------------------------------------------------
//  . .
//
//      .
//       ZigZag-a.
//
//         ,
//  ...
//------------------------------------------------------
void matriza()
  {
   if (afrm)
     {
      afrm=false;
      int shift,k;
      
      k=0;
      for (shift=0; shift<Bars && k<10; shift++)
        {
         if (zz[shift]>0)
           {
            afr[k]=Time[shift];
            if (zz[shift]==zzL[shift]) {afrl[k]=Low[shift]; afrh[k]=0.0;}
            if (zz[shift]==zzH[shift]) {afrh[k]=High[shift]; afrl[k]=0.0;}
            k++;
           }
        }

      //   
      if (ExtPitchforkStatic>0)
        {
         if (mPitch[2]>0) {screenPitchforkS(); ExtPitchforkStatic=0;}
         if (mPitch[2]==0) screenPitchforkS();
        }
      if (ExtPitchforkDinamic>0) {screenPitchforkD();}

      //     .
      if (ExtFiboStatic)
        {
         if (mFibo[1]>0) {ExtFiboStatic=false; screenFiboS();}
         if (mFibo[1]==0) screenFiboS();
        }
      if (ExtFiboDinamic) {screenFiboD();}

      //  
      if (ExtFiboExpansion>0)
        {
         if (mExpansion[2]>0) {FiboExpansion(); ExtFiboExpansion=0;}
         if (mExpansion[2]==0) FiboExpansion();
        }

      //  
      if (ExtFiboFanDinamic) screenFiboFanD();

      if (ExtFiboFanNum>0 && ExtFiboFanColor>0)
        {
         if (mFan[1]>0) {screenFiboFan(); ExtFiboFanNum=0;}
         if (mFan[1]==0) screenFiboFan();
        }
      
      ExtSave=false;
     }
  }
//--------------------------------------------------------
//  . .
//--------------------------------------------------------

//--------------------------------------------------------
//    . .
//--------------------------------------------------------
void screenPitchforkS()
  {
   int k1,n,nbase1,nbase2;
   double a1,b1,c1,ab1,bc1,ab2,bc2,d,n1,cl1,ch1;
   datetime ta1,tb1,tc1,tab2,tbc2,tcl1,tch1;
   bool fo1=false,fo2=false;
   int    pitch_time[]={0,0,0}; 
   double pitch_cena[]={0,0,0};
   int    TLine_time[]={0,0,0};
   double TLine[]={0,0,0};
   int  m1,m2;

   if (ExtFiboFanStatic) {ExtFiboFanStatic=false;screenFiboFanS();}
 
   if (ExtPitchforkStatic>0)
     {
      n=(iBarShift(Symbol(),Period(),afr[mPitch[0]])+iBarShift(Symbol(),Period(),afr[mPitch[1]]))/2.0;
      k1=MathCeil(n);
      if (n<k1) fo1=true;
      tab2=Time[k1];

      n=(iBarShift(Symbol(),Period(),afr[mPitch[1]])+iBarShift(Symbol(),Period(),afr[mPitch[2]]))/2.0;
      k1=MathCeil(n);
      if (n<k1) fo2=true;
      tbc2=Time[k1];

      n=iBarShift(Symbol(),Period(),afr[mPitch[0]])-iBarShift(Symbol(),Period(),afr[mPitch[2]]);

      nameObj="pmedianaS" + ExtComplekt;
      ObjectDelete(nameObj);

      if (mPitch[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }

      if (afrl[mPitch[0]]>0)
        {
         d=(afrl[mPitch[2]]-afrl[mPitch[0]])/4/n;
         ab1=(afrl[mPitch[0]]+afrh[mPitch[1]])/2;
         if (fo1) {fo1=false; ab1=ab1+d;}
         bc1=(afrh[mPitch[1]]+afrl[mPitch[2]])/2;
         if (fo2) {fo2=false; bc1=bc1+d;}
        }
      else
        {
         d=(afrh[mPitch[2]]-afrh[mPitch[0]])/4/n;
         ab1=(afrh[mPitch[0]]+afrl[mPitch[1]])/2;
         if (fo1) {fo1=false; ab1=ab1+d;}
         bc1=(afrl[mPitch[1]]+afrh[mPitch[2]])/2;
         if (fo2) {fo2=false; bc1=bc1+d;}
        }

      pitch_time[0]=tab2;pitch_cena[0]=ab1;

      if (ExtPitchforkStatic==2)
        {
         ObjectCreate(nameObj,OBJ_TREND,0,tab2,ab1,tbc2,bc1);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DASH);
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         nameObj="1-2pmedianaS" + ExtComplekt;
         ObjectDelete(nameObj);
         ObjectCreate(nameObj,OBJ_TEXT,0,tab2,ab1+3*Point);
         ObjectSetText(nameObj,"     1/2 ML",9,"Arial", ExtLinePitchforkS);
        }   
     }

   nameObj="pitchforkS" + ExtComplekt;
   if (mPitch[2]>0)
     {
      if (ExtSave)
        {
         nameObj=nameObj + save;
        }
     }

   ObjectDelete(nameObj);

   if (afrl[mPitch[0]]>0)
     {
      if (ExtPitchforkStatic!=4)
        {
         pitch_time[0]=afr[mPitch[0]];pitch_cena[0]=afrl[mPitch[0]];
         if (ExtPitchforkStatic==3) pitch_cena[0]=ab1;
        }
      pitch_time[1]=afr[mPitch[1]];pitch_cena[1]=afrh[mPitch[1]];
      pitch_time[2]=afr[mPitch[2]];pitch_cena[2]=afrl[mPitch[2]];
     }
   else
     {
      if (ExtPitchforkStatic!=4)
        {
         pitch_time[0]=afr[mPitch[0]];pitch_cena[0]=afrh[mPitch[0]];
         if (ExtPitchforkStatic==3) pitch_cena[0]=ab1;
        }
      pitch_time[1]=afr[mPitch[1]];pitch_cena[1]=afrl[mPitch[1]];
      pitch_time[2]=afr[mPitch[2]];pitch_cena[2]=afrh[mPitch[2]];
     }

   ObjectCreate(nameObj,OBJ_PITCHFORK,0,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1],pitch_time[2],pitch_cena[2]);
   ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
   ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboFanMedianaStaticColor>0)
     {
      ta1=pitch_time[0];
      a1=pitch_cena[0];
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;
      m1=iBarShift(Symbol(),Period(),pitch_time[0]);
      tb1=Time[0];
      b1=pitch_cena[0]-d*(m1+1);

      nameObj="FanMedianaStatic" + ExtComplekt;
/*
      if (mPitch[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }
*/
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_FIBOFAN,0,ta1,a1,tb1,b1);
      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanMedianaStaticColor);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      screenFibo();

     }

   if (ExtUTL)
     {
      nameObj="UTL" + ExtComplekt;
      if (mPitch[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }

      ObjectDelete(nameObj);
      if (pitch_cena[1]>pitch_cena[2])
        {
         ObjectCreate(nameObj,OBJ_TREND,0,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1]);
        }
      else
        {
         ObjectCreate(nameObj,OBJ_TREND,0,pitch_time[0],pitch_cena[0],pitch_time[2],pitch_cena[2]);
        }
      ObjectSet(nameObj,OBJPROP_STYLE,STYLE_SOLID);
      ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
     }

   if (ExtLTL)
     {
      nameObj="LTL" + ExtComplekt;
      if (mPitch[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }

      ObjectDelete(nameObj);
      if (pitch_cena[1]>pitch_cena[2])
        {
         ObjectCreate(nameObj,OBJ_TREND,0,pitch_time[0],pitch_cena[0],pitch_time[2],pitch_cena[2]);
        }
      else
        {
         ObjectCreate(nameObj,OBJ_TREND,0,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1]);
        }
      ObjectSet(nameObj,OBJPROP_STYLE,STYLE_SOLID);
      ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
     }
/*
   if (ExtPivotZoneColor>0)
     {
      ta1=pitch_time[2];
      a1=pitch_cena[2];
      m1=iBarShift(Symbol(),Period(),pitch_time[0])-iBarShift(Symbol(),Period(),pitch_time[1]);
      m2=iBarShift(Symbol(),Period(),pitch_time[1])-iBarShift(Symbol(),Period(),pitch_time[2]);
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;

      if (m1>m2)
        {
         tb1=Time[iBarShift(Symbol(),Period(),pitch_time[2])-m1+1];
         b1=pitch_cena[0]-d*(2*m1+m2);
        }
      else
        {
         tb1=Time[iBarShift(Symbol(),Period(),pitch_time[2])-m2+1];
         b1=pitch_cena[0]-d*(2*m2+m1);
        }

      nameObj="PivotZoneS" + ExtComplekt;
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_RECTANGLE,0,ta1,a1,tb1,b1);
      ObjectSet(nameObj, OBJPROP_BACK, true);
      ObjectSet(nameObj, OBJPROP_COLOR, ExtPivotZoneColor); 
     }
*/
   if (ExtUWL || ExtLWL)
     {
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      ta1=pitch_time[0];
      tb1=pitch_time[2];
      a1=pitch_cena[0];
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;
      n1=(iBarShift(Symbol(),Period(),pitch_time[1])-iBarShift(Symbol(),Period(),pitch_time[2]))/2.0+1;
      b1=(pitch_cena[1]+pitch_cena[2])/2.0-d*n1;
      if (pitch_cena[1]>pitch_cena[2])
        {
         if (ExtUWL)
           {
            ch1=pitch_cena[1];
            tch1=pitch_time[1];
           }
         if (ExtLWL)
           {
            cl1=pitch_cena[2];
            tcl1=pitch_time[2];
           }
        }
      else
        {
         if (ExtUWL)
           {
            ch1=pitch_cena[2];
            tch1=pitch_time[2];
           }
         if (ExtLWL)
           {
            cl1=pitch_cena[1];
            tcl1=pitch_time[1];
           }
        }
      if (fo2) {fo2=false; b1=b1+d;}

      if (ExtUWL)
        {
         nameObj="UWL" + ExtComplekt;
         if (mPitch[2]>0)
           {
            if (ExtSave)
              {
               nameObj=nameObj + save;
              }
           }
  
         ObjectDelete(nameObj);

         ObjectCreate(nameObj,OBJ_FIBOCHANNEL,0,ta1,a1,tb1,b1,tch1,ch1);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkS);
         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,5);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.618);
         ObjectSetFiboDescription(nameObj, 0, "U W L 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
         ObjectSetFiboDescription(nameObj, 1, "U W L 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.618);
         ObjectSetFiboDescription(nameObj, 2, "U W L 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,2.0);
         ObjectSetFiboDescription(nameObj, 3, "U W L 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,2.618);
         ObjectSetFiboDescription(nameObj, 4, "U W L 261.8"); 
        }

      if (ExtLWL)
        {
         nameObj="LWL" + ExtComplekt;
         if (mPitch[2]>0)
           {
            if (ExtSave)
              {
               nameObj=nameObj + save;
              }
           }

         ObjectDelete(nameObj);

         ObjectCreate(nameObj,OBJ_FIBOCHANNEL,0,ta1,a1,tb1,b1,tcl1,cl1);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkS);
         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,5);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.618);
         ObjectSetFiboDescription(nameObj, 0, "L W L 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
         ObjectSetFiboDescription(nameObj, 1, "L W L 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.618);
         ObjectSetFiboDescription(nameObj, 2, "L W L 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,2.0);
         ObjectSetFiboDescription(nameObj, 3, "L W L 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,2.618);
         ObjectSetFiboDescription(nameObj, 4, "L W L 261.8"); 
        }

     }


//      if (ExtPitchforkStaticColor!=CLR_NONE && ExtPitchforkStaticColor!=-16777216)
   if (ExtPitchforkStaticColor>0)
     {
      n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),afr[mPitch[1]])+iBarShift(Symbol(),Period(),afr[mPitch[2]]))/2.0;
      nbase1=iBarShift(Symbol(),Period(),afr[mPitch[1]]);
      nameObj="1L" + ExtComplekt;

      ta1=Time[nbase1+n];
      tc1=afr[mPitch[1]];
      TLine_time[0]=afr[mPitch[1]];
      TLine_time[2]=afr[mPitch[2]];
      if (afrh[mPitch[1]]>0)
        {
         a1=(pitch_cena[0]-(afrh[mPitch[1]]+afrl[mPitch[2]])/2)+afrh[mPitch[1]];
         c1=afrh[mPitch[1]];
         ObjectCreate(nameObj,OBJ_TREND,0,ta1,a1,tc1,c1);

         TLine[0]=afrh[mPitch[1]];
         TLine_time[1]=iTime(NULL, 0, 1);
         TLine[1]=ObjectGetValueByShift(nameObj, 1);
         TLine[2]=afrl[mPitch[2]];
         ObjectDelete(nameObj);
        }
      else
        {
         a1=pitch_cena[0]-(afrl[mPitch[1]]+afrh[mPitch[2]])/2+afrl[mPitch[1]];
         c1=afrl[mPitch[1]];
         ObjectCreate(nameObj,OBJ_TREND,0,ta1,a1,tc1,c1);

         TLine[0]=afrl[mPitch[1]];
         TLine_time[1]=iTime(NULL, 0, 1); 
         TLine[1]=ObjectGetValueByShift(nameObj, 1);
         TLine[2]=afrh[mPitch[2]];
         ObjectDelete(nameObj);
        }

      nameObj="CL" + ExtComplekt;
/*
      if (mPitch[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }
*/
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_CHANNEL,0,TLine_time[0],TLine[0],TLine_time[1],TLine[1],TLine_time[2],TLine[2]);
      ObjectSet(nameObj, OBJPROP_BACK, true);
      ObjectSet(nameObj, OBJPROP_COLOR, ExtPitchforkStaticColor); 
     }

   if (ExtRLine)
     {

      n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),afr[mPitch[1]])+iBarShift(Symbol(),Period(),afr[mPitch[2]]))/2.0;

      nbase1=iBarShift(Symbol(),Period(),afr[mPitch[1]]);
      nbase2=iBarShift(Symbol(),Period(),afr[mPitch[2]]);
      tc1=afr[mPitch[1]];
      ta1=Time[nbase1+n];
      tb1=Time[nbase2+n];

      if (afrh[mPitch[1]]>0)
        {
         c1=afrh[mPitch[1]];
         a1=(pitch_cena[0]-(afrh[mPitch[1]]+afrl[mPitch[2]])/2)+afrh[mPitch[1]];
         b1=(pitch_cena[0]-(afrh[mPitch[1]]+afrl[mPitch[2]])/2)+afrl[mPitch[2]];
        }
      else
        {
         c1=afrl[mPitch[1]];
         a1=pitch_cena[0]-(afrl[mPitch[1]]+afrh[mPitch[2]])/2+afrl[mPitch[1]];
         b1=pitch_cena[0]-(afrl[mPitch[1]]+afrh[mPitch[2]])/2+afrh[mPitch[2]];
        }

      nameObj="RLineS" + ExtComplekt;
      if (mPitch[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }

      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_FIBOCHANNEL,0,ta1,a1,tb1,b1,tc1,c1);

      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkS);

      if (ExtRLineBase) 
        {
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
        }

      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
      ObjectSet(nameObj,OBJPROP_RAY,false);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      if (ExtFiboType)
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,15);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSetFiboDescription(nameObj, 0, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSetFiboDescription(nameObj, 1, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSetFiboDescription(nameObj, 2, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSetFiboDescription(nameObj, 3, " RL 70.7"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSetFiboDescription(nameObj, 4, " RL 78.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.886);
         ObjectSetFiboDescription(nameObj, 5, " RL 88.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.128);
         ObjectSetFiboDescription(nameObj, 7, " RL 112.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.272);
         ObjectSetFiboDescription(nameObj, 8, " RL 127.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.414);
         ObjectSetFiboDescription(nameObj, 9, " RL 141.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.618);
         ObjectSetFiboDescription(nameObj, 10, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.0);
         ObjectSetFiboDescription(nameObj, 11, " RL 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,2.414);
         ObjectSetFiboDescription(nameObj, 12, " RL 241.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.618);
         ObjectSetFiboDescription(nameObj, 13, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,4.0);
         ObjectSetFiboDescription(nameObj, 14, " RL 400.0"); 

        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,10);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSetFiboDescription(nameObj, 0, " RL 23.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSetFiboDescription(nameObj, 1, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSetFiboDescription(nameObj, 2, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSetFiboDescription(nameObj, 3, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSetFiboDescription(nameObj, 4, " RL 76.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.0);
         ObjectSetFiboDescription(nameObj, 5, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.618);
         ObjectSetFiboDescription(nameObj, 6, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
         ObjectSetFiboDescription(nameObj, 7, " RL 200"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
         ObjectSetFiboDescription(nameObj, 8, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,4.0);
         ObjectSetFiboDescription(nameObj, 9, " RL 400.0"); 
        }
     }

      //   
      if (ExtFiboTime1)
        {
         nameObj="fiboTime1" + ExtComplekt;
         if (mPitch[2]>0)
           {
            if (ExtSave)
              {
               nameObj=nameObj + save;
              }
           }

         ObjectDelete(nameObj);

         if (afrl[mPitch[0]]>0)
           {
            if (afrl[mPitch[0]]>afrl[mPitch[2]])
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,0,afr[mPitch[0]],afrl[mPitch[2]]-5*Point,afr[mPitch[2]],afrl[mPitch[2]]-5*Point);
              }
            else
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,0,afr[mPitch[0]],afrl[mPitch[0]]-5*Point,afr[mPitch[2]],afrl[mPitch[0]]-5*Point);
              }
           }
         else
           {
            ObjectCreate(nameObj,OBJ_FIBOTIMES,0,afr[mPitch[0]],afrl[mPitch[1]]-5*Point,afr[mPitch[2]],afrl[mPitch[1]]-5*Point);
           }

         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboTime1C);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         if (ExtFiboType)
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.382);
            ObjectSetFiboDescription(nameObj, 2, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.5);
            ObjectSetFiboDescription(nameObj, 3, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.618);
            ObjectSetFiboDescription(nameObj, 4, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.707);
            ObjectSetFiboDescription(nameObj, 5, "Ft .707"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.786);
            ObjectSetFiboDescription(nameObj, 6, "Ft .786"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.841);
            ObjectSetFiboDescription(nameObj, 7, "Ft .841"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.0);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.272);
            ObjectSetFiboDescription(nameObj, 9, "Ft 1.272"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.414);
            ObjectSetFiboDescription(nameObj, 10, "Ft 1.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
            ObjectSetFiboDescription(nameObj, 11, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,3.0);
            ObjectSetFiboDescription(nameObj, 12, "Ft 2."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,3.414);
            ObjectSetFiboDescription(nameObj, 13, "Ft 2.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,3.618);
            ObjectSetFiboDescription(nameObj, 15, "Ft 2.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,4.0);
            ObjectSetFiboDescription(nameObj, 16, "Ft 3."); 

           }
         else
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,11);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.236);
            ObjectSetFiboDescription(nameObj, 2, "Ft .236"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.382);
            ObjectSetFiboDescription(nameObj, 3, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.5);
            ObjectSetFiboDescription(nameObj, 4, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.618);
            ObjectSetFiboDescription(nameObj, 5, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.764);
            ObjectSetFiboDescription(nameObj, 6, "Ft .764"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
            ObjectSetFiboDescription(nameObj, 7, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,3.0);
            ObjectSetFiboDescription(nameObj, 9, "Ft 3."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
            ObjectSetFiboDescription(nameObj, 10, "Ft 2.618"); 
           }

        }

      if (ExtFiboTime2)
        {
         nameObj="fiboTime2" + ExtComplekt;
         if (mPitch[2]>0)
           {
            if (ExtSave)
              {
               nameObj=nameObj + save;
              }
           }

         ObjectDelete(nameObj);

         if (afrl[mPitch[1]]>0)
           {
            ObjectCreate(nameObj,OBJ_FIBOTIMES,0,afr[mPitch[1]],afrl[mPitch[1]]-8*Point,afr[mPitch[2]],afrl[mPitch[1]]-8*Point);
           }
         else
           {
            ObjectCreate(nameObj,OBJ_FIBOTIMES,0,afr[mPitch[1]],afrl[mPitch[2]]-8*Point,afr[mPitch[2]],afrl[mPitch[2]]-8*Point);
           }

         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboTime2C);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         if (ExtFiboType)
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.382);
            ObjectSetFiboDescription(nameObj, 2, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.5);
            ObjectSetFiboDescription(nameObj, 3, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.618);
            ObjectSetFiboDescription(nameObj, 4, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.707);
            ObjectSetFiboDescription(nameObj, 5, "Ft .707"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.786);
            ObjectSetFiboDescription(nameObj, 6, "Ft .786"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.841);
            ObjectSetFiboDescription(nameObj, 7, "Ft .841"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.0);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.272);
            ObjectSetFiboDescription(nameObj, 9, "Ft 1.272"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.414);
            ObjectSetFiboDescription(nameObj, 10, "Ft 1.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
            ObjectSetFiboDescription(nameObj, 11, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,3.0);
            ObjectSetFiboDescription(nameObj, 12, "Ft 2."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,3.414);
            ObjectSetFiboDescription(nameObj, 13, "Ft 2.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,3.618);
            ObjectSetFiboDescription(nameObj, 15, "Ft 2.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,4.0);
            ObjectSetFiboDescription(nameObj, 16, "Ft 3."); 

           }
         else
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,11);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.236);
            ObjectSetFiboDescription(nameObj, 2, "Ft .236"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.382);
            ObjectSetFiboDescription(nameObj, 3, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.5);
            ObjectSetFiboDescription(nameObj, 4, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.618);
            ObjectSetFiboDescription(nameObj, 5, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.764);
            ObjectSetFiboDescription(nameObj, 6, "Ft .764"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
            ObjectSetFiboDescription(nameObj, 7, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,3.0);
            ObjectSetFiboDescription(nameObj, 9, "Ft 3."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
            ObjectSetFiboDescription(nameObj, 10, "Ft 2.618"); 
           }
        }

  }
//--------------------------------------------------------
//    . .
//--------------------------------------------------------

//--------------------------------------------------------
//    . .
//--------------------------------------------------------
void screenPitchforkD()
  {
   int k1,n,nbase1,nbase2;
   double a1,b1,c1,ab1,bc1,ab2,bc2,d,n1;
   datetime ta1,tb1,tc1,tab2,tbc2;
   bool fo1=false,fo2=false;
   int    pitch_time[]={0,0,0}; 
   double pitch_cena[]={0,0,0};
   int m1,m2;

   if (ExtPitchforkDinamic>0)
     {
      n=(iBarShift(Symbol(),Period(),afr[2])+iBarShift(Symbol(),Period(),afr[1]))/2.0;
      k1=MathCeil(n);
      if (n<k1) fo1=true;
      tab2=Time[k1];

      n=(iBarShift(Symbol(),Period(),afr[1])+iBarShift(Symbol(),Period(),afr[0]))/2.0;
      k1=MathCeil(n);
      if (n<k1) fo2=true;
      tbc2=Time[k1];

      n=iBarShift(Symbol(),Period(),afr[2])-iBarShift(Symbol(),Period(),afr[0]);

//            nameObj="pm" + Period() + "_" + afr[3];
      nameObj="pmedianaD" + ExtComplekt;
      ObjectDelete(nameObj);

      if (afrl[2]>0)
        {
         d=(afrl[0]-afrl[2])/4/n;
         ab1=(afrl[2]+afrh[1])/2;
         if (fo1) {fo1=false; ab1=ab1+d;}
         bc1=(afrh[1]+afrl[0])/2;
         if (fo2) {fo2=false; bc1=bc1+d;}
        }
      else
        {
         d=(afrh[0]-afrh[2])/4/n;
         ab1=(afrh[2]+afrl[1])/2;
         if (fo1) {fo1=false; ab1=ab1+d;}
         bc1=(afrl[1]+afrh[0])/2;
         if (fo2) {fo2=false; bc1=bc1+d;}
        }

      pitch_time[0]=tab2;pitch_cena[0]=ab1;

      if (ExtPitchforkDinamic==2)
        {
         ObjectCreate(nameObj,OBJ_TREND,0,tab2,ab1,tbc2,bc1);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DASH);
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkD);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         nameObj="1-2pmedianaD" + ExtComplekt;
         ObjectDelete(nameObj);
         ObjectCreate(nameObj,OBJ_TEXT,0,tab2,ab1+3*Point);
         ObjectSetText(nameObj,"     1/2 ML",9,"Arial", ExtLinePitchforkD);
        }
     }

//         nameObj="pf" + Period() + "_" + afr[2];
   nameObj="pitchforkD" + ExtComplekt;
   ObjectDelete(nameObj);

   if (afrl[2]>0)
     {
      if (ExtPitchforkDinamic!=4)
        {
         pitch_time[0]=afr[2];pitch_cena[0]=afrl[2];
         if (ExtPitchforkDinamic==3) pitch_cena[0]=ab1;
        }
      pitch_time[1]=afr[1];pitch_cena[1]=afrh[1];
      pitch_time[2]=afr[0];pitch_cena[2]=afrl[0];
     }
   else
     {
      if (ExtPitchforkDinamic!=4)
        {
         pitch_time[0]=afr[2];pitch_cena[0]=afrh[2];
         if (ExtPitchforkDinamic==3) pitch_cena[0]=ab1;
        }
      pitch_time[1]=afr[1];pitch_cena[1]=afrl[1];
      pitch_time[2]=afr[0];pitch_cena[2]=afrh[0];
     }

   ObjectCreate(nameObj,OBJ_PITCHFORK,0,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1],pitch_time[2],pitch_cena[2]);
   ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
   ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkD);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboFanMedianaDinamicColor>0)
     {
      ta1=pitch_time[0];
      a1=pitch_cena[0];
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;
      m1=iBarShift(Symbol(),Period(),pitch_time[0]);
      tb1=Time[0];
      b1=pitch_cena[0]-d*(m1+1);

      nameObj="FanMedianaDinamic" + ExtComplekt;
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_FIBOFAN,0,ta1,a1,tb1,b1);
      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanMedianaDinamicColor);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      screenFibo();
     }

   if (ExtRLine)
     {
      nameObj="RLineD" + ExtComplekt;
      ObjectDelete(nameObj);

      n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),afr[1])+iBarShift(Symbol(),Period(),afr[0]))/2.0;
   
      nbase1=iBarShift(Symbol(),Period(),afr[1]);
      nbase2=iBarShift(Symbol(),Period(),afr[0]);
      tc1=afr[1];
      ta1=Time[nbase1+n];
      tb1=Time[nbase2+n];

      if (afrh[1]>0)
        {
            //     
//            d=(afrl[2]-(afrh[1]+afrl[0])/2)/n;

         c1=afrh[1];
         a1=(pitch_cena[0]-(afrh[1]+afrl[0])/2)+afrh[1];
         b1=(pitch_cena[0]-(afrh[1]+afrl[0])/2)+afrl[0];
        }
      else
        {
            //     
//            d=(afrh[2]-(afrl[1]+afrh[0])/2)/n;

         c1=afrl[1];
         a1=pitch_cena[0]-(afrl[1]+afrh[0])/2+afrl[1];
         b1=pitch_cena[0]-(afrl[1]+afrh[0])/2+afrh[0];
        }

      ObjectCreate(nameObj,OBJ_FIBOCHANNEL,0,ta1,a1,tb1,b1,tc1,c1);

      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkD);

      if (ExtRLineBase) 
        {
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkD);
        }
 
      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
      ObjectSet(nameObj,OBJPROP_RAY,false);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      if (ExtFiboType)
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,15);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSetFiboDescription(nameObj, 0, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSetFiboDescription(nameObj, 1, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSetFiboDescription(nameObj, 2, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSetFiboDescription(nameObj, 3, " RL 70.7"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSetFiboDescription(nameObj, 4, " RL 78.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.841);
         ObjectSetFiboDescription(nameObj, 5, " RL 84.1"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.128);
         ObjectSetFiboDescription(nameObj, 7, " RL 112.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.272);
         ObjectSetFiboDescription(nameObj, 8, " RL 127.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.414);
         ObjectSetFiboDescription(nameObj, 9, " RL 141.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.618);
         ObjectSetFiboDescription(nameObj, 10, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.0);
         ObjectSetFiboDescription(nameObj, 11, " RL 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,2.414);
         ObjectSetFiboDescription(nameObj, 12, " RL 241.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.618);
         ObjectSetFiboDescription(nameObj, 13, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,4.0);
         ObjectSetFiboDescription(nameObj, 14, " RL 400.0"); 

        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,10);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSetFiboDescription(nameObj, 0, " RL 23.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSetFiboDescription(nameObj, 1, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSetFiboDescription(nameObj, 2, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSetFiboDescription(nameObj, 3, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSetFiboDescription(nameObj, 4, " RL 76.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.0);
         ObjectSetFiboDescription(nameObj, 5, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.618);
         ObjectSetFiboDescription(nameObj, 6, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
         ObjectSetFiboDescription(nameObj, 7, " RL 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
         ObjectSetFiboDescription(nameObj, 8, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,4.0);
         ObjectSetFiboDescription(nameObj, 9, " RL 400.0"); 
        }
     }
  }
//--------------------------------------------------------
//    . .
//--------------------------------------------------------

//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void screenFiboFan()
  {
   double a1,b1;  

   if (afrl[mFan[0]]>0)
     {
      a1=afrl[mFan[0]]; b1=afrh[mFan[1]];
     }
   else
     {
      a1=afrh[mFan[0]]; b1=afrl[mFan[1]];
     }
  
   nameObj="FiboFan" + ExtComplekt;
/*
      if (ExtSave)
        {
         nameObj=nameObj + save;
        }
*/
   ObjectDelete(nameObj);

   ObjectCreate(nameObj,OBJ_FIBOFAN,0,afr[mFan[0]],a1,afr[mFan[1]],b1);
   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanColor);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   screenFibo();
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//--------------------------------------------------------
void screenFibo()
  {
      if (!ExtFiboType)
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,18);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,-0.236);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,-0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,-0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,-0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,-0.764);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,-1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,-1.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,-2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+17,-2.618);

//         if (ExtFiboFanHidden)
//           {
            ObjectSetFiboDescription(nameObj, 0, "23.6"); 
            ObjectSetFiboDescription(nameObj, 1, "38.2"); 
            ObjectSetFiboDescription(nameObj, 2, "50.0"); 
            ObjectSetFiboDescription(nameObj, 3, "61.8"); 
            ObjectSetFiboDescription(nameObj, 4, "76.4"); 
            ObjectSetFiboDescription(nameObj, 5, "100.0"); 
            ObjectSetFiboDescription(nameObj, 6, "161.8"); 
            ObjectSetFiboDescription(nameObj, 7, "200.0"); 
            ObjectSetFiboDescription(nameObj, 8, "261.8"); 
            ObjectSetFiboDescription(nameObj, 9, "-23.6"); 
            ObjectSetFiboDescription(nameObj, 10, "-38.2"); 
            ObjectSetFiboDescription(nameObj, 11, "-50.0"); 
            ObjectSetFiboDescription(nameObj, 12, "-61.8"); 
            ObjectSetFiboDescription(nameObj, 13, "-76.4"); 
            ObjectSetFiboDescription(nameObj, 14, "-100.0"); 
            ObjectSetFiboDescription(nameObj, 15, "-161.8"); 
            ObjectSetFiboDescription(nameObj, 16, "-200.0"); 
            ObjectSetFiboDescription(nameObj, 17, "-261.8"); 
//           }
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,24);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.886);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.272);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.414);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,-0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,-0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,-0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,-0.707);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,-0.786);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+17,-0.886);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+18,-1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+19,-1.272);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+20,-1.414);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+21,-1.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+22,-2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+23,-2.618);

//         if (ExtFiboFanHidden)
//           {
            ObjectSetFiboDescription(nameObj, 0, "38.2"); 
            ObjectSetFiboDescription(nameObj, 1, "50.0"); 
            ObjectSetFiboDescription(nameObj, 2, "61.8"); 
            ObjectSetFiboDescription(nameObj, 3, "70.7"); 
            ObjectSetFiboDescription(nameObj, 4, "78.6"); 
            ObjectSetFiboDescription(nameObj, 5, "88.6"); 
            ObjectSetFiboDescription(nameObj, 6, "100.0"); 
            ObjectSetFiboDescription(nameObj, 7, "127.2"); 
            ObjectSetFiboDescription(nameObj, 8, "141.4"); 
            ObjectSetFiboDescription(nameObj, 9, "161.8"); 
            ObjectSetFiboDescription(nameObj, 10, "200.0"); 
            ObjectSetFiboDescription(nameObj, 11, "261.8"); 
            ObjectSetFiboDescription(nameObj, 12, "-38.2"); 
            ObjectSetFiboDescription(nameObj, 13, "-50.0"); 
            ObjectSetFiboDescription(nameObj, 14, "-61.8"); 
            ObjectSetFiboDescription(nameObj, 15, "-70.7"); 
            ObjectSetFiboDescription(nameObj, 16, "-78.6"); 
            ObjectSetFiboDescription(nameObj, 17, "-88.6"); 
            ObjectSetFiboDescription(nameObj, 18, "-100.0"); 
            ObjectSetFiboDescription(nameObj, 19, "-127.2"); 
            ObjectSetFiboDescription(nameObj, 20, "-141.4"); 
            ObjectSetFiboDescription(nameObj, 21, "-161.8"); 
            ObjectSetFiboDescription(nameObj, 22, "-200.0"); 
            ObjectSetFiboDescription(nameObj, 23, "-261.8"); 
//           }
        }
  }
//--------------------------------------------------------
//  . .
//--------------------------------------------------------


//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void screenFiboS()
  {
   double fibo_0, fibo_100, fiboPrice, fiboPrice1;

   nameObj="fiboS" + ExtComplekt;
   ObjectDelete(nameObj);
   if (afrl[mFibo[1]]>0) 
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrh[mFibo[0]];fibo_100=afrl[mFibo[1]];
         fiboPrice=afrh[mFibo[0]]-afrl[mFibo[1]];fiboPrice1=afrl[mFibo[1]];
        }
      else
        {
         fibo_100=afrh[mFibo[0]];fibo_0=afrl[mFibo[1]];
         fiboPrice=afrl[mFibo[1]]-afrh[mFibo[0]];fiboPrice1=afrh[mFibo[0]];
        }
     }
   else 
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrl[mFibo[0]];fibo_100=afrh[mFibo[1]];
         fiboPrice=afrl[mFibo[0]]-afrh[mFibo[1]];fiboPrice1=afrh[mFibo[1]];
        }
      else
        {
         fibo_100=afrl[mFibo[0]];fibo_0=afrh[mFibo[1]];
         fiboPrice=afrh[mFibo[1]]-afrl[mFibo[0]];fiboPrice1=afrl[mFibo[0]];
        }
     }

   if (!ExtFiboCorrectionExpansion)
     {
      ObjectCreate(nameObj,OBJ_FIBO,0,afr[mFibo[0]],fibo_0,afr[mFibo[1]],fibo_100);
     }
   else
     {
      ObjectCreate(nameObj,OBJ_FIBO,0,afr[mFibo[1]],fibo_0,afr[mFibo[0]],fibo_100);
     }
   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboS);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboType)
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);
      fibo_patterns(fiboPrice, fiboPrice1);
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,14);
      fibo_standart (fiboPrice, fiboPrice1);
     }
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------

//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void screenFiboD()
  {
   double fibo_0, fibo_100, fiboPrice, fiboPrice1;

   nameObj="fiboD" + ExtComplekt;

   ObjectDelete(nameObj);
   if (afrh[1]>0)
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrh[1];fibo_100=afrl[0];
         fiboPrice=afrh[1]-afrl[0];fiboPrice1=afrl[0];
        }
      else
        {
         fibo_100=afrh[1];fibo_0=afrl[0];
         fiboPrice=afrl[0]-afrh[1];fiboPrice1=afrh[1];
        }
     }
   else
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrl[1];fibo_100=afrh[0];
         fiboPrice=afrl[1]-afrh[0];fiboPrice1=afrh[0];
        }
      else
        {
         fibo_100=afrl[1];fibo_0=afrh[0];
         fiboPrice=afrh[0]-afrl[1];fiboPrice1=afrl[1];
        }
     }

   if (!ExtFiboCorrectionExpansion)
     {
      ObjectCreate(nameObj,OBJ_FIBO,0,afr[1],fibo_0,afr[0],fibo_100);
     }
   else
     {
      ObjectCreate(nameObj,OBJ_FIBO,0,afr[0],fibo_0,afr[1],fibo_100);
     }

   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboD);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboType)
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);
      fibo_patterns(fiboPrice, fiboPrice1);
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,14);
      fibo_standart (fiboPrice, fiboPrice1);
     }

  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void fibo_patterns(double fiboPrice,double fiboPrice1)
  {
   if (!ExtFiboCorrectionExpansion)
     {   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "0  -->  "+DoubleToStr(fiboPrice1, cPoint)); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
      ObjectSetFiboDescription(nameObj, 1, "38.2  -->  "+DoubleToStr(fiboPrice*0.382+fiboPrice1, cPoint)); 
    
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
      ObjectSetFiboDescription(nameObj, 2, "50.0  -->  "+DoubleToStr(fiboPrice*0.5+fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
      ObjectSetFiboDescription(nameObj, 3, "61.8  -->  "+DoubleToStr(fiboPrice*0.618+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.707);
      ObjectSetFiboDescription(nameObj, 4, "70.7  -->  "+DoubleToStr(fiboPrice*0.707+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.786);
      ObjectSetFiboDescription(nameObj, 5, "78.6  -->  "+DoubleToStr(fiboPrice*0.786+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,0.841);
      ObjectSetFiboDescription(nameObj, 6, "84.1  -->  "+DoubleToStr(fiboPrice*0.841+fiboPrice1, cPoint) ); 
 
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,0.886);
      ObjectSetFiboDescription(nameObj, 7, "88.6  -->  "+DoubleToStr(fiboPrice*0.886+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.0);
      ObjectSetFiboDescription(nameObj, 8, "100.0  -->  "+DoubleToStr(fiboPrice+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.128);
      ObjectSetFiboDescription(nameObj, 9, "112.8  -->  "+DoubleToStr(fiboPrice*1.128+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.272);
      ObjectSetFiboDescription(nameObj, 10, "127.2  -->  "+DoubleToStr(fiboPrice*1.272+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,1.414);
      ObjectSetFiboDescription(nameObj, 11, "141.4  -->  "+DoubleToStr(fiboPrice*1.414+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,1.618);
      ObjectSetFiboDescription(nameObj, 12, "161.8  -->  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.0);
      ObjectSetFiboDescription(nameObj, 13, "200.0  -->  "+DoubleToStr(fiboPrice*2.0+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,2.414);
      ObjectSetFiboDescription(nameObj, 14, "241.4  -->  "+DoubleToStr(fiboPrice*2.414+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,2.618);
      ObjectSetFiboDescription(nameObj, 15, "261.8  -->  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,4.0);
      ObjectSetFiboDescription(nameObj, 16, "400.0  -->  "+DoubleToStr(fiboPrice*4.0+fiboPrice1, cPoint) );
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "Fe 1  -->  "+DoubleToStr(fiboPrice+fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,1);
      ObjectSetFiboDescription(nameObj, 1, "Fe 0  -->  "+DoubleToStr(fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.382);
      ObjectSetFiboDescription(nameObj, 2, "Fe 38.2  -->  "+DoubleToStr(fiboPrice*1.382+fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.5);
      ObjectSetFiboDescription(nameObj, 3, "Fe 50.0  -->  "+DoubleToStr(fiboPrice*1.5+fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.618);
      ObjectSetFiboDescription(nameObj, 4, "Fe 61.8  -->  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.707);
      ObjectSetFiboDescription(nameObj, 5, "Fe 70.7  -->  "+DoubleToStr(fiboPrice*1.707+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.786);
      ObjectSetFiboDescription(nameObj, 6, "Fe 78.6  -->  "+DoubleToStr(fiboPrice*1.786+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.841);
      ObjectSetFiboDescription(nameObj, 7, "Fe 84.1  -->  "+DoubleToStr(fiboPrice*1.841+fiboPrice1, cPoint) ); 
 
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.886);
      ObjectSetFiboDescription(nameObj, 8, "Fe 88.6  -->  "+DoubleToStr(fiboPrice*1.886+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.0);
      ObjectSetFiboDescription(nameObj, 9, "Fe 100.0  -->  "+DoubleToStr(fiboPrice*2+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.128);
      ObjectSetFiboDescription(nameObj, 10, "Fe 112.8  -->  "+DoubleToStr(fiboPrice*2.128+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.272);
      ObjectSetFiboDescription(nameObj, 11, "Fe 127.2  -->  "+DoubleToStr(fiboPrice*2.272+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,2.414);
      ObjectSetFiboDescription(nameObj, 12, "Fe 141.4  -->  "+DoubleToStr(fiboPrice*2.414+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.618);
      ObjectSetFiboDescription(nameObj, 13, "Fe 161.8  -->  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, cPoint) ); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,3.0);
      ObjectSetFiboDescription(nameObj, 14, "Fe 200.0  -->  "+DoubleToStr(fiboPrice*3.0+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,3.414);
      ObjectSetFiboDescription(nameObj, 15, "Fe 241.4  -->  "+DoubleToStr(fiboPrice*3.414+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,3.618);
      ObjectSetFiboDescription(nameObj, 16, "Fe 261.8  -->  "+DoubleToStr(fiboPrice*3.618+fiboPrice1, cPoint) ); 
     }
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//--------------------------------------------------------
void fibo_standart(double fiboPrice,double fiboPrice1)
  {
   if (!ExtFiboCorrectionExpansion)
     {   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "0  -->  "+DoubleToStr(fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.146);
      ObjectSetFiboDescription(nameObj, 1, "14.6  -->  "+DoubleToStr(fiboPrice*0.146+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.236);
      ObjectSetFiboDescription(nameObj, 2, "23.6  -->  "+DoubleToStr(fiboPrice*0.236+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.382);
      ObjectSetFiboDescription(nameObj, 3, "38.2  -->  "+DoubleToStr(fiboPrice*0.382+fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.5);
      ObjectSetFiboDescription(nameObj, 4, "50.0  -->  "+DoubleToStr(fiboPrice*0.5+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.618);
      ObjectSetFiboDescription(nameObj, 5, "61.8  -->  "+DoubleToStr(fiboPrice*0.618+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,0.764);
      ObjectSetFiboDescription(nameObj, 6, "76.4  -->  "+DoubleToStr(fiboPrice*0.764+fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,0.854);
      ObjectSetFiboDescription(nameObj, 7, "85.4  -->  "+DoubleToStr(fiboPrice*0.854+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.0);
      ObjectSetFiboDescription(nameObj, 8, "100.0  -->  "+DoubleToStr(fiboPrice+fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.236);
      ObjectSetFiboDescription(nameObj, 9, "1.236  -->  "+DoubleToStr(fiboPrice*1.236+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.618);
      ObjectSetFiboDescription(nameObj, 10, "161.8  -->  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
      ObjectSetFiboDescription(nameObj, 11, "261.8  -->  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,4.236);
      ObjectSetFiboDescription(nameObj, 12, "423.6  -->  "+DoubleToStr(fiboPrice*4.236+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,6.854);
      ObjectSetFiboDescription(nameObj, 13, "685.4  -->  "+DoubleToStr(fiboPrice*6.854+fiboPrice1, cPoint) ); 
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "Fe 1  -->  "+DoubleToStr(fiboPrice+fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,1);
      ObjectSetFiboDescription(nameObj, 1, "Fe 0  -->  "+DoubleToStr(fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.236);
      ObjectSetFiboDescription(nameObj, 2, "Fe 23.6  -->  "+DoubleToStr(fiboPrice*1.236+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.382);
      ObjectSetFiboDescription(nameObj, 3, "Fe 38.2  -->  "+DoubleToStr(fiboPrice*1.382+fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.5);
      ObjectSetFiboDescription(nameObj, 4, "Fe 50.0  -->  "+DoubleToStr(fiboPrice*1.5+fiboPrice1, cPoint)); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.618);
      ObjectSetFiboDescription(nameObj, 5, "Fe 61.8  -->  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.764);
      ObjectSetFiboDescription(nameObj, 6, "Fe 76.4  -->  "+DoubleToStr(fiboPrice*1.764+fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.854);
      ObjectSetFiboDescription(nameObj, 7, "Fe 85.4  -->  "+DoubleToStr(fiboPrice*1.854+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.0);
      ObjectSetFiboDescription(nameObj, 8, "Fe 100.0  -->  "+DoubleToStr(fiboPrice*2+fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.236);
      ObjectSetFiboDescription(nameObj, 9, "Fe 1.236  -->  "+DoubleToStr(fiboPrice*2.236+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
      ObjectSetFiboDescription(nameObj, 10, "Fe 161.8  -->  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, cPoint) ); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,3.618);
      ObjectSetFiboDescription(nameObj, 11, "Fe 261.8  -->  "+DoubleToStr(fiboPrice*3.618+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,5.236);
      ObjectSetFiboDescription(nameObj, 12, "Fe 423.6  -->  "+DoubleToStr(fiboPrice*5.236+fiboPrice1, cPoint) ); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,7.854);
      ObjectSetFiboDescription(nameObj, 13, "Fe 685.4  -->  "+DoubleToStr(fiboPrice*7.854+fiboPrice1, cPoint) ); 
     }
  }
//--------------------------------------------------------
//  . .
//--------------------------------------------------------

//--------------------------------------------------------
//  - . .
//--------------------------------------------------------
void screenFiboFanS()
  {
   double fiboPrice1, fiboPrice2;

   nameObj="fiboFanS" + ExtComplekt;
   ObjectDelete(nameObj);
   if (afrl[mPitch[1]]>0) 
     {
      fiboPrice1=afrl[mPitch[1]];fiboPrice2=afrh[mPitch[2]];
     }
   else 
     {
      fiboPrice1=afrh[mPitch[1]];fiboPrice2=afrl[mPitch[2]];
     }
   ObjectCreate(nameObj,OBJ_FIBOFAN,0,afr[mPitch[1]],fiboPrice1,afr[mPitch[2]],fiboPrice2);
   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanS);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   ObjectSet(nameObj,OBJPROP_FIBOLEVELS,4);

   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);

   if (ExtFiboFanHidden)
     {
      ObjectSetFiboDescription(nameObj, 0, "23.6"); 
      ObjectSetFiboDescription(nameObj, 1, "38.2"); 
      ObjectSetFiboDescription(nameObj, 2, "50.0"); 
      ObjectSetFiboDescription(nameObj, 3, "61.8"); 
     }

  }
//--------------------------------------------------------
//  - . .
//--------------------------------------------------------


//--------------------------------------------------------
//  - . .
//--------------------------------------------------------
void screenFiboFanD()
  {
   double fiboPrice1, fiboPrice2;

   nameObj="fiboFanD" + ExtComplekt;

   ObjectDelete(nameObj);
   if (afrl[1]>0) 
     {
      fiboPrice1=afrl[1];fiboPrice2=afrh[0];
     }
   else 
     {
      fiboPrice1=afrh[1];fiboPrice2=afrl[0];
     }
   ObjectCreate(nameObj,OBJ_FIBOFAN,0,afr[1],fiboPrice1,afr[0],fiboPrice2);
   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanD);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   ObjectSet(nameObj,OBJPROP_FIBOLEVELS,4);

   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);

   if (ExtFiboFanHidden)
     {
      ObjectSetFiboDescription(nameObj, 0, "23.6"); 
      ObjectSetFiboDescription(nameObj, 1, "38.2"); 
      ObjectSetFiboDescription(nameObj, 2, "50.0"); 
      ObjectSetFiboDescription(nameObj, 3, "61.8"); 
     }
  }
//--------------------------------------------------------
//  - . .
//--------------------------------------------------------

//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void FiboExpansion()
  {
   if (ExtFiboExpansion>1)
     {
      nameObj="fiboExpansion" + ExtComplekt;
      if (mExpansion[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }

      ObjectDelete(nameObj);
      if (afrl[mExpansion[0]]>0)
        {
         ObjectCreate(nameObj,OBJ_EXPANSION,0,afr[mExpansion[0]],afrl[mExpansion[0]],afr[mExpansion[1]],afrh[mExpansion[1]],afr[mExpansion[2]],afrl[mExpansion[2]]);
        }
      else
        {
         ObjectCreate(nameObj,OBJ_EXPANSION,0,afr[mExpansion[0]],afrh[mExpansion[0]],afr[mExpansion[1]],afrl[mExpansion[1]],afr[mExpansion[2]],afrh[mExpansion[2]]);
        }

      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboExpansionColor);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      if (!ExtFiboType)
        {   
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,11);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSetFiboDescription(nameObj, 0, "FE 23.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSetFiboDescription(nameObj, 1, "FE 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSetFiboDescription(nameObj, 2, "FE 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSetFiboDescription(nameObj, 3, "FE 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSetFiboDescription(nameObj, 4, "FE 76.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.854);
         ObjectSetFiboDescription(nameObj, 5, "FE 85.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, "FE 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.236);
         ObjectSetFiboDescription(nameObj, 7, "FE 1.236"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.618);
         ObjectSetFiboDescription(nameObj, 8, "FE 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.0);
         ObjectSetFiboDescription(nameObj, 9, "FE 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
         ObjectSetFiboDescription(nameObj, 10, "FE 261.8"); 
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,12);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSetFiboDescription(nameObj, 0, "FE 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSetFiboDescription(nameObj, 1, "FE 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSetFiboDescription(nameObj, 2, "FE 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSetFiboDescription(nameObj, 3, "FE 70.7"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSetFiboDescription(nameObj, 4, "FE 78.6"); 
 
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.886);
         ObjectSetFiboDescription(nameObj, 5, "FE 88.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, "FE 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.272);
         ObjectSetFiboDescription(nameObj, 7, "FE 127.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.414);
         ObjectSetFiboDescription(nameObj, 8, "FE 141.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.618);
         ObjectSetFiboDescription(nameObj, 9, "FE 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.0);
         ObjectSetFiboDescription(nameObj, 10, "FE 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
         ObjectSetFiboDescription(nameObj, 11, "FE 261.8"); 
        }
     }
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------
void delete_objects1()
  {
   int i;
   string txt;

   for (i=ObjectsTotal(); i>=0; i--)
     {
      txt=ObjectName(i);
      if (StringFind(txt,"" + ExtComplekt + "pl")>-1)ObjectDelete (txt);
      if (StringFind(txt,"" + ExtComplekt + "ph")>-1) ObjectDelete (txt);
     }
  }
//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------
void delete_objects2(string txt1)
  {
   int i;
   string txt;

   for (i=ObjectsTotal(); i>=0; i--)
     {
      txt=ObjectName(i);
      if (StringFind(txt,txt1)>-1)ObjectDelete (txt);
     }
  }
//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------

//----------------------------------------------------
//  ZigZag ( 4  ). .
//----------------------------------------------------
void ZigZag_()
  {
//  ZigZag  . .
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;

   for(shift=Bars-minBars; shift>=0; shift--)
     {
      val=Low[Lowest(NULL,0,MODE_LOW,minBars,shift)];
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=zzL[shift+back];
               if((res!=0)&&(res>val)) zzL[shift+back]=0.0; 
              }
           }
        } 
      zzL[shift]=val;
      //--- high
      val=High[Highest(NULL,0,MODE_HIGH,minBars,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=zzH[shift+back];
               if((res!=0)&&(res<val)) zzH[shift+back]=0.0; 
              } 
           }
        }
      zzH[shift]=val;
     }

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars-minBars; shift>=0; shift--)
     {
      curlow=zzL[shift];
      curhigh=zzH[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh) zzH[lasthighpos]=0;
            else zzH[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) zzL[lastlowpos]=0;
            else zzL[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  
   for(shift=Bars-1; shift>=0; shift--)
     {
      zz[shift]=zzL[shift];
      if(shift>=Bars-minBars) {zzH[shift]=0.0; zzL[shift]=0.0; zz[shift]=0.0;}
      else
        {
         res=zzH[shift];
         if(res!=0.0) zz[shift]=res;
        }
     }

  }
//--------------------------------------------------------
// ZigZag  . . 
//--------------------------------------------------------


//----------------------------------------------------
//  ZigZag   . .
//----------------------------------------------------
void ang_AZZ_()
 {
   int i,n,cbi;
   cbi=Bars-IndicatorCounted()-1;
//---------------------------------
   for (i=cbi; i>=0; i--) 
     {
//-------------------------------------------------
      //     fs    si   
      if (ti!=Time[i]) {fsp=fs; sip=si;} ti=Time[i];
      //       
      if (minSize==0 && minPercent!=0) di=minPercent*Close[i]/2/100;
//-------------------------------------------------
      //   
      if (High[i]>=si+di && Low[i]<si-di) //        di
        {
         if (High[i]-si>=si-Low[i]) si=High[i]-di;  //        
         if (High[i]-si<si-Low[i]) si=Low[i]+di;  // , 
        } 
      else  //   
        {
         if (High[i]>=si+di) si=High[i]-di;   // 
         if (Low[i]<=si-di) si=Low[i]+di;   // 
        }

      //     
      if (i>Bars-2) {si=(High[i]+Low[i])/2;}

      //     
      if (chHL && chHL_PeakDet_or_vts) {ha[i]=si+di; la[i]=si-di;} 

      //      
      if (si>sip) fs=1; //  
      if (si<sip) fs=2; //  

//-------------------------------------------------

      if (fs==1 && fsp==2) //      
        {
         hm=High[i];

         zz[bi]=Low[bi];
         zzL[bi]=Low[bi];
         if (i>0) {if (PeakDet && chHL_PeakDet_or_vts) for (n=bip; n>=bi; n--) {lam[n]=Low[bip];}}
         aip=ai; 
         taip=Time[ai];
         ai=i;
         tai=Time[i];
         fsp=fs;
        }

      if (fs==2 && fsp==1) //      
        {
         lm=Low[i]; 

         zz[ai]=High[ai];
         zzH[ai]=High[ai];
         if (i>0) {if (PeakDet && chHL_PeakDet_or_vts) for (n=aip; n>=ai; n--) {ham[n]=High[aip];}}
         bip=bi; 
         tbip=Time[bi];
         bi=i;
         tbi=Time[i];
         fsp=fs;
        }

      //  t.  .
      if (fs==1 && High[i]>hm) 
        {hm=High[i]; ai=i; tai=Time[i];}
      if (fs==2 && Low[i]<lm) 
        {lm=Low[i]; bi=i; tbi=Time[i];}

//===================================================================================================
      //  .    ZigZag-a

      if (i==0) 
        {
         ai0=iBarShift(Symbol(),Period(),tai); 
         bi0=iBarShift(Symbol(),Period(),tbi);
         aip0=iBarShift(Symbol(),Period(),taip); 
         bip0=iBarShift(Symbol(),Period(),tbip);

         if (fs==1) {for (n=bi0-1; n>ai0; n--) {zzH[n]=0; zz[n]=0;} zz[ai0]=High[ai0]; zzH[ai0]=High[ai0]; zzL[ai0]=0;}         
         if (fs==2) {for (n=ai0-1; n>bi0; n--) {zzL[n]=0; zz[n]=0;} zz[bi0]=Low[bi0]; zzL[bi0]=Low[bi0]; zzH[bi0]=0;}

         if (PeakDet)
           {
            if (fs==1) 
              {
               for (n=aip0; n>=0; n--) {ham[n]=High[aip0];}
               for (n=bi0; n>=0; n--) {lam[n]=Low[bi0];}
              }
            if (fs==2)
              {
               for (n=bip0; n>=0; n--) {lam[n]=Low[bip0];} 
               for (n=ai0; n>=0; n--) {ham[n]=High[ai0];} 
              } 
           }

        }
//====================================================================================================
     }
//--------------------------------------------
 }

//--------------------------------------------------------
// ZigZag . . 
//--------------------------------------------------------


//----------------------------------------------------
//     Ensign. .
//----------------------------------------------------
void Ensign_ZZ()
 {
   int i,n,cbi;
   
   cbi=Bars-IndicatorCounted()-1;
//---------------------------------
   for (i=cbi; i>=0; i--) 
     {
//-------------------------------------------------
      //       
      if (lLast==0) {lLast=Low[i];hLast=High[i]; if (ExtIndicator==3) di=hLast-lLast;}

      //        .
      //         .
      if (fs==0)
        {
         if (lLast<Low[i] && hLast<High[i]) {fs=1; hLast=High[i]; si=High[i]; ai=i; tai=Time[i]; if (ExtIndicator==3) di=High[i]-Low[i];}  //  
         if (lLast>Low[i] && hLast>High[i]) {fs=2; lLast=Low[i]; si=Low[i]; bi=i; tbi=Time[i]; if (ExtIndicator==3) di=High[i]-Low[i];}  //  
        }

      if (ti!=Time[i])
        {
         //     fs   
         ti=Time[i];

         ai0=iBarShift(Symbol(),Period(),tai); 
         bi0=iBarShift(Symbol(),Period(),tbi);

         fcount0=false;
         if ((fh || fl) && countBar>0) {countBar--; if (i==0 && countBar==0) fcount0=true;}
         // .    .
         if (fs==1)
           {
            if (hLast>High[i] && !fh) fh=true;

            if (i==0)
              {

               if (Close[i+1]<lLast && fh) {fs=2; countBar=minBars; fh=false;}
               if (countBar==0 && si-di>Low[i+1] && High[i+1]<hLast && ai0>i+1 && fh && !fcount0) {fs=2; countBar=minBars; fh=false;}

               if (fs==2) //         
                 {
                  zz[ai0]=High[ai0];
                  zzH[ai0]=High[ai0];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=aip; n>=ai; n--) {ham[n]=High[aip];}
                  lLast=Low[i+1];
                  if (ExtIndicator==3) di=High[i+1]-Low[i+1];
                  si=Low[i+1];
                  bip=bi0; 
                  tbip=Time[bi0];
                  bi=i+1;
                  tbi=Time[i+1];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i+1]=si+di; la[i+1]=si;}
                }

              }
             else
              {
               if (Close[i]<lLast && fh) {fs=2; countBar=minBars; fh=false;}
               if (countBar==0 && si-di>Low[i] && High[i]<hLast && fh) {fs=2; countBar=minBars; fh=false;}

               if (fs==2) //      
                 {
                  zz[ai]=High[ai];
                  zzH[ai]=High[ai];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=aip; n>=ai; n--) {ham[n]=High[aip];}
                  lLast=Low[i];
                  if (ExtIndicator==3) di=High[i]-Low[i];
                  si=Low[i];
                  bip=bi; 
                  tbip=Time[bi];
                  bi=i;
                  tbi=Time[i];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i]=si+di; la[i]=si;}
                 }
              }

           }
         else // fs==2
           {
            if (lLast<Low[i] && !fl) fl=true;

            if (i==0)
              {

               if (Close[i+1]>hLast && fl) {fs=1; countBar=minBars; fl=false;}
               if (countBar==0 && si+di<High[i+1] && Low[i+1]>lLast && bi0>i+1 && fl && !fcount0) {fs=1; countBar=minBars; fl=false;}

               if (fs==1) //         
                 {
                  zz[bi0]=Low[bi0];
                  zzL[bi0]=Low[bi0];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=bip; n>=bi; n--) {lam[n]=Low[bip];}
                  hLast=High[i+1];
                  if (ExtIndicator==3) di=High[i+1]-Low[i+1];
                  si=High[i+1];
                  aip=ai0; 
                  taip=Time[ai0];
                  ai=i+1;
                  tai=Time[i+1];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i+1]=si; la[i+1]=si-di;}
                 }

              }
             else
              {
               if (Close[i]>hLast && fl) {fs=1; countBar=minBars; fl=false;}
               if (countBar==0 && si+di<High[i] && Low[i]>lLast && fl) {fs=1; countBar=minBars; fl=false;}

               if (fs==1) //      
                 {
                  zz[bi]=Low[bi];
                  zzL[bi]=Low[bi];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=bip; n>=bi; n--) {lam[n]=Low[bip];}
                  hLast=High[i];
                  if (ExtIndicator==3) di=High[i]-Low[i];
                  si=High[i];
                  aip=ai; 
                  taip=Time[ai];
                  ai=i;
                  tai=Time[i];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i]=si; la[i]=si-di;}
                 }
              }
           }
        } 

      //  
      if (fs==1 && High[i]>si) {ai=i; tai=Time[i]; hLast=High[i]; si=High[i]; countBar=minBars; fh=false; if (ExtIndicator==3) di=High[i]-Low[i];}
      if (fs==2 && Low[i]<si) {bi=i; tbi=Time[i]; lLast=Low[i]; si=Low[i]; countBar=minBars; fl=false; if (ExtIndicator==3) di=High[i]-Low[i];}

      //     
      if (chHL && chHL_PeakDet_or_vts)
        {
         if (fs==1) {ha[i]=si; la[i]=si-di;}
         if (fs==2) {ha[i]=si+di; la[i]=si;}
        } 

//===================================================================================================
      //  .    ZigZag-a

      if (i==0) 
        {
         ai0=iBarShift(Symbol(),Period(),tai); 
         bi0=iBarShift(Symbol(),Period(),tbi);
         aip0=iBarShift(Symbol(),Period(),taip); 
         bip0=iBarShift(Symbol(),Period(),tbip);

         if (fs==1) {for (n=bi0-1; n>=0; n--) {zzH[n]=0; zz[n]=0;} zz[ai0]=High[ai0]; zzH[ai0]=High[ai0]; zzL[ai0]=0;}         
         if (fs==2) {for (n=ai0-1; n>=0; n--) {zzL[n]=0; zz[n]=0;} zz[bi0]=Low[bi0]; zzL[bi0]=Low[bi0]; zzH[bi0]=0;}

         if (PeakDet && chHL_PeakDet_or_vts)
           {
            if (fs==1) {for (n=aip0; n>=0; n--) {ham[n]=High[aip0];} for (n=bi0; n>=0; n--) {lam[n]=Low[bi0];} }
            if (fs==2) {for (n=bip0; n>=0; n--) {lam[n]=Low[bip0];} for (n=ai0; n>=0; n--) {ham[n]=High[ai0];} } 
           }
        }

//====================================================================================================
     }
//--------------------------------------------
 }
//--------------------------------------------------------
//     Ensign. . 
//--------------------------------------------------------


//----------------------------------------------------
//  ZigZag tauber. .
//----------------------------------------------------

void ZigZag_tauber()
  {
//  ZigZag  . .
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;
   GetHigh(0,Bars,0.0,0);

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars; shift>=0; shift--)
     {
      curlow=zzL[shift];
      curhigh=zzH[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
        if(lasthigh>0) 
           {
            if(lasthigh<curhigh) zzH[lasthighpos]=0;
            else zzH[shift]=0;
           }
        //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) zzL[lastlowpos]=0;
            else zzL[shift]=0;
          }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  

   for(shift=Bars-1; shift>=0; shift--)
     {
      zz[shift]=zzL[shift];
      res=zzH[shift];
      if(res!=0.0) zz[shift]=res;
     }

  }

void GetHigh(int start, int end, double price, int step)
  {
   int count=end-start;
   if (count<=0) return;
   int i=Highest(NULL,0,MODE_HIGH,count+1,start);
   double val=High[i];
   if ((val-price)>(minSize*Point))
     { 
      zzH[i]=val;
      if (i==start) {GetLow(start+step,end-step,val,1-step); if (zzL[start-1]>0) zzL[start]=0; return;}     
      if (i==end) {GetLow(start+step,end-step,val,1-step); if (zzL[end+1]>0) zzL[end]=0; return;} 
      GetLow(start,i-1,val,0);
      GetLow(i+1,end,val,0);
     }
  }

void GetLow(int start, int end, double price, int step)
  {
   int count=end-start;
   if (count<=0) return;
   int i=Lowest(NULL,0,MODE_LOW,count+1,start);
   double val=Low[i];
   if ((price-val)>(minSize*Point))
     {
      zzL[i]=val; 
      if (i==start) {GetHigh(start+step,end-step,val,1-step); if (zzH[start-1]>0) zzH[start]=0; return;}     
      if (i==end) {GetHigh(start+step,end-step,val,1-step); if (zzH[end+1]>0) zzH[end]=0; return;}   
      GetHigh(start,i-1,val,0);
      GetHigh(i+1,end,val,0);
     }
  }
//--------------------------------------------------------
// ZigZag tauber. . 
//--------------------------------------------------------




//--------------------------------------------------------
//  i-vts . . 
//--------------------------------------------------------
//+------------------------------------------------------------------+
//|                                                        i-VTS.mq4 |
//|                                                     & KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|  06.12.2005   VTS                                       |
//+------------------------------------------------------------------+
//
//       MQL  MQ4
//
void i_vts() //
  {
   double ms[2];
   int    LoopBegin, sh;

 	if (NumberOfBars==0) LoopBegin=Bars-1;
   else LoopBegin=NumberOfBars-1;
   LoopBegin=MathMin(Bars-25, LoopBegin);

   for (sh=LoopBegin; sh>=0; sh--)
     {
      GetValueVTS("", 0, NumberOfVTS, sh, ms);
      ha[sh]=ms[0];
      la[sh]=ms[1];
     }
  }

void i_vts1() //
  {
   double ms[2];
   int    LoopBegin, sh;

 	if (NumberOfBars==0) LoopBegin=Bars-1;
   else LoopBegin=NumberOfBars-1;
   LoopBegin=MathMin(Bars-25, LoopBegin);

   for (sh=LoopBegin; sh>=0; sh--)
     {
      GetValueVTS("", 0, NumberOfVTS1, sh, ms);
      ham[sh]=ms[0];
      lam[sh]=ms[1];
     }
  }
//+------------------------------------------------------------------+
//-------    ---------------------------------
//+------------------------------------------------------------------+
//| :                                                       |
//|   sym -                                   |
//|   tf  -  ( )                             |
//|   ng  -                                               |
//|   nb  -                                                 |
//|   ms  -                                            |
//+------------------------------------------------------------------+
void GetValueVTS(string sym, int tf, int ng, int nb, double& ms[])
  {
   if (sym=="") sym=Symbol();
   double f1, f2, s1, s2;

   f1=iClose(sym, tf, nb)-3*iATR(sym, tf, 10, nb);
   f2=iClose(sym, tf, nb)+3*iATR(sym, tf, 10, nb);
   for (int i=1; i<=ng; i++)
     {
      s1=iClose(sym, tf, nb+i)-3*iATR(sym, tf, 10, nb+i);
      s2=iClose(sym, tf, nb+i)+3*iATR(sym, tf, 10, nb+i);
      if (f1<s1) f1=s1;
      if (f2>s2) f2=s2;
     }
    ms[0]=f2;   //  
    ms[1]=f1;   //  
  }
//+------------------------------------------------------------------+
//--------------------------------------------------------
//  i-vts . . 
//--------------------------------------------------------

//--------------------------------------------------------
//   . . 
//--------------------------------------------------------
void info_TF ()
  {
   string info, txt, fibo;
   int i,pips;

   openTF[0]=iOpen(NULL,PERIOD_MN1,0);
   closeTF[0]=iClose(NULL,PERIOD_MN1,0);
   lowTF[0]=iLow(NULL,PERIOD_MN1,0);
   highTF[0]=iHigh(NULL,PERIOD_MN1,0);
   
   openTF[1]=iOpen(NULL,PERIOD_W1,0);
   closeTF[1]=iClose(NULL,PERIOD_W1,0);
   lowTF[1]=iLow(NULL,PERIOD_W1,0);
   highTF[1]=iHigh(NULL,PERIOD_W1,0);
   
   openTF[2]=iOpen(NULL,PERIOD_D1,0);
   closeTF[2]=iClose(NULL,PERIOD_D1,0);
   lowTF[2]=iLow(NULL,PERIOD_D1,0);
   highTF[2]=iHigh(NULL,PERIOD_D1,0);
   
   openTF[3]=iOpen(NULL,PERIOD_H4,0);
   closeTF[3]=iClose(NULL,PERIOD_H4,0);
   lowTF[3]=iLow(NULL,PERIOD_H4,0);
   highTF[3]=iHigh(NULL,PERIOD_H4,0);
   
   openTF[4]=iOpen(NULL,PERIOD_H1,0);
   closeTF[4]=iClose(NULL,PERIOD_H1,0);
   lowTF[4]=iLow(NULL,PERIOD_H1,0);
   highTF[4]=iHigh(NULL,PERIOD_H1,0);
   
   info="|  ";

   for (i=0;i<5;i++)
     {
      pips=(highTF[i]-lowTF[i])/Point;
      if (pips>0)
        {
         if (openTF[i]>closeTF[i]) {txt=" < ";}
         else if (openTF[i]==closeTF[i]) {txt=" = ";}
         else if (openTF[i]<closeTF[i]) {txt=" > ";}
         info=info + TF[i] + txt + DoubleToStr(pips,0) + "   " +  DoubleToStr((closeTF[i]-lowTF[i])/(pips*Point),3) + " |  ";
        }
     }
   Comment(info);
   close_TF=Close[0];
  }
//--------------------------------------------------------
//   . . 
//--------------------------------------------------------

