//+------------------------------------------------------------------+
//|                                               zigzag-pointer.mq4 |
//|                                    zigzag modified by Dr. Gaines |
//|                                      dr_richard_gaines@yahoo.com |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "dr_richard_gaines"
#property link      "http://www.metaquotes.net/"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_width1 2
#property indicator_color2 White
#property indicator_width2 2
//---- indicator parameters
extern int ExtDepth=115;//105;//21;
extern int ExtDeviation=130;//120;//24;
extern int ExtBackstep=80;//70;//14;
//---- indicator buffers
double ZigZagUp[];
double ZigZagDown[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(2);
//---- drawing settings
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0, 174);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1, 174);
//---- indicator buffers mapping
   SetIndexBuffer(0,ZigZagUp);
   SetIndexBuffer(1,ZigZagDown);
   SetIndexEmptyValue(0,0.0);
   SetIndexEmptyValue(1,0.0);     
//---- indicator short name
   IndicatorShortName("ZigZag("+ExtDepth+","+ExtDeviation+","+ExtBackstep+")");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      val=Low[Lowest(NULL,0,MODE_LOW,ExtDepth,shift)];
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ZigZagUp[shift+back];
               if((res!=0)&&(res>val)) { ZigZagUp[shift+back]=0.0; } 
              }
           }
        } 
      ZigZagUp[shift]=val;
      //--- high
      val=High[Highest(NULL,0,MODE_HIGH,ExtDepth,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ZigZagDown[shift+back];
               if((res!=0)&&(res<val)){ ZigZagDown[shift+back]=0.0; } 
              } 
           }
        }
      ZigZagDown[shift]=val;
     }

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      curlow=ZigZagUp[shift];
      curhigh=ZigZagDown[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh)
             {
              ZigZagDown[lasthighpos]=0;
             }
            else ZigZagDown[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow)
             {
              ZigZagUp[lastlowpos]=0;
            }
            else ZigZagUp[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  
   for(shift=Bars-1; shift>=0; shift--)
     {
      if(shift>=Bars-ExtDepth) ZigZagUp[shift]=0.0;
      else
        {
         res=ZigZagDown[shift];
         if(res!=0.0) ZigZagDown[shift]=res;
        }
     }
  }
  
  //end//