//+------------------------------------------------------------------+
//|                                               zigzag-pointer.mq4 |
//|                                    zigzag modified by Dr. Gaines |
//|                                      dr_richard_gaines@yahoo.com |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 clrLime
#property indicator_color2 clrRed
#property indicator_color3 clrGreen  //Yellow
#property indicator_color4 clrFireBrick  //Orange
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 1
#property indicator_width4 1
//---- indicator parameters
extern int ExtDepth=100;
extern int ExtDeviation=75;
extern int ExtBackstep=15;
//---- indicator buffers
double ZigZagUp[];
double ZigZagDown[];
double zzL[];
double zzH[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(4);
//---- drawing settings
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0, 233);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1, 234);
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2, 233);
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexArrow(3, 234);
//---- indicator buffers mapping
   SetIndexBuffer(0,ZigZagUp);
   SetIndexBuffer(1,ZigZagDown);
   SetIndexBuffer(2,zzL);
   SetIndexBuffer(3,zzH);
   SetIndexEmptyValue(0,0.0);
   SetIndexEmptyValue(1,0.0);
   SetIndexEmptyValue(2,0.0);
   SetIndexEmptyValue(3,0.0);
   
//---- indicator short name
   IndicatorShortName("ZigZag("+ExtDepth+","+ExtDeviation+","+ExtBackstep+")");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      val=Low[Lowest(NULL,0,MODE_LOW,ExtDepth,shift)];
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ZigZagUp[shift+back];
               if((res!=0)&&(res>val)) { ZigZagUp[shift+back]=0.0; zzL[shift + back] = res; } 
              }
           }
        } 
      ZigZagUp[shift]=val;
      //--- high
      val=High[Highest(NULL,0,MODE_HIGH,ExtDepth,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ZigZagDown[shift+back];
               if((res!=0)&&(res<val)){ ZigZagDown[shift+back]=0.0; zzH[shift + back] = res; } 
              } 
           }
        }
      ZigZagDown[shift]=val;
     }

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      curlow=ZigZagUp[shift];
      curhigh=ZigZagDown[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh)
             {
              zzH[lasthighpos] = ZigZagDown[lasthighpos];
               ZigZagDown[lasthighpos]=0;
             }
            else ZigZagDown[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow)
             {
              zzL[lastlowpos] = ZigZagUp[lastlowpos];
              ZigZagUp[lastlowpos]=0;
            }
            else ZigZagUp[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  
   for(shift=Bars-1; shift>=0; shift--)
     {
      if(shift>=Bars-ExtDepth) ZigZagUp[shift]=0.0;
      else
        {
         res=ZigZagDown[shift];
         if(res!=0.0) ZigZagDown[shift]=res;
        }
     }
  return(0);
  }
  
  //end//