#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 CLR_NONE
#property indicator_color2 Red
#property indicator_width2 2
#property indicator_color3 Lime
#property indicator_width3 2

extern int NoiseLevel    = 30;
extern int SwitchPercent = 30;
extern int Mode          = 0;
extern int OncePerCandle = 1;
extern bool alertsOn        = true;
extern bool alertsOnCurrent = false;
extern bool alertsMessage   = true;
extern bool alertsSound     = true;
extern bool alertsEmail     = false;
int MaxBars              = 600;
extern int ArrowOffset   = 15;
double Porog1[];
double Porog2[];
double Porog3[];
bool mds = FALSE;
double LevRT;
double mdt;
double Const1 = 0.0;
double Const2 = 0.0;
double Const3 = 0.0;
double Const4 = 0.0;
double Const5 = 0.0;
int rf1 = 0;
int rf2 = 0;
int rf3 = 0;
int mda = 0;
int mdk = -1;
int mdl = 0;
int mdn = 0;
int mdrs = 0;

int new_candle() {
   if (mdn != Time[0] || mdl != Bars) {
      mdn = Time[0];
      mdl = Bars;
      return (1);
   }
   return (0);
}

int init() {
   IndicatorBuffers(3);
   SetIndexStyle(0, DRAW_SECTION, STYLE_SOLID, 2);
   SetIndexBuffer(0, Porog1);
   SetIndexBuffer(1, Porog2);
   SetIndexBuffer(2, Porog3);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexArrow(1, SYMBOL_ARROWDOWN);
   SetIndexStyle(2, DRAW_ARROW);
   SetIndexArrow(2, SYMBOL_ARROWUP);
   SetIndexEmptyValue(0, 0.0);
   IndicatorShortName("ZigZag_Larsen_out");
   mdrs = 0;
   if (Mode == 0) {
      Const1 = Close[0] - NoiseLevel / 2 * Point;
      Const2 = Close[0] + NoiseLevel / 2 * Point;
   } else {
      Const1 = Open[0] - NoiseLevel / 2 * Point;
      Const2 = Open[0] + NoiseLevel / 2 * Point;
   }
   Const5 = Open[0];
   Const2 = Const1;
   Const3 = Const1;
   Const4 = Const1;
   LevRT = Const1;
   mdt = LevRT;
   return (0);
}

int start() {
   int barsdown = IndicatorCounted();
   if (!new_candle())
      if (OncePerCandle == 1) return (0);
   int bars1 = Bars;
   if (bars1 > MaxBars) bars1 = MaxBars;
   int bars2 = bars1;
   mdk = bars2;
   mda = 0;
   Porog1[1] = Const5;
   int brshift = bars2 - 1;
   if (Mode == 0) Porog1[brshift] = Close[brshift];
   else Porog1[brshift] = Open[brshift];
   while (brshift >= 0) {
      GetMoving(brshift);
      if (rf3 == TRUE) {
         if (rf1 == 1) {
            Porog1[brshift] = Const3;
            Porog3[brshift] = Const3 - ArrowOffset * Point;
            Porog2[brshift] = 0.0;
            if (brshift == 0) Const5 = Const3;
         }
         if (rf1 == -1) {
            Porog1[brshift] = Const4;
            Porog2[brshift] = Const4 + ArrowOffset * Point;
            Porog3[brshift] = 0.0;
            if (brshift == 0) Const5 = Const4;
         }
         rf3 = FALSE;
      } else {
         if (brshift == 0) {
            if (rf1 == 1) Porog1[0] = Const2;
            if (rf1 == -1) Porog1[0] = Const1;
         } else {
            Porog1[brshift] = 0.0;
            Porog2[brshift] = 0.0;
            Porog3[brshift] = 0.0;
            if (brshift == 0) Const5 = 0.0;
         }
      }
      brshift--;
   }
   manageAlerts();
   return (0);
}

int GetMoving(int smet) {
   int shifting = (Const2 - Const1) * SwitchPercent / 100.0;
   if (shifting < NoiseLevel) shifting = NoiseLevel;
   if (Mode == 1) LevRT = Open[smet];
   else {
      if (rf1 != -1) LevRT = High[smet];
      else LevRT = Low[smet];
   }
   if (rf1 != -1 && LevRT > Const2) Const2 = LevRT;
   if (rf1 != 1 && LevRT < Const1) Const1 = LevRT;
   if (Const2 - Const1 >= NoiseLevel * Point) {
      if (rf1 != 1 && LevRT - Const1 >= shifting * Point) {
         rf1 = 1;
         Const3 = Const1;
         Const2 = LevRT;
         mdt = LevRT;
      }
      if (rf1 != -1 && Const2 - LevRT >= shifting * Point) {
         rf1 = -1;
         Const4 = Const2;
         Const1 = LevRT;
         mdt = LevRT;
      }
   }
   if (rf2 != rf1) {
      rf2 = rf1;
      rf3 = TRUE;
   }
   return (rf1);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
            int forBar = 0;
      else      forBar = 1;
      if (Porog2[forBar]!=0 || Porog3[forBar]!=0)
      {
         if (Porog2[forBar]!= 0) doAlert(0,"down");
         if (Porog3[forBar]!= 0) doAlert(0,"up");
      }            
   }
} 
void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[forBar]) {
          previousAlert  = doWhat;
          previousTime   = Time[forBar];

          //
          //
          //
          //
          //

          message =  Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" ZZLarsen signal "+doWhat;
             if (alertsMessage) Alert(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," ZZLarsen"),message);
             if (alertsSound)   PlaySound("alert2.wav");
      }
}