//+------------------------------------------------------------------+
//|                                                      XPeriod.mq4 |
//|                                                      Denis Orlov |
//|                                    http://denis-or-love.narod.ru |
/*
          . 
:
http://codebase.mql4.com/ru/6014

The indicator allows to display candle schedules of the different time periods in one window. 
In detail:
http://codebase.mql4.com/6072

***
  :
http://codebase.mql4.com/ru/author/denis_orlov
***
  !
***
All my indicators:

http://codebase.mql4.com/author/denis_orlov
***
USE AND PROSPER!

*/
//+------------------------------------------------------------------+
#property copyright "Denis Orlov"
#property link      "http://denis-or-love.narod.ru"

//#include <Trend.mqh>
//#include <DrawObjects.mqh>

//#property indicator_separate_window
#property indicator_chart_window

#property indicator_buffers 4

#property indicator_color1 DarkTurquoise
#property indicator_color2 DarkBlue
#property indicator_color3 DarkTurquoise
#property indicator_color4 DarkBlue


double Line1[], Line2[], Line3[], Line4[];
//#property indicator_maximum 100
//#property indicator_minimum 0
extern bool TesterMode=false;
extern int TimeFrame=0;
extern int History=10;
extern int Vertical_Shift=-60;
extern bool DoubleLong=false;
extern bool OutlineCandles=true;
extern color ColorBullShadow=BlanchedAlmond;
extern color ColorBullBody=NavajoWhite;
extern color ColorBearShadow=Gainsboro;
extern color ColorBearBody=Gray;
extern bool BackRoundCandles=True;
extern int OutlineWidth=3;
extern color LabelColor=Blue;


string pr="XPeriod ";
int per,per1;
bool redraw=false;
int bar0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
      if(TimeFrame==0)
     switch(Period())                 //   ..     
      {                              // ..          
      case     1: TimeFrame=1; break;//  1  
      case     5: TimeFrame=1; break;//  5      
      case    15: TimeFrame=5; break;//  15      
      case    30: TimeFrame=15; break;//  30      
      case    60: TimeFrame=30; break;//  H1      
      case   240: TimeFrame=60; break;//  H4      
      case  1440: TimeFrame=240; break;//  D1      
      case 10080: TimeFrame=1440; break;//  W1      
      case 43200: TimeFrame=10080; break;//  N     
      }
      
      
      //IndicatorBuffers(4);
      
   
   SetIndexStyle(0,DRAW_HISTOGRAM,0,3);
   SetIndexBuffer(0,Line1);
   
   SetIndexStyle(1,DRAW_HISTOGRAM,0,3);
   SetIndexBuffer(1,Line2);

   SetIndexStyle(2,DRAW_HISTOGRAM,0,1);
   SetIndexBuffer(2,Line3);
   
   SetIndexStyle(3,DRAW_HISTOGRAM,0,1);
   SetIndexBuffer(3,Line4);

      
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
      Delete_My_Obj(pr+PeriodToStr(TimeFrame));
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
      
      string TF=PeriodToStr(TimeFrame);
      IndicatorShortName(pr+TF);
      
      double TesterTimeCurrent=GlobalVariableGet( "TesterTimeCurrent");
       //if( TesterTimeCurrent==0) return;
      
      // bar0=TimeToBarPeriod(TesterTimeCurrent, TimeFrame);
      if(TesterMode) bar0=iBarShift(NULL,TimeFrame,TesterTimeCurrent);
         else bar0=0;
      
      
      
       DrawText( pr+TF+" label", Time[0]+Period()*90 , iLow(NULL,TimeFrame,bar0)+Vertical_Shift*Point, 
         TF//TimeToStr(Time[0],TIME_SECONDS)+"; "+ TimeToStr(TesterTimeCurrent,TIME_SECONDS)//
          ,LabelColor);
          
      //if(ObjectFind(pr+TF+" label")>-1)
       //{
         double lp=ObjectGet(pr+TF+" label",OBJPROP_PRICE1);
         if(lp!=iLow(NULL,TimeFrame,bar0)+Vertical_Shift*Point)
            {
               Vertical_Shift=(lp- iLow(NULL,TimeFrame,bar0))/Point;
               redraw=True;
            }
        
      //}
          
         Chart( bar0,bar0);///  -    
     // Comment(Vertical_Shift);
      
         if(TimeFrame<Period())
            int   canF=iBarShift(NULL,TimeFrame,Time[History]);
            else
               {
               if(!TesterMode)canF=History;
               else
                  canF=iBarShift(NULL,TimeFrame,TesterTimeCurrent)+History;
                }
                

         
     if (per1 != iTime(NULL,TimeFrame, 0) || per!= Time[0] || redraw)  //       
      {
         per = Time[0]; 
         per1= iTime(NULL,TimeFrame, bar0);
         redraw=False;
         
            ArrayInitialize( Line1, 0);
            ArrayInitialize( Line2, 0);
            ArrayInitialize( Line3, 0);
            ArrayInitialize( Line4, 0);
         Chart( canF,bar0);///  
         
         if(!OutlineCandles)return(0);
         
         
         if(TimeFrame<Period())
            {
               //canF=TimeToBarPeriod(Time[History], TimeFrame);
               canF=iBarShift(NULL,TimeFrame,Time[History]);
               int K=MathRound(Period()/TimeFrame),  cnt2=History+1; 
               for( int i=canF;i>=bar0;i=i-K)
                  { 
                     cnt2--;
                     datetime t1=Time[i-bar0];
                     int t_2=i-K+1-bar0; 
                     if(t_2<0) datetime t2=Time[0]; 
                        else
                         t2=Time[t_2]; 
                         //if(cnt2==1)Alert(canF+";"+bar0+";"+i+";"+K+";"+(i-K+1-bar0));
                        
                     if(DoubleLong)
                      double p1=High[cnt2]*2-Low[cnt2]+Vertical_Shift*Point;
                        else p1=High[cnt2]+Vertical_Shift*Point;
                      double p2=Low[cnt2]+Vertical_Shift*Point;
                        
                    
                     
                     double op=Open[cnt2], cl=Close[cnt2];
                     if(op<cl) color clr=ColorBullShadow; else clr=ColorBearShadow;
                     
               string name=pr+TF+" Candle Shadows "+cnt2;//+" "+TimeToStr(t1,TIME_DATE|TIME_MINUTES);
               DrawRect(name, t1, p1, t2, p2, clr, OutlineWidth, "", BackRoundCandles,  0);
               
               if(op!=cl)//BODY
                    {
                        if(op<cl) 
                     {
                         if(DoubleLong)
                           {
                           p1=cl*2-Low[cnt2]+Vertical_Shift*Point;
                           p2=op*2-Low[cnt2]+Vertical_Shift*Point;
                           }
                           else
                           {
                           p1=cl+Vertical_Shift*Point;
                           p2=op+Vertical_Shift*Point;
                           }
                         clr=ColorBullBody;
                     }
                     else
                     {
                         if(DoubleLong)
                           {
                           p1=op*2-Low[cnt2]+Vertical_Shift*Point;
                           p2=cl*2-Low[cnt2]+Vertical_Shift*Point;
                           }
                           else
                           {
                           p1=op+Vertical_Shift*Point;
                           p2=cl+Vertical_Shift*Point;
                           }
                         
                         clr=ColorBearBody; 
                     }
                     name=pr+TF+" Candle Body "+cnt2;//+" "+TimeToStr(t1,TIME_DATE|TIME_MINUTES);
                     
                  DrawRect(name, t1, p1, t2, p2, clr, OutlineWidth, "", BackRoundCandles,  0);
                    }//if(op!=cl)
               
                   }//for
            }
            else
            {
               Delete_My_Obj(pr+TF+" Candle ");
               
               K=MathRound(TimeFrame/Period());
              // canF=TimeToBarPeriod(iTime(NULL,TimeFrame, History), Period());
                
             cnt2=canF+1; // cnt2=History+1
             canF=iBarShift(NULL,Period(),iTime(NULL,TimeFrame, canF));
               for( i=canF;i>=0;i=i-K)
                  {
                       cnt2--;
                       t1=Time[i];
                       t_2=i-K+1; 
                        if(t_2<0)  t2=Time[0]; 
                           else
                            t2=Time[t_2]; 
                        //Alert(canF+";"+cnt2);
                        
                         p1=iHigh(NULL,TimeFrame,cnt2);
                         p2=iLow(NULL,TimeFrame,cnt2);
                         
                         op=iOpen(NULL,TimeFrame,cnt2); cl=iClose(NULL,TimeFrame,cnt2);
                         if(op<cl) clr=ColorBullShadow; else clr=ColorBearShadow;
                     
                   name=pr+TF+" Candle Shadows "+cnt2;//+" "+TimeToStr(t1,TIME_DATE|TIME_MINUTES);
                  DrawRect(name, t1, p1, t2, p2, clr, OutlineWidth, "", BackRoundCandles,  0);
                  
                if(op!=cl) //BODY
                  { 
                   if(op<cl) 
                     {
                         p1=cl;
                         p2=op;
                         clr=ColorBullBody;
                     }
                     else
                     {
                         p1=op;
                         p2=cl;
                         clr=ColorBearBody; 
                     }
                     name=pr+TF+" Candle Body "+cnt2;//+" "+TimeToStr(t1,TIME_DATE|TIME_MINUTES);
                     
                  DrawRect(name, t1, p1, t2, p2, clr, OutlineWidth, "", BackRoundCandles,  0);
                  }//if(op!=cl) 
                        
                 }//for
            
            }//else
         
      }// if (per != Time[0])  //    
     
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
   
void Chart(int from, int to) 
   {  
     // if(TimeFrame<Period()) 
      int b0=bar0;
        // else b0=0;
        
         
      for(int i=from;i>=to;i--)
         {
          double p_1=iOpen(NULL,TimeFrame,i), p_2=iClose(NULL,TimeFrame,i);
          
          
                  if(p_1<p_2)//UP
              {
                 if(DoubleLong)
                 Line3[i-b0]=iHigh(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                 else
                 Line3[i-b0]=iHigh(NULL,TimeFrame,i)+Vertical_Shift*Point;
                 Line4[i-b0]=iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                 
                 if(DoubleLong)
                  {
                    Line1[i-b0]=iClose(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                    Line2[i-b0]=iOpen(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                  }
                  else
                  {
                    Line1[i-b0]=iClose(NULL,TimeFrame,i)+Vertical_Shift*Point;
                    Line2[i-b0]=iOpen(NULL,TimeFrame,i)+Vertical_Shift*Point;
                  }
                 
              }
              else
              {
                  if(p_1>p_2)
                     {
                        if(DoubleLong)
                           {
                              Line2[i-b0]=iOpen(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                              Line1[i-b0]=iClose(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                           }
                           else
                           {
                              Line2[i-b0]=iOpen(NULL,TimeFrame,i)+Vertical_Shift*Point;
                              Line1[i-b0]=iClose(NULL,TimeFrame,i)+Vertical_Shift*Point;
                           }
                     }
                     else
                   if(p_1==p_2)//dodge
                     {
                     
                        if(DoubleLong)
                              {
                                 Line2[i-b0]=iOpen(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+(Vertical_Shift+0.01)*Point;
                                 Line1[i-b0]=iClose(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                              }
                              else
                              {
                                 Line2[i-b0]=iOpen(NULL,TimeFrame,i)+(Vertical_Shift+0.01)*Point;
                                 Line1[i-b0]=iClose(NULL,TimeFrame,i)+Vertical_Shift*Point;
                              }
                              
                     }
                     
                    if(DoubleLong)
                    Line4[i-b0]=iHigh(NULL,TimeFrame,i)*2-iLow(NULL,TimeFrame,i)+Vertical_Shift*Point;
                    else
                    Line4[i-b0]=iHigh(NULL,TimeFrame,i)+Vertical_Shift*Point;
                    Line3[i-b0]=iLow(NULL,TimeFrame,i)+Vertical_Shift*Point; 
              }
           }
   }
 //----------------------
void Delete_My_Obj(string Prefix)
   {//Alert(ObjectsTotal());
   for(int k=ObjectsTotal()-1; k>=0; k--)  //     
     {
      string Obj_Name=ObjectName(k);   //   
      string Head=StringSubstr(Obj_Name,0,StringLen(Prefix));//   

      if (Head==Prefix)//  , ..
         {
         ObjectDelete(Obj_Name);
         //Alert(Head+";"+Prefix);
         }                
        
     }
   }
 //----------------------   
string PeriodToStr(int Per)
   {
      switch(Per)                 //   ..     
      {                              // ..       
      case     1: return("M1"); break;//  1      
      case     5: return("M5"); break;//  5      
      case    15: return("M15"); break;//  15      
      case    30: return("M30"); break;//  30      
      case    60: return("H1"); break;//  H1      
      case   240: return("H4"); break;//  H4      
      case  1440: return("D1"); break;//  D1      
      case 10080: return("W1"); break;//  W1      
      case 43200: return("N"); break;//  N     
      }
   } 
   //----------------------
int DrawText( string name, datetime T, double P, string Text, color Clr=Green, int Win=0, int Fsize=10)
   { 
      if (name=="") name="Text_"+T;
      
      int Error=ObjectFind(name);//  
   if (Error!=Win)//    .   :(
    { 
      ObjectCreate(name, OBJ_TEXT, Win, T, P);
      }
      
      ObjectSet(name, OBJPROP_TIME1, T);
      ObjectSet(name, OBJPROP_PRICE1, P);
      ObjectSetText(name, Text ,Fsize,"Arial",Clr);
   }
 //---------------------- 
int DrawRect(string name, datetime T1, double P1, datetime T2, double P2, color Clr, int W=1, string Text="", bool BACK=false, int Win=0)
   {
     int Error=ObjectFind(name);//  
   if (Error!=Win)//    .   :(
    {  
      ObjectCreate(name, OBJ_RECTANGLE, Win,T1,P1,T2,P2);//  
    }
     
    ObjectSet(name, OBJPROP_TIME1 ,T1);
    ObjectSet(name, OBJPROP_PRICE1,P1);
    ObjectSet(name, OBJPROP_TIME2 ,T2);
    ObjectSet(name, OBJPROP_PRICE2,P2);
    ObjectSet(name,OBJPROP_BACK, BACK);
    ObjectSet(name,OBJPROP_STYLE,0);
    ObjectSet(name, OBJPROP_COLOR , Clr);
    ObjectSet(name, OBJPROP_WIDTH , W);
    ObjectSetText(name,Text);
   // WindowRedraw();
   }   