//+------------------------------------------------------------------+
//|                                        Andre Boyka Lines ABL.mq4 |
//|                                                      Swan  2010 |
//|                                                                  |
//|      - renee (Romania)                                       |
//|   - http://www.onix-trade.net/forum/index.php?showtopic=81964    |
//|      -  - http://www.onix-trade.net/forum       |                                                        |
//|       Andre                                           |
//+------------------------------------------------------------------+
#property copyright "Swan  2010"
#property link      "http://forum.mql4.com/ru"
#property indicator_chart_window

extern string ="D1";//D-,W-,MN-,Y-. -
extern color Pitchfork_1=Red;
extern color Pitchfork_2=Blue;
extern color Boyka_Line=DarkOrange;
extern int Boyka_Line_Width=4;
extern bool DrawVLine=true;
extern color VLine=Green;

int TF=1440,nTF=1;
string sTF="D";
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
if(StringSubstr(,0,1)=="D")  {sTF="D"; nTF=StrToInteger(StringSubstr(,1,0));TF=1440;}
if(StringSubstr(,0,1)=="W")  {sTF="W"; nTF=StrToInteger(StringSubstr(,1,0));TF=10080;}
if(StringSubstr(,0,2)=="MN") {sTF="MN";nTF=StrToInteger(StringSubstr(,2,0));TF=43200;}
if(StringSubstr(,0,1)=="Y")  {sTF="Y"; nTF=StrToInteger(StringSubstr(,1,0));TF=120960;}
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
//----
ObjectDelete(+"_b0");
ObjectDelete(+"_b1");
ObjectDelete(+"_b2");
ObjectDelete(+"_b3");
ObjectDelete(+"_Pitchfork_1");
ObjectDelete(+"_Pitchfork_2");
ObjectDelete(+"_Boyka_Line");
//----
return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
 {
if(TF<=Period()) return(0);

int b0,b1,b2,b3;
double H1,H2,L1,L2;
int iH1,iH2,iL1,iL2;

if(sTF=="Y")
   {
   int Y=TimeYear(iTime(NULL,0,0));
   b0=iBarShift(NULL,0,StrToTime(Y+".0.0 00:00"));Y-=nTF;
   b1=iBarShift(NULL,0,StrToTime(Y+".0.0 00:00"));Y-=nTF;
   b2=iBarShift(NULL,0,StrToTime(Y+".0.0 00:00"));Y-=nTF;
   b3=iBarShift(NULL,0,StrToTime(Y+".0.0 00:00"));
   }
else if(sTF=="MN")
   {
   b0=iBarShift(NULL,0,iTime(NULL,TF,0));
   if(TimeDay(Time[b0])!=1) b0--;
   b1=iBarShift(NULL,0,iTime(NULL,TF,nTF));
   if(TimeDay(Time[b1])!=1) b1--;
   b2=iBarShift(NULL,0,iTime(NULL,TF,2*nTF));
   if(TimeDay(Time[b2])!=1) b2--;
   b3=iBarShift(NULL,0,iTime(NULL,TF,3*nTF));
   if(TimeDay(Time[b3])!=1) b3--;
   }
else if(sTF=="W")
   {
   b0=iBarShift(NULL,0,iTime(NULL,TF,0));
   if(TimeHour(Time[b0])!=0) b0--;
   b1=iBarShift(NULL,0,iTime(NULL,TF,nTF));
   if(TimeHour(Time[b1])!=0) b1--;
   b2=iBarShift(NULL,0,iTime(NULL,TF,2*nTF));
   if(TimeHour(Time[b2])!=0) b2--;
   b3=iBarShift(NULL,0,iTime(NULL,TF,3*nTF));
   if(TimeHour(Time[b3])!=0) b3--;
   }
else
   {
   b0=iBarShift(NULL,0,iTime(NULL,TF,0));
   if(TimeMinute(Time[b0])!=0) b0--;
   b1=iBarShift(NULL,0,iTime(NULL,TF,nTF));
   if(TimeMinute(Time[b1])!=0) b1--;
   b2=iBarShift(NULL,0,iTime(NULL,TF,2*nTF));
   if(TimeMinute(Time[b2])!=0) b2--;
   b3=iBarShift(NULL,0,iTime(NULL,TF,3*nTF));
   if(TimeMinute(Time[b3])!=0) b3--;
   }
//----
if(DrawVLine){
ObjectDelete(+"_b0");
ObjectDelete(+"_b1");
ObjectDelete(+"_b2");
ObjectDelete(+"_b3");

ObjectCreate(+"_b0",OBJ_VLINE,0,Time[b0],1.0);
ObjectCreate(+"_b1",OBJ_VLINE,0,Time[b1],1.0);
ObjectCreate(+"_b2",OBJ_VLINE,0,Time[b2],1.0);
ObjectCreate(+"_b3",OBJ_VLINE,0,Time[b3],1.0);

ObjectSet(+"_b0",OBJPROP_COLOR,VLine);
ObjectSet(+"_b1",OBJPROP_COLOR,VLine);
ObjectSet(+"_b2",OBJPROP_COLOR,VLine);
ObjectSet(+"_b3",OBJPROP_COLOR,VLine);

ObjectSet(+"_b0",OBJPROP_BACK,true);
ObjectSet(+"_b1",OBJPROP_BACK,true);
ObjectSet(+"_b2",OBJPROP_BACK,true);
ObjectSet(+"_b3",OBJPROP_BACK,true);
}

iH1=iHighest(NULL,0,MODE_HIGH,b1-b0,b0+1); H1=High[iH1];
iL1=iLowest(NULL,0,MODE_LOW,b1-b0,b0+1);   L1=Low[iL1];

iH2=iHighest(NULL,0,MODE_HIGH,b2-b1,b1+1); H2=High[iH2];
iL2=iLowest(NULL,0,MODE_LOW,b2-b1,b1+1);   L2=Low[iL2];


ObjectDelete(+"_Pitchfork_1");
ObjectCreate(+"_Pitchfork_1",OBJ_PITCHFORK,0,Time[iL2],L2,Time[iH1],H1,Time[iL1],L1);
ObjectSet(+"_Pitchfork_1",OBJPROP_COLOR,Pitchfork_1);

ObjectDelete(+"_Pitchfork_2");
ObjectCreate(+"_Pitchfork_2",OBJ_PITCHFORK,0,Time[iH2],H2,Time[iH1],H1,Time[iL1],L1);
ObjectSet(+"_Pitchfork_2",OBJPROP_COLOR,Pitchfork_2);

ObjectDelete(+"_Boyka_Line");
ObjectCreate(+"_Boyka_Line",OBJ_PITCHFORK,0,Time[(b1+b2)/2],(H2+L2)/2,Time[iH1],H1,Time[iL1],L1);
ObjectSet(+"_Boyka_Line",OBJPROP_COLOR,Boyka_Line);
ObjectSet(+"_Boyka_Line",OBJPROP_WIDTH,Boyka_Line_Width);

WindowRedraw();
  return(0);
 }
//+------------------------------------------------------------------+