//+------------------------------------------------------------------+
//| 5 Min RSI 12-period qual INDICATOR                               |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com"

#property indicator_chart_window
#property indicator_buffers 8

#property indicator_color1 Red
#property indicator_color2 HotPink
#property indicator_color3 LightPink
#property indicator_color4 MistyRose

#property indicator_color5 White
#property indicator_color6 LightGray
#property indicator_color7 LightSlateGray
#property indicator_color8 DarkGray


//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double ExtMapBuffer7[];
double ExtMapBuffer8[];


// User Input


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|

int init()
  {

   // 233 up arrow
   // 234 down arrow
   // 159 big dot
   // 168 open square
   
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexArrow(0,159);  //up
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1, ExtMapBuffer2);
   SetIndexArrow(1,159);  //down

   SetIndexStyle(2,DRAW_ARROW);
   SetIndexBuffer(2, ExtMapBuffer3);
   SetIndexArrow(2,159);

   SetIndexStyle(3,DRAW_ARROW);
   SetIndexBuffer(3, ExtMapBuffer4);
   SetIndexArrow(3,159);

   SetIndexStyle(4,DRAW_ARROW);
   SetIndexBuffer(4, ExtMapBuffer5);
   SetIndexArrow(4,159);

   SetIndexStyle(5,DRAW_ARROW);
   SetIndexBuffer(5, ExtMapBuffer6);
   SetIndexArrow(5,159);

   SetIndexStyle(6,DRAW_ARROW);
   SetIndexBuffer(6, ExtMapBuffer7);
   SetIndexArrow(6,159);

   SetIndexStyle(7,DRAW_ARROW);
   SetIndexBuffer(7, ExtMapBuffer8);
   SetIndexArrow(7,159);

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   int i;
   
   for( i=0; i<Bars; i++ ) ExtMapBuffer1[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer2[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer3[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer4[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer5[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer6[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer7[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer8[i]=0;

   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

// Current position if 55/45 or over/under. Does any of 
// the previous 'qual' period ever fall below55/above45? (last11)
//
// If qual*2 periods have been above55/below45
// then lets not try to transact any more (last22)
         

int start()
  {
   int      pos=Bars-100; // leave room for moving average periods

   double   rsic=0;        // Relative Strength Indicator
   double   rsip=0;        // Relative Strength Indicator

   int      above=0;       // above 50 counter
   int      below=0;       // below 50 counter
   
   while(pos>=0)
     {
      rsic=iRSI(Symbol(),0,28,PRICE_CLOSE,pos);
      rsip=iRSI(Symbol(),0,28,PRICE_CLOSE,pos+1);

      if (rsic>50 && rsip<50)  //rising RSI
        {
         above=0;
         below=0;
        }

      if (rsic<50 && rsip>50)   //falling RSI
        {
         above=0;
         below=0;
        }
        
      if (rsic>50) above++;              // count periods above 50
      if (rsic<50) below++;              // count periods below 50

      if (above >= 40)
        {
         ExtMapBuffer1[pos]=High[pos];
         ExtMapBuffer2[pos]=0;
         ExtMapBuffer3[pos]=0;
         ExtMapBuffer4[pos]=0;
        }
      if (above>=30 && above<=39 )
        {
         ExtMapBuffer1[pos]=0;
         ExtMapBuffer2[pos]=High[pos];
         ExtMapBuffer3[pos]=0;
         ExtMapBuffer4[pos]=0;
        }
      if (above>=20 && above<=29 )
        {
         ExtMapBuffer1[pos]=0;
         ExtMapBuffer2[pos]=0;
         ExtMapBuffer3[pos]=High[pos];
         ExtMapBuffer4[pos]=0;
        }
      if (above>=10 && above<=19 )
        {
         ExtMapBuffer1[pos]=0;
         ExtMapBuffer2[pos]=0;
         ExtMapBuffer3[pos]=0;
         ExtMapBuffer4[pos]=High[pos];
        }
         
      if (below >= 40)
        {
         ExtMapBuffer5[pos]=Low[pos];
         ExtMapBuffer6[pos]=0;
         ExtMapBuffer7[pos]=0;
         ExtMapBuffer8[pos]=0;
        }
      if (below>=30 && below<=39 )
        {
         ExtMapBuffer5[pos]=0;
         ExtMapBuffer6[pos]=Low[pos];
         ExtMapBuffer7[pos]=0;
         ExtMapBuffer8[pos]=0;
        }
      if (below>=20 && below<=29 )
        {
         ExtMapBuffer5[pos]=0;
         ExtMapBuffer6[pos]=0;
         ExtMapBuffer7[pos]=Low[pos];
         ExtMapBuffer8[pos]=0;
        }
      if (below>=10 && below<=19 )
        {
         ExtMapBuffer5[pos]=0;
         ExtMapBuffer6[pos]=0;
         ExtMapBuffer7[pos]=0;
         ExtMapBuffer8[pos]=Low[pos];
        }

 	   pos--;
     }

   return(0);
  }
//+------------------------------------------------------------------+