//------------------------------------------------------------------
#property copyright "www.forex-tsd.com"
#property link      "www.forex-tsd.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_color1  DodgerBlue
#property indicator_color2  Coral
#property indicator_color3  Coral
#property indicator_color4  Teal
#property indicator_color5  Chocolate
#property indicator_width1  11
#property indicator_width2  11
#property indicator_width3  11
#property indicator_level1  80
#property indicator_level2  20
#property indicator_minimum 0
#property indicator_maximum 100

//
//
//
//
//

enum enPrices
{
   pr_close,      // Close
   pr_open,       // Open
   pr_high,       // High
   pr_low,        // Low
   pr_median,     // Median
   pr_typical,    // Typical
   pr_weighted,   // Weighted
   pr_average,    // Average (high+low+open+close)/4
   pr_medianb,    // Average median body (open+close)/2
   pr_tbiased,    // Trend biased price
   pr_haclose,    // Heiken ashi close
   pr_haopen ,    // Heiken ashi open
   pr_hahigh,     // Heiken ashi high
   pr_halow,      // Heiken ashi low
   pr_hamedian,   // Heiken ashi median
   pr_hatypical,  // Heiken ashi typical
   pr_haweighted, // Heiken ashi weighted
   pr_haaverage,  // Heiken ashi average
   pr_hamedianb,  // Heiken ashi median body
   pr_hatbiased   // Heiken ashi trend biased price
};
enum enInterpolation
{
   int_noint, // No interpolation
   int_line,  // Linear interpolation
   int_quad   // Quadratic interpolation
};

//
//
//
//
//

extern ENUM_TIMEFRAMES TimeFrame                 = PERIOD_CURRENT;
extern int             StochasticLength          = 5;
extern int             SmoothEMA                 = 11;
extern enPrices        VolatilityPrice           = pr_haaverage;
extern int             VolatilityPeriod          = 5;
extern int             VolatilitySmooth          = 13;
extern bool            drawDivergences           = true;
extern int             DivergearrowSize          = 1;
extern double          DivergencearrowsUpperGap  = 0.2;
extern double          DivergencearrowsLowerGap  = 0.2;
extern bool            ShowClassicalDivergence   = true;
extern bool            ShowHiddenDivergence      = true;
extern bool            drawIndicatorTrendLines   = false;
extern bool            drawPriceTrendLines       = false;
extern string          drawLinesIdentificator    = "volDssdiverge1";
extern color           divergenceBullishColor    = Lime;
extern color           divergenceBearishColor    = Magenta;
extern bool            divergenceAlert           = false;
extern bool            divergenceAlertsMessage   = true;
extern bool            divergenceAlertsSound     = true;
extern bool            divergenceAlertsEmail     = false;
extern bool            divergenceAlertsNotify    = false;
extern string          divergenceAlertsSoundName = "alert1.wav";
extern bool            alertsOn                  = false;
extern bool            alertsOnCurrent           = true;
extern bool            alertsMessage             = true;
extern bool            alertsSound               = false;
extern bool            alertsEmail               = false;
extern bool            alertsNotify              = false;
extern enInterpolation Interpolate               = int_line;

double sto[];
double stoa[];
double stob[];
double bullishDivergence[];
double bearishDivergence[];
double price[];
double sum[];
double slope[];
string indicatorFileName;
bool   returnBars;
string indicatorName;
string labelNames;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(8);
      SetIndexBuffer(0,sto);
      SetIndexBuffer(1,stoa);
      SetIndexBuffer(2,stob);
      SetIndexBuffer(3,bullishDivergence); SetIndexStyle(3,DRAW_ARROW,0,DivergearrowSize); SetIndexArrow(3,233);
      SetIndexBuffer(4,bearishDivergence); SetIndexStyle(4,DRAW_ARROW,0,DivergearrowSize); SetIndexArrow(4,234); 
      SetIndexBuffer(5,price);
      SetIndexBuffer(6,sum);
      SetIndexBuffer(7,slope);
         
         StochasticLength  = MathMax(1,StochasticLength);
         SmoothEMA         = MathMax(1,SmoothEMA);
         indicatorFileName = WindowExpertName();
         returnBars        = TimeFrame==-99; 
         TimeFrame         = MathMax(TimeFrame,_Period);
         
         labelNames        = "Vol Dss_DivergenceLine "+drawLinesIdentificator+":";
         indicatorName     = timeFrameToString(TimeFrame)+" Volatility adjusted Dss ("+StochasticLength+","+SmoothEMA+","+VolatilityPeriod+","+VolatilitySmooth+")";
   IndicatorShortName(indicatorName);
return(0);
}
int deinit()
{
   int length=StringLen(labelNames);
   for(int i=ObjectsTotal()-1; i>=0; i--)
   {
      string name = ObjectName(i);
      if(StringSubstr(name,0,length) == labelNames)  ObjectDelete(name);   
   }
   return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int k,counted_bars=IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { sto[0] = limit+1; return(0); }
         if (TimeFrame != _Period)
         {
            limit = (int)MathMax(limit,MathMin(Bars-1,iCustom(NULL,TimeFrame,indicatorFileName,-99,0,0)*TimeFrame/Period()));
            if (slope[limit]==-1) CleanPoint(limit,stoa,stob);   
            for (int i=limit; i>=0; i--)
            {
               int y = iBarShift(NULL,TimeFrame,Time[i]);
                  sto[i]               = iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,StochasticLength,SmoothEMA,VolatilityPrice,VolatilityPeriod,VolatilitySmooth,drawDivergences,DivergearrowSize,DivergencearrowsUpperGap,DivergencearrowsLowerGap,ShowClassicalDivergence,ShowHiddenDivergence,drawIndicatorTrendLines,drawPriceTrendLines,drawLinesIdentificator,divergenceBullishColor,divergenceBearishColor,divergenceAlert,divergenceAlertsMessage,divergenceAlertsSound,divergenceAlertsEmail,divergenceAlertsNotify,divergenceAlertsSoundName,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,alertsNotify,0,y);
                  slope[i]             = iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,StochasticLength,SmoothEMA,VolatilityPrice,VolatilityPeriod,VolatilitySmooth,drawDivergences,DivergearrowSize,DivergencearrowsUpperGap,DivergencearrowsLowerGap,ShowClassicalDivergence,ShowHiddenDivergence,drawIndicatorTrendLines,drawPriceTrendLines,drawLinesIdentificator,divergenceBullishColor,divergenceBearishColor,divergenceAlert,divergenceAlertsMessage,divergenceAlertsSound,divergenceAlertsEmail,divergenceAlertsNotify,divergenceAlertsSoundName,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,alertsNotify,7,y);
                  stoa[i]              = EMPTY_VALUE;
                  stob[i]              = EMPTY_VALUE;
                  bullishDivergence[i] = EMPTY_VALUE;
                  bearishDivergence[i] = EMPTY_VALUE;
               int firstBar = iBarShift(NULL,0,iTime(NULL,TimeFrame,y));
               if (i==firstBar)
               {
                  bullishDivergence[i] = iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,StochasticLength,SmoothEMA,VolatilityPrice,VolatilityPeriod,VolatilitySmooth,drawDivergences,DivergearrowSize,DivergencearrowsUpperGap,DivergencearrowsLowerGap,ShowClassicalDivergence,ShowHiddenDivergence,drawIndicatorTrendLines,drawPriceTrendLines,drawLinesIdentificator,divergenceBullishColor,divergenceBearishColor,divergenceAlert,divergenceAlertsMessage,divergenceAlertsSound,divergenceAlertsEmail,divergenceAlertsNotify,divergenceAlertsSoundName,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,alertsNotify,3,y);
                  bearishDivergence[i] = iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,StochasticLength,SmoothEMA,VolatilityPrice,VolatilityPeriod,VolatilitySmooth,drawDivergences,DivergearrowSize,DivergencearrowsUpperGap,DivergencearrowsLowerGap,ShowClassicalDivergence,ShowHiddenDivergence,drawIndicatorTrendLines,drawPriceTrendLines,drawLinesIdentificator,divergenceBullishColor,divergenceBearishColor,divergenceAlert,divergenceAlertsMessage,divergenceAlertsSound,divergenceAlertsEmail,divergenceAlertsNotify,divergenceAlertsSoundName,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,alertsNotify,4,y);
               }
                  if (!Interpolate || y==iBarShift(NULL,TimeFrame,Time[i-1])) continue;
                     interpolate(sto   ,TimeFrame,i,Interpolate);
            }
            for (i=limit; i>=0; i--) if (slope[i] == -1) PlotPoint(i,stoa,stob,sto);
            return(0);            
         }

   //
   //
   //
   //
   //
 
      if (slope[limit]==-1) CleanPoint(limit,stoa,stob);   
      for(i = limit; i >= 0; i--)
      {
         price[i]   =  getPrice(VolatilityPrice,Open,Close,High,Low,i);
         sum[i]     =  0;       for (k = 0; k<VolatilityPeriod; k++) sum[i] += MathAbs(price[i+k]-price[i+k+1]);
         double avg =  sum[i];  for (k = 1; k<VolatilitySmooth; k++) avg    += sum[i+k];
                avg /= VolatilitySmooth;
         
                //
                //
                //
                //
                //
                
                if (avg!=0 && sum[i]!=0)
                     int stoPer = MathFloor(MathMin(MathMax(StochasticLength/(sum[i]/avg),StochasticLength/2.0),StochasticLength*5.0));
                else     stoPer = StochasticLength;
                sto[i]   = iDss(price[i],price[i],price[i],stoPer,SmoothEMA,i);
                stoa[i]  = EMPTY_VALUE;
                stob[i]  = EMPTY_VALUE;
                slope[i] = slope[i+1];
                  if (sto[i]>sto[i+1]) slope[i] =  1;
                  if (sto[i]<sto[i+1]) slope[i] = -1;
                  if (slope[i] == -1) PlotPoint(i,stoa,stob,sto);
                  
                  //
                  //
                  //
                  //
                  //
                  
                  if (drawDivergences)
                  {
                    CatchBullishDivergence(i);
                    CatchBearishDivergence(i);
                  }         
      }
      
      //
      //
      //
      //
      //
      
      if (alertsOn)
      {
        if (alertsOnCurrent)
           int whichBar = 0;
        else     whichBar = 1; 
        if (slope[whichBar] != slope[whichBar+1])
        {
           if (slope[whichBar] ==  1) doAlert(whichBar,"sloping up");
           if (slope[whichBar] == -1) doAlert(whichBar,"sloping down");
        }
     }
return(0);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

void interpolate(double& target[], int ptimeFrame, int i, int interpolateType)
{
   int bar = iBarShift(NULL,ptimeFrame,Time[i]); double x0 = 0, x1 = 1, x2 = 2, y0 =0, y1 = 0, y2 = 0;
   if (interpolateType==int_quad)
   {
      y0 = target[i];                                                
      y1 = target[(int)MathMin(iBarShift(NULL,0,iTime(NULL,ptimeFrame,bar+0))+1,Bars-1)]; 
      y2 = target[(int)MathMin(iBarShift(NULL,0,iTime(NULL,ptimeFrame,bar+1))+1,Bars-1)]; 
   }      

      //
      //
      //
      //
      //

      datetime time = iTime(NULL,ptimeFrame,bar);
      int n,k;
         for(n = 1; (i+n)<Bars && Time[i+n] >= time; n++) continue;
         for(k = 1; (i+n)<Bars && (i+k)<Bars && k<n; k++)
         if (interpolateType==int_quad)
         {
            double x3 = (double)k/n;
               target[i+k]  = y0*(x3-x1)*(x3-x2)/(-x1*(-x2))+
                              y1*(x3-x0)*(x3-x2)/( x1*(-x1))+
		                        y2*(x3-x0)*(x3-x1)/( x2*( x1));         
         }
         else target[i+k] = target[i] + (target[i+n] - target[i])*k/n;
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//
//

double workHa[][4];
double getPrice(int tprice, const double& open[], const double& close[], const double& high[], const double& low[], int i, int instanceNo=0)
{
  if (tprice>=pr_haclose)
   {
      if (ArrayRange(workHa,0)!= Bars) ArrayResize(workHa,Bars);
         int r = Bars-i-1;
         
         //
         //
         //
         //
         //
         
         double haOpen;
         if (r>0)
                haOpen  = (workHa[r-1][instanceNo+2] + workHa[r-1][instanceNo+3])/2.0;
         else   haOpen  = (open[i]+close[i])/2;
         double haClose = (open[i] + high[i] + low[i] + close[i]) / 4.0;
         double haHigh  = MathMax(high[i], MathMax(haOpen,haClose));
         double haLow   = MathMin(low[i] , MathMin(haOpen,haClose));

         if(haOpen  <haClose) { workHa[r][instanceNo+0] = haLow;  workHa[r][instanceNo+1] = haHigh; } 
         else                 { workHa[r][instanceNo+0] = haHigh; workHa[r][instanceNo+1] = haLow;  } 
                                workHa[r][instanceNo+2] = haOpen;
                                workHa[r][instanceNo+3] = haClose;
         //
         //
         //
         //
         //
         
         switch (tprice)
         {
            case pr_haclose:     return(haClose);
            case pr_haopen:      return(haOpen);
            case pr_hahigh:      return(haHigh);
            case pr_halow:       return(haLow);
            case pr_hamedian:    return((haHigh+haLow)/2.0);
            case pr_hamedianb:   return((haOpen+haClose)/2.0);
            case pr_hatypical:   return((haHigh+haLow+haClose)/3.0);
            case pr_haweighted:  return((haHigh+haLow+haClose+haClose)/4.0);
            case pr_haaverage:   return((haHigh+haLow+haClose+haOpen)/4.0);
            case pr_hatbiased:
               if (haClose>haOpen)
                     return((haHigh+haClose)/2.0);
               else  return((haLow+haClose)/2.0);        
         }
   }
   
   //
   //
   //
   //
   //
 
   switch (tprice)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_medianb:   return((open[i]+close[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
      case pr_tbiased:   
               if (close[i]>open[i])
                     return((high[i]+close[i])/2.0);
               else  return((low[i]+close[i])/2.0);        
   }
   return(0);
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if (i>=Bars-3) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
      if (first[i+2] == EMPTY_VALUE) 
            { first[i]  = from[i];  first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
      else  { second[i] =  from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else     { first[i]  = from[i];                           second[i] = EMPTY_VALUE; }
}

//
//
//
//
//

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(timeFrameToString(Period())+" "+Symbol()," ",timeFrameToString(TimeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Volatility adjusted Dss ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Volatility adjusted Dss "),message);
          if (alertsNotify)  SendNotification(message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//
//
//
//
//

void CatchBullishDivergence(int shift)
{
   shift++;
         bullishDivergence[shift] = EMPTY_VALUE;
            ObjectDelete(labelNames+"l"+DoubleToStr(Time[shift],0));
            ObjectDelete(labelNames+"l"+"os" + DoubleToStr(Time[shift],0));            
   if(!IsIndicatorLow(shift)) return;  

   //
   //
   //
   //
   //
      
   int currentLow = shift;
   int lastLow    = GetIndicatorLastLow(shift+1);
   if (sto[currentLow] > sto[lastLow] && Low[currentLow] < Low[lastLow])
   {
     if (ShowClassicalDivergence)
     {
        bullishDivergence[currentLow] = sto[currentLow] - DivergencearrowsLowerGap;
        if (drawPriceTrendLines)    DrawPriceTrendLine("l",Time[currentLow],Time[lastLow],Low[currentLow],Low[lastLow],    divergenceBullishColor,STYLE_SOLID);
        if (drawIndicatorTrendLines)DrawIndicatorTrendLine("l",Time[currentLow],Time[lastLow],sto[currentLow],sto[lastLow],divergenceBullishColor,STYLE_SOLID);
        if (divergenceAlert)        DisplayAlert("Classical bullish divergence",currentLow);  
     }
                        
   }
     
   //
   //
   //
   //
   //
        
   if (sto[currentLow] < sto[lastLow] && Low[currentLow] > Low[lastLow])
   {
     if (ShowHiddenDivergence)
     {
        bullishDivergence[currentLow] = sto[currentLow] - DivergencearrowsLowerGap;
        if (drawPriceTrendLines)     DrawPriceTrendLine("l",Time[currentLow],Time[lastLow],Low[currentLow],Low[lastLow],    divergenceBullishColor, STYLE_DOT);
        if (drawIndicatorTrendLines) DrawIndicatorTrendLine("l",Time[currentLow],Time[lastLow],sto[currentLow],sto[lastLow],divergenceBullishColor, STYLE_DOT);
        if (divergenceAlert)         DisplayAlert("Reverse bullish divergence",currentLow); 
     }
   }
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

void CatchBearishDivergence(int shift)
{
   shift++; 
         bearishDivergence[shift] = EMPTY_VALUE;
            ObjectDelete(labelNames+"h"+DoubleToStr(Time[shift],0));
            ObjectDelete(labelNames+"h"+"os" + DoubleToStr(Time[shift],0));            
   if(IsIndicatorPeak(shift) == false) return;
   int currentPeak = shift;
   int lastPeak    = GetIndicatorLastPeak(shift+1);

   //
   //
   //
   //
   //
      
   if (sto[currentPeak] < sto[lastPeak] && High[currentPeak]>High[lastPeak])
   {
     if (ShowClassicalDivergence)
     {
        bearishDivergence[currentPeak] = sto[currentPeak] + DivergencearrowsUpperGap; 
        if (drawPriceTrendLines)     DrawPriceTrendLine("h",Time[currentPeak],Time[lastPeak],High[currentPeak],High[lastPeak],  divergenceBearishColor,STYLE_SOLID);
        if (drawIndicatorTrendLines) DrawIndicatorTrendLine("h",Time[currentPeak],Time[lastPeak],sto[currentPeak],sto[lastPeak],divergenceBearishColor,STYLE_SOLID);
        if (divergenceAlert)         DisplayAlert("Classical bearish divergence",currentPeak);
     } 
                        
   }
   
   //
   //
   //
   //
   //

   if (sto[currentPeak] > sto[lastPeak] && High[currentPeak] < High[lastPeak])
   {
     if (ShowHiddenDivergence)
     {
        bearishDivergence[currentPeak] = sto[currentPeak] + DivergencearrowsUpperGap;
        if (drawPriceTrendLines)     DrawPriceTrendLine("h",Time[currentPeak],Time[lastPeak],High[currentPeak],High[lastPeak],  divergenceBearishColor, STYLE_DOT);
        if (drawIndicatorTrendLines) DrawIndicatorTrendLine("h",Time[currentPeak],Time[lastPeak],sto[currentPeak],sto[lastPeak],divergenceBearishColor, STYLE_DOT);
        if (divergenceAlert)         DisplayAlert("Reverse bearish divergence",currentPeak);
     }
                         
   }   
}

//
//
//
//
//

bool IsIndicatorPeak(int shift)
{
   if(sto[shift] >= sto[shift+1] && sto[shift] > sto[shift+2] && sto[shift] > sto[shift-1])
       return(true);
   else 
       return(false);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//

bool IsIndicatorLow(int shift)
{
   if(sto[shift] <= sto[shift+1] && sto[shift] < sto[shift+2] && sto[shift] < sto[shift-1])
       return(true);
   else 
       return(false);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//

int GetIndicatorLastPeak(int shift)
{
    for(int i = shift+5; i < Bars; i++)
    {
       if(sto[i] >= sto[i+1] && sto[i] > sto[i+2] && sto[i] >= sto[i-1] && sto[i] > sto[i-2])
    return(i);
    }
return(-1);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//

int GetIndicatorLastLow(int shift)
{
    for (int i = shift+5; i < Bars; i++)
    {
       if (sto[i] <= sto[i+1] && sto[i] < sto[i+2] && sto[i] <= sto[i-1] && sto[i] < sto[i-2])
    return(i);
    }
     
return(-1);
}

//
//
//
//
//

void DisplayAlert(string doWhat, int shift)
{
    string dmessage;
    static datetime lastAlertTime;
    if(shift <= 2 && Time[0] != lastAlertTime)
    {
      dmessage =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Volatility adjusted Dss ",doWhat);
          if (divergenceAlertsMessage) Alert(dmessage);
          if (divergenceAlertsNotify)  SendNotification(dmessage);
          if (divergenceAlertsEmail)   SendMail(StringConcatenate(Symbol()," Volatility adjusted Dss "),dmessage);
          if (divergenceAlertsSound)   PlaySound(divergenceAlertsSoundName); 
          lastAlertTime = Time[0];
    }
}

//
//
//
//
//

void DrawPriceTrendLine(string first,datetime t1, datetime t2, double p1, double p2, color lineColor, double style)
{
    string label = labelNames+first+"os"+DoubleToStr(t1,0);
      ObjectDelete(label);
      ObjectCreate(label, OBJ_TREND, 0, t1, p1, t2, p2, 0, 0);
         ObjectSet(label, OBJPROP_RAY, 0);
         ObjectSet(label, OBJPROP_COLOR, lineColor);
         ObjectSet(label, OBJPROP_STYLE, style);
}

//
//
//
//
//

void DrawIndicatorTrendLine(string first,datetime t1, datetime t2, double p1, double p2, color lineColor, double style)
{
    int indicatorWindow = WindowFind(indicatorName);
    if (indicatorWindow < 0) return;
    
    //
    //
    //
    //
    //
    
    string label = labelNames+first+DoubleToStr(t1,0);
      ObjectDelete(label);
      ObjectCreate(label, OBJ_TREND, indicatorWindow, t1, p1, t2, p2, 0, 0);
         ObjectSet(label, OBJPROP_RAY, 0);
         ObjectSet(label, OBJPROP_COLOR, lineColor);
         ObjectSet(label, OBJPROP_STYLE, style);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workDss[][5];
#define _st1    0
#define _ss1    1
#define _pHigh  2
#define _pLow   3
#define _dss    4

double iDss(double close, double high, double low, int length, double smooth, int r)
{
   if (ArrayRange(workDss,0)!=Bars) ArrayResize(workDss,Bars); r=Bars-r-1;
   
   //
   //
   //
   //
   //
   
      double alpha = 2.0 / (1.0+smooth);
         workDss[r][_pHigh]  = high;
         workDss[r][_pLow]   = low;
     
         double min = workDss[r][_pLow];
         double max = workDss[r][_pHigh];
         for (int k=1; k<length && (r-k)>=0; k++)
         {
            min = MathMin(min,workDss[r-k][_pLow]);
            max = MathMax(max,workDss[r-k][_pHigh]);
         }
      
         workDss[r][_st1] = 0;
               if (min!=max) workDss[r][_st1] = 100*(close-min)/(max-min);
         workDss[r][_ss1] = workDss[r-1][_ss1]+alpha*(workDss[r][_st1]-workDss[r-1][_ss1]);

         //
         //
         //
         //
         //
         
         min = workDss[r][_ss1];
         max = workDss[r][_ss1];
         for (k=1; k<length && (r-k)>=0; k++)
         {
            min = MathMin(min,workDss[r-k][_ss1]);
            max = MathMax(max,workDss[r-k][_ss1]);
         }
         double stoch = 0; if (min!=max) stoch = 100*(workDss[r][_ss1]-min)/(max-min);
         
         //
         //
         //
         //
         //
         
         workDss[r][_dss] = workDss[r-1][_dss]+alpha*(stoch -workDss[r-1][_dss]);
   return(workDss[r][_dss]);
}


