//+------------------------------------------------------------------+
//|                                        PotitionSizeCalc.mq4  |
//|     Copyright  2011, MetaQuotes Software Corp. Ciclo            |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+

#property copyright "Copyright  2009, MetaQuotes Software Corp. Ciclo" 
#property link "http://www.metaquotes.net" 

#property indicator_chart_window 

//---- input parameters 
extern string nota_dist_SL="Si dist_SL=0 => dist_SL= automatico"; 
extern int dist_SL=0; 

extern string nota_equity="Si equity=0 => equity=AccountEquity";
extern double equity=0;

/*Capital no existente aadido al valor de la Equity para hacer los calculos del n de lotes 
capital= Equity+C. C puede ser positivo o negativo.  */
extern string nota1_C= "Capital=Equity+C. C es virtual y ";
extern string nota2_C= "puede ser cero,positivo o negativo";
extern double C=0;

extern string nota_risk= "risk= % a arriestar sobre Equity+C";
extern double risk=2;

extern string nota_ATR="Necesario si dist_SL=0";
extern int TFrameATR=0; 
extern int periodATR=14;

extern string nota_k="Si dist_SL=0 => dist_SL=k*ATR(n)"; 
extern double k=3;

extern string divisacuenta="";

extern string note_tamao_letra = "Tamao de letra"; extern int FontSize=9;
extern string note_tipo_letra = "Tipo de Letra"; extern string FontType="Comic Sans MS";
extern string note_color = "Default Font Color"; extern color  FontColor = White;

extern string note_esquina = "En que esquina se muestra?";
extern string note1 = "Sup.Izq.=0; Sup.Der.=1";
extern string note2 = "Inf.Izq.=2; Inf.Der.=3";
extern int    WhatCorner=0;

extern int    DistanciaX=5; extern int  DistanciaY= 15;

//+------------------------------------------------------------------+ 
//| Custom indicator initialization function | 
//+------------------------------------------------------------------+ 
int init() 
{ 
//---- indicators 


//---- 
return(0); 
} 
//+------------------------------------------------------------------+ 
//| Custom indicator deinitialization function | 
//+------------------------------------------------------------------+ 
int deinit() 
{ 
//---- 
ObjectDelete("Info");
//---- 
return(0); 
} 
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function | 
//+------------------------------------------------------------------+ 
int start() 
{ 
double riesgo=risk/100;
int dist=dist_SL;
if (dist_SL==0)dist=k*iATR(NULL,TFrameATR,periodATR,0)/Point; 
double tickValue=MarketInfo (Symbol(), MODE_TICKVALUE); 
double equityCta=equity;
if (equity==0)equityCta=AccountEquity();
//if(equityCta>C) equityCta=equityCta-C;
equityCta=equityCta+C;
double size= equityCta*riesgo/dist/tickValue; 

string Com = StringConcatenate("Riesgo= ",riesgo*100,"% sobre ",equityCta, " ",divisacuenta," y dist. SL=",dist,", Lotes= ",DoubleToStr(size,2)); 
//Comment(Com); 
  
   ObjectCreate("info", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("info", Com, FontSize, FontType, FontColor);
   ObjectSet("info", OBJPROP_CORNER, WhatCorner);
   ObjectSet("info", OBJPROP_XDISTANCE, DistanciaX);
   ObjectSet("info", OBJPROP_YDISTANCE, DistanciaY);
//---- 
return(0); 
} 
//+------------------------------------------------------------------+ 


