//+------------------------------------------------------------------+
//|                                                       _Bline.mq4 |
//|                                        Copyright  20012, FXSSG. |
//|                                           http://www.fxBline.com |
//|                                         E-mail: info@fxBline.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2012, FX Bline."
#property link      "http://www.fxBline.com"

//---- indicator settings
#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 DarkSlateGray
#property indicator_color2 Maroon
#property indicator_color3 Teal
#property indicator_color4 OrangeRed
#property indicator_color5 Teal
#property indicator_color6 OrangeRed
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1
#property indicator_width5 1
#property indicator_width6 1
#property indicator_style3 STYLE_DOT
#property indicator_style4 STYLE_DOT
#property indicator_style5 STYLE_DOT
#property indicator_style6 STYLE_DOT

//---- indicator parameters
extern int  TradePeriod         = 80;     
extern int  StopPeriod          = 5;     
extern bool Strict              = false;  
extern bool DisplayAlerts       = false;  
extern bool MailAlerts          = false;  

//---- indicator buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double TrendDirection[];

//---- internal
static datetime TimeStamp;
static int AlertCount = 1;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   // One more invisible buffer to store trend direction
   IndicatorBuffers(7);
   
   // Drawing settings
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexStyle(4,DRAW_ARROW); SetIndexArrow(4,233);
   SetIndexStyle(5,DRAW_ARROW); SetIndexArrow(5,234);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   
   // Name and labels
   IndicatorShortName("Turtle Channel ("+ TradePeriod +"-"+ StopPeriod +")");
   SetIndexLabel(0,"Upper line");
   SetIndexLabel(1,"Lower line");
   SetIndexLabel(2,"Longs Stop line");
   SetIndexLabel(3,"Shorts Stop line");
   SetIndexLabel(4, "Bullish trend change");
   SetIndexLabel(5, "Bearish trend change");
   
   // Buffers
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexBuffer(2,ExtMapBuffer3);    
   SetIndexBuffer(3,ExtMapBuffer4);    
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexBuffer(5,ExtMapBuffer6);
   SetIndexBuffer(6,TrendDirection);
   
   Comment("Copyright  http://www.fxssg.com");
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{

     int start = 1;
     int limit;
     int counted_bars = IndicatorCounted();


     if(counted_bars < 0) 
        return(-1);
        
  
     limit = Bars - 1 - counted_bars;
     
 
     for(int i = limit; i >= start; i--)
     {           

         double rhigh = iHigh(Symbol(),Period(),iHighest(Symbol(), Period(), MODE_HIGH, TradePeriod,i+1));
         double rlow  = iLow(Symbol(),Period(),iLowest(Symbol(), Period(), MODE_LOW, TradePeriod, i+1));
         double shigh = iHigh(Symbol(),Period(),iHighest(Symbol(), Period(), MODE_HIGH, StopPeriod,i+1));
         double slow  = iLow(Symbol(),Period(),iLowest(Symbol(), Period(), MODE_LOW, StopPeriod, i+1));
         
         // Candle value
         double CLOSE = iClose(Symbol(),0, i);
         double HIGH = iHigh(Symbol(),0, i);
         double LOW = iLow(Symbol(),0, i);
         

         TrendDirection[i] = TrendDirection[i+1];
         
 
         ExtMapBuffer1[i] = EMPTY_VALUE;
         ExtMapBuffer2[i] = EMPTY_VALUE;
         ExtMapBuffer3[i] = EMPTY_VALUE;
         ExtMapBuffer4[i] = EMPTY_VALUE;
         ExtMapBuffer5[i] = EMPTY_VALUE;
         ExtMapBuffer6[i] = EMPTY_VALUE;
         

         if((CLOSE > rhigh || (HIGH > rhigh && Strict == true)) && TrendDirection[i+1] != OP_BUY)
         {
            TrendDirection[i] = OP_BUY;
            ExtMapBuffer5[i] = rlow;
         

         } else if((CLOSE < rlow || (LOW < rlow && Strict == true)) && TrendDirection[i+1] != OP_SELL) {
            
            TrendDirection[i] = OP_SELL;
            ExtMapBuffer6[i] = rhigh;
         }
         

         if(TrendDirection[i] == OP_BUY)
         {
            ExtMapBuffer1[i] = rlow;
            ExtMapBuffer3[i] = slow;
            

         } else if(TrendDirection[i] == OP_SELL) {
         
            ExtMapBuffer2[i] = rhigh;
            ExtMapBuffer4[i] = shigh;
         }
     }
     

     if(TimeStamp != Time[0])
     {
         if(TrendDirection[1] == OP_SELL && TrendDirection[2] == OP_BUY && AlertCount == 0)
         {
            if(DisplayAlerts) Alert("[SSG_Bline "+ TradePeriod +"-"+ StopPeriod +"]["+ Symbol() +"] SELL");
            if(MailAlerts)    SendMail("[SSG_Bline "+ TradePeriod +"-"+ StopPeriod +"]", "["+ Symbol() +"] SELL");
         } else if (TrendDirection[1] == OP_BUY && TrendDirection[2] == OP_SELL && AlertCount == 0) {
            if(DisplayAlerts) Alert("[SSG_Bline "+ TradePeriod +"-"+ StopPeriod +"]["+ Symbol() +"] BUY");
            if(MailAlerts)    SendMail("[SSG_Bline "+ TradePeriod +"-"+ StopPeriod +"]", "["+ Symbol() +"] BUY");
         }
         TimeStamp = Time[0];
         AlertCount = 0;
     }
    

   return(0);
}