//------------------------------------------------------------------
#property copyright "mladen"
#property link      "www.forex-station.cm"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1  Blue
#property indicator_color2  Red
#property indicator_color3  Blue
#property indicator_color4  Red
#property indicator_color5  Blue
#property indicator_color6  Red
#property indicator_color7  Blue
#property indicator_color8  Red
#property indicator_minimum 0
#property indicator_maximum 5

//
//
//
//
//

extern string TimeFrame1            = "Current time frame";
extern string TimeFrame2            = "next1";
extern string TimeFrame3            = "next2";
extern string TimeFrame4            = "next3";
extern int    period                = 10;
extern int    PriceType             = PRICE_MEDIAN;
extern bool   ChangeOnSlope         = false;
extern string UniqueID              = "4 Time frame EFT";
extern bool   alertsOn              = false;
extern int    alertsLevel           = 3;
extern bool   alertsMessage         = true;
extern bool   alertsSound           = false;
extern bool   alertsEmail           = false;
extern int    LinesWidth            =  0;
extern color  LabelsColor           = DarkGray;
extern int    LabelsHorizontalShift = 5;
extern double LabelsVerticalShift   = 1.5;

//
//
//
//
//

double eft1u[];
double eft1d[];
double eft2u[];
double eft2d[];
double eft3u[];
double eft3d[];
double eft4u[];
double eft4d[];

int    timeFrames[4];
bool   returnBars;
bool   calculateValue;
string indicatorFileName;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,eft1u);
   SetIndexBuffer(1,eft1d);
   SetIndexBuffer(2,eft2u);
   SetIndexBuffer(3,eft2d);
   SetIndexBuffer(4,eft3u);
   SetIndexBuffer(5,eft3d);
   SetIndexBuffer(6,eft4u);
   SetIndexBuffer(7,eft4d);
      indicatorFileName = WindowExpertName();
      returnBars        = (TimeFrame1=="returnBars");     if (returnBars)     return(0);
      calculateValue    = (TimeFrame1=="calculateValue"); if (calculateValue) return(0);
      
      //
      //
      //
      //
      //
      
      for (int i=0; i<8; i++) 
      {
         SetIndexStyle(i,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(i,110); 
      }
      timeFrames[0] = stringToTimeFrame(TimeFrame1);
      timeFrames[1] = stringToTimeFrame(TimeFrame2);
      timeFrames[2] = stringToTimeFrame(TimeFrame3);
      timeFrames[3] = stringToTimeFrame(TimeFrame4);
      alertsLevel = MathMin(MathMax(alertsLevel,3),4);
      IndicatorShortName(UniqueID);
   return(0);
}
int deinit()
{
   for (int t=0; t<4; t++) ObjectDelete(UniqueID+t);
   return(0); 
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double trend[][2];
#define _up 0
#define _dn 1
int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { eft1u[0] = limit+1; return(0); }
         if (calculateValue) { calculateByeft(limit); return(0); }

         if (timeFrames[0] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[0],indicatorFileName,"returnBars",0,0)*timeFrames[0]/Period()));
         if (timeFrames[1] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[1],indicatorFileName,"returnBars",0,0)*timeFrames[1]/Period()));
         if (timeFrames[2] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[2],indicatorFileName,"returnBars",0,0)*timeFrames[2]/Period()));
         if (timeFrames[3] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[3],indicatorFileName,"returnBars",0,0)*timeFrames[3]/Period()));
         if (ArrayRange(trend,0)!=Bars) ArrayResize(trend,Bars);

         //
         //
         //
         //
         //
         
         bool initialized = false;
         if (!initialized)
         {
            initialized = true;
            int window = WindowFind(UniqueID);
            for (int t=0; t<4; t++)
            {
               string label = timeFrameToString(timeFrames[t]);
               ObjectCreate(UniqueID+t,OBJ_TEXT,window,0,0);
                  ObjectSet(UniqueID+t,OBJPROP_COLOR,LabelsColor);
                  ObjectSet(UniqueID+t,OBJPROP_PRICE1,t+LabelsVerticalShift);
                  ObjectSetText(UniqueID+t,label,8,"Arial");
            }               
         }
         for (t=0; t<4; t++) ObjectSet(UniqueID+t,OBJPROP_TIME1,Time[0]+Period()*LabelsHorizontalShift*60);

   //
   //
   //
   //
   //
    
   for(i = limit, r=Bars-i-1; i >= 0; i--,r++)
   {
      trend[r][_up] = 0;
      trend[r][_dn] = 0;
      for (int k=0; k<4; k++)
      {
         int y = iBarShift(NULL,timeFrames[k],Time[i]);
            if (!ChangeOnSlope)
               {               
                  double val1 = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",period,PriceType,ChangeOnSlope,0,y);
                  bool isUp = (val1>0);
               }                  
            else       isUp = (iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",period,PriceType,ChangeOnSlope,2,y)>iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",period,PriceType,ChangeOnSlope,2,y+1));
            switch (k)
            {
               case 0 : if (isUp) { eft1u[i] = k+1; eft1d[i] = EMPTY_VALUE;}  else { eft1d[i] = k+1; eft1u[i] = EMPTY_VALUE; } break;
               case 1 : if (isUp) { eft2u[i] = k+1; eft2d[i] = EMPTY_VALUE;}  else { eft2d[i] = k+1; eft2u[i] = EMPTY_VALUE; } break;
               case 2 : if (isUp) { eft3u[i] = k+1; eft3d[i] = EMPTY_VALUE;}  else { eft3d[i] = k+1; eft3u[i] = EMPTY_VALUE; } break;
               case 3 : if (isUp) { eft4u[i] = k+1; eft4d[i] = EMPTY_VALUE;}  else { eft4d[i] = k+1; eft4u[i] = EMPTY_VALUE; } break;
            }
            if (isUp)
                  trend[r][_up] += 1;
            else  trend[r][_dn] += 1;
      }
   }
   manageAlerts();
   return(0);
}


//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

void calculateByeft(int limit)
{
   for (int i=limit; i>=0; i--) 
   {
      eft4u[i] = iMA(NULL,0,1,0,MODE_SMA,PriceType,i);
      
      //
      //
      //
      //
      //
                  
      double MaxH = eft4u[ArrayMaximum(eft4u,period,i)];
      double MinL = eft4u[ArrayMinimum(eft4u,period,i)];
         if (MaxH!=MinL)
               eft4d[i] = 0.33*2*((eft4u[i]-MinL)/(MaxH-MinL)-0.5)+0.67*eft4d[i+1];
         else  eft4d[i] = 0.00;
               eft4d[i] = MathMin(MathMax(eft4d[i],-0.999),0.999); 
               eft2u[i] = 0.5*MathLog((1+eft4d[i])/(1-eft4d[i]))+0.5*eft2u[i+1];

      // 
      //
      //
      //
      //

      if(eft2u[i]==eft2u[i+1]) 
      {
        eft3u[i] = eft3u[i+1];
        eft3d[i] = eft3d[i+1];  
        continue;
      }
      
         //
         //
         //
         //
         //
         
         eft3u[i] = EMPTY_VALUE;
         eft3d[i] = EMPTY_VALUE;
         eft1u[i] = eft1u[i+1];
            if (eft2u[i] > 0)   eft1u[i] =  1;
            if (eft2u[i] < 0)   eft1u[i] = -1;
            if (eft1u[i] ==  1) eft3u[i] = eft2u[i];
            if (eft1u[i] == -1) eft3d[i] = eft2u[i];
   }
}
              
//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = Bars-1;
      if (trend[whichBar][_up] >= alertsLevel || trend[whichBar][_dn] >= alertsLevel)
      {
         if (trend[whichBar][_up] >= alertsLevel) doAlert("up"  ,trend[whichBar][_up]);
         if (trend[whichBar][_dn] >= alertsLevel) doAlert("down",trend[whichBar][_dn]);
      }
   }
}

//
//
//
//
//

void doAlert(string doWhat, int howMany)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[0]) {
       previousAlert  = doWhat;
       previousTime   = Time[0];

       //
       //
       //
       //
       //

       message =  Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" "+howMany+" time frames of Ehlers Fisher Transform are aligned "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(Symbol()+" 4 time frame Ehlers Fisher Transform ",message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int toInt(double value) { return(value); }
int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   int max = ArraySize(iTfTable)-1, add=0;
   int nxt = (StringFind(tfs,"NEXT1")>-1); if (nxt>0) { tfs = ""+Period(); add=1; }
       nxt = (StringFind(tfs,"NEXT2")>-1); if (nxt>0) { tfs = ""+Period(); add=2; }
       nxt = (StringFind(tfs,"NEXT3")>-1); if (nxt>0) { tfs = ""+Period(); add=3; }

      //
      //
      //
      //
      //
         
      for (int i=max; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[toInt(MathMin(max,i+add))],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}